<?php
namespace CorpusParole\Providers;

use Illuminate\Support\ServiceProvider;
use CorpusParole\Libraries\Sparql\SparqlClient;

/**
 * Service provider charged to bind repository interfaces to implementations
 */
class SparqlClientServiceProvider extends ServiceProvider {

    public function register() {
        $this->app->bind(
            'CorpusParole\Libraries\Sparql\SparqlClient',
            function($app) {
                $httpClient = $app->make('GuzzleHttp\Client', [[ 'base_uri' => config('corpusparole.rdf4j_query_url'), 'http_errors' => false]]);
                $sparqlClient = $app->make('EasyRdf\Sparql\Client', [config('corpusparole.rdf4j_query_url'), config('corpusparole.rdf4j_update_url')]);
                return new SparqlClient($httpClient, $sparqlClient);
            }
        );
    }
}
