class sysconfig::apache (
    $vhost = hiera('sysconfig::params::vhost', $sysconfig::params::vhost),
) inherits sysconfig::params {
    notify {'apache': name => "\$vhost : ${vhost}", withpath => true }

    $apache_packages = [
        'httpd'
    ]
    $corpus_folders = [
        "/var/www/corpusdelaparole",
        "/var/www/corpusdelaparole/corpus-back",
        "/var/www/corpusdelaparole/drupal"
    ]

    package { $apache_packages:
        ensure => present,
    }

    service { "httpd":
        ensure => running,
        enable => true,
        require => Package['httpd']
    }

    file { $corpus_folders:
        ensure => directory,
        owner => 'apache',
        group => 'apache',
        require => Package['httpd']
    }

    file { "/etc/www":
        ensure => directory,
    }

    file { ["/etc/httpd/conf.d/userdir.conf", "/etc/httpd/conf.d/autoindex.conf"]:
        ensure => absent,
        require => Package['httpd'],
        notify => Service['httpd']
    }
    file { "/etc/httpd/conf/httpd.conf":
        ensure => file,
        source => "puppet:///modules/sysconfig/httpd/httpd.conf",
        require => Package['httpd'],
        notify => Service['httpd']
    }
    file { "/etc/httpd/conf.d/welcome.conf":
        ensure => file,
        source => "puppet:///modules/sysconfig/httpd/welcome.conf",
        require => Package['httpd'],
        notify => Service['httpd']
    }
    file { "/etc/httpd/conf.d/10-corpusdelaparole.conf":
        ensure => file,
        content => template("sysconfig/httpd/vhost.conf.erb"),
        require => [Package['httpd'], File['/etc/www'], File[$corpus_folders]],
        notify => Service['httpd']
    }

    exec { "open-http-port":
        command => "firewall-cmd --permanent --add-port=80/tcp",
        path => [ '/bin', '/usr/bin', '/usr/local/bin' ]
    }->
    exec { "open-http-port-reload":
        command => "firewall-cmd --reload",
        path => [ '/bin', '/usr/bin', '/usr/local/bin' ]
    }

    #remove
    #/etc/httpd/conf.d/userdir.conf
    #/etc/httpd/conf.d/autotindex.conf
    #/etc/httpd/conf.d/welcome.conf

}
