class sysconfig::tomcat (
    $tomcat_open_port = hiera('sysconfig::params::tomcat_open_port', sysconfig::params::tomcat_open_port),
) inherits sysconfig::params {

    $package_list = [
        'tomcat'
    ]

    package { $package_list:
        ensure => present,
        require => Package['java-1.8.0-openjdk-headless']
    }

    if any2bool($tomcat_open_port) {
        exec { "open-tomcat-port":
            command => "firewall-cmd --permanent --add-port=8080/tcp",
            path => [ '/bin', '/usr/bin', '/usr/local/bin' ]
        }->
        exec { "open-tomcat-port-reload":
            command => "firewall-cmd --reload",
            path => [ '/bin', '/usr/bin', '/usr/local/bin' ]
        }
    }

    service { "tomcat":
        ensure => running,
        enable => true,
        require => Package['tomcat']
    }

}
