<?php
namespace CorpusParole\Libraries\RdfModel;

use CorpusParole\Libraries\RdfModel\RdfModelDelta;
use EasyRdf\Resource;

/**
 *
 */
class RdfModelResource extends Resource {

    public function __construct($uri, $graph = null) {
        parent::__construct($uri, $graph);
        $this->uri = $uri;
    }

    protected $deltaList = [];
    protected $currentDelta = null;
    protected $uri = null;

    public function isDirty() {
        return !is_null($this->deltaList) && count($this->deltaList)>0;
    }

    public function deltaCount() {
        return is_null($this->deltaList)?0:count($this->deltaList);
    }

    public function getDeltaList() {
        return $this->deltaList;
    }

    public function getUri() {
        return $this->uri;
    }

    public function getCurrentDelta() {
        return $this->getCurrentDelta;
    }

    public function startDelta() {
        $this->currentDelta = new RdfModelDelta($this->getGraph()->getUri());
        array_push($this->deltaList, $this->currentDelta);
        return $this->currentDelta;
    }

    protected function setSimpleProperty($baseNode, $property, $oldValue, $newValue) {
        $delta = $this->startDelta();
        $baseNode->delete($property, $oldValue);
        $delta->getDeletedGraph()->add($baseNode, $property, $oldValue);
        $baseNode->add($property, $newValue);
        $delta->getAddedGraph()->add($baseNode, $property, $newValue);
    }


}
