<?php
namespace CorpusParole\Libraries\Mergers;

/**
 * merge graphes after mapping them.
 */
interface RdfMerger {


    /**
     * Merge an Rdf Graph from one model to another
     *
     * @param EasyRdf\Graph $baseGraph The graph used as base for the merge
     * @param EasyRdf\Graph $srcGraph The source graph with the new triples to add
     *
     * @return EasyRdf\Graph The new merged graph
     */
    function mergeGraph($baseGraph, $srcGraph);

}
