import Ember from 'ember';
import _ from 'lodash';
import store from 'corpus-common-addon/utils/store';

export default Ember.Service.extend({

    promises: null,
    queryRegister: null,

    storeKeyBase: null,
    apiPath: null,
    resDocRoot: null,

    processId: function(id) { return id; },

    getReturnDictKey: function(id) { return id; },

    init() {
        this._super(...arguments);
        this.set('promises', []);
        this.set('queryRegister',{});
        this.doQuery = _.debounce(this._doQuery,10);
    },

    env: function() {
        return Ember.getOwner(this).resolveRegistration('config:environment');
    },


    _getStoreKey: function(id) {
        return this.storeKeyBase+':'+id;
    },

    _doQuery: function() {
        var queryRegister = this.get('queryRegister');
        this.set('queryRegister', {});
        var ids = Object.keys(queryRegister).join(',');
        if(!ids) {
            _.each(queryRegister, (resolve_reject) => {
                resolve_reject[0]({});
            });
        }
        Ember.$.ajax({
            //TODO Configuration ?
            url: this.env().baseURL.replace(/\/$/,'') + this.apiPath +ids,

            success: (itemDoc) => {
                _.each(queryRegister, (resolve_reject) => {
                    resolve_reject[0](itemDoc[this.resDocRoot]);
                });
            },
            error: (req, status, error) => {
                _.each(queryRegister, (resolve_reject) => {
                    resolve_reject[1](status + ':' + error);
                });

            }
        });
    },

    // make the query for the name.
    // return a Promise
    queryName: function(id) {
        var queryRegister = this.get('queryRegister');
        return new Ember.RSVP.Promise(function(resolve, reject) {
            queryRegister[id] = [resolve, reject];
            this.doQuery(this);
        }.bind(this));
    },

    getName: function(id) {

        if(!id) {
            return new Ember.RSVP.Promise(function(resolve/*, reject*/) {
                resolve('');
            });
        }

        var objectId = this.processId(id);

        var namePromise = null;

        var storeKey = this._getStoreKey(id);
        var name = store.get(storeKey);

        if( name !== null) {
            namePromise = new Ember.RSVP.Promise(function(resolve/*, reject*/) {
                resolve(name);
            });
        } else if ( storeKey in this.get('promises')) {
            namePromise = this.get('promises')[storeKey];
        } else {
            //TODO: handle error !!!
            namePromise = this.queryName(objectId)
                .then(function(names) {
                    delete this.get('promises')[storeKey];
                    return store.set(storeKey, names[this.getReturnDictKey(objectId)]);
                }.bind(this));
            this.get('promises')[storeKey] = namePromise;
        }
        return namePromise;
    }

});
