import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['sorting-component'],

    filterService: Ember.inject.service('filter'),

    sorting: ['label'],
    sortedThemes: Ember.computed.sort('themes', 'sorting'),

    isAlphabetical: true,
    isPopularity: Ember.computed('isAlphabetical', function() { return !this.get('isAlphabetical'); }),

    minimum: Ember.computed('themes', function() { return Math.min(...this.themes.mapBy('count')); }),
    maximum: Ember.computed('themes', function() { return Math.max(...this.themes.mapBy('count')); }),

    actions: {

        setQueryParameters: function(id) {
            this.get('filterService').set('theme', id);
        },

        sortBy: function (type) {
            if(type === 'alphabetical') {
                this.set('isAlphabetical', true);
                this.set('sorting', ['label']);
            } else {
                this.set('isAlphabetical', false);
                this.set('sorting', ['count:desc']);
            }
            this.get('sortedThemes');
        }

    }

});