import Ember from 'ember';

export default Ember.Service.extend(Ember.Evented, {

    items: [],
    item: null,
    model: null,
    transcript: null,

    window: '',
    playing: false,
    progress: 0, // In Milliseconds
    reduce: false,

    display: function(el) {
         if(this.get('window') !== el) {
            this.set('window', el);
        } else {
            this.set('window', '');
        }
    },

    init: function() {
        this.on('reset', Ember.run.bind(this, this.get('reset')));
    },

    setProgress: function(time) {
        this.set('progress', time);
    },

    select: function (id) {
        this.set('item', id);
    },

    play: function(id) {
        this.select(id);
        this.set('playing', true);
    },

    pause: function() {
        this.set('playing', false);
    },

    reset: function(id) {
        this.set('item', id);
    }
});
