<?php
namespace CorpusParole\Libraries\Filters;

use Config;
use CorpusParole\Libraries\Utils;

class CorpusFilterManager {

    public static function getLanguageNode($nodeId) {
        $node = null;
        $currentNodes = [config('corpusparole.languages_treemap'),];
        while(is_null($node) || !empty($currentNodes)) {
            $currentNode = array_pop($currentNodes);
            foreach($currentNode['children'] as $n) {
                if($n['id'] === $nodeId) {
                    $node = $n;
                    break;
                } elseif (array_key_exists('children', $n)) {
                    array_push($currentNodes, $n);
                }
            }
        }
        return $node;
    }

    private static function getLanguageNodeChildren($nodeId) {
        $node = self::getLanguageNode($nodeId);
        if(is_null($node)) {
            return [];
        } elseif (array_key_exists('values', $node)) {
            return $node['values'];
        } elseif (array_key_exists('children', $node)) {
            return array_map(function($c) {
                return $c['id'];
            }, $node['children']);
        } else {
            return [];
        }
    }

    public static function prepareLanguages($languages) {

        $resLanguage = [];
        if(is_string($languages)) {
            $languages = [ $languages, ];
        }
        foreach($languages as $lang) {
            if($lang == config('corpusparole.language_corpus_node_global')) {
                // ignore global
                continue;
            }
            else if(Utils::startsWith($lang, config('corpusparole.lexvo_base_url'))) {
                array_push($resLanguage, $lang);
            } elseif(Utils::startsWith($lang, config('corpusparole.language_corpus_node_prefix'))) {
                $resLanguage = array_merge($resLanguage, self::prepareLanguages(self::getLanguageNodeChildren($lang)));
            } else {
                array_push($resLanguage, config('corpusparole.lexvo_base_url').$lang);
            }
        }

        return array_unique($resLanguage);
    }

    public static function getLanguagesFilterPart($languages) {
        return [
            'bool' => [
                'should' => [
                    [ 'terms' => [ 'language' => $languages ]]
                ]
            ]
        ];
    }

}
