import Ember from 'ember';

const OLAC_ROLES = {
  'http://www.language-archives.org/OLAC/1.1/annotator': 'bo.olac_role_annotator',
  'http://www.language-archives.org/OLAC/1.1/author': 'bo.olac_role_author',
  'http://www.language-archives.org/OLAC/1.1/compiler': 'bo.olac_role_compiler',
  'http://www.language-archives.org/OLAC/1.1/consultant': 'bo.olac_role_consultant',
  'http://www.language-archives.org/OLAC/1.1/data_inputter': 'bo.olac_role_data_inputter',
  'http://www.language-archives.org/OLAC/1.1/depositor': 'bo.olac_role_depositor',
  'http://www.language-archives.org/OLAC/1.1/developer': 'bo.olac_role_developer',
  'http://www.language-archives.org/OLAC/1.1/editor': 'bo.olac_role_editor',
  'http://www.language-archives.org/OLAC/1.1/illustrator': 'bo.olac_role_illustrator',
  'http://www.language-archives.org/OLAC/1.1/interpreter': 'bo.olac_role_interpreter',
  'http://www.language-archives.org/OLAC/1.1/interviewer': 'bo.olac_role_interviewer',
  'http://www.language-archives.org/OLAC/1.1/participant': 'bo.olac_role_participant',
  'http://www.language-archives.org/OLAC/1.1/performer': 'bo.olac_role_performer',
  'http://www.language-archives.org/OLAC/1.1/photographer': 'bo.olac_role_photographer',
  'http://www.language-archives.org/OLAC/1.1/recorder': 'bo.olac_role_recorder',
  'http://www.language-archives.org/OLAC/1.1/researcher': 'bo.olac_role_researcher',
  'http://www.language-archives.org/OLAC/1.1/research_participant': 'bo.olac_role_research_participant',
  'http://www.language-archives.org/OLAC/1.1/responder': 'bo.olac_role_responder',
  'http://www.language-archives.org/OLAC/1.1/signer': 'bo.olac_role_signer',
  'http://www.language-archives.org/OLAC/1.1/singer': 'bo.olac_role_singer',
  'http://www.language-archives.org/OLAC/1.1/speaker': 'bo.olac_role_speaker',
  'http://www.language-archives.org/OLAC/1.1/sponsor': 'bo.olac_role_sponsor',
  'http://www.language-archives.org/OLAC/1.1/transcriber': 'bo.olac_role_transcriber',
  'http://www.language-archives.org/OLAC/1.1/translator': 'bo.olac_role_translator',
};


const DISCOURSE_CATEGORY_KEYS = {
  "http://ark.bnf.fr/ark:/12148/cb12083158d": "cat1",
  "http://ark.bnf.fr/ark:/12148/cb119783362": "cat1",
  "http://ark.bnf.fr/ark:/12148/cb119317924": "cat1",
  "http://ark.bnf.fr/ark:/12148/cb12481481z": "cat1",
  "http://ark.bnf.fr/ark:/12148/cb119341539": "cat1",
  "http://ark.bnf.fr/ark:/12148/cb11946100d": "cat1",
  "http://ark.bnf.fr/ark:/12148/cb11931724n": "cat2",
  "http://ark.bnf.fr/ark:/12148/cb11949715t": "cat2",
  "http://ark.bnf.fr/ark:/12148/cb13319048g": "cat3",
  "http://ark.bnf.fr/ark:/12148/cb11936159v": "cat3",
  "http://ark.bnf.fr/ark:/12148/cb11948542x": "cat3",
  "http://ark.bnf.fr/ark:/12148/cb11953414d": "cat3",
  "http://ark.bnf.fr/ark:/12148/cb11955657q": "cat3",
  "http://ark.bnf.fr/ark:/12148/cb11957378b": "cat3",
  "http://ark.bnf.fr/ark:/12148/cb11937212q": "cat3",
  "http://ark.bnf.fr/ark:/12148/cb119834877": "cat3",
  "http://ark.bnf.fr/ark:/12148/cb11976851v": "cat3",
  "http://ark.bnf.fr/ark:/12148/cb120502737": "cat4",
  "http://ark.bnf.fr/ark:/12148/cb11932135w": "cat4",
  "http://ark.bnf.fr/ark:/12148/cb119829234": "cat4"
};

const DISCOURSE_CATEGORY_VALUES = {
  "cat1": {
    "fill": "#F3F6F7",
    "stroke": "#BECFD4"
  },
  "cat2": {
    "fill": "#BECFD4",
    "stroke": "#91ADB6"
  },
  "cat3": {
    "fill": "#91ADB6",
    "stroke": "#628793"
  },
  "cat4":{
    "fill": "#628793",
    "stroke": "#415A62"
  }
};

const KEY_CODES = {
  BACKSPACE : 8,
  DELETE : 46,
  ESCAPE: 27,
  RETURN: 13,
};

const LANGUAGES_TREEMAP = {
  "id": "corpus-global",
  "name": "Global",
  "children": [
  {
    "id": "http://lexvo.org/id/iso639-3/fra",
    "name": "Français",
  },
  {
    "id": "http://lexvo.org/id/iso639-3/gsw",
    "name": "Alsacien",
  },
  {
    "id": "http://lexvo.org/id/iso639-3/bre",
    "name": "Breton",
  },
  {
    "id": "http://lexvo.org/id/iso639-3/oci",
    "name": "Occitan",
  },
  {
    "id": "http://lexvo.org/id/iso639-3/lad",
    "name": "Judéo-espagnol",
  },
  {
    "id": "http://lexvo.org/id/iso639-3/und",
    "name": "Indéterminée",
  },
  {
    "id": "corpus-regionals",
    "name": "Langues régionales",
    // (franccomtois,wallon, champenois, picard, normand, gallo,poitevin-saintongeais [dans ses deux variétés : poitevinet saintongeais], lorrain, bourguignon-morvandiau)
    "children": [
      {
        "id": "corpus-oil",
        "name": "Langues d'oïl",
        "values": ["http://lexvo.org/id/iso639-3/pcd",]
      },
      {
        "id": "http://lexvo.org/id/iso639-3/frp",
        "name": "Francoprovençal",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/cos",
        "name": "Corse",
      },
      {
        "id": "corpus-creoles",
        "name": "Les Créoles",
        "children": [
          {
            "id": "http://lexvo.org/id/iso639-3/rcf",
            "name": "Créole de la Réunion",
          },
          {
            "id": "http://lexvo.org/id/iso639-3/gcf",
            "name": "Créole de la Guadeloupe",
          }
        ]
      }
    ]
  },
  {
    "id": "corpus-non-territorials",
    "name": "Langues non territoriales",
    "children": [
      {
        "id": "http://lexvo.org/id/iso639-3/fsl",
        "name": "Langue des signes française (LSF)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/kab",
        "name": "Berbère",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/ell",
        "name": "Grec moderne"
      },
      {
        "id": "http://lexvo.org/id/iso639-3/spa",
        "name": "Espagnol"
      },
      {
        "id": "http://lexvo.org/id/iso639-3/eng",
        "name": "Anglais",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/ita",
        "name": "Italien",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/deu",
        "name": "Allemand",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/tur",
        "name": "Turque",
      },
    ]
  },
  {
    "id": "corpus-guyane",
    "name": "Guyane",
    "children": [
      {
        "id": "http://lexvo.org/id/iso639-3/gcf",
        "name": "Ndyuka-Trio Pidgin (njt)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/plu",
        "name": "Palikúr (plu)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/gcr",
        "name": "Guianese Creole French (gcr)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/djk",
        "name": "Eastern Maroon Creole (djk)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/srn",
        "name": "Sranan Tongo (srn)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/car",
        "name": "kali'na (car)",
      }
    ]
  },
  {
    "id": "corpus-mayotte",
    "name": "Mayotte",
    "children": [
      {
        "id": "http://lexvo.org/id/iso639-3/swb",
        "name": "Maore Comorian (swb)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/lsy",
        "name": "Mauritian Sign Language (lsy)",
      }
    ]
  },
  {
    "id": "corpus-polynesia",
    "name": "Polynésie française",
    "children": [
      {
        "id": "http://lexvo.org/id/iso639-3/uve",
        "name": "West Uvean (uve)",
      }
    ]
  },
  {
    "id": "corpus-wallis-futuna",
    "name": "Wallis et Futuna",
    "children": [
      {
        "id": "http://lexvo.org/id/iso639-3/fud",
        "name": "LanEast Futuna (fud)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/wls",
        "name": "Wallisian (wls)",
      }
    ]
  },
  {
    "id": "corpus-new-caledonia",
    "name": "Nouvelle-Calédonie",
    "children": [
      {
        "id": "http://lexvo.org/id/iso639-3/wls",
        "name": "Wallisian (wls)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/ane",
        "name": "Xârâcùù (ane)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/cam",
        "name": "Cemuhî (cam)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/axx",
        "name": "Xaragure (axx)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/iai",
        "name": "Iaai (iai)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/nee",
        "name": "Nêlêmwa-Nixumwak (nee)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/dhv",
        "name": "Dehu (dhv)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/nen",
        "name": "Nengone (nen)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/aji",
        "name": "Ajië (aji)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/kdk",
        "name": "Numee (kdk)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/nem",
        "name": "Nemi",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/nua",
        "name": "Yuaga (nua)",
      },
      {
        "id": "http://lexvo.org/id/iso639-3/bwa",
        "name": "Bwatoo (bwa)",
      }
    ]
  }
 ]
};

export default Ember.Service.extend({
  OLAC_ROLES: OLAC_ROLES,
  DISCOURSE_CATEGORY_KEYS: DISCOURSE_CATEGORY_KEYS,
  DISCOURSE_CATEGORY_VALUES: DISCOURSE_CATEGORY_VALUES,
  KEY_CODES: KEY_CODES,
  VIAF_BASE_URL: "http://viaf.org/viaf/",
  LEXVO_BASE_URL: "http://lexvo.org/id/iso639-3/",
  LANGUAGES_TREEMAP: LANGUAGES_TREEMAP
});
