/*jshint node:true*/
module.exports = function(app) {
  var express = require('express');
  var _ = require('lodash');

  var v1ViafRouter = express.Router();

  var viafMappings = {
    "93752300": "Sonia Branca-Rosoff",
    "9122216": "Dominique Huck",
    "51700729": "Patrick Sauzet",
    "56666014": "Guylaine Brun-Trigaud",
    "61542329": "Arlette Bothorel",
    "91792187": "Xavier Ravier"
  };

  v1ViafRouter.get('/:id', function(req, res) {
    var idList = req.params.id.split(',');
    var resMap = _.reduce(idList, function(r, id) {
      r[id] = (id in viafMappings)?viafMappings[id]:null;
    }, {});
    res.send({
      'viafids': _.reduce(idList, function(r, id) {
        r[id] = (id in viafMappings)?viafMappings[id]:null;
        return r;
      }, {}),
    });
  });

  app.use('/api/v1/viaf', v1ViafRouter);
};
