<?php

namespace CorpusParole\Http\Controllers\Api;

// use Illuminate\Http\Request;
// use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;

use Illuminate\Http\Request;
use EasyRdf\Resource;
use EasyRdf\Literal;

use Es;
use Log;

use CorpusParole\Libraries\Sparql\SparqlClient;
use CorpusParole\Services\LexvoResolverInterface;
use CorpusParole\Services\BnfResolverInterface;


class ThemeController extends Controller
{
    private $sparqlClient = null;

    public function __construct(SparqlClient $sparqlClient, LexvoResolverInterface $lexvoResolver, BnfResolverInterface $bnfResolver) {
        $this->sparqlClient = $sparqlClient;
        $this->lexvoResolver = $lexvoResolver;
        $this->bnfResolver = $bnfResolver;
    }

    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $filter = $request->input('filter', 'bnf');
        $index = $request->input('index', 0);
        $limit = $request->input('limit', config('corpusparole.theme_default_limit'));
        $sort = $request->input('sort', 'count');

        if($filter === 'bnf') {
            $include = ".*\|bnf\|.*";
        }
        elseif($filter === 'lexvo') {
            $include = ".*\|lxv\|.*";
        }
        elseif($filter === 'all') {
            $include = false;
        }
        else {
            abort(401,"Value for filter parameter must be in 'bnf', 'lexvo', 'all'");
        }

        if($sort == "count" || $sort == "descending") {
            $order_field = "_count";
            $order_dir = "desc";
        } elseif($sort == "-count") {
            $order_field = "_count";
            $order_dir = "asc";
        } elseif ($sort == "label" || $sort == "alphabetical") {
            $order_field = "_term";
            $order_dir = "asc";
        } elseif ($sort == "-label") {
            $order_field = "_term";
            $order_dir = "desc";
        } else {
            $order_field = "_count";
            $order_dir = "desc";
        }

        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                'size' => 0,
                'aggs' => [
                    "subjects" => [
                        "nested" => [ "path" => "subject" ],
                        "aggs" => [
                            "subjects" => [
                                "terms" => [
                                    "field" => "subject.label_code",
                                    "size" => $limit * ($index+1),
                                    "order" => [ $order_field => $order_dir ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];

        if($include) {
            $query['body']['aggs']['subjects']['aggs']['subjects']['terms']['include'] = $include;
        }

        $esRes = Es::search($query);

        $themes = [];

        $bucketList = array_slice($esRes['aggregations']['subjects']['subjects']['buckets'], $index*$limit, $limit);

        foreach($bucketList as $bucket) {
            $parts = explode("|", $bucket['key']);
            $label = $parts[0];
            $url = ['bnf' => config('corpusparole.bnf_ark_base_url'), 'lxv' => config('corpusparole.lexvo_base_url')][$parts[1]].$parts[2];
            $themes[$url] = [
                "label" => $label,
                "count" => $bucket['doc_count']
            ];
        }

        return response()->json(['themes' => $themes ]);

    }

}
