import Ember from 'ember';
import ENV from 'app-client/config/environment';
import URI from 'urijs';

export function initialize(appInstance) {
  // appInstance.inject('route', 'foo', 'service:foo');
  const player = appInstance.lookup('service:player');
  Ember.$(ENV.APP.navigationLinksSelector).click(function(e) {
    const locHash = window.location.hash;
    const uri = URI(Ember.$(e.target).prop('href'));
    Ember.run(() => {
      // close notice or transcript "window"
      player.displayMetadata(false);
      // if we do not navigate, force the  router refresh
      if(locHash === "#"+uri.fragment()) {
        appInstance.get('router').router.refresh();
      }
    });
  });
}

export default {
  name: 'nav-menu',
  initialize
};
