<?php
namespace CorpusParole\Services;

interface GeonamesResolverInterface {

    /**
     * Get label from Geonames id
     * @param string $id The id to resolve. Can be an url starting with http(s)://(wwww|sws).geonames.org
     * @return a string with the label
     */
    public function getLabel($id);

    /**
     * Get a list of labels from an array of geonames ids.
     * @param array $ids The array of ids to resolve.
     *                   Each id can be an url starting with http(s)://(wwww|sws).geonames.org
     */
    public function getLabels(array $ids);

}
