<?php
namespace CorpusParole\Libraries\Filters;

use Config;
use CorpusParole\Libraries\Utils;

class CorpusFilterManager {

    public static function getLanguageNode($nodeId) {
        $node = null;
        $currentNodes = [config('corpusparole.languages_treemap'),];
        while(is_null($node) && !empty($currentNodes)) {
            $currentNode = array_pop($currentNodes);
            foreach($currentNode['children'] as $n) {
                if($n['id'] === $nodeId) {
                    $node = $n;
                    break;
                } elseif (array_key_exists('children', $n)) {
                    array_push($currentNodes, $n);
                }
            }
        }
        return $node;
    }

    private static function getLanguageNodeChildren($nodeId) {
        $node = self::getLanguageNode($nodeId);
        if(is_null($node)) {
            return [];
        } elseif (array_key_exists('values', $node)) {
            return $node['values'];
        } elseif (array_key_exists('children', $node)) {
            return array_map(function($c) {
                return $c['id'];
            }, $node['children']);
        } else {
            return [];
        }
    }

    public static function prepareLanguages($languages) {

        if(is_null($languages)) {
            return [];
        }
        $resLanguage = [];
        if(is_string($languages)) {
            $languages = [ $languages, ];
        }
        foreach($languages as $lang) {
            if($lang == config('corpusparole.language_corpus_node_global')) {
                // ignore global
                continue;
            }
            else if(Utils::startsWith($lang, config('corpusparole.lexvo_base_url'))) {
                array_push($resLanguage, $lang);
            } elseif(Utils::startsWith($lang, config('corpusparole.language_corpus_node_prefix'))) {
                $resLanguage = array_merge($resLanguage, self::prepareLanguages(self::getLanguageNodeChildren($lang)));
            } else {
                array_push($resLanguage, config('corpusparole.lexvo_base_url').$lang);
            }
        }

        return array_unique($resLanguage);
    }

    public static function getLanguagesFilterPart($languages) {
        return [
            'bool' => [
                'should' => [
                    [ 'terms' => [ 'language' => $languages ]]
                ]
            ]
        ];
    }

    public static function prepareLocation($location) {
        if(empty($location)) {
            return null;
        }
        if(is_array($location)) {
            $location = $location[0]; //from test above we know ther is at least one element
        }
        if(preg_match(config('corpusparole.geonames_url_regexp'), $location, $m)) {
            $location = $m[1];
        }
        // for the moment we do not make this check. Incorrect loaction format will return an empty result
        /*if(!preg_match('/\d+/', $location)) {
            return null;
        }*/

        return $location;
    }

    /**
     * Search in geonames_hierarchy (values are bae geonames ids)
     */
    public static function getLocationFilterPart($location) {
        return [
            'term' => [ 'geonames_hierarchy' => "$location" ]
        ];
    }

    public static function prepareTheme($entities) {
        if(empty($entities)) {
            return [];
        }
        if(is_string($entities)) {
            $entities = [$entities,];
        }
        return array_reduce($entities, function($res, $e) {
            if(preg_match(config('corpusparole.bnf_ark_url_regexp'), $e, $m)) {
                array_push($res, $m[1]);
            } elseif(Utils::startsWith($e, config('corpusparole.bnf_ark_id_base'))) {
                array_push($res, $e);
            }

            return $res;
        }, []);
    }

    public static function getThemeFilterPart($themes) {
        $nestedQueries = [];
        foreach($themes as $t) {
            $nestedQueries[] = [
                'nested' => [
                    'path' => "subject",
                    'query' => [ 'term' => ['subject.code' => "$t" ] ]
                ]
            ];
        }
        return [
            'query' => [
                'bool' => [
                    'must' => $nestedQueries
                ]
            ]
        ];
    }

}
