var gulp = require('gulp');
var elixir = require('laravel-elixir');
var del = require('del');
var seq = require('run-sequence');
var minimist = require('minimist');

var exec = require('child_process').execSync;

var options = minimist(process.argv.slice(2));

var buildOption = "--prod";
if(options.prod) {
    buildOption = "--prod";
} else if(options.dev) {
    buildOption = "--dev";
}


var paths = {
 'bower_base_path': './vendor/bower_components/',
 'bootstrap': './vendor/bower_components/bootstrap-sass/assets/'
 };

gulp.task('build-ember', function(cb) {
    exec('node_modules/.bin/ember build '+buildOption, {
        cwd: '../bo_client',
        stdio:[0,1,2]
    });
});

gulp.task('copy-bo-ember', function() {
    gulp.src('../bo_client/dist/assets/*.js')
        .pipe(gulp.dest('public/js/vendor/'));
    gulp.src('../bo_client/dist/assets/*.css')
        .pipe(gulp.dest('public/css/'));
    gulp.src('../bo_client/dist/fonts/**/*')
        .pipe(gulp.dest('public/fonts/'));
    gulp.src('../bo_client/dist/assets/img/**/*')
        .pipe(gulp.dest('public/css/img'));

});

gulp.task('do-copy-to-build', function() {
    del(['../../build/root/var/www/corpusdelaparole/corpus-back/**/*'], {force: true}, function(err, files) {
        if(err) {
            return;
        }
        gulp.src(['**/*','!vendor', '!vendor/**', '!node_modules', /*'!public/corpus-app', '!public/corpus-app/**',*/ '!node_modules/**', '!.env', '!.git*', '!bootstrap/cache/**'])
            .pipe(gulp.dest('../../build/root/var/www/corpusdelaparole/corpus-back/'))
    });
});

elixir(function(mix) {
    mix.sass('app.scss', 'public/css/app.css', {includePaths: [paths['bootstrap']+'stylesheets/']})
        .copy(paths.bootstrap + 'fonts/bootstrap', 'public/fonts')
        .copy(paths.bootstrap + 'javascripts/bootstrap.js', 'public/js/vendor/bootstrap.js')
        .copy(paths.bower_base_path + 'jquery/dist/jquery.min.js', 'public/js/vendor/jquery.js')
        .copy(paths.bower_base_path + 'font-awesome/css/font-awesome.min.css', 'public/css/vendor/font-awesome.css')
        .task('build-ember')
        .task('copy-bo-ember');
});

gulp.task('copy-build', function(cb) {
    return seq('default', 'do-copy-to-build', cb);
});

