import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['filtering-component'],

    isDropdownOpen: false,

    filter: Ember.inject.service(),

    input: '',
    filteredThemes: Ember.computed.filter('themes', function(item) {
        return this.get('input') && item.get('label').match(new RegExp('^' + this.get('input')));
    }).property('input'),

    init: function() {
        this._super(...arguments);
        Ember.$(window).on('click', this, Ember.run.bind(this, this.get('elementFocusOut')));
    },

    elementFocusOut: function(event) {
        if(this.get('element') && !Ember.$.contains(this.get('element'), event.target)) {
            this.set('isDropdownOpen', false);
        }
    },

    actions: {

        setQueryParameters: function(id) {
            this.get('filter').set('theme', id);
            this.set('input', '');
        },

        focusIn: function() {
            this.set('isDropdownOpen', true);
        },

        keyUp: function() {
            this.set('input', Ember.$('input').val());
        }

    },


    didDestroyElement: function() {
        this._super(...arguments);
        Ember.$(window).off('click', this.get('elementFocusOut'));
    }

});
