<?php

use Mockery as m;

use EasyRdf\Resource;
use EasyRdf\Literal;

/**
 *
 */
class DiscourseControllerTest extends TestCase {

    private $sparqlClient;

    public function setUp() {

        parent::setup();

        // create a mock of the post repository interface and inject it into the
        // IoC container
        $this->sparqlClient = m::mock('CorpusParole\Libraries\Sparql\SparqlClient');
        $this->app->instance('CorpusParole\Libraries\Sparql\SparqlClient', $this->sparqlClient);
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testIndexQuery() {

        $query = preg_replace('/\s+/', ' ', "select (?o as ?res) (COUNT(?s) as ?count) where {
            ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO>.
            ?s <http://purl.org/dc/elements/1.1/type> ?o.
            filter(uri(?o) in (<".implode('>,<', array_keys(config('corpusparole.corpus_discourse_type'))).">))
        }
        GROUP BY ?o
        ORDER BY DESC(?count)");

        $this->sparqlClient
            ->shouldReceive('query')
            ->with($query)
            ->once()
            ->andReturn(new \ArrayIterator([]));
        $this->get('/api/v1/discourses/');
    }

    public function testIndex() {

        $this->sparqlClient
            ->shouldReceive('query')
            ->once()
            ->andReturn(new \ArrayIterator([
                (object)['res'=>new Resource('http://ark.bnf.fr/ark:/12148/cb12083158d'), 'count' => Literal::create(44)],
                (object)['res'=>new Resource('http://ark.bnf.fr/ark:/12148/cb119783362'), 'count' => Literal::create(33)],
                (object)['res'=>new Resource('http://ark.bnf.fr/ark:/12148/cb13319048g'), 'count' => Literal::create(22)],
            ]));
        $this->get('/api/v1/discourses/')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["discourses" => [
            "http://ark.bnf.fr/ark:/12148/cb12083158d" => ["label" => "argumentation", "count" => 44],
            "http://ark.bnf.fr/ark:/12148/cb119783362" => ["label" => "bavardage", "count" => 33],
            "http://ark.bnf.fr/ark:/12148/cb13319048g" => ["label" => "chansons", "count" => 22],
        ]]);
    }
}
