import Ember from 'ember';

export default Ember.Controller.extend({

    player: Ember.inject.service(),

    playerVideoscreenObserver: Ember.observer('player.videoscreen', function() {
        Ember.$('body').toggleClass('videoscreen', this.get('player').get('videoscreen'));
    }),

    queryParams: ['location', 'date', 'notice', {
        language: 'langue',
        discourse: 'discours',
        theme: 'thematique'
    }],

    date: [],
    discourse: null,
    language: null,
    location: null,
    theme: null,

    filter: Ember.inject.service(),
    setFilter: Ember.observer('discourse', 'language', 'location', 'theme', function(sender, key) {
        this.get('filter').set(key, this.get(key));
    }),
    filterObserver: Ember.observer('filter.discourse', 'filter.language', 'filter.location', 'filter.theme', function(sender, key) {
        key = key.split('.').pop();
        this.set(key, this.get('filter').get(key));
    }),

    setDateFilter: Ember.observer('date', function(sender, key) {
        var intervals = [];
        this.get(key).forEach(function(interval) {
            interval = interval.split('-');
            if(interval.length > 1) {
                var array = [];
                for(var i = interval[0]; i <= interval[1]; i++) {
                    array.push(parseInt(i));
                }
                interval = array;
            } else {
                interval = parseInt(interval);
            }
            intervals = intervals.concat(interval);
        });
        this.get('filter').set(key, intervals);
    }),
    dateFilterObserver: Ember.observer('filter.date', function(sender, key) {
        key = key.split('.').pop();
        var intervals = [];
        this.get('filter').get('date').forEach(function(date) {
            var isInterval = false;
            intervals.forEach(function(interval) {
                if(interval.length && (interval.includes(date + 1) || interval.includes(date - 1))) {
                    interval.push(date);
                    isInterval = true;
                }
            });
            if (!isInterval) {
                intervals.push([date]);
            }
        });
        intervals.forEach(function(interval, index) {
            if(interval.length > 1) {
               intervals[index] =  interval.shift() + '-' + interval.pop();
            } else {
               intervals[index] =  interval.toString();
            }
        });
        if(!this.arraysEqual(this.get('date').toArray(), intervals)) {
            this.set('date', intervals);    
        }
    }),

    arraysEqual: function(a, b) {
        if (a === b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length !== b.length) {
            return false;
        }
        for(var i = 0; i < a.length; ++i) {
            if(a[i] !== b[i]) {
                return false;
            }
        }
        return true;
    },

    

    itemObserver: Ember.observer('player.item', function() {
        var self = this;
        this.store.findRecord('document', this.get('player').get('item'), { reload: true }).then(function(model){
            self.get('player').set('model', model);
            if (self.get('player').get('model').get('transcript')) {
                self.store.findRecord('transcript', encodeURIComponent(self.get('player').get('item'))).then(function(model) {
                    self.get('player').set('transcript', model);
                });
            } else {
                self.get('player').set('transcript', null);
            }
        });
    }),

    notice: null,
    noticeModel: null,

    noticeObserver: Ember.observer('notice', function() {
        var self = this;
        if (this.get('notice')) {
            this.store.findRecord('document', this.get('notice'), { reload: true }).then(function(model){
                self.set('noticeModel', model);
            });
        }
    }),
    noticeModelObserver: Ember.observer('noticeModel', function() {
        if (!this.get('noticeModel')) {
            this.set('notice', null); 
        }
    }),

    init: function() {
        this._super(...arguments);
        this.get('player');
    },

    actions: {

        changeDocument: function(docDirection){
            var direction = (docDirection === "next") ? 1 : -1;
            var currentObject = this.get("filteredDocuments").findBy('id', this.get("currentItem").get('id'));
            if ( currentObject !== 'undefined'){
                var index = this.get("filteredDocuments").indexOf(currentObject);
                if ( typeof(this.get("filteredDocuments").objectAt(index+direction)) !== 'undefined'){
                    return this.set('currentId', this.get("filteredDocuments").objectAt(index+direction).id);
                }
            }
            return this.set('currentId', this.get('filteredDocuments').get('firstObject').id);
        },
        play: function(item){
            this.set("currentId", item.id);
        }

    }
});
