import ENV from 'app-client/config/environment';
import _ from 'lodash/lodash';
import * as constants from 'corpus-common-addon/utils/constants';

export default function() {

    // These comments are here to help you get started. Feel free to delete them.

    /*
      Config (with defaults).

      Note: these only affect routes defined *after* them!
    */
    // this.urlPrefix = '';    // make this `http://localhost:8080`, for example, if your API is on a different server
    // this.namespace = '';    // make this `api`, for example, if your API is namespaced
    this.namespace = ENV.rootURL.replace(/\/$/,'')+'/api/v1';
    // this.timing = 400;      // delay for each request, automatically set to 0 during testing

    this.get('/documents', function({ documents }) {
        return this.serialize(documents.all(), 'sparse-document');
    });

    this.get('/documents/:id', ({documents}, request) => {
        let id = decodeURIComponent(request.params.id);
        return documents.find(id);
    });

    this.get('/documents/:id/transcript',  ({transcripts}, request) => {
        let id = decodeURIComponent(request.params.id);
        return transcripts.find(id).transcript;
    });

    this.get('/languages');

    this.get('/themes');

    this.get('/discourses');

    this.get('/lexvo/:ids', ({lexvos}, request) => {
        var langIds = decodeURIComponent(request.params.ids);
        var resMap = _.reduce(langIds.split(','), function(res, id) {
            var fullId = id;
            if(!_.startsWith(fullId, constants.LEXVO_BASE_URL)) {
                fullId = constants.LEXVO_BASE_URL + id;
            }
            var lexvoRes = lexvos.find(fullId);
            res[id] = lexvoRes?lexvoRes.name:null;
            return res;
        }, {});
        return {
            'lexvoids': resMap
        };
    });

    this.get('/bnf/:ids', ({ bnfs }, request) => {
        var bnfIds = decodeURIComponent(request.params.ids);
        var resMap = _.reduce(bnfIds.split(','), function(res, id) {
            var fullId = id;
            if(_.startsWith(fullId, constants.BNF_BASE_URL)) {
                fullId = fullId.slice(constants.BNF_BASE_URL.length);
            } else if (_.startsWith(fullId, constants.BNF_ARK_BASE_URL)) {
                fullId = fullId.slice(constants.BNF_ARK_BASE_URL.length);
            } else if (!_.startsWith(fullId, constants.BNF_ARK_BASE_ID)) {
                fullId = constants.BNF_ARK_BASE_ID + fullId;
            }
            var bnfRes = bnfs.find(fullId);
            res[id] = bnfRes?bnfRes.label:null;
            return res;
        }, {});
        return {
            'bnfids': resMap
        };
    });


}
