import RESTAdapter from 'ember-data/adapters/rest';
import ENV from 'app-client/config/environment';

export default RESTAdapter.extend({

    namespace: ENV.rootURL.replace(/\/$/,"")+'/api/v1',

    buildURL: function(modelName, id) {
        if(modelName === 'transcript') {
            return this.urlPrefix() + '/documents/' + id + '/' + modelName;
        }
        return this._super(...arguments);
    },

    pathForType: function(modelName) {
        if(modelName === 'transcript') {
            return modelName;
        }
        return this._super(...arguments);
    }

});
