<?php
namespace CorpusParole\Services;

interface LexvoResolverInterface {

    /**
     * Get name from Viaf id
     * @param string $id The id to resolve. Can be an url starting with http://viaf.org/viaf/
     * @return a string with the name
     */
    public function getName($id);

    /**
     * Get a list of names from an array of viaf ids.
     * @param array $ids The array of ids to resolve.
     *                   Each id can be an url starting with http://viaf.org/viaf/
     */
    public function getNames(array $ids);

}
