import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['filtering-component'],

    isDropdownOpen: false,

    filter: '',
    filteredThemes: Ember.computed.filter('themes', function(item) {
        return this.get('filter') && (item.get('label') || '').match(new RegExp('^' + this.get('filter')));
    }).property('filter'),

    init: function() {
        this._super(...arguments);
        jQuery(window).on('click', this, Ember.run.bind(this, this.get('elementFocusOut')));
    },

    elementFocusOut: function(event) {
        if(!$.contains(this.get('element'), event.target)) {
            this.set('isDropdownOpen', false);
        }
    },

    actions: {

        setQueryParameters: function(id) {
            this.get('setQueryParameters')(id);
            this.set('filter', '');
        },

        focusIn: function() {
            this.set('isDropdownOpen', true);
        }

    },


    didDestroyElement: function() {
        this._super(...arguments);
        jQuery(window).off('click', this.get('elementFocusOut'));
    }

});
