<?php

namespace CorpusParole\Console\Commands;

use Config;
use Illuminate\Console\Command;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputArgument;
use Phpoaipmh\Client;
use Phpoaipmh\Endpoint;

class ImportCocoonRDF extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'corpus-parole:importRDF';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description.';

    /**
     * Create a new command instance.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function fire()
    {
        echo("hello\n");
        libxml_use_internal_errors(true);

        $gs = new \EasyRdf_GraphStore(Config::get('corpusparole.sesame_update_url'));

        //$doc = new \EasyRdf_Graph("http://cocoon.huma-num.fr/exist/crdo/rdf/crdo-ESLO1_ENTCONT_203");
        //$doc->load();

        $client = new Client(Config::get('corpusparole.cocoon_oaipmh_url'));
        //$client = new Client('http://memory.loc.gov/cgi-bin/oai2_0');
        $endpoint = new Endpoint($client);

        $recs = $endpoint->listRecords('olac', null, null, 'LanguesDeFrance');
        //$recs = $endpoint->listRecords('oai_dc', null, null, 'mussm');

        foreach ($recs as $item) {
            if ($recs->getNumRequests() > 1) {
                break;
            }
            $identifier = (string) $item->xpath('/record/header/identifier')[0];
            $docRdfUrl = Config::get('corpusparole.cocoon_rdf_base_uri').substr($identifier, strlen(Config::get('corpusparole.cocoon_doc_id_base')));
            print("Processing $identifier : $docRdfUrl\n");
            $doc = new \EasyRdf_Graph($docRdfUrl);
            $doc->load();
            $subjects = $doc->resourcesMatching('foaf:primaryTopic');
            $subject = reset($subjects)->getUri();
            $gs->insert($doc, $subject);
        }
    }

    /**
     * Get the console command arguments.
     *
     * @return array
     */
    protected function getArguments()
    {
        return [
            ['example', InputArgument::REQUIRED, 'An example argument.'],
        ];
    }

    /**
     * Get the console command options.
     *
     * @return array
     */
    protected function getOptions()
    {
        return [
            //['example', null, InputOption::VALUE_OPTIONAL, 'An example option.', null],
        ];
    }
}
