<?php
namespace CorpusParole\Models;

use Config;
use CorpusParole\Libraries\Utils;
use Log;

/**
 * Model class for Document. Inherit from EasyRdf_Resource
 */
class Document extends \EasyRdf_Resource {

    public function __construct($uri, $graph = null) {
        parent::__construct($uri, $graph);
        $this->innerDocument = $this->getResource('foaf:primaryTopic');
    }

    private $id = null;
    private $innerDocument = null;

    public function getId() {
        if(is_null($this->id)) {
            $this->id = substr($this->uri, strlen(Config::get('corpusparole.cocoon_doc_id_base_uri')));
        }
        return $this->id;
    }

    public function getTitle() {
        return $this->innerDocument->getLiteral('dc11:title');
    }

    public function getPublishers() {
        return $this->innerDocument->allLiterals('dc11:publisher');
    }

    public function getMediaArray() {

        //TODO: add media type
        $res = [];
        $formats = $this->innerDocument->allResources("dc:isFormatOf");
        foreach ($formats as $f) {
            $uri = $f->getUri();
            $mimetype = Utils::get_mimetype($uri);
            array_push($res, ["url" => $uri, "format" => $mimetype]);
        }
        array_push($res, ["url" => $this->innerDocument->getUri(), "format" => $this->innerDocument->getLiteral('dc11:format')]);
        return $res;
    }

    public function getTypes() {
        return $this->innerDocument->all('dc11:type');
    }

    public function getDiscourseTypes() {
        return array_values(array_filter($this->getTypes(), function($v) {
            return $v instanceof \EasyRdf_Literal && $v->getDatatypeUri() === Config::get('constants.OLAC_DISCOURSE_TYPE')['uri'];
        }));
    }

    public function getOtherTypes() {
        $res = array_values(array_filter($this->getTypes(), function($v) {
            return $v instanceof \EasyRdf_Resource || $v->getDatatypeUri() !== Config::get('constants.OLAC_DISCOURSE_TYPE')['uri'];
        }));
        return $res;
    }

    public function updateDiscourseTypes(array $discoursesTypes) {
        foreach($this->getDiscourseTypes() as $discourseType) {
            $this->innerDocument->delete('dc11:type', $discourseType);
        }
        // re-add them

        foreach($discoursesTypes as $dType) {
            $this->innerDocument->add('dc11:type', new \EasyRdf_Literal($dType, null, Config::get('constants.OLAC_DISCOURSE_TYPE')['uri']));
        }
    }

    public function isIsomorphic($doc) {
        return \EasyRdf_Isomorphic::isomorphic($this->graph, $doc->graph);
    }

    /*
     * Clone document.
     * clone also the innerDocumenent
     */
    public function __clone() {

        $this->graph = new \EasyRdf_Graph($this->graph->getUri(), $this->graph->toRdfPhp());
        $this->innerDocument = $this->getResource('foaf:primaryTopic');
    }

}
