import DS from 'ember-data';
import Ember from 'ember';
import _ from 'lodash/lodash';

var CPDocument = DS.Model.extend({
  // id: DS.attr('string'),
  uri: DS.attr('string'),
  title: DS.attr('string'),
  language: DS.attr('string'),
  publishers: DS.attr({defaultValue: []}),
  contributors: DS.attr({defaultValue: []}),
  mediaArray: DS.attr({defaultValue: []}),
  mediaList: Ember.computed('mediaArray', function() {
    var res = [];
    var mp3 = null;
    _.forEach(this.get('mediaArray'), function(m) {
      if(m.format === 'audio/mpeg') {
        mp3 = m;
      } else if (m.format.startsWith('audio/')) {
        res.push(m);
      }
    });
    if(mp3) {
      res.unshift(mp3);
    }
    return res;
  })
});

CPDocument.reopenClass({
  FIXTURES: [

  ]
});

export default CPDocument;
