Contributing to YUI
===================

The YUI Project is a two-way open-source project managed by the YUI engineering
team at Yahoo!. Please read about our
[Contributor Model](https://github.com/yui/yui3/wiki/Contributor-Model)
for more details.


Getting Started
---------------
(see also [Developer Workflow](https://github.com/yui/yui3/wiki/Developer-Workflow) )

**Join YUILibrary.com**

Create a free account on
[YUILibrary.com](http://yuilibrary.com/forum/ucp.php?mode=register) account so
you can:

  * [Create bugs](https://github.com/yui/yui3/issues/new) and
  enhancement requests.
  * Post on the [support forum](http://yuilibrary.com/forum/).
  * Contribute modules to the [Gallery](http://yuilibrary.com/gallery/).
  * Contribute documentation, examples or code to the core library. (You will
    also need a GitHub account and signed CLA - see below).

**Join GitHub.com**

Create a free account on [GitHub](https://github.com/signup/free) so you can:

  * Fork the source code.
  * Contribute modules to the Gallery. (You can now use your own repo as the
  source.)
  * Contribute documentation, examples or code to the core library.

**Submit a CLA**

Sign and submit a [Contributor License Agreement (CLA)](http://yuilibrary.com/contribute/cla/) so you can:

  * Have your Gallery modules hosted on the Yahoo! CDN.
  * Contribute bug fixes and enhancements to the core library.
  * Make sure you check **"individual"** or **"company"** in the CLA form.

**Join YUI Contributor Mailing List**

Join the [mailing list](https://groups.google.com/forum/?fromgroups=#!forum/yui-contrib) so you can:
   * Discuss technical issues about your feature.
   * Contribute to ongoing discussions around YUI features.
   * Read about major pull requests and give feedback.

**Fork Repo**
   * Visit https://github.com/yui/yui3 and click the fork button.
   * Clone this fork down to your local PC.
   * For a specific task, create a branch on this clone and check your changes
   into this branch.
   * Push those changes back to your "origin" (back up to github).

**Build YUI**
   * See [Building YUI](https://github.com/yui/yui3/wiki/Developer-Workflow#building-yui).

**Pull Request**
   * See [Making a change to YUI](https://github.com/yui/yui3/wiki/Developer-Workflow#making-a-change-to-yui).
   * Issue a pull request from your special branch via github to the yui/yui3 repo.
   * Make sure your pull request is against `dev-3.x` or `dev-master` **not** `3.x` or `master`.
   * `dev-master` is for small changes or bugfixes. `dev-3.x` is for bigger
   features or updates. (For more details see
   [Branch Information](https://github.com/yui/yui3/wiki/Developer-Workflow#branch-information) )
   * Be sure your pull request meets the
   [Contribution Standards](https://github.com/yui/yui3/wiki/Contribution-Standards).

**Other Resources**
   * [Contribute Code to YUI](http://yuilibrary.com/yui/docs/tutorials/contribute/)

Pull Request Requirements
-------------------------
**If you are making a pull request now please take note of the following
requirements that your pull request needs (from Contribution Standards, above):**

   * Complete API Docs and inline code comments
   * Unit tests with 80% line coverage
   * User Guide (Components only)
   * Functional examples, written up in Selleck format and with test automation
   (https://github.com/yui/yui3/wiki/Selleck-Example-Tests)
   * Proper commit logs
   * Proper updates to HISTORY.md
