/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/attribute-observable/attribute-observable.js']) {
   __coverage__['build/attribute-observable/attribute-observable.js'] = {"path":"build/attribute-observable/attribute-observable.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":32},"end":{"line":1,"column":51}}},"2":{"name":"AttributeObservable","line":37,"loc":{"start":{"line":37,"column":4},"end":{"line":37,"column":35}}},"3":{"name":"(anonymous_3)","line":68,"loc":{"start":{"line":68,"column":14},"end":{"line":68,"column":40}}},"4":{"name":"(anonymous_4)","line":85,"loc":{"start":{"line":85,"column":15},"end":{"line":85,"column":41}}},"5":{"name":"(anonymous_5)","line":98,"loc":{"start":{"line":98,"column":19},"end":{"line":98,"column":41}}},"6":{"name":"(anonymous_6)","line":112,"loc":{"start":{"line":112,"column":20},"end":{"line":112,"column":42}}},"7":{"name":"(anonymous_7)","line":135,"loc":{"start":{"line":135,"column":26},"end":{"line":135,"column":86}}},"8":{"name":"(anonymous_8)","line":195,"loc":{"start":{"line":195,"column":27},"end":{"line":195,"column":39}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":225,"column":45}},"2":{"start":{"line":24,"column":4},"end":{"line":27,"column":32}},"3":{"start":{"line":37,"column":4},"end":{"line":42,"column":5}},"4":{"start":{"line":39,"column":8},"end":{"line":39,"column":33}},"5":{"start":{"line":41,"column":8},"end":{"line":41,"column":50}},"6":{"start":{"line":44,"column":4},"end":{"line":44,"column":48}},"7":{"start":{"line":46,"column":4},"end":{"line":205,"column":6}},"8":{"start":{"line":69,"column":12},"end":{"line":69,"column":50}},"9":{"start":{"line":86,"column":12},"end":{"line":86,"column":56}},"10":{"start":{"line":99,"column":12},"end":{"line":99,"column":47}},"11":{"start":{"line":113,"column":12},"end":{"line":113,"column":21}},"12":{"start":{"line":114,"column":12},"end":{"line":118,"column":13}},"13":{"start":{"line":115,"column":16},"end":{"line":117,"column":17}},"14":{"start":{"line":116,"column":20},"end":{"line":116,"column":54}},"15":{"start":{"line":119,"column":12},"end":{"line":119,"column":24}},"16":{"start":{"line":136,"column":12},"end":{"line":142,"column":18}},"17":{"start":{"line":144,"column":12},"end":{"line":146,"column":13}},"18":{"start":{"line":145,"column":16},"end":{"line":145,"column":49}},"19":{"start":{"line":148,"column":12},"end":{"line":164,"column":13}},"20":{"start":{"line":152,"column":16},"end":{"line":152,"column":45}},"21":{"start":{"line":154,"column":16},"end":{"line":154,"column":36}},"22":{"start":{"line":155,"column":16},"end":{"line":155,"column":43}},"23":{"start":{"line":156,"column":16},"end":{"line":156,"column":52}},"24":{"start":{"line":158,"column":16},"end":{"line":158,"column":42}},"25":{"start":{"line":159,"column":16},"end":{"line":161,"column":17}},"26":{"start":{"line":160,"column":20},"end":{"line":160,"column":44}},"27":{"start":{"line":163,"column":16},"end":{"line":163,"column":37}},"28":{"start":{"line":166,"column":12},"end":{"line":171,"column":13}},"29":{"start":{"line":167,"column":16},"end":{"line":167,"column":39}},"30":{"start":{"line":168,"column":16},"end":{"line":168,"column":31}},"31":{"start":{"line":170,"column":16},"end":{"line":170,"column":45}},"32":{"start":{"line":176,"column":12},"end":{"line":176,"column":39}},"33":{"start":{"line":177,"column":12},"end":{"line":177,"column":45}},"34":{"start":{"line":178,"column":12},"end":{"line":178,"column":37}},"35":{"start":{"line":179,"column":12},"end":{"line":179,"column":35}},"36":{"start":{"line":181,"column":12},"end":{"line":185,"column":13}},"37":{"start":{"line":182,"column":16},"end":{"line":182,"column":51}},"38":{"start":{"line":184,"column":16},"end":{"line":184,"column":45}},"39":{"start":{"line":197,"column":12},"end":{"line":203,"column":13}},"40":{"start":{"line":199,"column":16},"end":{"line":199,"column":45}},"41":{"start":{"line":202,"column":16},"end":{"line":202,"column":48}},"42":{"start":{"line":208,"column":4},"end":{"line":208,"column":60}},"43":{"start":{"line":210,"column":4},"end":{"line":210,"column":48}},"44":{"start":{"line":222,"column":4},"end":{"line":222,"column":44}}},"branchMap":{"1":{"line":115,"type":"if","locations":[{"start":{"line":115,"column":16},"end":{"line":115,"column":16}},{"start":{"line":115,"column":16},"end":{"line":115,"column":16}}]},"2":{"line":144,"type":"if","locations":[{"start":{"line":144,"column":12},"end":{"line":144,"column":12}},{"start":{"line":144,"column":12},"end":{"line":144,"column":12}}]},"3":{"line":145,"type":"binary-expr","locations":[{"start":{"line":145,"column":22},"end":{"line":145,"column":42}},{"start":{"line":145,"column":46},"end":{"line":145,"column":48}}]},"4":{"line":148,"type":"if","locations":[{"start":{"line":148,"column":12},"end":{"line":148,"column":12}},{"start":{"line":148,"column":12},"end":{"line":148,"column":12}}]},"5":{"line":159,"type":"if","locations":[{"start":{"line":159,"column":16},"end":{"line":159,"column":16}},{"start":{"line":159,"column":16},"end":{"line":159,"column":16}}]},"6":{"line":166,"type":"if","locations":[{"start":{"line":166,"column":12},"end":{"line":166,"column":12}},{"start":{"line":166,"column":12},"end":{"line":166,"column":12}}]},"7":{"line":181,"type":"if","locations":[{"start":{"line":181,"column":12},"end":{"line":181,"column":12}},{"start":{"line":181,"column":12},"end":{"line":181,"column":12}}]},"8":{"line":197,"type":"if","locations":[{"start":{"line":197,"column":12},"end":{"line":197,"column":12}},{"start":{"line":197,"column":12},"end":{"line":197,"column":12}}]}},"code":["(function () { YUI.add('attribute-observable', function (Y, NAME) {","","    /*For log lines*/","    /*jshint maxlen:200*/","","","    /**","     * The attribute module provides an augmentable Attribute implementation, which","     * adds configurable attributes and attribute change events to the class being","     * augmented. It also provides a State class, which is used internally by Attribute,","     * but can also be used independently to provide a name/property/value data structure to","     * store state.","     *","     * @module attribute","     */","","    /**","     * The `attribute-observable` submodule provides augmentable attribute change event support","     * for AttributeCore based implementations.","     *","     * @module attribute","     * @submodule attribute-observable","     */","    var EventTarget = Y.EventTarget,","","        CHANGE = \"Change\",","        BROADCAST = \"broadcast\";","","    /**","     * Provides an augmentable implementation of attribute change events for","     * AttributeCore.","     *","     * @class AttributeObservable","     * @extensionfor AttributeCore","     * @uses EventTarget","     */","    function AttributeObservable() {","        // Perf tweak - avoid creating event literals if not required.","        this._ATTR_E_FACADE = {};","","        EventTarget.call(this, {emitFacade:true});","    }","","    AttributeObservable._ATTR_CFG = [BROADCAST];","","    AttributeObservable.prototype = {","","        /**","         * Sets the value of an attribute.","         *","         * @method set","         * @chainable","         *","         * @param {String} name The name of the attribute. If the","         * current value of the attribute is an Object, dot notation can be used","         * to set the value of a property within the object (e.g. <code>set(\"x.y.z\", 5)</code>).","         *","         * @param {Any} value The value to set the attribute to.","         *","         * @param {Object} opts (Optional) Optional event data to be mixed into","         * the event facade passed to subscribers of the attribute's change event. This","         * can be used as a flexible way to identify the source of a call to set, allowing","         * the developer to distinguish between set called internally by the host, vs.","         * set called externally by the application developer.","         *","         * @return {Object} A reference to the host object.","         */","        set : function(name, val, opts) {","            return this._setAttr(name, val, opts);","        },","","        /**","         * Allows setting of readOnly/writeOnce attributes. See <a href=\"#method_set\">set</a> for argument details.","         *","         * @method _set","         * @protected","         * @chainable","         *","         * @param {String} name The name of the attribute.","         * @param {Any} val The value to set the attribute to.","         * @param {Object} opts (Optional) Optional event data to be mixed into","         * the event facade passed to subscribers of the attribute's change event.","         * @return {Object} A reference to the host object.","         */","        _set : function(name, val, opts) {","            return this._setAttr(name, val, opts, true);","        },","","        /**","         * Sets multiple attribute values.","         *","         * @method setAttrs","         * @param {Object} attrs  An object with attributes name/value pairs.","         * @param {Object} opts  Properties to mix into the event payload. These are shared and mixed into each set","         * @return {Object} A reference to the host object.","         * @chainable","         */","        setAttrs : function(attrs, opts) {","            return this._setAttrs(attrs, opts);","        },","","        /**","         * Implementation behind the public setAttrs method, to set multiple attribute values.","         *","         * @method _setAttrs","         * @protected","         * @param {Object} attrs  An object with attributes name/value pairs.","         * @param {Object} opts  Properties to mix into the event payload. These are shared and mixed into each set","         * @return {Object} A reference to the host object.","         * @chainable","         */","        _setAttrs : function(attrs, opts) {","            var attr;","            for (attr in attrs) {","                if ( attrs.hasOwnProperty(attr) ) {","                    this.set(attr, attrs[attr], opts);","                }","            }","            return this;","        },","","        /**","         * Utility method to help setup the event payload and fire the attribute change event.","         *","         * @method _fireAttrChange","         * @private","         * @param {String} attrName The name of the attribute","         * @param {String} subAttrName The full path of the property being changed,","         * if this is a sub-attribute value being change. Otherwise null.","         * @param {Any} currVal The current value of the attribute","         * @param {Any} newVal The new value of the attribute","         * @param {Object} opts Any additional event data to mix into the attribute change event's event facade.","         * @param {Object} [cfg] The attribute config stored in State, if already available.","         */","        _fireAttrChange : function(attrName, subAttrName, currVal, newVal, opts, cfg) {","            var host = this,","                eventName = this._getFullType(attrName + CHANGE),","                state = host._state,","                hasOpts = false,","                facade,","                broadcast,","                e;","","            if (!cfg) {","                cfg = state.data[attrName] || {};","            }","","            if (!cfg.published) {","","                // PERF: Using lower level _publish() for","                // critical path performance","                e = host._publish(eventName);","","                e.emitFacade = true;","                e.defaultTargetOnly = true;","                e.defaultFn = host._defAttrChangeFn;","","                broadcast = cfg.broadcast;","                if (broadcast !== undefined) {","                    e.broadcast = broadcast;","                }","","                cfg.published = true;","            }","","            if (opts) {","                facade = Y.merge(opts);","                hasOpts = true;","            } else {","                facade = host._ATTR_E_FACADE;","            }","","            // Not using the single object signature for fire({type:..., newVal:...}), since","            // we don't want to override type. Changed to the fire(type, {newVal:...}) signature.","","            facade.attrName = attrName;","            facade.subAttrName = subAttrName;","            facade.prevVal = currVal;","            facade.newVal = newVal;","","            if (hasOpts) {","                host.fire(eventName, facade, opts);","            } else {","                host.fire(eventName, facade);","            }","        },","","        /**","         * Default function for attribute change events.","         *","         * @private","         * @method _defAttrChangeFn","         * @param {EventFacade} e The event object for attribute change events.","         */","        _defAttrChangeFn : function(e) {","","            if (!this._setAttrVal(e.attrName, e.subAttrName, e.prevVal, e.newVal, e.details[1])) {","                // Prevent \"after\" listeners from being invoked since nothing changed.","                e.stopImmediatePropagation();","","            } else {","                e.newVal = this.get(e.attrName);","            }","        }","    };","","    // Basic prototype augment - no lazy constructor invocation.","    Y.mix(AttributeObservable, EventTarget, false, null, 1);","","    Y.AttributeObservable = AttributeObservable;","","    /**","    The `AttributeEvents` class extension was deprecated in YUI 3.8.0 and is now","    an alias for the `AttributeObservable` class extension. Use that class","    extnesion instead. This alias will be removed in a future version of YUI.","","    @class AttributeEvents","    @uses EventTarget","    @deprecated Use `AttributeObservable` instead.","    @see AttributeObservable","    **/","    Y.AttributeEvents = AttributeObservable;","","","}, '3.10.3', {\"requires\": [\"event-custom\"]});","","}());"]};
}
var __cov_9K73gzfZHiMKML8YmNpq_A = __coverage__['build/attribute-observable/attribute-observable.js'];
__cov_9K73gzfZHiMKML8YmNpq_A.s['1']++;YUI.add('attribute-observable',function(Y,NAME){__cov_9K73gzfZHiMKML8YmNpq_A.f['1']++;__cov_9K73gzfZHiMKML8YmNpq_A.s['2']++;var EventTarget=Y.EventTarget,CHANGE='Change',BROADCAST='broadcast';__cov_9K73gzfZHiMKML8YmNpq_A.s['3']++;function AttributeObservable(){__cov_9K73gzfZHiMKML8YmNpq_A.f['2']++;__cov_9K73gzfZHiMKML8YmNpq_A.s['4']++;this._ATTR_E_FACADE={};__cov_9K73gzfZHiMKML8YmNpq_A.s['5']++;EventTarget.call(this,{emitFacade:true});}__cov_9K73gzfZHiMKML8YmNpq_A.s['6']++;AttributeObservable._ATTR_CFG=[BROADCAST];__cov_9K73gzfZHiMKML8YmNpq_A.s['7']++;AttributeObservable.prototype={set:function(name,val,opts){__cov_9K73gzfZHiMKML8YmNpq_A.f['3']++;__cov_9K73gzfZHiMKML8YmNpq_A.s['8']++;return this._setAttr(name,val,opts);},_set:function(name,val,opts){__cov_9K73gzfZHiMKML8YmNpq_A.f['4']++;__cov_9K73gzfZHiMKML8YmNpq_A.s['9']++;return this._setAttr(name,val,opts,true);},setAttrs:function(attrs,opts){__cov_9K73gzfZHiMKML8YmNpq_A.f['5']++;__cov_9K73gzfZHiMKML8YmNpq_A.s['10']++;return this._setAttrs(attrs,opts);},_setAttrs:function(attrs,opts){__cov_9K73gzfZHiMKML8YmNpq_A.f['6']++;__cov_9K73gzfZHiMKML8YmNpq_A.s['11']++;var attr;__cov_9K73gzfZHiMKML8YmNpq_A.s['12']++;for(attr in attrs){__cov_9K73gzfZHiMKML8YmNpq_A.s['13']++;if(attrs.hasOwnProperty(attr)){__cov_9K73gzfZHiMKML8YmNpq_A.b['1'][0]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['14']++;this.set(attr,attrs[attr],opts);}else{__cov_9K73gzfZHiMKML8YmNpq_A.b['1'][1]++;}}__cov_9K73gzfZHiMKML8YmNpq_A.s['15']++;return this;},_fireAttrChange:function(attrName,subAttrName,currVal,newVal,opts,cfg){__cov_9K73gzfZHiMKML8YmNpq_A.f['7']++;__cov_9K73gzfZHiMKML8YmNpq_A.s['16']++;var host=this,eventName=this._getFullType(attrName+CHANGE),state=host._state,hasOpts=false,facade,broadcast,e;__cov_9K73gzfZHiMKML8YmNpq_A.s['17']++;if(!cfg){__cov_9K73gzfZHiMKML8YmNpq_A.b['2'][0]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['18']++;cfg=(__cov_9K73gzfZHiMKML8YmNpq_A.b['3'][0]++,state.data[attrName])||(__cov_9K73gzfZHiMKML8YmNpq_A.b['3'][1]++,{});}else{__cov_9K73gzfZHiMKML8YmNpq_A.b['2'][1]++;}__cov_9K73gzfZHiMKML8YmNpq_A.s['19']++;if(!cfg.published){__cov_9K73gzfZHiMKML8YmNpq_A.b['4'][0]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['20']++;e=host._publish(eventName);__cov_9K73gzfZHiMKML8YmNpq_A.s['21']++;e.emitFacade=true;__cov_9K73gzfZHiMKML8YmNpq_A.s['22']++;e.defaultTargetOnly=true;__cov_9K73gzfZHiMKML8YmNpq_A.s['23']++;e.defaultFn=host._defAttrChangeFn;__cov_9K73gzfZHiMKML8YmNpq_A.s['24']++;broadcast=cfg.broadcast;__cov_9K73gzfZHiMKML8YmNpq_A.s['25']++;if(broadcast!==undefined){__cov_9K73gzfZHiMKML8YmNpq_A.b['5'][0]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['26']++;e.broadcast=broadcast;}else{__cov_9K73gzfZHiMKML8YmNpq_A.b['5'][1]++;}__cov_9K73gzfZHiMKML8YmNpq_A.s['27']++;cfg.published=true;}else{__cov_9K73gzfZHiMKML8YmNpq_A.b['4'][1]++;}__cov_9K73gzfZHiMKML8YmNpq_A.s['28']++;if(opts){__cov_9K73gzfZHiMKML8YmNpq_A.b['6'][0]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['29']++;facade=Y.merge(opts);__cov_9K73gzfZHiMKML8YmNpq_A.s['30']++;hasOpts=true;}else{__cov_9K73gzfZHiMKML8YmNpq_A.b['6'][1]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['31']++;facade=host._ATTR_E_FACADE;}__cov_9K73gzfZHiMKML8YmNpq_A.s['32']++;facade.attrName=attrName;__cov_9K73gzfZHiMKML8YmNpq_A.s['33']++;facade.subAttrName=subAttrName;__cov_9K73gzfZHiMKML8YmNpq_A.s['34']++;facade.prevVal=currVal;__cov_9K73gzfZHiMKML8YmNpq_A.s['35']++;facade.newVal=newVal;__cov_9K73gzfZHiMKML8YmNpq_A.s['36']++;if(hasOpts){__cov_9K73gzfZHiMKML8YmNpq_A.b['7'][0]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['37']++;host.fire(eventName,facade,opts);}else{__cov_9K73gzfZHiMKML8YmNpq_A.b['7'][1]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['38']++;host.fire(eventName,facade);}},_defAttrChangeFn:function(e){__cov_9K73gzfZHiMKML8YmNpq_A.f['8']++;__cov_9K73gzfZHiMKML8YmNpq_A.s['39']++;if(!this._setAttrVal(e.attrName,e.subAttrName,e.prevVal,e.newVal,e.details[1])){__cov_9K73gzfZHiMKML8YmNpq_A.b['8'][0]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['40']++;e.stopImmediatePropagation();}else{__cov_9K73gzfZHiMKML8YmNpq_A.b['8'][1]++;__cov_9K73gzfZHiMKML8YmNpq_A.s['41']++;e.newVal=this.get(e.attrName);}}};__cov_9K73gzfZHiMKML8YmNpq_A.s['42']++;Y.mix(AttributeObservable,EventTarget,false,null,1);__cov_9K73gzfZHiMKML8YmNpq_A.s['43']++;Y.AttributeObservable=AttributeObservable;__cov_9K73gzfZHiMKML8YmNpq_A.s['44']++;Y.AttributeEvents=AttributeObservable;},'3.10.3',{'requires':['event-custom']});
