/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/widget-position/widget-position.js']) {
   __coverage__['build/widget-position/widget-position.js'] = {"path":"build/widget-position/widget-position.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0,0],"4":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":27},"end":{"line":1,"column":46}}},"2":{"name":"Position","line":33,"loc":{"start":{"line":33,"column":4},"end":{"line":33,"column":30}}},"3":{"name":"(anonymous_3)","line":61,"loc":{"start":{"line":61,"column":20},"end":{"line":61,"column":34}}},"4":{"name":"(anonymous_4)","line":64,"loc":{"start":{"line":64,"column":20},"end":{"line":64,"column":31}}},"5":{"name":"(anonymous_5)","line":79,"loc":{"start":{"line":79,"column":20},"end":{"line":79,"column":34}}},"6":{"name":"(anonymous_6)","line":82,"loc":{"start":{"line":82,"column":20},"end":{"line":82,"column":31}}},"7":{"name":"(anonymous_7)","line":97,"loc":{"start":{"line":97,"column":23},"end":{"line":97,"column":37}}},"8":{"name":"(anonymous_8)","line":124,"loc":{"start":{"line":124,"column":28},"end":{"line":124,"column":39}}},"9":{"name":"(anonymous_9)","line":137,"loc":{"start":{"line":137,"column":26},"end":{"line":137,"column":37}}},"10":{"name":"(anonymous_10)","line":155,"loc":{"start":{"line":155,"column":25},"end":{"line":155,"column":36}}},"11":{"name":"(anonymous_11)","line":170,"loc":{"start":{"line":170,"column":14},"end":{"line":170,"column":26}}},"12":{"name":"(anonymous_12)","line":182,"loc":{"start":{"line":182,"column":17},"end":{"line":182,"column":29}}},"13":{"name":"(anonymous_13)","line":194,"loc":{"start":{"line":194,"column":22},"end":{"line":194,"column":36}}},"14":{"name":"(anonymous_14)","line":206,"loc":{"start":{"line":206,"column":16},"end":{"line":206,"column":30}}},"15":{"name":"(anonymous_15)","line":218,"loc":{"start":{"line":218,"column":16},"end":{"line":218,"column":30}}},"16":{"name":"(anonymous_16)","line":230,"loc":{"start":{"line":230,"column":16},"end":{"line":230,"column":27}}},"17":{"name":"(anonymous_17)","line":242,"loc":{"start":{"line":242,"column":16},"end":{"line":242,"column":27}}},"18":{"name":"(anonymous_18)","line":254,"loc":{"start":{"line":254,"column":25},"end":{"line":254,"column":37}}},"19":{"name":"(anonymous_19)","line":267,"loc":{"start":{"line":267,"column":19},"end":{"line":267,"column":33}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":275,"column":68}},"2":{"start":{"line":8,"column":4},"end":{"line":24,"column":30}},"3":{"start":{"line":33,"column":4},"end":{"line":40,"column":5}},"4":{"start":{"line":34,"column":8},"end":{"line":34,"column":47}},"5":{"start":{"line":37,"column":8},"end":{"line":37,"column":56}},"6":{"start":{"line":38,"column":8},"end":{"line":38,"column":52}},"7":{"start":{"line":39,"column":8},"end":{"line":39,"column":52}},"8":{"start":{"line":50,"column":4},"end":{"line":101,"column":6}},"9":{"start":{"line":62,"column":16},"end":{"line":62,"column":32}},"10":{"start":{"line":65,"column":16},"end":{"line":65,"column":36}},"11":{"start":{"line":80,"column":16},"end":{"line":80,"column":32}},"12":{"start":{"line":83,"column":16},"end":{"line":83,"column":36}},"13":{"start":{"line":98,"column":16},"end":{"line":98,"column":45}},"14":{"start":{"line":111,"column":4},"end":{"line":111,"column":69}},"15":{"start":{"line":113,"column":4},"end":{"line":270,"column":6}},"16":{"start":{"line":125,"column":12},"end":{"line":125,"column":67}},"17":{"start":{"line":138,"column":12},"end":{"line":138,"column":40}},"18":{"start":{"line":139,"column":12},"end":{"line":141,"column":13}},"19":{"start":{"line":140,"column":16},"end":{"line":140,"column":30}},"20":{"start":{"line":142,"column":12},"end":{"line":142,"column":46}},"21":{"start":{"line":156,"column":12},"end":{"line":156,"column":54}},"22":{"start":{"line":171,"column":12},"end":{"line":172,"column":79}},"23":{"start":{"line":173,"column":16},"end":{"line":173,"column":42}},"24":{"start":{"line":183,"column":12},"end":{"line":183,"column":65}},"25":{"start":{"line":195,"column":12},"end":{"line":195,"column":89}},"26":{"start":{"line":207,"column":12},"end":{"line":207,"column":61}},"27":{"start":{"line":219,"column":12},"end":{"line":219,"column":61}},"28":{"start":{"line":231,"column":12},"end":{"line":231,"column":41}},"29":{"start":{"line":243,"column":12},"end":{"line":243,"column":41}},"30":{"start":{"line":255,"column":12},"end":{"line":257,"column":13}},"31":{"start":{"line":256,"column":16},"end":{"line":256,"column":40}},"32":{"start":{"line":268,"column":12},"end":{"line":268,"column":37}},"33":{"start":{"line":272,"column":4},"end":{"line":272,"column":32}}},"branchMap":{"1":{"line":139,"type":"if","locations":[{"start":{"line":139,"column":12},"end":{"line":139,"column":12}},{"start":{"line":139,"column":12},"end":{"line":139,"column":12}}]},"2":{"line":172,"type":"cond-expr","locations":[{"start":{"line":172,"column":50},"end":{"line":172,"column":57}},{"start":{"line":172,"column":60},"end":{"line":172,"column":78}}]},"3":{"line":195,"type":"binary-expr","locations":[{"start":{"line":195,"column":20},"end":{"line":195,"column":37}},{"start":{"line":195,"column":41},"end":{"line":195,"column":62}},{"start":{"line":195,"column":66},"end":{"line":195,"column":87}}]},"4":{"line":255,"type":"if","locations":[{"start":{"line":255,"column":12},"end":{"line":255,"column":12}},{"start":{"line":255,"column":12},"end":{"line":255,"column":12}}]}},"code":["(function () { YUI.add('widget-position', function (Y, NAME) {","","/**"," * Provides basic XY positioning support for Widgets, though an extension"," *"," * @module widget-position"," */","    var Lang = Y.Lang,","        Widget = Y.Widget,","","        XY_COORD = \"xy\",","","        POSITION = \"position\",","        POSITIONED = \"positioned\",","        BOUNDING_BOX = \"boundingBox\",","        RELATIVE = \"relative\",","","        RENDERUI = \"renderUI\",","        BINDUI = \"bindUI\",","        SYNCUI = \"syncUI\",","","        UI = Widget.UI_SRC,","","        XYChange = \"xyChange\";","","    /**","     * Widget extension, which can be used to add positioning support to the base Widget class, ","     * through the <a href=\"Base.html#method_build\">Base.build</a> method.","     *","     * @class WidgetPosition","     * @param {Object} config User configuration object","     */","    function Position(config) {","        this._posNode = this.get(BOUNDING_BOX);","","        // WIDGET METHOD OVERLAP","        Y.after(this._renderUIPosition, this, RENDERUI);","        Y.after(this._syncUIPosition, this, SYNCUI);","        Y.after(this._bindUIPosition, this, BINDUI);","    }","","    /**","     * Static property used to define the default attribute ","     * configuration introduced by WidgetPosition.","     *","     * @property ATTRS","     * @static","     * @type Object","     */","    Position.ATTRS = {","","        /**","         * @attribute x","         * @type number","         * @default 0","         *","         * @description Page X co-ordinate for the widget. This attribute acts as a facade for the ","         * xy attribute. Changes in position can be monitored by listening for xyChange events.","         */","        x: {","            setter: function(val) {","                this._setX(val);","            },","            getter: function() {","                return this._getX();","            },","            lazyAdd:false","        },","","        /**","         * @attribute y","         * @type number","         * @default 0","         *","         * @description Page Y co-ordinate for the widget. This attribute acts as a facade for the ","         * xy attribute. Changes in position can be monitored by listening for xyChange events.","         */","        y: {","            setter: function(val) {","                this._setY(val);","            },","            getter: function() {","                return this._getY();","            },","            lazyAdd: false","        },","","        /**","         * @attribute xy","         * @type Array","         * @default [0,0]","         *","         * @description Page XY co-ordinate pair for the widget.","         */","        xy: {","            value:[0,0],","            validator: function(val) {","                return this._validateXY(val);","            }","        }","    };","","    /**","     * Default class used to mark the boundingBox of a positioned widget.","     *","     * @property POSITIONED_CLASS_NAME","     * @type String","     * @default \"yui-widget-positioned\"","     * @static","     */","    Position.POSITIONED_CLASS_NAME = Widget.getClassName(POSITIONED);","","    Position.prototype = {","","        /**","         * Creates/Initializes the DOM to support xy page positioning.","         * <p>","         * This method in invoked after renderUI is invoked for the Widget class","         * using YUI's aop infrastructure.","         * </p>","         * @method _renderUIPosition","         * @protected","         */","        _renderUIPosition : function() {","            this._posNode.addClass(Position.POSITIONED_CLASS_NAME);","        },","","        /**","         * Synchronizes the UI to match the Widgets xy page position state.","         * <p>","         * This method in invoked after syncUI is invoked for the Widget class","         * using YUI's aop infrastructure.","         * </p>","         * @method _syncUIPosition","         * @protected","         */","        _syncUIPosition : function() {","            var posNode = this._posNode;","            if (posNode.getStyle(POSITION) === RELATIVE) {","                this.syncXY();","            }","            this._uiSetXY(this.get(XY_COORD));","        },","","        /**","         * Binds event listeners responsible for updating the UI state in response to ","         * Widget position related state changes.","         * <p>","         * This method in invoked after bindUI is invoked for the Widget class","         * using YUI's aop infrastructure.","         * </p>","         * @method _bindUIPosition","         * @protected","         */","        _bindUIPosition :function() {","            this.after(XYChange, this._afterXYChange);","        },","","        /**","         * Moves the Widget to the specified page xy co-ordinate position.","         *","         * @method move","         *","         * @param {Number} x The new x position","         * @param {Number} y The new y position","         * <p>Or</p>","         * @param {Array} x, y values passed as an array ([x, y]), to support","         * simple pass through of Node.getXY results","         */","        move: function () {","            var args = arguments,","                coord = (Lang.isArray(args[0])) ? args[0] : [args[0], args[1]];","                this.set(XY_COORD, coord);","        },","","        /**","         * Synchronizes the Panel's \"xy\", \"x\", and \"y\" properties with the ","         * Widget's position in the DOM.","         *","         * @method syncXY","         */","        syncXY : function () {","            this.set(XY_COORD, this._posNode.getXY(), {src: UI});","        },","","        /**","         * Default validator for the XY attribute","         *","         * @method _validateXY","         * @protected","         * @param {Array} val The XY page co-ordinate value which is being set.","         * @return {boolean} true if valid, false if not.","         */","        _validateXY : function(val) {","            return (Lang.isArray(val) && Lang.isNumber(val[0]) && Lang.isNumber(val[1]));","        },","","        /**","         * Default setter for the X attribute. The setter passes the X value through","         * to the XY attribute, which is the sole store for the XY state.","         *","         * @method _setX","         * @protected","         * @param {Number} val The X page co-ordinate value","         */","        _setX : function(val) {","            this.set(XY_COORD, [val, this.get(XY_COORD)[1]]);","        },","","        /**","         * Default setter for the Y attribute. The setter passes the Y value through","         * to the XY attribute, which is the sole store for the XY state.","         *","         * @method _setY","         * @protected","         * @param {Number} val The Y page co-ordinate value","         */","        _setY : function(val) {","            this.set(XY_COORD, [this.get(XY_COORD)[0], val]);","        },","","        /**","         * Default getter for the X attribute. The value is retrieved from ","         * the XY attribute, which is the sole store for the XY state.","         *","         * @method _getX","         * @protected ","         * @return {Number} The X page co-ordinate value","         */","        _getX : function() {","            return this.get(XY_COORD)[0];","        },","","        /**","         * Default getter for the Y attribute. The value is retrieved from ","         * the XY attribute, which is the sole store for the XY state.","         *","         * @method _getY","         * @protected ","         * @return {Number} The Y page co-ordinate value","         */","        _getY : function() {","            return this.get(XY_COORD)[1];","        },","","        /**","         * Default attribute change listener for the xy attribute, responsible","         * for updating the UI, in response to attribute changes.","         * ","         * @method _afterXYChange","         * @protected","         * @param {EventFacade} e The event facade for the attribute change","         */","        _afterXYChange : function(e) {","            if (e.src != UI) {","                this._uiSetXY(e.newVal);","            }","        },","","        /**","         * Updates the UI to reflect the XY page co-ordinates passed in.","         * ","         * @method _uiSetXY","         * @protected","         * @param {String} val The XY page co-ordinates value to be reflected in the UI","         */","        _uiSetXY : function(val) {","            this._posNode.setXY(val);","        }","    };","","    Y.WidgetPosition = Position;","","","}, '3.10.3', {\"requires\": [\"base-build\", \"node-screen\", \"widget\"]});","","}());"]};
}
var __cov_rwEdJ_2e$TkRuEvyx2pkhQ = __coverage__['build/widget-position/widget-position.js'];
__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['1']++;YUI.add('widget-position',function(Y,NAME){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['1']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['2']++;var Lang=Y.Lang,Widget=Y.Widget,XY_COORD='xy',POSITION='position',POSITIONED='positioned',BOUNDING_BOX='boundingBox',RELATIVE='relative',RENDERUI='renderUI',BINDUI='bindUI',SYNCUI='syncUI',UI=Widget.UI_SRC,XYChange='xyChange';__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['3']++;function Position(config){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['2']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['4']++;this._posNode=this.get(BOUNDING_BOX);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['5']++;Y.after(this._renderUIPosition,this,RENDERUI);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['6']++;Y.after(this._syncUIPosition,this,SYNCUI);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['7']++;Y.after(this._bindUIPosition,this,BINDUI);}__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['8']++;Position.ATTRS={x:{setter:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['3']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['9']++;this._setX(val);},getter:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['4']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['10']++;return this._getX();},lazyAdd:false},y:{setter:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['5']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['11']++;this._setY(val);},getter:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['6']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['12']++;return this._getY();},lazyAdd:false},xy:{value:[0,0],validator:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['7']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['13']++;return this._validateXY(val);}}};__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['14']++;Position.POSITIONED_CLASS_NAME=Widget.getClassName(POSITIONED);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['15']++;Position.prototype={_renderUIPosition:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['8']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['16']++;this._posNode.addClass(Position.POSITIONED_CLASS_NAME);},_syncUIPosition:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['9']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['17']++;var posNode=this._posNode;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['18']++;if(posNode.getStyle(POSITION)===RELATIVE){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['1'][0]++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['19']++;this.syncXY();}else{__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['1'][1]++;}__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['20']++;this._uiSetXY(this.get(XY_COORD));},_bindUIPosition:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['10']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['21']++;this.after(XYChange,this._afterXYChange);},move:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['11']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['22']++;var args=arguments,coord=Lang.isArray(args[0])?(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['2'][0]++,args[0]):(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['2'][1]++,[args[0],args[1]]);__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['23']++;this.set(XY_COORD,coord);},syncXY:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['12']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['24']++;this.set(XY_COORD,this._posNode.getXY(),{src:UI});},_validateXY:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['13']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['25']++;return(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['3'][0]++,Lang.isArray(val))&&(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['3'][1]++,Lang.isNumber(val[0]))&&(__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['3'][2]++,Lang.isNumber(val[1]));},_setX:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['14']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['26']++;this.set(XY_COORD,[val,this.get(XY_COORD)[1]]);},_setY:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['15']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['27']++;this.set(XY_COORD,[this.get(XY_COORD)[0],val]);},_getX:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['16']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['28']++;return this.get(XY_COORD)[0];},_getY:function(){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['17']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['29']++;return this.get(XY_COORD)[1];},_afterXYChange:function(e){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['18']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['30']++;if(e.src!=UI){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['4'][0]++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['31']++;this._uiSetXY(e.newVal);}else{__cov_rwEdJ_2e$TkRuEvyx2pkhQ.b['4'][1]++;}},_uiSetXY:function(val){__cov_rwEdJ_2e$TkRuEvyx2pkhQ.f['19']++;__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['32']++;this._posNode.setXY(val);}};__cov_rwEdJ_2e$TkRuEvyx2pkhQ.s['33']++;Y.WidgetPosition=Position;},'3.10.3',{'requires':['base-build','node-screen','widget']});
