/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/axis-time/axis-time.js']) {
   __coverage__['build/axis-time/axis-time.js'] = {"path":"build/axis-time/axis-time.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0,0]},"f":{"1":0,"2":0,"3":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":21},"end":{"line":1,"column":40}}},"2":{"name":"(anonymous_2)","line":30,"loc":{"start":{"line":30,"column":22},"end":{"line":31,"column":4}}},"3":{"name":"(anonymous_3)","line":57,"loc":{"start":{"line":57,"column":29},"end":{"line":58,"column":4}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":103,"column":55}},"2":{"start":{"line":19,"column":0},"end":{"line":99,"column":3}},"3":{"start":{"line":32,"column":8},"end":{"line":35,"column":18}},"4":{"start":{"line":36,"column":12},"end":{"line":36,"column":19}},"5":{"start":{"line":37,"column":8},"end":{"line":37,"column":37}},"6":{"start":{"line":38,"column":8},"end":{"line":38,"column":29}},"7":{"start":{"line":39,"column":8},"end":{"line":39,"column":21}},"8":{"start":{"line":59,"column":8},"end":{"line":70,"column":74}},"9":{"start":{"line":71,"column":8},"end":{"line":80,"column":9}},"10":{"start":{"line":73,"column":12},"end":{"line":73,"column":30}},"11":{"start":{"line":74,"column":12},"end":{"line":74,"column":31}},"12":{"start":{"line":78,"column":12},"end":{"line":78,"column":30}},"13":{"start":{"line":79,"column":12},"end":{"line":79,"column":31}},"14":{"start":{"line":81,"column":8},"end":{"line":81,"column":46}},"15":{"start":{"line":82,"column":8},"end":{"line":93,"column":9}},"16":{"start":{"line":84,"column":12},"end":{"line":84,"column":57}},"17":{"start":{"line":85,"column":12},"end":{"line":92,"column":13}},"18":{"start":{"line":87,"column":16},"end":{"line":87,"column":30}},"19":{"start":{"line":88,"column":16},"end":{"line":88,"column":52}},"20":{"start":{"line":89,"column":16},"end":{"line":89,"column":89}},"21":{"start":{"line":90,"column":16},"end":{"line":90,"column":38}},"22":{"start":{"line":91,"column":16},"end":{"line":91,"column":40}},"23":{"start":{"line":94,"column":8},"end":{"line":97,"column":10}}},"branchMap":{"1":{"line":71,"type":"if","locations":[{"start":{"line":71,"column":8},"end":{"line":71,"column":8}},{"start":{"line":71,"column":8},"end":{"line":71,"column":8}}]},"2":{"line":85,"type":"if","locations":[{"start":{"line":85,"column":12},"end":{"line":85,"column":12}},{"start":{"line":85,"column":12},"end":{"line":85,"column":12}}]},"3":{"line":85,"type":"binary-expr","locations":[{"start":{"line":85,"column":15},"end":{"line":85,"column":42}},{"start":{"line":85,"column":46},"end":{"line":85,"column":63}},{"start":{"line":85,"column":67},"end":{"line":85,"column":84}}]}},"code":["(function () { YUI.add('axis-time', function (Y, NAME) {","","/**"," * Provides functionality for drawing a time axis for use with a chart."," *"," * @module charts"," * @submodule axis-time"," */","/**"," * TimeAxis draws a time-based axis for a chart."," *"," * @class TimeAxis"," * @constructor"," * @extends Axis"," * @uses TimeImpl"," * @param {Object} config (optional) Configuration parameters."," * @submodule axis-time"," */","Y.TimeAxis = Y.Base.create(\"timeAxis\", Y.Axis, [Y.TimeImpl], {","    /**","     * Calculates and returns a value based on the number of labels and the index of","     * the current label.","     *","     * @method _getLabelByIndex","     * @param {Number} i Index of the label.","     * @param {Number} l Total number of labels.","     * @return String","     * @private","     */","    _getLabelByIndex: function(i, l)","    {","        var min = this.get(\"minimum\"),","            max = this.get(\"maximum\"),","            increm,","            label;","            l -= 1;","        increm = ((max - min)/l) * i;","        label = min + increm;","        return label;","    },","","    /**","     * Calculates the position of ticks and labels based on an array of specified label values. Returns","     * an object containing an array of values to be used for labels and an array of objects containing","     * x and y coordinates for each label.","     *","     * @method _getDataFromLabelValues","     * @param {Object} startPoint An object containing the x and y coordinates for the start of the axis.","     * @param {Array} labelValues An array containing values to be used for determining the number and","     * position of labels and ticks on the axis.","     * @param {Number} edgeOffset The distance, in pixels, on either edge of the axis.","     * @param {Number} layoutLength The length, in pixels, of the axis. If the axis is vertical, the length","     * is equal to the height. If the axis is horizontal, the length is equal to the width.","     * @return Object","     * @private","     */","    _getDataFromLabelValues: function(startPoint, labelValues, edgeOffset, layoutLength, direction)","    {","        var points = [],","            labelValue,","            i,","            len = labelValues.length,","            staticCoord,","            dynamicCoord,","            constantVal,","            newPoint,","            max = this.get(\"maximum\"),","            min = this.get(\"minimum\"),","            values = [],","            scaleFactor = (layoutLength - (edgeOffset * 2)) / (max - min);","        if(direction === \"vertical\")","        {","            staticCoord = \"x\";","            dynamicCoord = \"y\";","        }","        else","        {","            staticCoord = \"y\";","            dynamicCoord = \"x\";","        }","        constantVal = startPoint[staticCoord];","        for(i = 0; i < len; i = i + 1)","        {","            labelValue = this._getNumber(labelValues[i]);","            if(Y.Lang.isNumber(labelValue) && labelValue >= min && labelValue <= max)","            {","                newPoint = {};","                newPoint[staticCoord] = constantVal;","                newPoint[dynamicCoord] = edgeOffset + ((labelValue - min) * scaleFactor);","                points.push(newPoint);","                values.push(labelValue);","            }","        }","        return {","            points: points,","            values: values","        };","    }","});","","","","}, '3.10.3', {\"requires\": [\"axis\", \"axis-time-base\"]});","","}());"]};
}
var __cov_NIoKAV1h0fULE_RLRoh6Ig = __coverage__['build/axis-time/axis-time.js'];
__cov_NIoKAV1h0fULE_RLRoh6Ig.s['1']++;YUI.add('axis-time',function(Y,NAME){__cov_NIoKAV1h0fULE_RLRoh6Ig.f['1']++;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['2']++;Y.TimeAxis=Y.Base.create('timeAxis',Y.Axis,[Y.TimeImpl],{_getLabelByIndex:function(i,l){__cov_NIoKAV1h0fULE_RLRoh6Ig.f['2']++;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['3']++;var min=this.get('minimum'),max=this.get('maximum'),increm,label;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['4']++;l-=1;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['5']++;increm=(max-min)/l*i;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['6']++;label=min+increm;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['7']++;return label;},_getDataFromLabelValues:function(startPoint,labelValues,edgeOffset,layoutLength,direction){__cov_NIoKAV1h0fULE_RLRoh6Ig.f['3']++;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['8']++;var points=[],labelValue,i,len=labelValues.length,staticCoord,dynamicCoord,constantVal,newPoint,max=this.get('maximum'),min=this.get('minimum'),values=[],scaleFactor=(layoutLength-edgeOffset*2)/(max-min);__cov_NIoKAV1h0fULE_RLRoh6Ig.s['9']++;if(direction==='vertical'){__cov_NIoKAV1h0fULE_RLRoh6Ig.b['1'][0]++;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['10']++;staticCoord='x';__cov_NIoKAV1h0fULE_RLRoh6Ig.s['11']++;dynamicCoord='y';}else{__cov_NIoKAV1h0fULE_RLRoh6Ig.b['1'][1]++;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['12']++;staticCoord='y';__cov_NIoKAV1h0fULE_RLRoh6Ig.s['13']++;dynamicCoord='x';}__cov_NIoKAV1h0fULE_RLRoh6Ig.s['14']++;constantVal=startPoint[staticCoord];__cov_NIoKAV1h0fULE_RLRoh6Ig.s['15']++;for(i=0;i<len;i=i+1){__cov_NIoKAV1h0fULE_RLRoh6Ig.s['16']++;labelValue=this._getNumber(labelValues[i]);__cov_NIoKAV1h0fULE_RLRoh6Ig.s['17']++;if((__cov_NIoKAV1h0fULE_RLRoh6Ig.b['3'][0]++,Y.Lang.isNumber(labelValue))&&(__cov_NIoKAV1h0fULE_RLRoh6Ig.b['3'][1]++,labelValue>=min)&&(__cov_NIoKAV1h0fULE_RLRoh6Ig.b['3'][2]++,labelValue<=max)){__cov_NIoKAV1h0fULE_RLRoh6Ig.b['2'][0]++;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['18']++;newPoint={};__cov_NIoKAV1h0fULE_RLRoh6Ig.s['19']++;newPoint[staticCoord]=constantVal;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['20']++;newPoint[dynamicCoord]=edgeOffset+(labelValue-min)*scaleFactor;__cov_NIoKAV1h0fULE_RLRoh6Ig.s['21']++;points.push(newPoint);__cov_NIoKAV1h0fULE_RLRoh6Ig.s['22']++;values.push(labelValue);}else{__cov_NIoKAV1h0fULE_RLRoh6Ig.b['2'][1]++;}}__cov_NIoKAV1h0fULE_RLRoh6Ig.s['23']++;return{points:points,values:values};}});},'3.10.3',{'requires':['axis','axis-time-base']});
