if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/axis-numeric/axis-numeric.js']) {
   __coverage__['build/axis-numeric/axis-numeric.js'] = {"path":"build/axis-numeric/axis-numeric.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0,0,0,0]},"f":{"1":0,"2":0,"3":0,"4":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":24},"end":{"line":1,"column":43}}},"2":{"name":"(anonymous_2)","line":31,"loc":{"start":{"line":31,"column":22},"end":{"line":32,"column":4}}},"3":{"name":"(anonymous_3)","line":73,"loc":{"start":{"line":73,"column":19},"end":{"line":74,"column":4}}},"4":{"name":"(anonymous_4)","line":117,"loc":{"start":{"line":117,"column":22},"end":{"line":118,"column":4}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":140,"column":61}},"2":{"start":{"line":9,"column":0},"end":{"line":9,"column":20}},"3":{"start":{"line":20,"column":0},"end":{"line":136,"column":3}},"4":{"start":{"line":33,"column":8},"end":{"line":37,"column":56}},"5":{"start":{"line":38,"column":12},"end":{"line":38,"column":19}},"6":{"start":{"line":40,"column":8},"end":{"line":56,"column":9}},"7":{"start":{"line":42,"column":12},"end":{"line":42,"column":24}},"8":{"start":{"line":44,"column":13},"end":{"line":56,"column":9}},"9":{"start":{"line":46,"column":12},"end":{"line":46,"column":24}},"10":{"start":{"line":50,"column":12},"end":{"line":50,"column":33}},"11":{"start":{"line":51,"column":12},"end":{"line":54,"column":13}},"12":{"start":{"line":53,"column":16},"end":{"line":53,"column":60}},"13":{"start":{"line":55,"column":12},"end":{"line":55,"column":25}},"14":{"start":{"line":57,"column":8},"end":{"line":57,"column":33}},"15":{"start":{"line":75,"column":8},"end":{"line":81,"column":73}},"16":{"start":{"line":82,"column":8},"end":{"line":82,"column":79}},"17":{"start":{"line":83,"column":8},"end":{"line":101,"column":9}},"18":{"start":{"line":85,"column":12},"end":{"line":85,"column":50}},"19":{"start":{"line":86,"column":12},"end":{"line":100,"column":13}},"20":{"start":{"line":88,"column":16},"end":{"line":88,"column":27}},"21":{"start":{"line":89,"column":16},"end":{"line":89,"column":49}},"22":{"start":{"line":90,"column":16},"end":{"line":97,"column":18}},"23":{"start":{"line":98,"column":16},"end":{"line":98,"column":35}},"24":{"start":{"line":99,"column":16},"end":{"line":99,"column":39}},"25":{"start":{"line":102,"column":8},"end":{"line":105,"column":10}},"26":{"start":{"line":119,"column":8},"end":{"line":121,"column":16}},"27":{"start":{"line":122,"column":8},"end":{"line":125,"column":9}},"28":{"start":{"line":124,"column":12},"end":{"line":124,"column":24}},"29":{"start":{"line":126,"column":8},"end":{"line":126,"column":52}},"30":{"start":{"line":127,"column":8},"end":{"line":127,"column":34}},"31":{"start":{"line":128,"column":8},"end":{"line":128,"column":34}},"32":{"start":{"line":129,"column":8},"end":{"line":133,"column":9}},"33":{"start":{"line":132,"column":12},"end":{"line":132,"column":24}},"34":{"start":{"line":134,"column":8},"end":{"line":134,"column":21}}},"branchMap":{"1":{"line":40,"type":"if","locations":[{"start":{"line":40,"column":8},"end":{"line":40,"column":8}},{"start":{"line":40,"column":8},"end":{"line":40,"column":8}}]},"2":{"line":44,"type":"if","locations":[{"start":{"line":44,"column":13},"end":{"line":44,"column":13}},{"start":{"line":44,"column":13},"end":{"line":44,"column":13}}]},"3":{"line":51,"type":"if","locations":[{"start":{"line":51,"column":12},"end":{"line":51,"column":12}},{"start":{"line":51,"column":12},"end":{"line":51,"column":12}}]},"4":{"line":81,"type":"cond-expr","locations":[{"start":{"line":81,"column":34},"end":{"line":81,"column":59}},{"start":{"line":81,"column":62},"end":{"line":81,"column":72}}]},"5":{"line":82,"type":"binary-expr","locations":[{"start":{"line":82,"column":21},"end":{"line":82,"column":31}},{"start":{"line":82,"column":35},"end":{"line":82,"column":78}}]},"6":{"line":86,"type":"if","locations":[{"start":{"line":86,"column":12},"end":{"line":86,"column":12}},{"start":{"line":86,"column":12},"end":{"line":86,"column":12}}]},"7":{"line":86,"type":"binary-expr","locations":[{"start":{"line":86,"column":15},"end":{"line":86,"column":31}},{"start":{"line":86,"column":35},"end":{"line":86,"column":51}}]},"8":{"line":122,"type":"if","locations":[{"start":{"line":122,"column":8},"end":{"line":122,"column":8}},{"start":{"line":122,"column":8},"end":{"line":122,"column":8}}]},"9":{"line":122,"type":"binary-expr","locations":[{"start":{"line":122,"column":11},"end":{"line":122,"column":29}},{"start":{"line":122,"column":33},"end":{"line":122,"column":51}}]},"10":{"line":129,"type":"if","locations":[{"start":{"line":129,"column":8},"end":{"line":129,"column":8}},{"start":{"line":129,"column":8},"end":{"line":129,"column":8}}]},"11":{"line":129,"type":"binary-expr","locations":[{"start":{"line":129,"column":11},"end":{"line":129,"column":42}},{"start":{"line":130,"column":14},"end":{"line":130,"column":34}},{"start":{"line":130,"column":38},"end":{"line":130,"column":61}},{"start":{"line":130,"column":67},"end":{"line":130,"column":87}},{"start":{"line":130,"column":91},"end":{"line":130,"column":114}}]}},"code":["(function () { YUI.add('axis-numeric', function (Y, NAME) {","","/**"," * Provides functionality for drawing a numeric axis for use with a chart."," *"," * @module charts"," * @submodule axis-numeric"," */","var Y_Lang = Y.Lang;","/**"," * NumericAxis draws a numeric axis."," *"," * @class NumericAxis"," * @constructor"," * @extends Axis"," * @uses NumericImpl"," * @param {Object} config (optional) Configuration parameters."," * @submodule axis-numeric"," */","Y.NumericAxis = Y.Base.create(\"numericAxis\", Y.Axis, [Y.NumericImpl], {","    /**","     * Calculates and returns a value based on the number of labels and the index of","     * the current label.","     *","     * @method getLabelByIndex","     * @param {Number} i Index of the label.","     * @param {Number} l Total number of labels.","     * @return String","     * @private","     */","    _getLabelByIndex: function(i, l)","    {","        var min = this.get(\"minimum\"),","            max = this.get(\"maximum\"),","            increm = (max - min)/(l-1),","            label,","            roundingMethod = this.get(\"roundingMethod\");","            l -= 1;","        //respect the min and max. calculate all other labels.","        if(i === 0)","        {","            label = min;","        }","        else if(i === l)","        {","            label = max;","        }","        else","        {","            label = (i * increm);","            if(roundingMethod === \"niceNumber\")","            {","                label = this._roundToNearest(label, increm);","            }","            label += min;","        }","        return parseFloat(label);","    },","","    /**","     * Returns an object literal containing and array of label values and an array of points.","     *","     * @method _getLabelData","     * @param {Object} startPoint An object containing x and y values.","     * @param {Number} edgeOffset Distance to offset coordinates.","     * @param {Number} layoutLength Distance that the axis spans.","     * @param {Number} count Number of labels.","     * @param {String} direction Indicates whether the axis is horizontal or vertical.","     * @param {Array} Array containing values for axis labels.","     * @return Array","     * @private","     */","    _getLabelData: function(constantVal, staticCoord, dynamicCoord, min, max, edgeOffset, layoutLength, count, dataValues)","    {","        var dataValue,","            i,","            points = [],","            values = [],","            point,","            isVertical = staticCoord === \"x\",","            offset = isVertical ? layoutLength + edgeOffset : edgeOffset;","        dataValues = dataValues || this._getDataValuesByCount(count, min, max);","        for(i = 0; i < count; i = i + 1)","        {","            dataValue = parseFloat(dataValues[i]);","            if(dataValue <= max && dataValue >= min)","            {","                point = {};","                point[staticCoord] = constantVal;","                point[dynamicCoord] = this._getCoordFromValue(","                    min,","                    max,","                    layoutLength,","                    dataValue,","                    offset,","                    isVertical","                );","                points.push(point);","                values.push(dataValue);","            }","        }","        return {","            points: points,","            values: values","        };","    },","","    /**","     * Checks to see if data extends beyond the range of the axis. If so,","     * that data will need to be hidden. This method is internal, temporary and subject","     * to removal in the future.","     *","     * @method _hasDataOverflow","     * @protected","     * @return Boolean","     */","    _hasDataOverflow: function()","    {","        var roundingMethod,","            min,","            max;","        if(this.get(\"setMin\") || this.get(\"setMax\"))","        {","            return true;","        }","        roundingMethod = this.get(\"roundingMethod\");","        min = this._actualMinimum;","        max = this._actualMaximum;","        if(Y_Lang.isNumber(roundingMethod) &&","            ((Y_Lang.isNumber(max) && max > this._dataMaximum) || (Y_Lang.isNumber(min) && min < this._dataMinimum)))","        {","            return true;","        }","        return false;","    }","});","","","","}, '@VERSION@', {\"requires\": [\"axis\", \"axis-numeric-base\"]});","","}());"]};
}
var __cov_rRHiT7Hw9EyHGe8gGcWbSA = __coverage__['build/axis-numeric/axis-numeric.js'];
__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['1']++;YUI.add('axis-numeric',function(Y,NAME){__cov_rRHiT7Hw9EyHGe8gGcWbSA.f['1']++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['2']++;var Y_Lang=Y.Lang;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['3']++;Y.NumericAxis=Y.Base.create('numericAxis',Y.Axis,[Y.NumericImpl],{_getLabelByIndex:function(i,l){__cov_rRHiT7Hw9EyHGe8gGcWbSA.f['2']++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['4']++;var min=this.get('minimum'),max=this.get('maximum'),increm=(max-min)/(l-1),label,roundingMethod=this.get('roundingMethod');__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['5']++;l-=1;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['6']++;if(i===0){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['1'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['7']++;label=min;}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['1'][1]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['8']++;if(i===l){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['2'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['9']++;label=max;}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['2'][1]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['10']++;label=i*increm;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['11']++;if(roundingMethod==='niceNumber'){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['3'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['12']++;label=this._roundToNearest(label,increm);}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['3'][1]++;}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['13']++;label+=min;}}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['14']++;return parseFloat(label);},_getLabelData:function(constantVal,staticCoord,dynamicCoord,min,max,edgeOffset,layoutLength,count,dataValues){__cov_rRHiT7Hw9EyHGe8gGcWbSA.f['3']++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['15']++;var dataValue,i,points=[],values=[],point,isVertical=staticCoord==='x',offset=isVertical?(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['4'][0]++,layoutLength+edgeOffset):(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['4'][1]++,edgeOffset);__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['16']++;dataValues=(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['5'][0]++,dataValues)||(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['5'][1]++,this._getDataValuesByCount(count,min,max));__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['17']++;for(i=0;i<count;i=i+1){__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['18']++;dataValue=parseFloat(dataValues[i]);__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['19']++;if((__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['7'][0]++,dataValue<=max)&&(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['7'][1]++,dataValue>=min)){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['6'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['20']++;point={};__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['21']++;point[staticCoord]=constantVal;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['22']++;point[dynamicCoord]=this._getCoordFromValue(min,max,layoutLength,dataValue,offset,isVertical);__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['23']++;points.push(point);__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['24']++;values.push(dataValue);}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['6'][1]++;}}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['25']++;return{points:points,values:values};},_hasDataOverflow:function(){__cov_rRHiT7Hw9EyHGe8gGcWbSA.f['4']++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['26']++;var roundingMethod,min,max;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['27']++;if((__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['9'][0]++,this.get('setMin'))||(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['9'][1]++,this.get('setMax'))){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['8'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['28']++;return true;}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['8'][1]++;}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['29']++;roundingMethod=this.get('roundingMethod');__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['30']++;min=this._actualMinimum;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['31']++;max=this._actualMaximum;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['32']++;if((__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][0]++,Y_Lang.isNumber(roundingMethod))&&((__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][1]++,Y_Lang.isNumber(max))&&(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][2]++,max>this._dataMaximum)||(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][3]++,Y_Lang.isNumber(min))&&(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][4]++,min<this._dataMinimum))){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['10'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['33']++;return true;}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['10'][1]++;}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['34']++;return false;}});},'@VERSION@',{'requires':['axis','axis-numeric-base']});
