/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/widget-htmlparser/widget-htmlparser.js']) {
   __coverage__['build/widget-htmlparser/widget-htmlparser.js'] = {"path":"build/widget-htmlparser/widget-htmlparser.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":29},"end":{"line":1,"column":48}}},"2":{"name":"(anonymous_2)","line":81,"loc":{"start":{"line":81,"column":18},"end":{"line":81,"column":32}}},"3":{"name":"(anonymous_3)","line":90,"loc":{"start":{"line":90,"column":25},"end":{"line":90,"column":56}}},"4":{"name":"(anonymous_4)","line":102,"loc":{"start":{"line":102,"column":19},"end":{"line":102,"column":36}}},"5":{"name":"(anonymous_5)","line":111,"loc":{"start":{"line":111,"column":34},"end":{"line":111,"column":52}}},"6":{"name":"(anonymous_6)","line":146,"loc":{"start":{"line":146,"column":22},"end":{"line":146,"column":33}}},"7":{"name":"(anonymous_7)","line":159,"loc":{"start":{"line":159,"column":21},"end":{"line":159,"column":32}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":177,"column":44}},"2":{"start":{"line":11,"column":0},"end":{"line":16,"column":31}},"3":{"start":{"line":41,"column":0},"end":{"line":41,"column":24}},"4":{"start":{"line":56,"column":0},"end":{"line":58,"column":2}},"5":{"start":{"line":67,"column":0},"end":{"line":72,"column":2}},"6":{"start":{"line":74,"column":0},"end":{"line":174,"column":3}},"7":{"start":{"line":82,"column":8},"end":{"line":82,"column":44}},"8":{"start":{"line":91,"column":8},"end":{"line":91,"column":64}},"9":{"start":{"line":104,"column":8},"end":{"line":108,"column":16}},"10":{"start":{"line":110,"column":8},"end":{"line":132,"column":9}},"11":{"start":{"line":111,"column":12},"end":{"line":131,"column":15}},"12":{"start":{"line":112,"column":16},"end":{"line":112,"column":27}},"13":{"start":{"line":114,"column":16},"end":{"line":125,"column":17}},"14":{"start":{"line":115,"column":20},"end":{"line":115,"column":50}},"15":{"start":{"line":117,"column":20},"end":{"line":124,"column":21}},"16":{"start":{"line":118,"column":24},"end":{"line":118,"column":48}},"17":{"start":{"line":119,"column":24},"end":{"line":121,"column":25}},"18":{"start":{"line":120,"column":28},"end":{"line":120,"column":39}},"19":{"start":{"line":123,"column":24},"end":{"line":123,"column":45}},"20":{"start":{"line":127,"column":16},"end":{"line":130,"column":17}},"21":{"start":{"line":128,"column":20},"end":{"line":128,"column":54}},"22":{"start":{"line":129,"column":20},"end":{"line":129,"column":42}},"23":{"start":{"line":133,"column":8},"end":{"line":133,"column":74}},"24":{"start":{"line":147,"column":8},"end":{"line":147,"column":42}},"25":{"start":{"line":148,"column":8},"end":{"line":148,"column":56}},"26":{"start":{"line":162,"column":8},"end":{"line":164,"column":17}},"27":{"start":{"line":166,"column":8},"end":{"line":171,"column":9}},"28":{"start":{"line":167,"column":12},"end":{"line":167,"column":39}},"29":{"start":{"line":168,"column":12},"end":{"line":170,"column":13}},"30":{"start":{"line":169,"column":16},"end":{"line":169,"column":39}},"31":{"start":{"line":172,"column":8},"end":{"line":172,"column":22}}},"branchMap":{"1":{"line":82,"type":"binary-expr","locations":[{"start":{"line":82,"column":15},"end":{"line":82,"column":18}},{"start":{"line":82,"column":22},"end":{"line":82,"column":43}}]},"2":{"line":91,"type":"cond-expr","locations":[{"start":{"line":91,"column":29},"end":{"line":91,"column":57}},{"start":{"line":91,"column":60},"end":{"line":91,"column":63}}]},"3":{"line":110,"type":"if","locations":[{"start":{"line":110,"column":8},"end":{"line":110,"column":8}},{"start":{"line":110,"column":8},"end":{"line":110,"column":8}}]},"4":{"line":110,"type":"binary-expr","locations":[{"start":{"line":110,"column":12},"end":{"line":110,"column":18}},{"start":{"line":110,"column":22},"end":{"line":110,"column":29}}]},"5":{"line":114,"type":"if","locations":[{"start":{"line":114,"column":16},"end":{"line":114,"column":16}},{"start":{"line":114,"column":16},"end":{"line":114,"column":16}}]},"6":{"line":117,"type":"if","locations":[{"start":{"line":117,"column":20},"end":{"line":117,"column":20}},{"start":{"line":117,"column":20},"end":{"line":117,"column":20}}]},"7":{"line":119,"type":"if","locations":[{"start":{"line":119,"column":24},"end":{"line":119,"column":24}},{"start":{"line":119,"column":24},"end":{"line":119,"column":24}}]},"8":{"line":127,"type":"if","locations":[{"start":{"line":127,"column":16},"end":{"line":127,"column":16}},{"start":{"line":127,"column":16},"end":{"line":127,"column":16}}]},"9":{"line":127,"type":"binary-expr","locations":[{"start":{"line":127,"column":20},"end":{"line":127,"column":32}},{"start":{"line":127,"column":36},"end":{"line":127,"column":53}}]},"10":{"line":128,"type":"binary-expr","locations":[{"start":{"line":128,"column":35},"end":{"line":128,"column":47}},{"start":{"line":128,"column":51},"end":{"line":128,"column":53}}]},"11":{"line":148,"type":"cond-expr","locations":[{"start":{"line":148,"column":41},"end":{"line":148,"column":48}},{"start":{"line":148,"column":51},"end":{"line":148,"column":55}}]},"12":{"line":168,"type":"if","locations":[{"start":{"line":168,"column":12},"end":{"line":168,"column":12}},{"start":{"line":168,"column":12},"end":{"line":168,"column":12}}]}},"code":["(function () { YUI.add('widget-htmlparser', function (Y, NAME) {","","/**"," * Adds HTML Parser support to the base Widget class"," *"," * @module widget"," * @submodule widget-htmlparser"," * @for Widget"," */","","var Widget = Y.Widget,","    Node = Y.Node,","    Lang = Y.Lang,","","    SRC_NODE = \"srcNode\",","    CONTENT_BOX = \"contentBox\";","","/**"," * Object hash, defining how attribute values are to be parsed from"," * markup contained in the widget's content box. e.g.:"," * <pre>"," *   {"," *       // Set single Node references using selector syntax"," *       // (selector is run through node.one)"," *       titleNode: \"span.yui-title\","," *       // Set NodeList references using selector syntax"," *       // (array indicates selector is to be run through node.all)"," *       listNodes: [\"li.yui-item\"],"," *       // Set other attribute types, using a parse function."," *       // Context is set to the widget instance."," *       label: function(contentBox) {"," *           return contentBox.one(\"span.title\").get(\"innerHTML\");"," *       }"," *   }"," * </pre>"," *"," * @property HTML_PARSER"," * @type Object"," * @static"," */","Widget.HTML_PARSER = {};","","/**"," * The build configuration for the Widget class."," * <p>"," * Defines the static fields which need to be aggregated,"," * when this class is used as the main class passed to"," * the <a href=\"Base.html#method_build\">Base.build</a> method."," * </p>"," * @property _buildCfg"," * @type Object"," * @static"," * @final"," * @private"," */","Widget._buildCfg = {","    aggregates : [\"HTML_PARSER\"]","};","","/**"," * The DOM node to parse for configuration values, passed to the Widget's HTML_PARSER definition"," *"," * @attribute srcNode"," * @type String | Node"," * @writeOnce"," */","Widget.ATTRS[SRC_NODE] = {","    value: null,","    setter: Node.one,","    getter: \"_getSrcNode\",","    writeOnce: true","};","","Y.mix(Widget.prototype, {","","    /**","     * @method _getSrcNode","     * @protected","     * @return {Node} The Node to apply HTML_PARSER to","     */","    _getSrcNode : function(val) {","        return val || this.get(CONTENT_BOX);","    },","","    /**","     * @method _applyParsedConfig","     * @protected","     * @return {Object} The merged configuration literal","     */","    _applyParsedConfig : function(node, cfg, parsedCfg) {","        return (parsedCfg) ? Y.mix(cfg, parsedCfg, false) : cfg;","    },","","    /**","     * Utility method used to apply the <code>HTML_PARSER</code> configuration for the","     * instance, to retrieve config data values.","     *","     * @method _applyParser","     * @protected","     * @param config {Object} User configuration object (will be populated with values from Node)","     */","    _applyParser : function(config) {","","        var widget = this,","            srcNode = this._getNodeToParse(),","            schema = widget._getHtmlParser(),","            parsedConfig,","            val;","","        if (schema && srcNode) {","            Y.Object.each(schema, function(v, k, o) {","                val = null;","","                if (Lang.isFunction(v)) {","                    val = v.call(widget, srcNode);","                } else {","                    if (Lang.isArray(v)) {","                        val = srcNode.all(v[0]);","                        if (val.isEmpty()) {","                            val = null;","                        }","                    } else {","                        val = srcNode.one(v);","                    }","                }","","                if (val !== null && val !== undefined) {","                    parsedConfig = parsedConfig || {};","                    parsedConfig[k] = val;","                }","            });","        }","        config = widget._applyParsedConfig(srcNode, config, parsedConfig);","    },","","    /**","     * Determines whether we have a node reference which we should try and parse.","     *","     * The current implementation does not parse nodes generated from CONTENT_TEMPLATE,","     * only explicitly set srcNode, or contentBox attributes.","     *","     * @method _getNodeToParse","     * @return {Node} The node reference to apply HTML_PARSER to.","     * @private","     */","    _getNodeToParse : function() {","        var srcNode = this.get(\"srcNode\");","        return (!this._cbFromTemplate) ? srcNode : null;","    },","","    /**","     * Gets the HTML_PARSER definition for this instance, by merging HTML_PARSER","     * definitions across the class hierarchy.","     *","     * @private","     * @method _getHtmlParser","     * @return {Object} HTML_PARSER definition for this instance","     */","    _getHtmlParser : function() {","        // Removed caching for kweight. This is a private method","        // and only called once so don't need to cache HTML_PARSER","        var classes = this._getClasses(),","            parser = {},","            i, p;","","        for (i = classes.length - 1; i >= 0; i--) {","            p = classes[i].HTML_PARSER;","            if (p) {","                Y.mix(parser, p, true);","            }","        }","        return parser;","    }","});","","","}, '3.10.3', {\"requires\": [\"widget-base\"]});","","}());"]};
}
var __cov_pHKc0qbrmtUYA$EA31q4VA = __coverage__['build/widget-htmlparser/widget-htmlparser.js'];
__cov_pHKc0qbrmtUYA$EA31q4VA.s['1']++;YUI.add('widget-htmlparser',function(Y,NAME){__cov_pHKc0qbrmtUYA$EA31q4VA.f['1']++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['2']++;var Widget=Y.Widget,Node=Y.Node,Lang=Y.Lang,SRC_NODE='srcNode',CONTENT_BOX='contentBox';__cov_pHKc0qbrmtUYA$EA31q4VA.s['3']++;Widget.HTML_PARSER={};__cov_pHKc0qbrmtUYA$EA31q4VA.s['4']++;Widget._buildCfg={aggregates:['HTML_PARSER']};__cov_pHKc0qbrmtUYA$EA31q4VA.s['5']++;Widget.ATTRS[SRC_NODE]={value:null,setter:Node.one,getter:'_getSrcNode',writeOnce:true};__cov_pHKc0qbrmtUYA$EA31q4VA.s['6']++;Y.mix(Widget.prototype,{_getSrcNode:function(val){__cov_pHKc0qbrmtUYA$EA31q4VA.f['2']++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['7']++;return(__cov_pHKc0qbrmtUYA$EA31q4VA.b['1'][0]++,val)||(__cov_pHKc0qbrmtUYA$EA31q4VA.b['1'][1]++,this.get(CONTENT_BOX));},_applyParsedConfig:function(node,cfg,parsedCfg){__cov_pHKc0qbrmtUYA$EA31q4VA.f['3']++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['8']++;return parsedCfg?(__cov_pHKc0qbrmtUYA$EA31q4VA.b['2'][0]++,Y.mix(cfg,parsedCfg,false)):(__cov_pHKc0qbrmtUYA$EA31q4VA.b['2'][1]++,cfg);},_applyParser:function(config){__cov_pHKc0qbrmtUYA$EA31q4VA.f['4']++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['9']++;var widget=this,srcNode=this._getNodeToParse(),schema=widget._getHtmlParser(),parsedConfig,val;__cov_pHKc0qbrmtUYA$EA31q4VA.s['10']++;if((__cov_pHKc0qbrmtUYA$EA31q4VA.b['4'][0]++,schema)&&(__cov_pHKc0qbrmtUYA$EA31q4VA.b['4'][1]++,srcNode)){__cov_pHKc0qbrmtUYA$EA31q4VA.b['3'][0]++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['11']++;Y.Object.each(schema,function(v,k,o){__cov_pHKc0qbrmtUYA$EA31q4VA.f['5']++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['12']++;val=null;__cov_pHKc0qbrmtUYA$EA31q4VA.s['13']++;if(Lang.isFunction(v)){__cov_pHKc0qbrmtUYA$EA31q4VA.b['5'][0]++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['14']++;val=v.call(widget,srcNode);}else{__cov_pHKc0qbrmtUYA$EA31q4VA.b['5'][1]++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['15']++;if(Lang.isArray(v)){__cov_pHKc0qbrmtUYA$EA31q4VA.b['6'][0]++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['16']++;val=srcNode.all(v[0]);__cov_pHKc0qbrmtUYA$EA31q4VA.s['17']++;if(val.isEmpty()){__cov_pHKc0qbrmtUYA$EA31q4VA.b['7'][0]++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['18']++;val=null;}else{__cov_pHKc0qbrmtUYA$EA31q4VA.b['7'][1]++;}}else{__cov_pHKc0qbrmtUYA$EA31q4VA.b['6'][1]++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['19']++;val=srcNode.one(v);}}__cov_pHKc0qbrmtUYA$EA31q4VA.s['20']++;if((__cov_pHKc0qbrmtUYA$EA31q4VA.b['9'][0]++,val!==null)&&(__cov_pHKc0qbrmtUYA$EA31q4VA.b['9'][1]++,val!==undefined)){__cov_pHKc0qbrmtUYA$EA31q4VA.b['8'][0]++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['21']++;parsedConfig=(__cov_pHKc0qbrmtUYA$EA31q4VA.b['10'][0]++,parsedConfig)||(__cov_pHKc0qbrmtUYA$EA31q4VA.b['10'][1]++,{});__cov_pHKc0qbrmtUYA$EA31q4VA.s['22']++;parsedConfig[k]=val;}else{__cov_pHKc0qbrmtUYA$EA31q4VA.b['8'][1]++;}});}else{__cov_pHKc0qbrmtUYA$EA31q4VA.b['3'][1]++;}__cov_pHKc0qbrmtUYA$EA31q4VA.s['23']++;config=widget._applyParsedConfig(srcNode,config,parsedConfig);},_getNodeToParse:function(){__cov_pHKc0qbrmtUYA$EA31q4VA.f['6']++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['24']++;var srcNode=this.get('srcNode');__cov_pHKc0qbrmtUYA$EA31q4VA.s['25']++;return!this._cbFromTemplate?(__cov_pHKc0qbrmtUYA$EA31q4VA.b['11'][0]++,srcNode):(__cov_pHKc0qbrmtUYA$EA31q4VA.b['11'][1]++,null);},_getHtmlParser:function(){__cov_pHKc0qbrmtUYA$EA31q4VA.f['7']++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['26']++;var classes=this._getClasses(),parser={},i,p;__cov_pHKc0qbrmtUYA$EA31q4VA.s['27']++;for(i=classes.length-1;i>=0;i--){__cov_pHKc0qbrmtUYA$EA31q4VA.s['28']++;p=classes[i].HTML_PARSER;__cov_pHKc0qbrmtUYA$EA31q4VA.s['29']++;if(p){__cov_pHKc0qbrmtUYA$EA31q4VA.b['12'][0]++;__cov_pHKc0qbrmtUYA$EA31q4VA.s['30']++;Y.mix(parser,p,true);}else{__cov_pHKc0qbrmtUYA$EA31q4VA.b['12'][1]++;}}__cov_pHKc0qbrmtUYA$EA31q4VA.s['31']++;return parser;}});},'3.10.3',{'requires':['widget-base']});
