/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import jargs.gnu.CmdLineParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class YUICompressor {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        block32: {
            parser = new CmdLineParser();
            typeOpt = parser.addStringOption("type");
            verboseOpt = parser.addBooleanOption('v', "verbose");
            nomungeOpt = parser.addBooleanOption("nomunge");
            linebreakOpt = parser.addStringOption("line-break");
            preserveSemiOpt = parser.addBooleanOption("preserve-semi");
            disableOptimizationsOpt = parser.addBooleanOption("disable-optimizations");
            helpOpt = parser.addBooleanOption('h', "help");
            charsetOpt = parser.addStringOption("charset");
            outputFilenameOpt = parser.addStringOption('o', "output");
            in = null;
            out = null;
            try {
                try {
                    parser.parse(args);
                    help = (Boolean)parser.getOptionValue(helpOpt);
                    if (help != null && help.booleanValue()) {
                        YUICompressor.usage();
                        System.exit(0);
                    }
                    verbose = parser.getOptionValue(verboseOpt) != null;
                    charset = (String)parser.getOptionValue(charsetOpt);
                    if (charset == null || !Charset.isSupported(charset)) {
                        charset = System.getProperty("file.encoding");
                        if (charset == null) {
                            charset = "UTF-8";
                        }
                        if (verbose) {
                            System.err.println("\n[INFO] Using charset " + charset);
                        }
                    }
                    fileArgs = parser.getRemainingArgs();
                    type = (String)parser.getOptionValue(typeOpt);
                    if (fileArgs.length == 0) {
                        if (type == null || !type.equalsIgnoreCase("js") && !type.equalsIgnoreCase("css")) {
                            YUICompressor.usage();
                            System.exit(1);
                        }
                        in = new InputStreamReader(System.in, charset);
                    } else {
                        if (type != null && !type.equalsIgnoreCase("js") && !type.equalsIgnoreCase("css")) {
                            YUICompressor.usage();
                            System.exit(1);
                        }
                        inputFilename = fileArgs[0];
                        if (type == null && (idx = inputFilename.lastIndexOf(46)) >= 0 && idx < inputFilename.length() - 1) {
                            type = inputFilename.substring(idx + 1);
                        }
                        if (type == null || !type.equalsIgnoreCase("js") && !type.equalsIgnoreCase("css")) {
                            YUICompressor.usage();
                            System.exit(1);
                        }
                        in = new InputStreamReader((InputStream)new FileInputStream(inputFilename), charset);
                    }
                    linebreakpos = -1;
                    linebreakstr = (String)parser.getOptionValue(linebreakOpt);
                    if (linebreakstr != null) {
                        try {
                            linebreakpos = Integer.parseInt(linebreakstr, 10);
                        }
                        catch (NumberFormatException v0) {
                            YUICompressor.usage();
                            System.exit(1);
                        }
                    }
                    outputFilename = (String)parser.getOptionValue(outputFilenameOpt);
                    if (type.equalsIgnoreCase("js")) {
                        try {
                            compressor = new JavaScriptCompressor(in, new ErrorReporter(){

                                public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                    if (line < 0) {
                                        System.err.println("\n[WARNING] " + message);
                                    } else {
                                        System.err.println("\n[WARNING] " + line + ':' + lineOffset + ':' + message);
                                    }
                                }

                                public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                    if (line < 0) {
                                        System.err.println("\n[ERROR] " + message);
                                    } else {
                                        System.err.println("\n[ERROR] " + line + ':' + lineOffset + ':' + message);
                                    }
                                }

                                public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                                    this.error(message, sourceName, line, lineSource, lineOffset);
                                    return new EvaluatorException(message);
                                }
                            });
                            in.close();
                            in = null;
                            out = outputFilename == null ? new OutputStreamWriter((OutputStream)System.out, charset) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), charset);
                            munge = parser.getOptionValue(nomungeOpt) == null;
                            preserveAllSemiColons = parser.getOptionValue(preserveSemiOpt) != null;
                            disableOptimizations = parser.getOptionValue(disableOptimizationsOpt) != null;
                            compressor.compress(out, linebreakpos, munge, verbose, preserveAllSemiColons, disableOptimizations);
                        }
                        catch (EvaluatorException e) {
                            e.printStackTrace();
                            System.exit(2);
                        }
                    } else if (type.equalsIgnoreCase("css")) {
                        compressor = new CssCompressor(in);
                        in.close();
                        in = null;
                        out = outputFilename == null ? new OutputStreamWriter((OutputStream)System.out, charset) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilename), charset);
                        compressor.compress(out, linebreakpos);
                    }
                }
                catch (CmdLineParser.OptionException v1) {
                    YUICompressor.usage();
                    System.exit(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            catch (Throwable var26_30) {
                var25_31 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out == null) throw var26_30;
                try {
                    out.close();
                    throw var26_30;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw var26_30;
            }
            {
                var25_32 = null;
                if (in == null) break block32;
            }
            ** try [egrp 4[TRYBLOCK] [6 : 745->753)] { 
lbl107:
            // 1 sources

            in.close();
            break block32;
lbl109:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (out == null) return;
        try {}
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        out.close();
    }

    private static void usage() {
        System.out.println("\nUsage: java -jar yuicompressor-x.y.z.jar [options] [input file]\n\nGlobal Options\n  -h, --help                Displays this information\n  --type <js|css>           Specifies the type of the input file\n  --charset <charset>       Read the input file using <charset>\n  --line-break <column>     Insert a line break after the specified column number\n  -v, --verbose             Display informational messages and warnings\n  -o <file>                 Place the output into <file>. Defaults to stdout.\n\nJavaScript Options\n  --nomunge                 Minify only, do not obfuscate\n  --preserve-semi           Preserve all semicolons\n  --disable-optimizations   Disable all micro optimizations\n\nIf no input file is specified, it defaults to stdin. In this case, the 'type'\noption is required. Otherwise, the 'type' option is required only if the input\nfile extension is neither 'js' nor 'css'.");
    }
}

