class sysconfig::django_init (
    $superuser_name = hiera('sysconfig::params::superuser_name',$sysconfig::params::superuser_name),
    $superuser_pw   = hiera('sysconfig::params::superuser_pw',$sysconfig::params::superuser_pw)
){
    
    notify {'django_init': name => "\$superuser_name : ${superuser_name}, \$superuser_pw : ${superuser_pw}", withpath => true }

    exec { 'syncdb':
        command => '/srv/comt/bin/django syncdb --noinput --migrate',
        user    => 'vagrant' 
    }

    exec { 'loaddata':
        command => '/srv/comt/bin/django loaddata roles_generic',
        user    => 'vagrant',
        require => Exec['syncdb']
    }

    exec { 'createsuperuser':
        command => '/bin/echo "from django.contrib.auth.models import User; User.objects.create_superuser(\'$superuser_name\', \'admin@example.com\', \'$superuser_pw\')" | /srv/comt/bin/django shell',
        cwd     => '/srv/comt',
        user    => 'vagrant',
        unless  => '/bin/echo "from django.contrib.auth.models import User; exit(0) if User.objects.filter(username=\'$superuser_name\').count() else exit(1)" | /srv/comt/bin/django shell',
        require => Exec['syncdb']
    }
}