# upgrade system
class { 'sysconfig::sys_upgrade': }

# install packages
class { 'sysconfig::packages': require => Class['sysconfig::sys_upgrade'] }

# install postgres
class { 'sysconfig::postgresql': require => Class['sysconfig::sys_upgrade'] }

# install nginx
class { 'sysconfig::nginx': require => Class['sysconfig::sys_upgrade'] }

# create python
class { 'sysconfig::buildout': require => [Class['sysconfig::packages'], Class['sysconfig::postgresql']] }

# write config
class { 'sysconfig::config': require => Class['sysconfig::buildout'] }

# write django_init
class { 'sysconfig::django_init': require => Class['sysconfig::config'] }

# deploy
class { 'sysconfig::deploy': require => [ Class['sysconfig::django_init'], Class['sysconfig::nginx'], Class['sysconfig::postgresql'] ] }
