/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/async-queue/async-queue.js']) {
   __coverage__['build/async-queue/async-queue.js'] = {"path":"build/async-queue/async-queue.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0,"56":0,"57":0,"58":0,"59":0,"60":0,"61":0,"62":0,"63":0,"64":0,"65":0,"66":0,"67":0,"68":0,"69":0,"70":0,"71":0,"72":0,"73":0,"74":0,"75":0,"76":0,"77":0,"78":0,"79":0,"80":0,"81":0,"82":0,"83":0,"84":0,"85":0,"86":0,"87":0,"88":0,"89":0,"90":0,"91":0,"92":0,"93":0,"94":0,"95":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0,0],"13":[0,0],"14":[0,0],"15":[0,0],"16":[0,0],"17":[0,0],"18":[0,0],"19":[0,0],"20":[0,0],"21":[0,0],"22":[0,0],"23":[0,0],"24":[0,0],"25":[0,0],"26":[0,0],"27":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":23},"end":{"line":1,"column":42}}},"2":{"name":"(anonymous_2)","line":41,"loc":{"start":{"line":41,"column":15},"end":{"line":41,"column":26}}},"3":{"name":"(anonymous_3)","line":74,"loc":{"start":{"line":74,"column":19},"end":{"line":74,"column":31}}},"4":{"name":"(anonymous_4)","line":98,"loc":{"start":{"line":98,"column":12},"end":{"line":98,"column":24}}},"5":{"name":"(anonymous_5)","line":121,"loc":{"start":{"line":121,"column":18},"end":{"line":121,"column":30}}},"6":{"name":"(anonymous_6)","line":141,"loc":{"start":{"line":141,"column":11},"end":{"line":141,"column":23}}},"7":{"name":"(anonymous_7)","line":166,"loc":{"start":{"line":166,"column":18},"end":{"line":166,"column":31}}},"8":{"name":"(anonymous_8)","line":185,"loc":{"start":{"line":185,"column":14},"end":{"line":185,"column":34}}},"9":{"name":"(anonymous_9)","line":196,"loc":{"start":{"line":196,"column":29},"end":{"line":196,"column":41}}},"10":{"name":"(anonymous_10)","line":218,"loc":{"start":{"line":218,"column":10},"end":{"line":218,"column":22}}},"11":{"name":"(anonymous_11)","line":251,"loc":{"start":{"line":251,"column":15},"end":{"line":251,"column":35}}},"12":{"name":"(anonymous_12)","line":272,"loc":{"start":{"line":272,"column":16},"end":{"line":272,"column":36}}},"13":{"name":"(anonymous_13)","line":273,"loc":{"start":{"line":273,"column":56},"end":{"line":273,"column":68}}},"14":{"name":"(anonymous_14)","line":289,"loc":{"start":{"line":289,"column":16},"end":{"line":289,"column":28}}},"15":{"name":"(anonymous_15)","line":301,"loc":{"start":{"line":301,"column":17},"end":{"line":301,"column":30}}},"16":{"name":"(anonymous_16)","line":314,"loc":{"start":{"line":314,"column":10},"end":{"line":314,"column":22}}},"17":{"name":"(anonymous_17)","line":330,"loc":{"start":{"line":330,"column":16},"end":{"line":330,"column":28}}},"18":{"name":"(anonymous_18)","line":334,"loc":{"start":{"line":334,"column":34},"end":{"line":334,"column":47}}},"19":{"name":"(anonymous_19)","line":354,"loc":{"start":{"line":354,"column":11},"end":{"line":354,"column":23}}},"20":{"name":"(anonymous_20)","line":372,"loc":{"start":{"line":372,"column":11},"end":{"line":372,"column":23}}},"21":{"name":"(anonymous_21)","line":386,"loc":{"start":{"line":386,"column":14},"end":{"line":386,"column":34}}},"22":{"name":"(anonymous_22)","line":407,"loc":{"start":{"line":407,"column":18},"end":{"line":407,"column":32}}},"23":{"name":"(anonymous_23)","line":423,"loc":{"start":{"line":423,"column":14},"end":{"line":423,"column":34}}},"24":{"name":"(anonymous_24)","line":427,"loc":{"start":{"line":427,"column":34},"end":{"line":427,"column":46}}},"25":{"name":"(anonymous_25)","line":449,"loc":{"start":{"line":449,"column":20},"end":{"line":449,"column":33}}},"26":{"name":"(anonymous_26)","line":469,"loc":{"start":{"line":469,"column":13},"end":{"line":469,"column":33}}},"27":{"name":"(anonymous_27)","line":475,"loc":{"start":{"line":475,"column":34},"end":{"line":475,"column":46}}},"28":{"name":"(anonymous_28)","line":497,"loc":{"start":{"line":497,"column":19},"end":{"line":497,"column":32}}},"29":{"name":"(anonymous_29)","line":509,"loc":{"start":{"line":509,"column":11},"end":{"line":509,"column":23}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":522,"column":45}},"2":{"start":{"line":41,"column":0},"end":{"line":44,"column":2}},"3":{"start":{"line":42,"column":4},"end":{"line":42,"column":17}},"4":{"start":{"line":43,"column":4},"end":{"line":43,"column":36}},"5":{"start":{"line":46,"column":0},"end":{"line":53,"column":35}},"6":{"start":{"line":70,"column":0},"end":{"line":78,"column":33}},"7":{"start":{"line":75,"column":8},"end":{"line":75,"column":29}},"8":{"start":{"line":76,"column":8},"end":{"line":76,"column":36}},"9":{"start":{"line":80,"column":0},"end":{"line":518,"column":3}},"10":{"start":{"line":99,"column":8},"end":{"line":99,"column":72}},"11":{"start":{"line":101,"column":8},"end":{"line":101,"column":21}},"12":{"start":{"line":110,"column":8},"end":{"line":110,"column":27}},"13":{"start":{"line":112,"column":8},"end":{"line":112,"column":27}},"14":{"start":{"line":122,"column":8},"end":{"line":128,"column":11}},"15":{"start":{"line":142,"column":8},"end":{"line":142,"column":21}},"16":{"start":{"line":144,"column":8},"end":{"line":152,"column":9}},"17":{"start":{"line":145,"column":12},"end":{"line":145,"column":62}},"18":{"start":{"line":146,"column":12},"end":{"line":151,"column":13}},"19":{"start":{"line":147,"column":16},"end":{"line":147,"column":57}},"20":{"start":{"line":148,"column":16},"end":{"line":148,"column":32}},"21":{"start":{"line":150,"column":16},"end":{"line":150,"column":22}},"22":{"start":{"line":154,"column":8},"end":{"line":154,"column":32}},"23":{"start":{"line":167,"column":8},"end":{"line":169,"column":9}},"24":{"start":{"line":168,"column":12},"end":{"line":168,"column":28}},"25":{"start":{"line":186,"column":8},"end":{"line":188,"column":9}},"26":{"start":{"line":187,"column":12},"end":{"line":187,"column":28}},"27":{"start":{"line":190,"column":8},"end":{"line":204,"column":21}},"28":{"start":{"line":197,"column":16},"end":{"line":199,"column":17}},"29":{"start":{"line":198,"column":20},"end":{"line":198,"column":41}},"30":{"start":{"line":200,"column":16},"end":{"line":203,"column":17}},"31":{"start":{"line":201,"column":20},"end":{"line":202,"column":60}},"32":{"start":{"line":206,"column":8},"end":{"line":206,"column":38}},"33":{"start":{"line":219,"column":8},"end":{"line":220,"column":24}},"34":{"start":{"line":222,"column":8},"end":{"line":229,"column":9}},"35":{"start":{"line":226,"column":12},"end":{"line":228,"column":41}},"36":{"start":{"line":231,"column":8},"end":{"line":237,"column":9}},"37":{"start":{"line":236,"column":12},"end":{"line":236,"column":34}},"38":{"start":{"line":239,"column":8},"end":{"line":239,"column":20}},"39":{"start":{"line":252,"column":8},"end":{"line":252,"column":49}},"40":{"start":{"line":254,"column":8},"end":{"line":254,"column":30}},"41":{"start":{"line":255,"column":8},"end":{"line":255,"column":51}},"42":{"start":{"line":257,"column":8},"end":{"line":257,"column":58}},"43":{"start":{"line":259,"column":8},"end":{"line":259,"column":50}},"44":{"start":{"line":261,"column":8},"end":{"line":261,"column":20}},"45":{"start":{"line":273,"column":8},"end":{"line":277,"column":11}},"46":{"start":{"line":274,"column":12},"end":{"line":276,"column":13}},"47":{"start":{"line":275,"column":16},"end":{"line":275,"column":27}},"48":{"start":{"line":279,"column":8},"end":{"line":279,"column":21}},"49":{"start":{"line":290,"column":8},"end":{"line":290,"column":31}},"50":{"start":{"line":302,"column":8},"end":{"line":302,"column":21}},"51":{"start":{"line":315,"column":8},"end":{"line":315,"column":67}},"52":{"start":{"line":317,"column":8},"end":{"line":317,"column":20}},"53":{"start":{"line":331,"column":8},"end":{"line":332,"column":23}},"54":{"start":{"line":334,"column":8},"end":{"line":339,"column":11}},"55":{"start":{"line":335,"column":12},"end":{"line":338,"column":13}},"56":{"start":{"line":336,"column":16},"end":{"line":336,"column":27}},"57":{"start":{"line":337,"column":16},"end":{"line":337,"column":30}},"58":{"start":{"line":341,"column":8},"end":{"line":341,"column":24}},"59":{"start":{"line":355,"column":8},"end":{"line":357,"column":9}},"60":{"start":{"line":356,"column":12},"end":{"line":356,"column":35}},"61":{"start":{"line":359,"column":8},"end":{"line":359,"column":30}},"62":{"start":{"line":361,"column":8},"end":{"line":361,"column":20}},"63":{"start":{"line":373,"column":8},"end":{"line":373,"column":21}},"64":{"start":{"line":375,"column":8},"end":{"line":375,"column":28}},"65":{"start":{"line":387,"column":8},"end":{"line":387,"column":43}},"66":{"start":{"line":389,"column":8},"end":{"line":394,"column":9}},"67":{"start":{"line":390,"column":12},"end":{"line":390,"column":27}},"68":{"start":{"line":391,"column":12},"end":{"line":393,"column":13}},"69":{"start":{"line":392,"column":16},"end":{"line":392,"column":25}},"70":{"start":{"line":396,"column":8},"end":{"line":396,"column":18}},"71":{"start":{"line":408,"column":8},"end":{"line":408,"column":33}},"72":{"start":{"line":410,"column":8},"end":{"line":410,"column":44}},"73":{"start":{"line":424,"column":8},"end":{"line":424,"column":48}},"74":{"start":{"line":426,"column":8},"end":{"line":433,"column":9}},"75":{"start":{"line":427,"column":12},"end":{"line":430,"column":25}},"76":{"start":{"line":428,"column":20},"end":{"line":428,"column":48}},"77":{"start":{"line":429,"column":20},"end":{"line":429,"column":31}},"78":{"start":{"line":432,"column":12},"end":{"line":432,"column":40}},"79":{"start":{"line":435,"column":8},"end":{"line":435,"column":20}},"80":{"start":{"line":450,"column":8},"end":{"line":451,"column":64}},"81":{"start":{"line":453,"column":8},"end":{"line":453,"column":30}},"82":{"start":{"line":455,"column":8},"end":{"line":457,"column":9}},"83":{"start":{"line":456,"column":12},"end":{"line":456,"column":38}},"84":{"start":{"line":470,"column":8},"end":{"line":470,"column":48}},"85":{"start":{"line":474,"column":8},"end":{"line":481,"column":9}},"86":{"start":{"line":475,"column":12},"end":{"line":478,"column":24}},"87":{"start":{"line":476,"column":20},"end":{"line":476,"column":47}},"88":{"start":{"line":477,"column":20},"end":{"line":477,"column":31}},"89":{"start":{"line":480,"column":12},"end":{"line":480,"column":39}},"90":{"start":{"line":483,"column":8},"end":{"line":483,"column":20}},"91":{"start":{"line":498,"column":8},"end":{"line":498,"column":41}},"92":{"start":{"line":500,"column":8},"end":{"line":500,"column":61}},"93":{"start":{"line":512,"column":8},"end":{"line":514,"column":9}},"94":{"start":{"line":513,"column":12},"end":{"line":513,"column":24}},"95":{"start":{"line":516,"column":8},"end":{"line":516,"column":30}}},"branchMap":{"1":{"line":78,"type":"binary-expr","locations":[{"start":{"line":78,"column":3},"end":{"line":78,"column":25}},{"start":{"line":78,"column":29},"end":{"line":78,"column":31}}]},"2":{"line":146,"type":"if","locations":[{"start":{"line":146,"column":12},"end":{"line":146,"column":12}},{"start":{"line":146,"column":12},"end":{"line":146,"column":12}}]},"3":{"line":146,"type":"binary-expr","locations":[{"start":{"line":146,"column":16},"end":{"line":146,"column":24}},{"start":{"line":146,"column":28},"end":{"line":146,"column":44}}]},"4":{"line":154,"type":"binary-expr","locations":[{"start":{"line":154,"column":15},"end":{"line":154,"column":23}},{"start":{"line":154,"column":27},"end":{"line":154,"column":31}}]},"5":{"line":167,"type":"if","locations":[{"start":{"line":167,"column":8},"end":{"line":167,"column":8}},{"start":{"line":167,"column":8},"end":{"line":167,"column":8}}]},"6":{"line":186,"type":"if","locations":[{"start":{"line":186,"column":8},"end":{"line":186,"column":8}},{"start":{"line":186,"column":8},"end":{"line":186,"column":8}}]},"7":{"line":186,"type":"binary-expr","locations":[{"start":{"line":186,"column":12},"end":{"line":186,"column":32}},{"start":{"line":186,"column":36},"end":{"line":186,"column":54}}]},"8":{"line":194,"type":"cond-expr","locations":[{"start":{"line":194,"column":36},"end":{"line":194,"column":52}},{"start":{"line":194,"column":55},"end":{"line":194,"column":63}}]},"9":{"line":197,"type":"if","locations":[{"start":{"line":197,"column":16},"end":{"line":197,"column":16}},{"start":{"line":197,"column":16},"end":{"line":197,"column":16}}]},"10":{"line":200,"type":"if","locations":[{"start":{"line":200,"column":16},"end":{"line":200,"column":16}},{"start":{"line":200,"column":16},"end":{"line":200,"column":16}}]},"11":{"line":201,"type":"binary-expr","locations":[{"start":{"line":201,"column":37},"end":{"line":201,"column":52}},{"start":{"line":201,"column":56},"end":{"line":201,"column":57}}]},"12":{"line":223,"type":"binary-expr","locations":[{"start":{"line":223,"column":12},"end":{"line":223,"column":16}},{"start":{"line":223,"column":20},"end":{"line":223,"column":28}},{"start":{"line":223,"column":32},"end":{"line":223,"column":49}}]},"13":{"line":226,"type":"cond-expr","locations":[{"start":{"line":227,"column":16},"end":{"line":227,"column":39}},{"start":{"line":228,"column":16},"end":{"line":228,"column":40}}]},"14":{"line":231,"type":"if","locations":[{"start":{"line":231,"column":8},"end":{"line":231,"column":8}},{"start":{"line":231,"column":8},"end":{"line":231,"column":8}}]},"15":{"line":257,"type":"binary-expr","locations":[{"start":{"line":257,"column":19},"end":{"line":257,"column":32}},{"start":{"line":257,"column":36},"end":{"line":257,"column":57}}]},"16":{"line":274,"type":"if","locations":[{"start":{"line":274,"column":12},"end":{"line":274,"column":12}},{"start":{"line":274,"column":12},"end":{"line":274,"column":12}}]},"17":{"line":335,"type":"if","locations":[{"start":{"line":335,"column":12},"end":{"line":335,"column":12}},{"start":{"line":335,"column":12},"end":{"line":335,"column":12}}]},"18":{"line":355,"type":"if","locations":[{"start":{"line":355,"column":8},"end":{"line":355,"column":8}},{"start":{"line":355,"column":8},"end":{"line":355,"column":8}}]},"19":{"line":391,"type":"if","locations":[{"start":{"line":391,"column":12},"end":{"line":391,"column":12}},{"start":{"line":391,"column":12},"end":{"line":391,"column":12}}]},"20":{"line":391,"type":"binary-expr","locations":[{"start":{"line":391,"column":16},"end":{"line":391,"column":30}},{"start":{"line":391,"column":34},"end":{"line":391,"column":51}}]},"21":{"line":410,"type":"cond-expr","locations":[{"start":{"line":410,"column":26},"end":{"line":410,"column":36}},{"start":{"line":410,"column":39},"end":{"line":410,"column":43}}]},"22":{"line":426,"type":"if","locations":[{"start":{"line":426,"column":8},"end":{"line":426,"column":8}},{"start":{"line":426,"column":8},"end":{"line":426,"column":8}}]},"23":{"line":451,"type":"cond-expr","locations":[{"start":{"line":451,"column":34},"end":{"line":451,"column":56}},{"start":{"line":451,"column":59},"end":{"line":451,"column":63}}]},"24":{"line":455,"type":"if","locations":[{"start":{"line":455,"column":8},"end":{"line":455,"column":8}},{"start":{"line":455,"column":8},"end":{"line":455,"column":8}}]},"25":{"line":474,"type":"if","locations":[{"start":{"line":474,"column":8},"end":{"line":474,"column":8}},{"start":{"line":474,"column":8},"end":{"line":474,"column":8}}]},"26":{"line":500,"type":"cond-expr","locations":[{"start":{"line":500,"column":31},"end":{"line":500,"column":53}},{"start":{"line":500,"column":56},"end":{"line":500,"column":60}}]},"27":{"line":512,"type":"if","locations":[{"start":{"line":512,"column":8},"end":{"line":512,"column":8}},{"start":{"line":512,"column":8},"end":{"line":512,"column":8}}]}},"code":["(function () { YUI.add('async-queue', function (Y, NAME) {","","/**"," * <p>AsyncQueue allows you create a chain of function callbacks executed"," * via setTimeout (or synchronously) that are guaranteed to run in order."," * Items in the queue can be promoted or removed.  Start or resume the"," * execution chain with run().  pause() to temporarily delay execution, or"," * stop() to halt and clear the queue.</p>"," *"," * @module async-queue"," */","","/**"," * <p>A specialized queue class that supports scheduling callbacks to execute"," * sequentially, iteratively, even asynchronously.</p>"," *"," * <p>Callbacks can be function refs or objects with the following keys.  Only"," * the <code>fn</code> key is required.</p>"," *"," * <ul>"," * <li><code>fn</code> -- The callback function</li>"," * <li><code>context</code> -- The execution context for the callbackFn.</li>"," * <li><code>args</code> -- Arguments to pass to callbackFn.</li>"," * <li><code>timeout</code> -- Millisecond delay before executing callbackFn."," *                     (Applies to each iterative execution of callback)</li>"," * <li><code>iterations</code> -- Number of times to repeat the callback."," * <li><code>until</code> -- Repeat the callback until this function returns"," *                         true.  This setting trumps iterations.</li>"," * <li><code>autoContinue</code> -- Set to false to prevent the AsyncQueue from"," *                        executing the next callback in the Queue after"," *                        the callback completes.</li>"," * <li><code>id</code> -- Name that can be used to get, promote, get the"," *                        indexOf, or delete this callback.</li>"," * </ul>"," *"," * @class AsyncQueue"," * @extends EventTarget"," * @constructor"," * @param callback* {Function|Object} 0..n callbacks to seed the queue"," */","Y.AsyncQueue = function() {","    this._init();","    this.add.apply(this, arguments);","};","","var Queue   = Y.AsyncQueue,","    EXECUTE = 'execute',","    SHIFT   = 'shift',","    PROMOTE = 'promote',","    REMOVE  = 'remove',","","    isObject   = Y.Lang.isObject,","    isFunction = Y.Lang.isFunction;","","/**"," * <p>Static default values used to populate callback configuration properties."," * Preconfigured defaults include:</p>"," *"," * <ul>"," *  <li><code>autoContinue</code>: <code>true</code></li>"," *  <li><code>iterations</code>: 1</li>"," *  <li><code>timeout</code>: 10 (10ms between callbacks)</li>"," *  <li><code>until</code>: (function to run until iterations &lt;= 0)</li>"," * </ul>"," *"," * @property defaults"," * @type {Object}"," * @static"," */","Queue.defaults = Y.mix({","    autoContinue : true,","    iterations   : 1,","    timeout      : 10,","    until        : function () {","        this.iterations |= 0;","        return this.iterations <= 0;","    }","}, Y.config.queueDefaults || {});","","Y.extend(Queue, Y.EventTarget, {","    /**","     * Used to indicate the queue is currently executing a callback.","     *","     * @property _running","     * @type {Boolean|Object} true for synchronous callback execution, the","     *                        return handle from Y.later for async callbacks.","     *                        Otherwise false.","     * @protected","     */","    _running : false,","","    /**","     * Initializes the AsyncQueue instance properties and events.","     *","     * @method _init","     * @protected","     */","    _init : function () {","        Y.EventTarget.call(this, { prefix: 'queue', emitFacade: true });","","        this._q = [];","","        /** ","         * Callback defaults for this instance.  Static defaults that are not","         * overridden are also included.","         *","         * @property defaults","         * @type {Object}","         */","        this.defaults = {};","","        this._initEvents();","    },","","    /**","     * Initializes the instance events.","     *","     * @method _initEvents","     * @protected","     */","    _initEvents : function () {","        this.publish({","            'execute' : { defaultFn : this._defExecFn,    emitFacade: true },","            'shift'   : { defaultFn : this._defShiftFn,   emitFacade: true },","            'add'     : { defaultFn : this._defAddFn,     emitFacade: true },","            'promote' : { defaultFn : this._defPromoteFn, emitFacade: true },","            'remove'  : { defaultFn : this._defRemoveFn,  emitFacade: true }","        });","    },","","    /**","     * Returns the next callback needing execution.  If a callback is","     * configured to repeat via iterations or until, it will be returned until","     * the completion criteria is met.","     *","     * When the queue is empty, null is returned.","     *","     * @method next","     * @return {Function} the callback to execute","     */","    next : function () {","        var callback;","","        while (this._q.length) {","            callback = this._q[0] = this._prepare(this._q[0]);","            if (callback && callback.until()) {","                this.fire(SHIFT, { callback: callback });","                callback = null;","            } else {","                break;","            }","        }","","        return callback || null;","    },","","    /**","     * Default functionality for the &quot;shift&quot; event.  Shifts the","     * callback stored in the event object's <em>callback</em> property from","     * the queue if it is the first item.","     *","     * @method _defShiftFn","     * @param e {Event} The event object","     * @protected","     */","    _defShiftFn : function (e) {","        if (this.indexOf(e.callback) === 0) {","            this._q.shift();","        }","    },","","    /**","     * Creates a wrapper function to execute the callback using the aggregated ","     * configuration generated by combining the static AsyncQueue.defaults, the","     * instance defaults, and the specified callback settings.","     *","     * The wrapper function is decorated with the callback configuration as","     * properties for runtime modification.","     *","     * @method _prepare","     * @param callback {Object|Function} the raw callback","     * @return {Function} a decorated function wrapper to execute the callback","     * @protected","     */","    _prepare: function (callback) {","        if (isFunction(callback) && callback._prepared) {","            return callback;","        }","","        var config = Y.merge(","            Queue.defaults,","            { context : this, args: [], _prepared: true },","            this.defaults,","            (isFunction(callback) ? { fn: callback } : callback)),","            ","            wrapper = Y.bind(function () {","                if (!wrapper._running) {","                    wrapper.iterations--;","                }","                if (isFunction(wrapper.fn)) {","                    wrapper.fn.apply(wrapper.context || Y,","                                     Y.Array(wrapper.args));","                }","            }, this);","            ","        return Y.mix(wrapper, config);","    },","","    /**","     * Sets the queue in motion.  All queued callbacks will be executed in","     * order unless pause() or stop() is called or if one of the callbacks is","     * configured with autoContinue: false.","     *","     * @method run","     * @return {AsyncQueue} the AsyncQueue instance","     * @chainable","     */","    run : function () {","        var callback,","            cont = true;","","        for (callback = this.next();","            cont && callback && !this.isRunning();","            callback = this.next())","        {","            cont = (callback.timeout < 0) ?","                this._execute(callback) :","                this._schedule(callback);","        }","","        if (!callback) {","            /**","             * Event fired after the last queued callback is executed.","             * @event complete","             */","            this.fire('complete');","        }","","        return this;","    },","","    /**","     * Handles the execution of callbacks. Returns a boolean indicating","     * whether it is appropriate to continue running.","     *","     * @method _execute","     * @param callback {Object} the callback object to execute","     * @return {Boolean} whether the run loop should continue","     * @protected","     */","    _execute : function (callback) {","        this._running = callback._running = true;","","        callback.iterations--;","        this.fire(EXECUTE, { callback: callback });","","        var cont = this._running && callback.autoContinue;","","        this._running = callback._running = false;","","        return cont;","    },","","    /**","     * Schedules the execution of asynchronous callbacks.","     *","     * @method _schedule","     * @param callback {Object} the callback object to execute","     * @return {Boolean} whether the run loop should continue","     * @protected","     */","    _schedule : function (callback) {","        this._running = Y.later(callback.timeout, this, function () {","            if (this._execute(callback)) {","                this.run();","            }","        });","","        return false;","    },","","    /**","     * Determines if the queue is waiting for a callback to complete execution.","     *","     * @method isRunning","     * @return {Boolean} true if queue is waiting for a ","     *                   from any initiated transactions","     */","    isRunning : function () {","        return !!this._running;","    },","","    /**","     * Default functionality for the &quot;execute&quot; event.  Executes the","     * callback function","     *","     * @method _defExecFn","     * @param e {Event} the event object","     * @protected","     */","    _defExecFn : function (e) {","        e.callback();","    },","","    /**","     * Add any number of callbacks to the end of the queue. Callbacks may be","     * provided as functions or objects.","     *","     * @method add","     * @param callback* {Function|Object} 0..n callbacks","     * @return {AsyncQueue} the AsyncQueue instance","     * @chainable","     */","    add : function () {","        this.fire('add', { callbacks: Y.Array(arguments,0,true) });","","        return this;","    },","","    /**","     * Default functionality for the &quot;add&quot; event.  Adds the callbacks","     * in the event facade to the queue. Callbacks successfully added to the","     * queue are present in the event's <code>added</code> property in the","     * after phase.","     *","     * @method _defAddFn","     * @param e {Event} the event object","     * @protected","     */","    _defAddFn : function(e) {","        var _q = this._q,","            added = [];","","        Y.Array.each(e.callbacks, function (c) {","            if (isObject(c)) {","                _q.push(c);","                added.push(c);","            }","        });","","        e.added = added;","    },","","    /**","     * Pause the execution of the queue after the execution of the current","     * callback completes.  If called from code outside of a queued callback,","     * clears the timeout for the pending callback. Paused queue can be","     * restarted with q.run()","     *","     * @method pause","     * @return {AsyncQueue} the AsyncQueue instance","     * @chainable","     */","    pause: function () {","        if (isObject(this._running)) {","            this._running.cancel();","        }","","        this._running = false;","","        return this;","    },","","    /**","     * Stop and clear the queue after the current execution of the","     * current callback completes.","     *","     * @method stop","     * @return {AsyncQueue} the AsyncQueue instance","     * @chainable","     */","    stop : function () { ","        this._q = [];","","        return this.pause();","    },","","    /** ","     * Returns the current index of a callback.  Pass in either the id or","     * callback function from getCallback.","     *","     * @method indexOf","     * @param callback {String|Function} the callback or its specified id","     * @return {Number} index of the callback or -1 if not found","     */","    indexOf : function (callback) {","        var i = 0, len = this._q.length, c;","","        for (; i < len; ++i) {","            c = this._q[i];","            if (c === callback || c.id === callback) {","                return i;","            }","        }","","        return -1;","    },","","    /**","     * Retrieve a callback by its id.  Useful to modify the configuration","     * while the queue is running.","     *","     * @method getCallback","     * @param id {String} the id assigned to the callback","     * @return {Object} the callback object","     */","    getCallback : function (id) {","        var i = this.indexOf(id);","","        return (i > -1) ? this._q[i] : null;","    },","","    /**","     * Promotes the named callback to the top of the queue. If a callback is","     * currently executing or looping (via until or iterations), the promotion","     * is scheduled to occur after the current callback has completed.","     *","     * @method promote","     * @param callback {String|Object} the callback object or a callback's id","     * @return {AsyncQueue} the AsyncQueue instance","     * @chainable","     */","    promote : function (callback) {","        var payload = { callback : callback },e;","","        if (this.isRunning()) {","            e = this.after(SHIFT, function () {","                    this.fire(PROMOTE, payload);","                    e.detach();","                }, this);","        } else {","            this.fire(PROMOTE, payload);","        }","","        return this;","    },","","    /**","     * <p>Default functionality for the &quot;promote&quot; event.  Promotes the","     * named callback to the head of the queue.</p>","     *","     * <p>The event object will contain a property &quot;callback&quot;, which","     * holds the id of a callback or the callback object itself.</p>","     *","     * @method _defPromoteFn","     * @param e {Event} the custom event","     * @protected","     */","    _defPromoteFn : function (e) {","        var i = this.indexOf(e.callback),","            promoted = (i > -1) ? this._q.splice(i,1)[0] : null;","","        e.promoted = promoted;","","        if (promoted) {","            this._q.unshift(promoted);","        }","    },","","    /**","     * Removes the callback from the queue.  If the queue is active, the","     * removal is scheduled to occur after the current callback has completed.","     *","     * @method remove","     * @param callback {String|Object} the callback object or a callback's id","     * @return {AsyncQueue} the AsyncQueue instance","     * @chainable","     */","    remove : function (callback) {","        var payload = { callback : callback },e;","","        // Can't return the removed callback because of the deferral until","        // current callback is complete","        if (this.isRunning()) {","            e = this.after(SHIFT, function () {","                    this.fire(REMOVE, payload);","                    e.detach();","                },this);","        } else {","            this.fire(REMOVE, payload);","        }","","        return this;","    },","","    /**","     * <p>Default functionality for the &quot;remove&quot; event.  Removes the","     * callback from the queue.</p>","     *","     * <p>The event object will contain a property &quot;callback&quot;, which","     * holds the id of a callback or the callback object itself.</p>","     *","     * @method _defRemoveFn","     * @param e {Event} the custom event","     * @protected","     */","    _defRemoveFn : function (e) {","        var i = this.indexOf(e.callback);","","        e.removed = (i > -1) ? this._q.splice(i,1)[0] : null;","    },","","    /**","     * Returns the number of callbacks in the queue.","     *","     * @method size","     * @return {Number}","     */","    size : function () {","        // next() flushes callbacks that have met their until() criteria and","        // therefore shouldn't count since they wouldn't execute anyway.","        if (!this.isRunning()) {","            this.next();","        }","","        return this._q.length;","    }","});","","","","}, '3.10.3', {\"requires\": [\"event-custom\"]});","","}());"]};
}
var __cov_O36jymnQJbOjHJXjG8T1YQ = __coverage__['build/async-queue/async-queue.js'];
__cov_O36jymnQJbOjHJXjG8T1YQ.s['1']++;YUI.add('async-queue',function(Y,NAME){__cov_O36jymnQJbOjHJXjG8T1YQ.f['1']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['2']++;Y.AsyncQueue=function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['2']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['3']++;this._init();__cov_O36jymnQJbOjHJXjG8T1YQ.s['4']++;this.add.apply(this,arguments);};__cov_O36jymnQJbOjHJXjG8T1YQ.s['5']++;var Queue=Y.AsyncQueue,EXECUTE='execute',SHIFT='shift',PROMOTE='promote',REMOVE='remove',isObject=Y.Lang.isObject,isFunction=Y.Lang.isFunction;__cov_O36jymnQJbOjHJXjG8T1YQ.s['6']++;Queue.defaults=Y.mix({autoContinue:true,iterations:1,timeout:10,until:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['3']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['7']++;this.iterations|=0;__cov_O36jymnQJbOjHJXjG8T1YQ.s['8']++;return this.iterations<=0;}},(__cov_O36jymnQJbOjHJXjG8T1YQ.b['1'][0]++,Y.config.queueDefaults)||(__cov_O36jymnQJbOjHJXjG8T1YQ.b['1'][1]++,{}));__cov_O36jymnQJbOjHJXjG8T1YQ.s['9']++;Y.extend(Queue,Y.EventTarget,{_running:false,_init:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['4']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['10']++;Y.EventTarget.call(this,{prefix:'queue',emitFacade:true});__cov_O36jymnQJbOjHJXjG8T1YQ.s['11']++;this._q=[];__cov_O36jymnQJbOjHJXjG8T1YQ.s['12']++;this.defaults={};__cov_O36jymnQJbOjHJXjG8T1YQ.s['13']++;this._initEvents();},_initEvents:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['5']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['14']++;this.publish({'execute':{defaultFn:this._defExecFn,emitFacade:true},'shift':{defaultFn:this._defShiftFn,emitFacade:true},'add':{defaultFn:this._defAddFn,emitFacade:true},'promote':{defaultFn:this._defPromoteFn,emitFacade:true},'remove':{defaultFn:this._defRemoveFn,emitFacade:true}});},next:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['6']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['15']++;var callback;__cov_O36jymnQJbOjHJXjG8T1YQ.s['16']++;while(this._q.length){__cov_O36jymnQJbOjHJXjG8T1YQ.s['17']++;callback=this._q[0]=this._prepare(this._q[0]);__cov_O36jymnQJbOjHJXjG8T1YQ.s['18']++;if((__cov_O36jymnQJbOjHJXjG8T1YQ.b['3'][0]++,callback)&&(__cov_O36jymnQJbOjHJXjG8T1YQ.b['3'][1]++,callback.until())){__cov_O36jymnQJbOjHJXjG8T1YQ.b['2'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['19']++;this.fire(SHIFT,{callback:callback});__cov_O36jymnQJbOjHJXjG8T1YQ.s['20']++;callback=null;}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['2'][1]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['21']++;break;}}__cov_O36jymnQJbOjHJXjG8T1YQ.s['22']++;return(__cov_O36jymnQJbOjHJXjG8T1YQ.b['4'][0]++,callback)||(__cov_O36jymnQJbOjHJXjG8T1YQ.b['4'][1]++,null);},_defShiftFn:function(e){__cov_O36jymnQJbOjHJXjG8T1YQ.f['7']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['23']++;if(this.indexOf(e.callback)===0){__cov_O36jymnQJbOjHJXjG8T1YQ.b['5'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['24']++;this._q.shift();}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['5'][1]++;}},_prepare:function(callback){__cov_O36jymnQJbOjHJXjG8T1YQ.f['8']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['25']++;if((__cov_O36jymnQJbOjHJXjG8T1YQ.b['7'][0]++,isFunction(callback))&&(__cov_O36jymnQJbOjHJXjG8T1YQ.b['7'][1]++,callback._prepared)){__cov_O36jymnQJbOjHJXjG8T1YQ.b['6'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['26']++;return callback;}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['6'][1]++;}__cov_O36jymnQJbOjHJXjG8T1YQ.s['27']++;var config=Y.merge(Queue.defaults,{context:this,args:[],_prepared:true},this.defaults,isFunction(callback)?(__cov_O36jymnQJbOjHJXjG8T1YQ.b['8'][0]++,{fn:callback}):(__cov_O36jymnQJbOjHJXjG8T1YQ.b['8'][1]++,callback)),wrapper=Y.bind(function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['9']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['28']++;if(!wrapper._running){__cov_O36jymnQJbOjHJXjG8T1YQ.b['9'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['29']++;wrapper.iterations--;}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['9'][1]++;}__cov_O36jymnQJbOjHJXjG8T1YQ.s['30']++;if(isFunction(wrapper.fn)){__cov_O36jymnQJbOjHJXjG8T1YQ.b['10'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['31']++;wrapper.fn.apply((__cov_O36jymnQJbOjHJXjG8T1YQ.b['11'][0]++,wrapper.context)||(__cov_O36jymnQJbOjHJXjG8T1YQ.b['11'][1]++,Y),Y.Array(wrapper.args));}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['10'][1]++;}},this);__cov_O36jymnQJbOjHJXjG8T1YQ.s['32']++;return Y.mix(wrapper,config);},run:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['10']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['33']++;var callback,cont=true;__cov_O36jymnQJbOjHJXjG8T1YQ.s['34']++;for(callback=this.next();(__cov_O36jymnQJbOjHJXjG8T1YQ.b['12'][0]++,cont)&&(__cov_O36jymnQJbOjHJXjG8T1YQ.b['12'][1]++,callback)&&(__cov_O36jymnQJbOjHJXjG8T1YQ.b['12'][2]++,!this.isRunning());callback=this.next()){__cov_O36jymnQJbOjHJXjG8T1YQ.s['35']++;cont=callback.timeout<0?(__cov_O36jymnQJbOjHJXjG8T1YQ.b['13'][0]++,this._execute(callback)):(__cov_O36jymnQJbOjHJXjG8T1YQ.b['13'][1]++,this._schedule(callback));}__cov_O36jymnQJbOjHJXjG8T1YQ.s['36']++;if(!callback){__cov_O36jymnQJbOjHJXjG8T1YQ.b['14'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['37']++;this.fire('complete');}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['14'][1]++;}__cov_O36jymnQJbOjHJXjG8T1YQ.s['38']++;return this;},_execute:function(callback){__cov_O36jymnQJbOjHJXjG8T1YQ.f['11']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['39']++;this._running=callback._running=true;__cov_O36jymnQJbOjHJXjG8T1YQ.s['40']++;callback.iterations--;__cov_O36jymnQJbOjHJXjG8T1YQ.s['41']++;this.fire(EXECUTE,{callback:callback});__cov_O36jymnQJbOjHJXjG8T1YQ.s['42']++;var cont=(__cov_O36jymnQJbOjHJXjG8T1YQ.b['15'][0]++,this._running)&&(__cov_O36jymnQJbOjHJXjG8T1YQ.b['15'][1]++,callback.autoContinue);__cov_O36jymnQJbOjHJXjG8T1YQ.s['43']++;this._running=callback._running=false;__cov_O36jymnQJbOjHJXjG8T1YQ.s['44']++;return cont;},_schedule:function(callback){__cov_O36jymnQJbOjHJXjG8T1YQ.f['12']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['45']++;this._running=Y.later(callback.timeout,this,function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['13']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['46']++;if(this._execute(callback)){__cov_O36jymnQJbOjHJXjG8T1YQ.b['16'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['47']++;this.run();}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['16'][1]++;}});__cov_O36jymnQJbOjHJXjG8T1YQ.s['48']++;return false;},isRunning:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['14']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['49']++;return!!this._running;},_defExecFn:function(e){__cov_O36jymnQJbOjHJXjG8T1YQ.f['15']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['50']++;e.callback();},add:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['16']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['51']++;this.fire('add',{callbacks:Y.Array(arguments,0,true)});__cov_O36jymnQJbOjHJXjG8T1YQ.s['52']++;return this;},_defAddFn:function(e){__cov_O36jymnQJbOjHJXjG8T1YQ.f['17']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['53']++;var _q=this._q,added=[];__cov_O36jymnQJbOjHJXjG8T1YQ.s['54']++;Y.Array.each(e.callbacks,function(c){__cov_O36jymnQJbOjHJXjG8T1YQ.f['18']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['55']++;if(isObject(c)){__cov_O36jymnQJbOjHJXjG8T1YQ.b['17'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['56']++;_q.push(c);__cov_O36jymnQJbOjHJXjG8T1YQ.s['57']++;added.push(c);}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['17'][1]++;}});__cov_O36jymnQJbOjHJXjG8T1YQ.s['58']++;e.added=added;},pause:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['19']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['59']++;if(isObject(this._running)){__cov_O36jymnQJbOjHJXjG8T1YQ.b['18'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['60']++;this._running.cancel();}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['18'][1]++;}__cov_O36jymnQJbOjHJXjG8T1YQ.s['61']++;this._running=false;__cov_O36jymnQJbOjHJXjG8T1YQ.s['62']++;return this;},stop:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['20']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['63']++;this._q=[];__cov_O36jymnQJbOjHJXjG8T1YQ.s['64']++;return this.pause();},indexOf:function(callback){__cov_O36jymnQJbOjHJXjG8T1YQ.f['21']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['65']++;var i=0,len=this._q.length,c;__cov_O36jymnQJbOjHJXjG8T1YQ.s['66']++;for(;i<len;++i){__cov_O36jymnQJbOjHJXjG8T1YQ.s['67']++;c=this._q[i];__cov_O36jymnQJbOjHJXjG8T1YQ.s['68']++;if((__cov_O36jymnQJbOjHJXjG8T1YQ.b['20'][0]++,c===callback)||(__cov_O36jymnQJbOjHJXjG8T1YQ.b['20'][1]++,c.id===callback)){__cov_O36jymnQJbOjHJXjG8T1YQ.b['19'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['69']++;return i;}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['19'][1]++;}}__cov_O36jymnQJbOjHJXjG8T1YQ.s['70']++;return-1;},getCallback:function(id){__cov_O36jymnQJbOjHJXjG8T1YQ.f['22']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['71']++;var i=this.indexOf(id);__cov_O36jymnQJbOjHJXjG8T1YQ.s['72']++;return i>-1?(__cov_O36jymnQJbOjHJXjG8T1YQ.b['21'][0]++,this._q[i]):(__cov_O36jymnQJbOjHJXjG8T1YQ.b['21'][1]++,null);},promote:function(callback){__cov_O36jymnQJbOjHJXjG8T1YQ.f['23']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['73']++;var payload={callback:callback},e;__cov_O36jymnQJbOjHJXjG8T1YQ.s['74']++;if(this.isRunning()){__cov_O36jymnQJbOjHJXjG8T1YQ.b['22'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['75']++;e=this.after(SHIFT,function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['24']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['76']++;this.fire(PROMOTE,payload);__cov_O36jymnQJbOjHJXjG8T1YQ.s['77']++;e.detach();},this);}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['22'][1]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['78']++;this.fire(PROMOTE,payload);}__cov_O36jymnQJbOjHJXjG8T1YQ.s['79']++;return this;},_defPromoteFn:function(e){__cov_O36jymnQJbOjHJXjG8T1YQ.f['25']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['80']++;var i=this.indexOf(e.callback),promoted=i>-1?(__cov_O36jymnQJbOjHJXjG8T1YQ.b['23'][0]++,this._q.splice(i,1)[0]):(__cov_O36jymnQJbOjHJXjG8T1YQ.b['23'][1]++,null);__cov_O36jymnQJbOjHJXjG8T1YQ.s['81']++;e.promoted=promoted;__cov_O36jymnQJbOjHJXjG8T1YQ.s['82']++;if(promoted){__cov_O36jymnQJbOjHJXjG8T1YQ.b['24'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['83']++;this._q.unshift(promoted);}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['24'][1]++;}},remove:function(callback){__cov_O36jymnQJbOjHJXjG8T1YQ.f['26']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['84']++;var payload={callback:callback},e;__cov_O36jymnQJbOjHJXjG8T1YQ.s['85']++;if(this.isRunning()){__cov_O36jymnQJbOjHJXjG8T1YQ.b['25'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['86']++;e=this.after(SHIFT,function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['27']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['87']++;this.fire(REMOVE,payload);__cov_O36jymnQJbOjHJXjG8T1YQ.s['88']++;e.detach();},this);}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['25'][1]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['89']++;this.fire(REMOVE,payload);}__cov_O36jymnQJbOjHJXjG8T1YQ.s['90']++;return this;},_defRemoveFn:function(e){__cov_O36jymnQJbOjHJXjG8T1YQ.f['28']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['91']++;var i=this.indexOf(e.callback);__cov_O36jymnQJbOjHJXjG8T1YQ.s['92']++;e.removed=i>-1?(__cov_O36jymnQJbOjHJXjG8T1YQ.b['26'][0]++,this._q.splice(i,1)[0]):(__cov_O36jymnQJbOjHJXjG8T1YQ.b['26'][1]++,null);},size:function(){__cov_O36jymnQJbOjHJXjG8T1YQ.f['29']++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['93']++;if(!this.isRunning()){__cov_O36jymnQJbOjHJXjG8T1YQ.b['27'][0]++;__cov_O36jymnQJbOjHJXjG8T1YQ.s['94']++;this.next();}else{__cov_O36jymnQJbOjHJXjG8T1YQ.b['27'][1]++;}__cov_O36jymnQJbOjHJXjG8T1YQ.s['95']++;return this._q.length;}});},'3.10.3',{'requires':['event-custom']});
