/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/tree-node/tree-node.js']) {
   __coverage__['build/tree-node/tree-node.js'] = {"path":"build/tree-node/tree-node.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0,"51":0,"52":0,"53":0,"54":0,"55":0,"56":0,"57":0,"58":0,"59":0,"60":0},"b":{"1":[0,0],"2":[0,0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0],"15":[0,0],"16":[0,0],"17":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":21},"end":{"line":1,"column":40}}},"2":{"name":"TreeNode","line":43,"loc":{"start":{"line":43,"column":0},"end":{"line":43,"column":32}}},"3":{"name":"(anonymous_3)","line":193,"loc":{"start":{"line":193,"column":12},"end":{"line":193,"column":37}}},"4":{"name":"(anonymous_4)","line":214,"loc":{"start":{"line":214,"column":11},"end":{"line":214,"column":30}}},"5":{"name":"(anonymous_5)","line":244,"loc":{"start":{"line":244,"column":10},"end":{"line":244,"column":48}}},"6":{"name":"(anonymous_6)","line":255,"loc":{"start":{"line":255,"column":17},"end":{"line":255,"column":29}}},"7":{"name":"(anonymous_7)","line":267,"loc":{"start":{"line":267,"column":11},"end":{"line":267,"column":23}}},"8":{"name":"(anonymous_8)","line":280,"loc":{"start":{"line":280,"column":13},"end":{"line":280,"column":29}}},"9":{"name":"(anonymous_9)","line":318,"loc":{"start":{"line":318,"column":12},"end":{"line":318,"column":37}}},"10":{"name":"(anonymous_10)","line":330,"loc":{"start":{"line":330,"column":14},"end":{"line":330,"column":26}}},"11":{"name":"(anonymous_11)","line":345,"loc":{"start":{"line":345,"column":12},"end":{"line":345,"column":24}}},"12":{"name":"(anonymous_12)","line":357,"loc":{"start":{"line":357,"column":10},"end":{"line":357,"column":22}}},"13":{"name":"(anonymous_13)","line":379,"loc":{"start":{"line":379,"column":13},"end":{"line":379,"column":38}}},"14":{"name":"(anonymous_14)","line":391,"loc":{"start":{"line":391,"column":14},"end":{"line":391,"column":26}}},"15":{"name":"(anonymous_15)","line":413,"loc":{"start":{"line":413,"column":12},"end":{"line":413,"column":31}}},"16":{"name":"(anonymous_16)","line":425,"loc":{"start":{"line":425,"column":10},"end":{"line":425,"column":22}}},"17":{"name":"(anonymous_17)","line":443,"loc":{"start":{"line":443,"column":12},"end":{"line":443,"column":24}}},"18":{"name":"(anonymous_18)","line":507,"loc":{"start":{"line":507,"column":14},"end":{"line":507,"column":52}}},"19":{"name":"(anonymous_19)","line":512,"loc":{"start":{"line":512,"column":14},"end":{"line":512,"column":26}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":529,"column":13}},"2":{"start":{"line":43,"column":0},"end":{"line":68,"column":1}},"3":{"start":{"line":44,"column":4},"end":{"line":44,"column":28}},"4":{"start":{"line":46,"column":4},"end":{"line":46,"column":73}},"5":{"start":{"line":47,"column":4},"end":{"line":47,"column":21}},"6":{"start":{"line":49,"column":4},"end":{"line":49,"column":42}},"7":{"start":{"line":50,"column":4},"end":{"line":50,"column":38}},"8":{"start":{"line":51,"column":4},"end":{"line":51,"column":39}},"9":{"start":{"line":53,"column":4},"end":{"line":57,"column":5}},"10":{"start":{"line":54,"column":8},"end":{"line":54,"column":54}},"11":{"start":{"line":55,"column":11},"end":{"line":57,"column":5}},"12":{"start":{"line":56,"column":8},"end":{"line":56,"column":36}},"13":{"start":{"line":61,"column":4},"end":{"line":61,"column":24}},"14":{"start":{"line":65,"column":4},"end":{"line":67,"column":5}},"15":{"start":{"line":66,"column":8},"end":{"line":66,"column":39}},"16":{"start":{"line":70,"column":0},"end":{"line":524,"column":2}},"17":{"start":{"line":194,"column":8},"end":{"line":194,"column":57}},"18":{"start":{"line":215,"column":8},"end":{"line":215,"column":50}},"19":{"start":{"line":245,"column":8},"end":{"line":245,"column":68}},"20":{"start":{"line":256,"column":8},"end":{"line":256,"column":38}},"21":{"start":{"line":268,"column":8},"end":{"line":268,"column":60}},"22":{"start":{"line":281,"column":8},"end":{"line":281,"column":18}},"23":{"start":{"line":283,"column":8},"end":{"line":285,"column":9}},"24":{"start":{"line":284,"column":12},"end":{"line":284,"column":28}},"25":{"start":{"line":287,"column":8},"end":{"line":287,"column":40}},"26":{"start":{"line":289,"column":8},"end":{"line":289,"column":57}},"27":{"start":{"line":319,"column":8},"end":{"line":319,"column":57}},"28":{"start":{"line":331,"column":8},"end":{"line":333,"column":9}},"29":{"start":{"line":332,"column":12},"end":{"line":332,"column":24}},"30":{"start":{"line":335,"column":8},"end":{"line":335,"column":57}},"31":{"start":{"line":346,"column":8},"end":{"line":346,"column":43}},"32":{"start":{"line":358,"column":8},"end":{"line":360,"column":9}},"33":{"start":{"line":359,"column":12},"end":{"line":359,"column":58}},"34":{"start":{"line":380,"column":8},"end":{"line":380,"column":58}},"35":{"start":{"line":392,"column":8},"end":{"line":394,"column":9}},"36":{"start":{"line":393,"column":12},"end":{"line":393,"column":58}},"37":{"start":{"line":414,"column":8},"end":{"line":414,"column":51}},"38":{"start":{"line":426,"column":8},"end":{"line":428,"column":27}},"39":{"start":{"line":430,"column":8},"end":{"line":432,"column":9}},"40":{"start":{"line":431,"column":12},"end":{"line":431,"column":40}},"41":{"start":{"line":434,"column":8},"end":{"line":434,"column":21}},"42":{"start":{"line":444,"column":8},"end":{"line":446,"column":24}},"43":{"start":{"line":449,"column":8},"end":{"line":451,"column":9}},"44":{"start":{"line":450,"column":12},"end":{"line":450,"column":24}},"45":{"start":{"line":454,"column":8},"end":{"line":460,"column":9}},"46":{"start":{"line":455,"column":12},"end":{"line":455,"column":40}},"47":{"start":{"line":457,"column":12},"end":{"line":459,"column":13}},"48":{"start":{"line":458,"column":16},"end":{"line":458,"column":37}},"49":{"start":{"line":463,"column":8},"end":{"line":469,"column":9}},"50":{"start":{"line":464,"column":12},"end":{"line":464,"column":30}},"51":{"start":{"line":466,"column":12},"end":{"line":468,"column":13}},"52":{"start":{"line":467,"column":16},"end":{"line":467,"column":61}},"53":{"start":{"line":471,"column":8},"end":{"line":471,"column":19}},"54":{"start":{"line":508,"column":8},"end":{"line":508,"column":72}},"55":{"start":{"line":513,"column":8},"end":{"line":515,"column":19}},"56":{"start":{"line":517,"column":8},"end":{"line":519,"column":9}},"57":{"start":{"line":518,"column":12},"end":{"line":518,"column":41}},"58":{"start":{"line":521,"column":8},"end":{"line":521,"column":38}},"59":{"start":{"line":522,"column":8},"end":{"line":522,"column":35}},"60":{"start":{"line":526,"column":0},"end":{"line":526,"column":36}}},"branchMap":{"1":{"line":44,"type":"binary-expr","locations":[{"start":{"line":44,"column":4},"end":{"line":44,"column":10}},{"start":{"line":44,"column":15},"end":{"line":44,"column":26}}]},"2":{"line":46,"type":"binary-expr","locations":[{"start":{"line":46,"column":29},"end":{"line":46,"column":38}},{"start":{"line":46,"column":42},"end":{"line":46,"column":49}},{"start":{"line":46,"column":53},"end":{"line":46,"column":72}}]},"3":{"line":49,"type":"binary-expr","locations":[{"start":{"line":49,"column":20},"end":{"line":49,"column":35}},{"start":{"line":49,"column":39},"end":{"line":49,"column":41}}]},"4":{"line":50,"type":"binary-expr","locations":[{"start":{"line":50,"column":20},"end":{"line":50,"column":31}},{"start":{"line":50,"column":35},"end":{"line":50,"column":37}}]},"5":{"line":51,"type":"binary-expr","locations":[{"start":{"line":51,"column":20},"end":{"line":51,"column":32}},{"start":{"line":51,"column":36},"end":{"line":51,"column":38}}]},"6":{"line":53,"type":"if","locations":[{"start":{"line":53,"column":4},"end":{"line":53,"column":4}},{"start":{"line":53,"column":4},"end":{"line":53,"column":4}}]},"7":{"line":55,"type":"if","locations":[{"start":{"line":55,"column":11},"end":{"line":55,"column":11}},{"start":{"line":55,"column":11},"end":{"line":55,"column":11}}]},"8":{"line":268,"type":"cond-expr","locations":[{"start":{"line":268,"column":29},"end":{"line":268,"column":54}},{"start":{"line":268,"column":57},"end":{"line":268,"column":59}}]},"9":{"line":283,"type":"if","locations":[{"start":{"line":283,"column":8},"end":{"line":283,"column":8}},{"start":{"line":283,"column":8},"end":{"line":283,"column":8}}]},"10":{"line":289,"type":"cond-expr","locations":[{"start":{"line":289,"column":46},"end":{"line":289,"column":48}},{"start":{"line":289,"column":51},"end":{"line":289,"column":56}}]},"11":{"line":331,"type":"if","locations":[{"start":{"line":331,"column":8},"end":{"line":331,"column":8}},{"start":{"line":331,"column":8},"end":{"line":331,"column":8}}]},"12":{"line":335,"type":"binary-expr","locations":[{"start":{"line":335,"column":18},"end":{"line":335,"column":29}},{"start":{"line":335,"column":33},"end":{"line":335,"column":55}}]},"13":{"line":358,"type":"if","locations":[{"start":{"line":358,"column":8},"end":{"line":358,"column":8}},{"start":{"line":358,"column":8},"end":{"line":358,"column":8}}]},"14":{"line":392,"type":"if","locations":[{"start":{"line":392,"column":8},"end":{"line":392,"column":8}},{"start":{"line":392,"column":8},"end":{"line":392,"column":8}}]},"15":{"line":449,"type":"if","locations":[{"start":{"line":449,"column":8},"end":{"line":449,"column":8}},{"start":{"line":449,"column":8},"end":{"line":449,"column":8}}]},"16":{"line":457,"type":"if","locations":[{"start":{"line":457,"column":12},"end":{"line":457,"column":12}},{"start":{"line":457,"column":12},"end":{"line":457,"column":12}}]},"17":{"line":463,"type":"if","locations":[{"start":{"line":463,"column":8},"end":{"line":463,"column":8}},{"start":{"line":463,"column":8},"end":{"line":463,"column":8}}]}},"code":["(function () { YUI.add('tree-node', function (Y, NAME) {","","/*jshint expr:true, onevar:false */","","/**","Provides the `Tree.Node` class, which represents a tree node contained in a","`Tree` data structure.","","@module tree","@submodule tree-node","**/","","/**","Represents a tree node in a `Tree` data structure.","","@class Tree.Node","@param {Tree} tree `Tree` instance with which this node should be associated.","@param {Object} [config] Configuration hash for this node.","","    @param {Boolean} [config.canHaveChildren=false] Whether or not this node can","        contain child nodes. Will be automatically set to `true` if not","        specified and `config.children` contains one or more children.","","    @param {Tree.Node[]} [config.children] Array of `Tree.Node` instances","        for child nodes of this node.","","    @param {Object} [config.data] Implementation-specific data related to this","        node. You may add arbitrary properties to this hash for your own use.","","    @param {String} [config.id] Unique id for this node. This id must be unique","        among all tree nodes on the entire page, and will also be used as this","        node's DOM id when it's rendered by a TreeView. A unique id will be","        automatically generated unless you specify a custom value.","","    @param {Object} [config.state] State hash for this node. You may add","        arbitrary state properties to this hash for your own use. See the","        docs for `Tree.Node`'s `state` property for details on state values used","        internally by `Tree.Node`.","","@constructor","**/","","function TreeNode(tree, config) {","    config || (config = {});","","    this.id   = this._yuid = config.id || this.id || Y.guid('treeNode-');","    this.tree = tree;","","    this.children = config.children || [];","    this.data     = config.data || {};","    this.state    = config.state || {};","","    if (config.canHaveChildren) {","        this.canHaveChildren = config.canHaveChildren;","    } else if (this.children.length) {","        this.canHaveChildren = true;","    }","","    // Mix in arbitrary properties on the config object, but don't overwrite any","    // existing properties of this node.","    Y.mix(this, config);","","    // If this node has children, loop through them and ensure their parent","    // references are all set to this node.","    for (var i = 0, len = this.children.length; i < len; i++) {","        this.children[i].parent = this;","    }","}","","TreeNode.prototype = {","    // -- Public Properties ----------------------------------------------------","","    /**","    Whether or not this node can contain child nodes.","","    This value is falsy by default unless child nodes are added at instantiation","    time, in which case it will be automatically set to `true`. You can also","    manually set it to `true` to indicate that a node can have children even","    though it might not currently have any children.","","    Note that regardless of the value of this property, appending, prepending,","    or inserting a node into this node will cause `canHaveChildren` to be set to","    true automatically.","","    @property {Boolean} canHaveChildren","    **/","","    /**","    Child nodes contained within this node.","","    @property {Tree.Node[]} children","    @default []","    @readOnly","    **/","","    /**","    Arbitrary serializable data related to this node.","","    Use this property to store any data that should accompany this node when it","    is serialized to JSON.","","    @property {Object} data","    @default {}","    **/","","    /**","    Unique id for this node.","","    @property {String} id","    @readOnly","    **/","","    /**","    Parent node of this node, or `undefined` if this is an unattached node or","    the root node.","","    @property {Tree.Node} parent","    @readOnly","    **/","","    /**","    Current state of this node.","","    Use this property to store state-specific info -- such as whether this node","    is \"open\", \"selected\", or any other arbitrary state -- that should accompany","    this node when it is serialized to JSON.","","    @property {Object} state","    **/","","    /**","    The Tree instance with which this node is associated.","","    @property {Tree} tree","    @readOnly","    **/","","    // -- Protected Properties -------------------------------------------------","","    /**","    Mapping of child node ids to indices.","","    @property {Object} _indexMap","    @protected","    **/","","    /**","    Flag indicating whether the `_indexMap` is stale and needs to be rebuilt.","","    @property {Boolean} _isIndexStale","    @default true","    @protected","    **/","    _isIndexStale: true,","","    /**","    Simple way to type-check that this is an instance of Tree.Node.","","    @property {Boolean} _isYUITreeNode","    @default true","    @protected","    **/","    _isYUITreeNode: true,","","    /**","    Array of property names on this node that should be serialized to JSON when","    `toJSON()` is called.","","    Note that the `children` property is a special case that is managed","    separately.","","    @property {String[]} _serializable","    @protected","    **/","    _serializable: ['canHaveChildren', 'data', 'id', 'state'],","","    // -- Public Methods -------------------------------------------------------","","    /**","    Appends the given tree node or array of nodes to the end of this node's","    children.","","    @method append","    @param {Object|Object[]|Tree.Node|Tree.Node[]} node Child node, node config","        object, array of child nodes, or array of node config objects to append","        to the given parent. Node config objects will automatically be converted","        into node instances.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `add` event will","            be suppressed.","    @return {Tree.Node|Tree.Node[]} Node or array of nodes that were appended.","    **/","    append: function (node, options) {","        return this.tree.appendNode(this, node, options);","    },","","    /**","    Removes all children from this node. The removed children will still be","    reusable unless the `destroy` option is truthy.","","    @method empty","    @param {Object} [options] Options.","        @param {Boolean} [options.destroy=false] If `true`, the children will","            also be destroyed, which makes them available for garbage collection","            and means they can't be reused.","        @param {Boolean} [options.silent=false] If `true`, `remove` events will","            be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @return {Tree.Node[]} Array of removed child nodes.","    **/","    empty: function (options) {","        return this.tree.emptyNode(this, options);","    },","","    /**","    Performs a depth-first traversal of this node, passing it and each of its","    descendants to the specified _callback_, and returning the first node for","    which the callback returns a truthy value.","","    Traversal will stop as soon as a truthy value is returned from the callback.","","    See `Tree#traverseNode()` for more details on how depth-first traversal","    works.","","    @method find","    @param {Object} [options] Options.","        @param {Number} [options.depth] Depth limit. If specified, descendants","            will only be traversed to this depth before backtracking and moving","            on.","    @param {Function} callback Callback function to call with the traversed","        node and each of its descendants. If this function returns a truthy","        value, traversal will be stopped and the current node will be returned.","","        @param {Tree.Node} callback.node Node being traversed.","","    @param {Object} [thisObj] `this` object to use when executing _callback_.","    @return {Tree.Node|null} Returns the first node for which the _callback_","        returns a truthy value, or `null` if the callback never returns a truthy","        value.","    **/","    find: function (options, callback, thisObj) {","        return this.tree.findNode(this, options, callback, thisObj);","    },","","    /**","    Returns `true` if this node has one or more child nodes.","","    @method hasChildren","    @return {Boolean} `true` if this node has one or more child nodes, `false`","        otherwise.","    **/","    hasChildren: function () {","        return !!this.children.length;","    },","","    /**","    Returns the numerical index of this node within its parent node, or `-1` if","    this node doesn't have a parent node.","","    @method index","    @return {Number} Index of this node within its parent node, or `-1` if this","        node doesn't have a parent node.","    **/","    index: function () {","        return this.parent ? this.parent.indexOf(this) : -1;","    },","","    /**","    Returns the numerical index of the given child node, or `-1` if the node is","    not a child of this node.","","    @method indexOf","    @param {Tree.Node} node Child node.","    @return {Number} Index of the child, or `-1` if the node is not a child of","        this node.","    **/","    indexOf: function (node) {","        var index;","","        if (this._isIndexStale) {","            this._reindex();","        }","","        index = this._indexMap[node.id];","","        return typeof index === 'undefined' ? -1 : index;","    },","","    /**","    Inserts a node or array of nodes at the specified index under this node, or","    appends them to this node if no index is specified.","","    If a node being inserted is from another tree, it and all its children will","    be removed from that tree and moved to this one.","","    @method insert","    @param {Object|Object[]|Tree.Node|Tree.Node[]} node Child node, node config","        object, array of child nodes, or array of node config objects to insert","        under the given parent. Node config objects will automatically be","        converted into node instances.","","    @param {Object} [options] Options.","        @param {Number} [options.index] Index at which to insert the child node.","            If not specified, the node will be appended as the last child of the","            parent.","        @param {Boolean} [options.silent=false] If `true`, the `add` event will","            be suppressed.","        @param {String} [options.src='insert'] Source of the change, to be","            passed along to the event facade of the resulting event. This can be","            used to distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","","    @return {Tree.Node[]} Node or array of nodes that were inserted.","    **/","    insert: function (node, options) {","        return this.tree.insertNode(this, node, options);","    },","","    /**","    Returns `true` if this node has been inserted into a tree, `false` if it is","    merely associated with a tree and has not yet been inserted.","","    @method isInTree","    @return {Boolean} `true` if this node has been inserted into a tree, `false`","        otherwise.","    **/","    isInTree: function () {","        if (this.tree.rootNode === this) {","            return true;","        }","","        return !!(this.parent && this.parent.isInTree());","    },","","    /**","    Returns `true` if this node is the root of the tree.","","    @method isRoot","    @return {Boolean} `true` if this node is the root of the tree, `false`","        otherwise.","    **/","    isRoot: function () {","        return this.tree.rootNode === this;","    },","","    /**","    Returns this node's next sibling, or `undefined` if this node is the last","    child.","","    @method next","    @return {Tree.Node} This node's next sibling, or `undefined` if this node is","        the last child.","    **/","    next: function () {","        if (this.parent) {","            return this.parent.children[this.index() + 1];","        }","    },","","    /**","    Prepends a node or array of nodes at the beginning of this node's children.","","    If a node being prepended is from another tree, it and all its children will","    be removed from that tree and moved to this one.","","    @method prepend","    @param {Object|Object[]|Tree.Node|Tree.Node[]} node Child node, node config","        object, array of child nodes, or array of node config objects to prepend","        to this node. Node config objects will automatically be converted into","        node instances.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent=false] If `true`, the `add` event will","            be suppressed.","    @return {Tree.Node|Tree.Node[]} Node or array of nodes that were prepended.","    **/","    prepend: function (node, options) {","        return this.tree.prependNode(this, node, options);","    },","","    /**","    Returns this node's previous sibling, or `undefined` if this node is the","    first child","","    @method previous","    @return {Tree.Node} This node's previous sibling, or `undefined` if this","        node is the first child.","    **/","    previous: function () {","        if (this.parent) {","            return this.parent.children[this.index() - 1];","        }","    },","","    /**","    Removes this node from its parent node.","","    @method remove","    @param {Object} [options] Options.","        @param {Boolean} [options.destroy=false] If `true`, this node and all","            its children will also be destroyed, which makes them available for","            garbage collection and means they can't be reused.","        @param {Boolean} [options.silent=false] If `true`, the `remove` event","            will be suppressed.","        @param {String} [options.src] Source of the change, to be passed along","            to the event facade of the resulting event. This can be used to","            distinguish between changes triggered by a user and changes","            triggered programmatically, for example.","    @chainable","    **/","    remove: function (options) {","        return this.tree.removeNode(this, options);","    },","","    /**","    Returns the total number of nodes contained within this node, including all","    descendants of this node's children.","","    @method size","    @return {Number} Total number of nodes contained within this node, including","        all descendants.","    **/","    size: function () {","        var children = this.children,","            len      = children.length,","            total    = len;","","        for (var i = 0; i < len; i++) {","            total += children[i].size();","        }","","        return total;","    },","","    /**","    Serializes this node to an object suitable for use in JSON.","","    @method toJSON","    @return {Object} Serialized node object.","    **/","    toJSON: function () {","        var obj   = {},","            state = this.state,","            i, key, len;","","        // Do nothing if this node is marked as destroyed.","        if (state.destroyed) {","            return null;","        }","","        // Serialize properties explicitly marked as serializable.","        for (i = 0, len = this._serializable.length; i < len; i++) {","            key = this._serializable[i];","","            if (key in this) {","                obj[key] = this[key];","            }","        }","","        // Serialize child nodes.","        if (this.canHaveChildren) {","            obj.children = [];","","            for (i = 0, len = this.children.length; i < len; i++) {","                obj.children.push(this.children[i].toJSON());","            }","        }","","        return obj;","    },","","    /**","    Performs a depth-first traversal of this node, passing it and each of its","    descendants to the specified _callback_.","","    If the callback function returns `Tree.STOP_TRAVERSAL`, traversal will be","    stopped immediately. Otherwise, it will continue until the deepest","    descendant of _node_ has been traversed, or until each branch has been","    traversed to the optional maximum depth limit.","","    Since traversal is depth-first, that means nodes are traversed like this:","","                1","              / | \\","             2  8  9","            / \\     \\","           3   7    10","         / | \\      / \\","        4  5  6    11 12","","    @method traverse","    @param {Object} [options] Options.","        @param {Number} [options.depth] Depth limit. If specified, descendants","            will only be traversed to this depth before backtracking and moving","            on.","    @param {Function} callback Callback function to call with the traversed","        node and each of its descendants.","","        @param {Tree.Node} callback.node Node being traversed.","","    @param {Object} [thisObj] `this` object to use when executing _callback_.","    @return {Mixed} Returns `Tree.STOP_TRAVERSAL` if traversal was stopped;","        otherwise returns `undefined`.","    **/","    traverse: function (options, callback, thisObj) {","        return this.tree.traverseNode(this, options, callback, thisObj);","    },","","    // -- Protected Methods ----------------------------------------------------","    _reindex: function () {","        var children = this.children,","            indexMap = {},","            i, len;","","        for (i = 0, len = children.length; i < len; i++) {","            indexMap[children[i].id] = i;","        }","","        this._indexMap     = indexMap;","        this._isIndexStale = false;","    }","};","","Y.namespace('Tree').Node = TreeNode;","","","}, '3.10.3');","","}());"]};
}
var __cov_siF1pVVJ9wJWmbvFnyg_eg = __coverage__['build/tree-node/tree-node.js'];
__cov_siF1pVVJ9wJWmbvFnyg_eg.s['1']++;YUI.add('tree-node',function(Y,NAME){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['1']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['2']++;function TreeNode(tree,config){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['2']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['3']++;(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['1'][0]++,config)||(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['1'][1]++,config={});__cov_siF1pVVJ9wJWmbvFnyg_eg.s['4']++;this.id=this._yuid=(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['2'][0]++,config.id)||(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['2'][1]++,this.id)||(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['2'][2]++,Y.guid('treeNode-'));__cov_siF1pVVJ9wJWmbvFnyg_eg.s['5']++;this.tree=tree;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['6']++;this.children=(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['3'][0]++,config.children)||(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['3'][1]++,[]);__cov_siF1pVVJ9wJWmbvFnyg_eg.s['7']++;this.data=(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['4'][0]++,config.data)||(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['4'][1]++,{});__cov_siF1pVVJ9wJWmbvFnyg_eg.s['8']++;this.state=(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['5'][0]++,config.state)||(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['5'][1]++,{});__cov_siF1pVVJ9wJWmbvFnyg_eg.s['9']++;if(config.canHaveChildren){__cov_siF1pVVJ9wJWmbvFnyg_eg.b['6'][0]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['10']++;this.canHaveChildren=config.canHaveChildren;}else{__cov_siF1pVVJ9wJWmbvFnyg_eg.b['6'][1]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['11']++;if(this.children.length){__cov_siF1pVVJ9wJWmbvFnyg_eg.b['7'][0]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['12']++;this.canHaveChildren=true;}else{__cov_siF1pVVJ9wJWmbvFnyg_eg.b['7'][1]++;}}__cov_siF1pVVJ9wJWmbvFnyg_eg.s['13']++;Y.mix(this,config);__cov_siF1pVVJ9wJWmbvFnyg_eg.s['14']++;for(var i=0,len=this.children.length;i<len;i++){__cov_siF1pVVJ9wJWmbvFnyg_eg.s['15']++;this.children[i].parent=this;}}__cov_siF1pVVJ9wJWmbvFnyg_eg.s['16']++;TreeNode.prototype={_isIndexStale:true,_isYUITreeNode:true,_serializable:['canHaveChildren','data','id','state'],append:function(node,options){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['3']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['17']++;return this.tree.appendNode(this,node,options);},empty:function(options){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['4']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['18']++;return this.tree.emptyNode(this,options);},find:function(options,callback,thisObj){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['5']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['19']++;return this.tree.findNode(this,options,callback,thisObj);},hasChildren:function(){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['6']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['20']++;return!!this.children.length;},index:function(){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['7']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['21']++;return this.parent?(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['8'][0]++,this.parent.indexOf(this)):(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['8'][1]++,-1);},indexOf:function(node){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['8']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['22']++;var index;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['23']++;if(this._isIndexStale){__cov_siF1pVVJ9wJWmbvFnyg_eg.b['9'][0]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['24']++;this._reindex();}else{__cov_siF1pVVJ9wJWmbvFnyg_eg.b['9'][1]++;}__cov_siF1pVVJ9wJWmbvFnyg_eg.s['25']++;index=this._indexMap[node.id];__cov_siF1pVVJ9wJWmbvFnyg_eg.s['26']++;return typeof index==='undefined'?(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['10'][0]++,-1):(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['10'][1]++,index);},insert:function(node,options){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['9']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['27']++;return this.tree.insertNode(this,node,options);},isInTree:function(){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['10']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['28']++;if(this.tree.rootNode===this){__cov_siF1pVVJ9wJWmbvFnyg_eg.b['11'][0]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['29']++;return true;}else{__cov_siF1pVVJ9wJWmbvFnyg_eg.b['11'][1]++;}__cov_siF1pVVJ9wJWmbvFnyg_eg.s['30']++;return!!((__cov_siF1pVVJ9wJWmbvFnyg_eg.b['12'][0]++,this.parent)&&(__cov_siF1pVVJ9wJWmbvFnyg_eg.b['12'][1]++,this.parent.isInTree()));},isRoot:function(){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['11']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['31']++;return this.tree.rootNode===this;},next:function(){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['12']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['32']++;if(this.parent){__cov_siF1pVVJ9wJWmbvFnyg_eg.b['13'][0]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['33']++;return this.parent.children[this.index()+1];}else{__cov_siF1pVVJ9wJWmbvFnyg_eg.b['13'][1]++;}},prepend:function(node,options){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['13']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['34']++;return this.tree.prependNode(this,node,options);},previous:function(){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['14']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['35']++;if(this.parent){__cov_siF1pVVJ9wJWmbvFnyg_eg.b['14'][0]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['36']++;return this.parent.children[this.index()-1];}else{__cov_siF1pVVJ9wJWmbvFnyg_eg.b['14'][1]++;}},remove:function(options){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['15']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['37']++;return this.tree.removeNode(this,options);},size:function(){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['16']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['38']++;var children=this.children,len=children.length,total=len;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['39']++;for(var i=0;i<len;i++){__cov_siF1pVVJ9wJWmbvFnyg_eg.s['40']++;total+=children[i].size();}__cov_siF1pVVJ9wJWmbvFnyg_eg.s['41']++;return total;},toJSON:function(){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['17']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['42']++;var obj={},state=this.state,i,key,len;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['43']++;if(state.destroyed){__cov_siF1pVVJ9wJWmbvFnyg_eg.b['15'][0]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['44']++;return null;}else{__cov_siF1pVVJ9wJWmbvFnyg_eg.b['15'][1]++;}__cov_siF1pVVJ9wJWmbvFnyg_eg.s['45']++;for(i=0,len=this._serializable.length;i<len;i++){__cov_siF1pVVJ9wJWmbvFnyg_eg.s['46']++;key=this._serializable[i];__cov_siF1pVVJ9wJWmbvFnyg_eg.s['47']++;if(key in this){__cov_siF1pVVJ9wJWmbvFnyg_eg.b['16'][0]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['48']++;obj[key]=this[key];}else{__cov_siF1pVVJ9wJWmbvFnyg_eg.b['16'][1]++;}}__cov_siF1pVVJ9wJWmbvFnyg_eg.s['49']++;if(this.canHaveChildren){__cov_siF1pVVJ9wJWmbvFnyg_eg.b['17'][0]++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['50']++;obj.children=[];__cov_siF1pVVJ9wJWmbvFnyg_eg.s['51']++;for(i=0,len=this.children.length;i<len;i++){__cov_siF1pVVJ9wJWmbvFnyg_eg.s['52']++;obj.children.push(this.children[i].toJSON());}}else{__cov_siF1pVVJ9wJWmbvFnyg_eg.b['17'][1]++;}__cov_siF1pVVJ9wJWmbvFnyg_eg.s['53']++;return obj;},traverse:function(options,callback,thisObj){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['18']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['54']++;return this.tree.traverseNode(this,options,callback,thisObj);},_reindex:function(){__cov_siF1pVVJ9wJWmbvFnyg_eg.f['19']++;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['55']++;var children=this.children,indexMap={},i,len;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['56']++;for(i=0,len=children.length;i<len;i++){__cov_siF1pVVJ9wJWmbvFnyg_eg.s['57']++;indexMap[children[i].id]=i;}__cov_siF1pVVJ9wJWmbvFnyg_eg.s['58']++;this._indexMap=indexMap;__cov_siF1pVVJ9wJWmbvFnyg_eg.s['59']++;this._isIndexStale=false;}};__cov_siF1pVVJ9wJWmbvFnyg_eg.s['60']++;Y.namespace('Tree').Node=TreeNode;},'3.10.3');
