#!/usr/bin/env node

var examples = require('./selleck'),
    fs = require('fs'),
    path = require('path'),
    tab = '    ',
    xml = path.join(__dirname, '../tests', 'selleck.xml'),
    str = [
        '<?xml version="1.0"?>',
        '<!-- Dynamically generated by src/common/node/make_selleck_xml.js -->',
        '<yuitest>',
        tab + '<tests base="@TEST_ARTIFACTS_BASE@" timeout="240000">'
    ];

    str.push('<!-- This needs to be first to prep the ');
    str.push('            browser window for the other tests -->');
    str.push(tab + tab + '<url>common/tests/prep.html</url>');

    examples.forEach(function(url) {
        str.push(tab + tab + '<url>' + url + '</url>');
    });

    str.push(tab + '</tests>');
    str.push('</yuitest>');
    
    fs.writeFileSync(xml, str.join('\n'), 'utf8');

    console.log('Wrote', examples.length, 'example urls to selleck.xml');
