/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/arraylist/arraylist.js']) {
   __coverage__['build/arraylist/arraylist.js'] = {"path":"build/arraylist/arraylist.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":21},"end":{"line":1,"column":40}}},"2":{"name":"ArrayList","line":29,"loc":{"start":{"line":29,"column":0},"end":{"line":29,"column":28}}},"3":{"name":"(anonymous_3)","line":49,"loc":{"start":{"line":49,"column":10},"end":{"line":49,"column":25}}},"4":{"name":"(anonymous_4)","line":65,"loc":{"start":{"line":65,"column":10},"end":{"line":65,"column":35}}},"5":{"name":"(anonymous_5)","line":66,"loc":{"start":{"line":66,"column":34},"end":{"line":66,"column":55}}},"6":{"name":"(anonymous_6)","line":89,"loc":{"start":{"line":89,"column":10},"end":{"line":89,"column":35}}},"7":{"name":"(anonymous_7)","line":90,"loc":{"start":{"line":90,"column":41},"end":{"line":90,"column":62}}},"8":{"name":"(anonymous_8)","line":104,"loc":{"start":{"line":104,"column":13},"end":{"line":104,"column":33}}},"9":{"name":"(anonymous_9)","line":114,"loc":{"start":{"line":114,"column":10},"end":{"line":114,"column":22}}},"10":{"name":"(anonymous_10)","line":124,"loc":{"start":{"line":124,"column":13},"end":{"line":124,"column":25}}},"11":{"name":"(anonymous_11)","line":134,"loc":{"start":{"line":134,"column":12},"end":{"line":134,"column":24}}},"12":{"name":"(anonymous_12)","line":186,"loc":{"start":{"line":186,"column":15},"end":{"line":186,"column":40}}},"13":{"name":"(anonymous_13)","line":190,"loc":{"start":{"line":190,"column":28},"end":{"line":190,"column":46}}},"14":{"name":"(anonymous_14)","line":191,"loc":{"start":{"line":191,"column":27},"end":{"line":191,"column":39}}},"15":{"name":"(anonymous_15)","line":195,"loc":{"start":{"line":195,"column":42},"end":{"line":195,"column":63}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":214,"column":41}},"2":{"start":{"line":9,"column":0},"end":{"line":11,"column":19}},"3":{"start":{"line":29,"column":0},"end":{"line":36,"column":1}},"4":{"start":{"line":30,"column":4},"end":{"line":35,"column":5}},"5":{"start":{"line":31,"column":8},"end":{"line":31,"column":72}},"6":{"start":{"line":34,"column":8},"end":{"line":34,"column":40}},"7":{"start":{"line":38,"column":0},"end":{"line":137,"column":2}},"8":{"start":{"line":50,"column":8},"end":{"line":50,"column":30}},"9":{"start":{"line":66,"column":8},"end":{"line":70,"column":17}},"10":{"start":{"line":67,"column":12},"end":{"line":67,"column":34}},"11":{"start":{"line":69,"column":12},"end":{"line":69,"column":54}},"12":{"start":{"line":72,"column":8},"end":{"line":72,"column":20}},"13":{"start":{"line":90,"column":8},"end":{"line":94,"column":17}},"14":{"start":{"line":91,"column":12},"end":{"line":91,"column":34}},"15":{"start":{"line":93,"column":12},"end":{"line":93,"column":61}},"16":{"start":{"line":105,"column":8},"end":{"line":105,"column":53}},"17":{"start":{"line":115,"column":8},"end":{"line":115,"column":34}},"18":{"start":{"line":125,"column":8},"end":{"line":125,"column":28}},"19":{"start":{"line":135,"column":8},"end":{"line":135,"column":27}},"20":{"start":{"line":150,"column":0},"end":{"line":150,"column":43}},"21":{"start":{"line":154,"column":0},"end":{"line":154,"column":43}},"22":{"start":{"line":156,"column":0},"end":{"line":209,"column":4}},"23":{"start":{"line":188,"column":8},"end":{"line":188,"column":32}},"24":{"start":{"line":190,"column":8},"end":{"line":207,"column":12}},"25":{"start":{"line":191,"column":12},"end":{"line":206,"column":14}},"26":{"start":{"line":192,"column":16},"end":{"line":193,"column":30}},"27":{"start":{"line":195,"column":16},"end":{"line":203,"column":25}},"28":{"start":{"line":196,"column":20},"end":{"line":196,"column":43}},"29":{"start":{"line":198,"column":20},"end":{"line":198,"column":66}},"30":{"start":{"line":200,"column":20},"end":{"line":202,"column":21}},"31":{"start":{"line":201,"column":24},"end":{"line":201,"column":40}},"32":{"start":{"line":205,"column":16},"end":{"line":205,"column":47}},"33":{"start":{"line":211,"column":0},"end":{"line":211,"column":24}}},"branchMap":{"1":{"line":30,"type":"if","locations":[{"start":{"line":30,"column":4},"end":{"line":30,"column":4}},{"start":{"line":30,"column":4},"end":{"line":30,"column":4}}]},"2":{"line":31,"type":"cond-expr","locations":[{"start":{"line":31,"column":48},"end":{"line":31,"column":53}},{"start":{"line":31,"column":56},"end":{"line":31,"column":71}}]},"3":{"line":34,"type":"binary-expr","locations":[{"start":{"line":34,"column":22},"end":{"line":34,"column":33}},{"start":{"line":34,"column":37},"end":{"line":34,"column":39}}]},"4":{"line":69,"type":"binary-expr","locations":[{"start":{"line":69,"column":21},"end":{"line":69,"column":28}},{"start":{"line":69,"column":32},"end":{"line":69,"column":36}}]},"5":{"line":93,"type":"binary-expr","locations":[{"start":{"line":93,"column":28},"end":{"line":93,"column":35}},{"start":{"line":93,"column":39},"end":{"line":93,"column":43}}]},"6":{"line":200,"type":"if","locations":[{"start":{"line":200,"column":20},"end":{"line":200,"column":20}},{"start":{"line":200,"column":20},"end":{"line":200,"column":20}}]},"7":{"line":200,"type":"binary-expr","locations":[{"start":{"line":200,"column":25},"end":{"line":200,"column":45}},{"start":{"line":200,"column":49},"end":{"line":200,"column":64}}]},"8":{"line":205,"type":"cond-expr","locations":[{"start":{"line":205,"column":36},"end":{"line":205,"column":39}},{"start":{"line":205,"column":42},"end":{"line":205,"column":46}}]}},"code":["(function () { YUI.add('arraylist', function (Y, NAME) {","","/**"," * Collection utilities beyond what is provided in the YUI core"," * @module collection"," * @submodule arraylist"," */","","var YArray      = Y.Array,","    YArray_each = YArray.each,","    ArrayListProto;","","/**"," * Generic ArrayList class for managing lists of items and iterating operations"," * over them.  The targeted use for this class is for augmentation onto a"," * class that is responsible for managing multiple instances of another class"," * (e.g. NodeList for Nodes).  The recommended use is to augment your class with"," * ArrayList, then use ArrayList.addMethod to mirror the API of the constituent"," * items on the list's API."," *"," * The default implementation creates immutable lists, but mutability can be"," * provided via the arraylist-add submodule or by implementing mutation methods"," * directly on the augmented class's prototype."," *"," * @class ArrayList"," * @constructor"," * @param items { Array } array of items this list will be responsible for"," */","function ArrayList( items ) {","    if ( items !== undefined ) {","        this._items = Y.Lang.isArray( items ) ? items : YArray( items );","    } else {","        // ||= to support lazy initialization from augment","        this._items = this._items || [];","    }","}","","ArrayListProto = {","    /**","     * Get an item by index from the list.  Override this method if managing a","     * list of objects that have a different public representation (e.g. Node","     * instances vs DOM nodes).  The iteration methods that accept a user","     * function will use this method for access list items for operation.","     *","     * @method item","     * @param i { Integer } index to fetch","     * @return { mixed } the item at the requested index","     */","    item: function ( i ) {","        return this._items[i];","    },","","    /**","     * <p>Execute a function on each item of the list, optionally providing a","     * custom execution context.  Default context is the item.</p>","     *","     * <p>The callback signature is <code>callback( item, index )</code>.</p>","     *","     * @method each","     * @param fn { Function } the function to execute","     * @param context { mixed } optional override 'this' in the function","     * @return { ArrayList } this instance","     * @chainable","     */","    each: function ( fn, context ) {","        YArray_each( this._items, function ( item, i ) {","            item = this.item( i );","","            fn.call( context || item, item, i, this );","        }, this);","","        return this;","    },","","    /**","     * <p>Execute a function on each item of the list, optionally providing a","     * custom execution context.  Default context is the item.</p>","     *","     * <p>The callback signature is <code>callback( item, index )</code>.</p>","     *","     * <p>Unlike <code>each</code>, if the callback returns true, the","     * iteratation will stop.</p>","     *","     * @method some","     * @param fn { Function } the function to execute","     * @param context { mixed } optional override 'this' in the function","     * @return { Boolean } True if the function returned true on an item","     */","    some: function ( fn, context ) {","        return YArray.some( this._items, function ( item, i ) {","            item = this.item( i );","","            return fn.call( context || item, item, i, this );","        }, this);","    },","","    /**","     * Finds the first index of the needle in the managed array of items.","     *","     * @method indexOf","     * @param needle { mixed } The item to search for","     * @return { Integer } Array index if found.  Otherwise -1","     */","    indexOf: function ( needle ) {","        return YArray.indexOf( this._items, needle );","    },","","    /**","     * How many items are in this list?","     *","     * @method size","     * @return { Integer } Number of items in the list","     */","    size: function () {","        return this._items.length;","    },","","    /**","     * Is this instance managing any items?","     *","     * @method isEmpty","     * @return { Boolean } true if 1 or more items are being managed","     */","    isEmpty: function () {","        return !this.size();","    },","","    /**","     * Provides an array-like representation for JSON.stringify.","     *","     * @method toJSON","     * @return { Array } an array representation of the ArrayList","     */","    toJSON: function () {","        return this._items;","    }","};","// Default implementation does not distinguish between public and private","// item getter","/**"," * Protected method for optimizations that may be appropriate for API"," * mirroring. Similar in functionality to <code>item</code>, but is used by"," * methods added with <code>ArrayList.addMethod()</code>."," *"," * @method _item"," * @protected"," * @param i { Integer } Index of item to fetch"," * @return { mixed } The item appropriate for pass through API methods"," */","ArrayListProto._item = ArrayListProto.item;","","// Mixed onto existing proto to preserve constructor NOT being an own property.","// This has bitten me when composing classes by enumerating, copying prototypes.","Y.mix(ArrayList.prototype, ArrayListProto);","","Y.mix( ArrayList, {","","    /**","     * <p>Adds a pass through method to dest (typically the prototype of a list","     * class) that calls the named method on each item in the list with","     * whatever parameters are passed in.  Allows for API indirection via list","     * instances.</p>","     *","     * <p>Accepts a single string name or an array of string names.</p>","     *","     * <pre><code>list.each( function ( item ) {","     *     item.methodName( 1, 2, 3 );","     * } );","     * // becomes","     * list.methodName( 1, 2, 3 );</code></pre>","     *","     * <p>Additionally, the pass through methods use the item retrieved by the","     * <code>_item</code> method in case there is any special behavior that is","     * appropriate for API mirroring.</p>","     *","     * <p>If the iterated method returns a value, the return value from the","     * added method will be an array of values with each value being at the","     * corresponding index for that item.  If the iterated method does not","     * return a value, the added method will be chainable.","     *","     * @method addMethod","     * @static","     * @param dest {Object} Object or prototype to receive the iterator method","     * @param name {String|String[]} Name of method of methods to create","     */","    addMethod: function ( dest, names ) {","","        names = YArray( names );","","        YArray_each( names, function ( name ) {","            dest[ name ] = function () {","                var args = YArray( arguments, 0, true ),","                    ret  = [];","","                YArray_each( this._items, function ( item, i ) {","                    item = this._item( i );","","                    var result = item[ name ].apply( item, args );","","                    if ( result !== undefined && result !== item ) {","                        ret[i] = result;","                    }","                }, this);","","                return ret.length ? ret : this;","            };","        } );","    }","} );","","Y.ArrayList = ArrayList;","","","}, '3.10.3', {\"requires\": [\"yui-base\"]});","","}());"]};
}
var __cov_Pr6cz5MpnW7epOPHRJTxOA = __coverage__['build/arraylist/arraylist.js'];
__cov_Pr6cz5MpnW7epOPHRJTxOA.s['1']++;YUI.add('arraylist',function(Y,NAME){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['1']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['2']++;var YArray=Y.Array,YArray_each=YArray.each,ArrayListProto;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['3']++;function ArrayList(items){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['2']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['4']++;if(items!==undefined){__cov_Pr6cz5MpnW7epOPHRJTxOA.b['1'][0]++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['5']++;this._items=Y.Lang.isArray(items)?(__cov_Pr6cz5MpnW7epOPHRJTxOA.b['2'][0]++,items):(__cov_Pr6cz5MpnW7epOPHRJTxOA.b['2'][1]++,YArray(items));}else{__cov_Pr6cz5MpnW7epOPHRJTxOA.b['1'][1]++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['6']++;this._items=(__cov_Pr6cz5MpnW7epOPHRJTxOA.b['3'][0]++,this._items)||(__cov_Pr6cz5MpnW7epOPHRJTxOA.b['3'][1]++,[]);}}__cov_Pr6cz5MpnW7epOPHRJTxOA.s['7']++;ArrayListProto={item:function(i){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['3']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['8']++;return this._items[i];},each:function(fn,context){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['4']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['9']++;YArray_each(this._items,function(item,i){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['5']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['10']++;item=this.item(i);__cov_Pr6cz5MpnW7epOPHRJTxOA.s['11']++;fn.call((__cov_Pr6cz5MpnW7epOPHRJTxOA.b['4'][0]++,context)||(__cov_Pr6cz5MpnW7epOPHRJTxOA.b['4'][1]++,item),item,i,this);},this);__cov_Pr6cz5MpnW7epOPHRJTxOA.s['12']++;return this;},some:function(fn,context){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['6']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['13']++;return YArray.some(this._items,function(item,i){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['7']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['14']++;item=this.item(i);__cov_Pr6cz5MpnW7epOPHRJTxOA.s['15']++;return fn.call((__cov_Pr6cz5MpnW7epOPHRJTxOA.b['5'][0]++,context)||(__cov_Pr6cz5MpnW7epOPHRJTxOA.b['5'][1]++,item),item,i,this);},this);},indexOf:function(needle){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['8']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['16']++;return YArray.indexOf(this._items,needle);},size:function(){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['9']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['17']++;return this._items.length;},isEmpty:function(){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['10']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['18']++;return!this.size();},toJSON:function(){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['11']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['19']++;return this._items;}};__cov_Pr6cz5MpnW7epOPHRJTxOA.s['20']++;ArrayListProto._item=ArrayListProto.item;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['21']++;Y.mix(ArrayList.prototype,ArrayListProto);__cov_Pr6cz5MpnW7epOPHRJTxOA.s['22']++;Y.mix(ArrayList,{addMethod:function(dest,names){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['12']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['23']++;names=YArray(names);__cov_Pr6cz5MpnW7epOPHRJTxOA.s['24']++;YArray_each(names,function(name){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['13']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['25']++;dest[name]=function(){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['14']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['26']++;var args=YArray(arguments,0,true),ret=[];__cov_Pr6cz5MpnW7epOPHRJTxOA.s['27']++;YArray_each(this._items,function(item,i){__cov_Pr6cz5MpnW7epOPHRJTxOA.f['15']++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['28']++;item=this._item(i);__cov_Pr6cz5MpnW7epOPHRJTxOA.s['29']++;var result=item[name].apply(item,args);__cov_Pr6cz5MpnW7epOPHRJTxOA.s['30']++;if((__cov_Pr6cz5MpnW7epOPHRJTxOA.b['7'][0]++,result!==undefined)&&(__cov_Pr6cz5MpnW7epOPHRJTxOA.b['7'][1]++,result!==item)){__cov_Pr6cz5MpnW7epOPHRJTxOA.b['6'][0]++;__cov_Pr6cz5MpnW7epOPHRJTxOA.s['31']++;ret[i]=result;}else{__cov_Pr6cz5MpnW7epOPHRJTxOA.b['6'][1]++;}},this);__cov_Pr6cz5MpnW7epOPHRJTxOA.s['32']++;return ret.length?(__cov_Pr6cz5MpnW7epOPHRJTxOA.b['8'][0]++,ret):(__cov_Pr6cz5MpnW7epOPHRJTxOA.b['8'][1]++,this);};});}});__cov_Pr6cz5MpnW7epOPHRJTxOA.s['33']++;Y.ArrayList=ArrayList;},'3.10.3',{'requires':['yui-base']});
