/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/axis-numeric/axis-numeric.js']) {
   __coverage__['build/axis-numeric/axis-numeric.js'] = {"path":"build/axis-numeric/axis-numeric.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0,0,0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":24},"end":{"line":1,"column":43}}},"2":{"name":"(anonymous_2)","line":31,"loc":{"start":{"line":31,"column":22},"end":{"line":32,"column":4}}},"3":{"name":"(anonymous_3)","line":73,"loc":{"start":{"line":73,"column":16},"end":{"line":74,"column":4}}},"4":{"name":"(anonymous_4)","line":98,"loc":{"start":{"line":98,"column":29},"end":{"line":99,"column":4}}},"5":{"name":"(anonymous_5)","line":150,"loc":{"start":{"line":150,"column":22},"end":{"line":151,"column":4}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":173,"column":58}},"2":{"start":{"line":9,"column":0},"end":{"line":9,"column":16}},"3":{"start":{"line":20,"column":0},"end":{"line":169,"column":3}},"4":{"start":{"line":33,"column":8},"end":{"line":37,"column":56}},"5":{"start":{"line":38,"column":12},"end":{"line":38,"column":19}},"6":{"start":{"line":40,"column":8},"end":{"line":56,"column":9}},"7":{"start":{"line":42,"column":12},"end":{"line":42,"column":24}},"8":{"start":{"line":44,"column":13},"end":{"line":56,"column":9}},"9":{"start":{"line":46,"column":12},"end":{"line":46,"column":24}},"10":{"start":{"line":50,"column":12},"end":{"line":50,"column":33}},"11":{"start":{"line":51,"column":12},"end":{"line":54,"column":13}},"12":{"start":{"line":53,"column":16},"end":{"line":53,"column":60}},"13":{"start":{"line":55,"column":12},"end":{"line":55,"column":25}},"14":{"start":{"line":57,"column":8},"end":{"line":57,"column":33}},"15":{"start":{"line":75,"column":8},"end":{"line":75,"column":80}},"16":{"start":{"line":76,"column":8},"end":{"line":79,"column":9}},"17":{"start":{"line":78,"column":12},"end":{"line":78,"column":29}},"18":{"start":{"line":80,"column":8},"end":{"line":80,"column":22}},"19":{"start":{"line":100,"column":8},"end":{"line":111,"column":74}},"20":{"start":{"line":112,"column":8},"end":{"line":121,"column":9}},"21":{"start":{"line":114,"column":12},"end":{"line":114,"column":30}},"22":{"start":{"line":115,"column":12},"end":{"line":115,"column":31}},"23":{"start":{"line":119,"column":12},"end":{"line":119,"column":30}},"24":{"start":{"line":120,"column":12},"end":{"line":120,"column":31}},"25":{"start":{"line":122,"column":8},"end":{"line":122,"column":46}},"26":{"start":{"line":123,"column":8},"end":{"line":134,"column":9}},"27":{"start":{"line":125,"column":12},"end":{"line":125,"column":40}},"28":{"start":{"line":126,"column":12},"end":{"line":133,"column":13}},"29":{"start":{"line":128,"column":16},"end":{"line":128,"column":30}},"30":{"start":{"line":129,"column":16},"end":{"line":129,"column":52}},"31":{"start":{"line":130,"column":16},"end":{"line":130,"column":104}},"32":{"start":{"line":131,"column":16},"end":{"line":131,"column":38}},"33":{"start":{"line":132,"column":16},"end":{"line":132,"column":40}},"34":{"start":{"line":135,"column":8},"end":{"line":138,"column":10}},"35":{"start":{"line":152,"column":8},"end":{"line":154,"column":16}},"36":{"start":{"line":155,"column":8},"end":{"line":158,"column":9}},"37":{"start":{"line":157,"column":12},"end":{"line":157,"column":24}},"38":{"start":{"line":159,"column":8},"end":{"line":159,"column":52}},"39":{"start":{"line":160,"column":8},"end":{"line":160,"column":34}},"40":{"start":{"line":161,"column":8},"end":{"line":161,"column":34}},"41":{"start":{"line":162,"column":8},"end":{"line":166,"column":9}},"42":{"start":{"line":165,"column":12},"end":{"line":165,"column":24}},"43":{"start":{"line":167,"column":8},"end":{"line":167,"column":21}}},"branchMap":{"1":{"line":40,"type":"if","locations":[{"start":{"line":40,"column":8},"end":{"line":40,"column":8}},{"start":{"line":40,"column":8},"end":{"line":40,"column":8}}]},"2":{"line":44,"type":"if","locations":[{"start":{"line":44,"column":13},"end":{"line":44,"column":13}},{"start":{"line":44,"column":13},"end":{"line":44,"column":13}}]},"3":{"line":51,"type":"if","locations":[{"start":{"line":51,"column":12},"end":{"line":51,"column":12}},{"start":{"line":51,"column":12},"end":{"line":51,"column":12}}]},"4":{"line":76,"type":"if","locations":[{"start":{"line":76,"column":8},"end":{"line":76,"column":8}},{"start":{"line":76,"column":8},"end":{"line":76,"column":8}}]},"5":{"line":112,"type":"if","locations":[{"start":{"line":112,"column":8},"end":{"line":112,"column":8}},{"start":{"line":112,"column":8},"end":{"line":112,"column":8}}]},"6":{"line":126,"type":"if","locations":[{"start":{"line":126,"column":12},"end":{"line":126,"column":12}},{"start":{"line":126,"column":12},"end":{"line":126,"column":12}}]},"7":{"line":126,"type":"binary-expr","locations":[{"start":{"line":126,"column":15},"end":{"line":126,"column":42}},{"start":{"line":126,"column":46},"end":{"line":126,"column":63}},{"start":{"line":126,"column":67},"end":{"line":126,"column":84}}]},"8":{"line":155,"type":"if","locations":[{"start":{"line":155,"column":8},"end":{"line":155,"column":8}},{"start":{"line":155,"column":8},"end":{"line":155,"column":8}}]},"9":{"line":155,"type":"binary-expr","locations":[{"start":{"line":155,"column":11},"end":{"line":155,"column":29}},{"start":{"line":155,"column":33},"end":{"line":155,"column":51}}]},"10":{"line":162,"type":"if","locations":[{"start":{"line":162,"column":8},"end":{"line":162,"column":8}},{"start":{"line":162,"column":8},"end":{"line":162,"column":8}}]},"11":{"line":162,"type":"binary-expr","locations":[{"start":{"line":162,"column":11},"end":{"line":162,"column":42}},{"start":{"line":163,"column":14},"end":{"line":163,"column":34}},{"start":{"line":163,"column":38},"end":{"line":163,"column":61}},{"start":{"line":163,"column":67},"end":{"line":163,"column":87}},{"start":{"line":163,"column":91},"end":{"line":163,"column":114}}]}},"code":["(function () { YUI.add('axis-numeric', function (Y, NAME) {","","/**"," * Provides functionality for drawing a numeric axis for use with a chart."," *"," * @module charts"," * @submodule axis-numeric"," */","Y_Lang = Y.Lang;","/**"," * NumericAxis draws a numeric axis."," *"," * @class NumericAxis"," * @constructor"," * @extends Axis"," * @uses NumericImpl"," * @param {Object} config (optional) Configuration parameters."," * @submodule axis-numeric"," */","Y.NumericAxis = Y.Base.create(\"numericAxis\", Y.Axis, [Y.NumericImpl], {","    /**","     * Calculates and returns a value based on the number of labels and the index of","     * the current label.","     *","     * @method getLabelByIndex","     * @param {Number} i Index of the label.","     * @param {Number} l Total number of labels.","     * @return String","     * @private","     */","    _getLabelByIndex: function(i, l)","    {","        var min = this.get(\"minimum\"),","            max = this.get(\"maximum\"),","            increm = (max - min)/(l-1),","            label,","            roundingMethod = this.get(\"roundingMethod\");","            l -= 1;","        //respect the min and max. calculate all other labels.","        if(i === 0)","        {","            label = min;","        }","        else if(i === l)","        {","            label = max;","        }","        else","        {","            label = (i * increm);","            if(roundingMethod === \"niceNumber\")","            {","                label = this._roundToNearest(label, increm);","            }","            label += min;","        }","        return parseFloat(label);","    },","","    /**","     * Calculates points based off the majorUnit count or distance of the Axis.","     *","     * @method _getPoints","     * @param {Object} startPoint An object literal containing the x and y coordinates of the first","     * point on the axis.","     * @param {Number} len The number of points on an axis.","     * @param {Number} edgeOffset The distance from the start of the axis and the point.","     * @param {Number} majorUnitDistance The distance between points on an axis.","     * @param {String} direction Indicates whether the axis is horizontal or vertical.","     * @return Array","     * @private","     */","    _getPoints: function(startPoint, len, edgeOffset, majorUnitDistance, direction)","    {","        var points = Y.NumericAxis.superclass._getPoints.apply(this, arguments);","        if(direction === \"vertical\")","        {","            points.reverse();","        }","        return points;","    },","","    /**","     * Calculates the position of ticks and labels based on an array of specified label values. Returns","     * an object containing an array of values to be used for labels and an array of objects containing","     * x and y coordinates for each label.","     *","     * @method _getDataFromLabelValues","     * @param {Object} startPoint An object containing the x and y coordinates for the start of the axis.","     * @param {Array} labelValues An array containing values to be used for determining the number and","     * position of labels and ticks on the axis.","     * @param {Number} edgeOffset The distance, in pixels, on either edge of the axis.","     * @param {Number} layoutLength The length, in pixels, of the axis. If the axis is vertical, the length","     * is equal to the height. If the axis is horizontal, the length is equal to the width.","     * @return Object","     * @private","     */","    _getDataFromLabelValues: function(startPoint, labelValues, edgeOffset, layoutLength, direction)","    {","        var points = [],","            labelValue,","            i,","            len = labelValues.length,","            staticCoord,","            dynamicCoord,","            constantVal,","            newPoint,","            max = this.get(\"maximum\"),","            min = this.get(\"minimum\"),","            values = [],","            scaleFactor = (layoutLength - (edgeOffset * 2)) / (max - min);","        if(direction === \"vertical\")","        {","            staticCoord = \"x\";","            dynamicCoord = \"y\";","        }","        else","        {","            staticCoord = \"y\";","            dynamicCoord = \"x\";","        }","        constantVal = startPoint[staticCoord];","        for(i = 0; i < len; i = i + 1)","        {","            labelValue = labelValues[i];","            if(Y.Lang.isNumber(labelValue) && labelValue >= min && labelValue <= max)","            {","                newPoint = {};","                newPoint[staticCoord] = constantVal;","                newPoint[dynamicCoord] = (layoutLength - edgeOffset) - (labelValue - min) * scaleFactor;","                points.push(newPoint);","                values.push(labelValue);","            }","        }","        return {","            points: points,","            values: values","        };","    },","","    /**","     * Checks to see if data extends beyond the range of the axis. If so,","     * that data will need to be hidden. This method is internal, temporary and subject","     * to removal in the future.","     *","     * @method _hasDataOverflow","     * @protected","     * @return Boolean","     */","    _hasDataOverflow: function()","    {","        var roundingMethod,","            min,","            max;","        if(this.get(\"setMin\") || this.get(\"setMax\"))","        {","            return true;","        }","        roundingMethod = this.get(\"roundingMethod\");","        min = this._actualMinimum;","        max = this._actualMaximum;","        if(Y_Lang.isNumber(roundingMethod) &&","            ((Y_Lang.isNumber(max) && max > this._dataMaximum) || (Y_Lang.isNumber(min) && min < this._dataMinimum)))","        {","            return true;","        }","        return false;","    }","});","","","","}, '3.10.3', {\"requires\": [\"axis\", \"axis-numeric-base\"]});","","}());"]};
}
var __cov_rRHiT7Hw9EyHGe8gGcWbSA = __coverage__['build/axis-numeric/axis-numeric.js'];
__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['1']++;YUI.add('axis-numeric',function(Y,NAME){__cov_rRHiT7Hw9EyHGe8gGcWbSA.f['1']++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['2']++;Y_Lang=Y.Lang;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['3']++;Y.NumericAxis=Y.Base.create('numericAxis',Y.Axis,[Y.NumericImpl],{_getLabelByIndex:function(i,l){__cov_rRHiT7Hw9EyHGe8gGcWbSA.f['2']++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['4']++;var min=this.get('minimum'),max=this.get('maximum'),increm=(max-min)/(l-1),label,roundingMethod=this.get('roundingMethod');__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['5']++;l-=1;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['6']++;if(i===0){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['1'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['7']++;label=min;}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['1'][1]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['8']++;if(i===l){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['2'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['9']++;label=max;}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['2'][1]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['10']++;label=i*increm;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['11']++;if(roundingMethod==='niceNumber'){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['3'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['12']++;label=this._roundToNearest(label,increm);}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['3'][1]++;}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['13']++;label+=min;}}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['14']++;return parseFloat(label);},_getPoints:function(startPoint,len,edgeOffset,majorUnitDistance,direction){__cov_rRHiT7Hw9EyHGe8gGcWbSA.f['3']++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['15']++;var points=Y.NumericAxis.superclass._getPoints.apply(this,arguments);__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['16']++;if(direction==='vertical'){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['4'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['17']++;points.reverse();}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['4'][1]++;}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['18']++;return points;},_getDataFromLabelValues:function(startPoint,labelValues,edgeOffset,layoutLength,direction){__cov_rRHiT7Hw9EyHGe8gGcWbSA.f['4']++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['19']++;var points=[],labelValue,i,len=labelValues.length,staticCoord,dynamicCoord,constantVal,newPoint,max=this.get('maximum'),min=this.get('minimum'),values=[],scaleFactor=(layoutLength-edgeOffset*2)/(max-min);__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['20']++;if(direction==='vertical'){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['5'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['21']++;staticCoord='x';__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['22']++;dynamicCoord='y';}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['5'][1]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['23']++;staticCoord='y';__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['24']++;dynamicCoord='x';}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['25']++;constantVal=startPoint[staticCoord];__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['26']++;for(i=0;i<len;i=i+1){__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['27']++;labelValue=labelValues[i];__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['28']++;if((__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['7'][0]++,Y.Lang.isNumber(labelValue))&&(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['7'][1]++,labelValue>=min)&&(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['7'][2]++,labelValue<=max)){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['6'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['29']++;newPoint={};__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['30']++;newPoint[staticCoord]=constantVal;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['31']++;newPoint[dynamicCoord]=layoutLength-edgeOffset-(labelValue-min)*scaleFactor;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['32']++;points.push(newPoint);__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['33']++;values.push(labelValue);}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['6'][1]++;}}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['34']++;return{points:points,values:values};},_hasDataOverflow:function(){__cov_rRHiT7Hw9EyHGe8gGcWbSA.f['5']++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['35']++;var roundingMethod,min,max;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['36']++;if((__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['9'][0]++,this.get('setMin'))||(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['9'][1]++,this.get('setMax'))){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['8'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['37']++;return true;}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['8'][1]++;}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['38']++;roundingMethod=this.get('roundingMethod');__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['39']++;min=this._actualMinimum;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['40']++;max=this._actualMaximum;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['41']++;if((__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][0]++,Y_Lang.isNumber(roundingMethod))&&((__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][1]++,Y_Lang.isNumber(max))&&(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][2]++,max>this._dataMaximum)||(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][3]++,Y_Lang.isNumber(min))&&(__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['11'][4]++,min<this._dataMinimum))){__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['10'][0]++;__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['42']++;return true;}else{__cov_rRHiT7Hw9EyHGe8gGcWbSA.b['10'][1]++;}__cov_rRHiT7Hw9EyHGe8gGcWbSA.s['43']++;return false;}});},'3.10.3',{'requires':['axis','axis-numeric-base']});
