/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/tree-sortable/tree-sortable.js']) {
   __coverage__['build/tree-sortable/tree-sortable.js'] = {"path":"build/tree-sortable/tree-sortable.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0,"43":0,"44":0,"45":0,"46":0,"47":0,"48":0,"49":0,"50":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0],"15":[0,0],"16":[0,0],"17":[0,0],"18":[0,0],"19":[0,0],"20":[0,0],"21":[0,0],"22":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":25},"end":{"line":1,"column":44}}},"2":{"name":"Sortable","line":40,"loc":{"start":{"line":40,"column":0},"end":{"line":40,"column":20}}},"3":{"name":"(anonymous_3)","line":55,"loc":{"start":{"line":55,"column":17},"end":{"line":55,"column":35}}},"4":{"name":"(anonymous_4)","line":82,"loc":{"start":{"line":82,"column":20},"end":{"line":82,"column":36}}},"5":{"name":"(anonymous_5)","line":106,"loc":{"start":{"line":106,"column":14},"end":{"line":106,"column":39}}},"6":{"name":"(anonymous_6)","line":159,"loc":{"start":{"line":159,"column":14},"end":{"line":159,"column":30}}},"7":{"name":"(anonymous_7)","line":176,"loc":{"start":{"line":176,"column":21},"end":{"line":176,"column":37}}},"8":{"name":"(anonymous_8)","line":192,"loc":{"start":{"line":192,"column":26},"end":{"line":192,"column":50}}},"9":{"name":"(anonymous_9)","line":246,"loc":{"start":{"line":246,"column":11},"end":{"line":246,"column":48}}},"10":{"name":"NodeSortable","line":267,"loc":{"start":{"line":267,"column":0},"end":{"line":267,"column":24}}},"11":{"name":"(anonymous_11)","line":289,"loc":{"start":{"line":289,"column":10},"end":{"line":289,"column":29}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":298,"column":37}},"2":{"start":{"line":38,"column":0},"end":{"line":38,"column":22}},"3":{"start":{"line":40,"column":0},"end":{"line":40,"column":22}},"4":{"start":{"line":42,"column":0},"end":{"line":250,"column":2}},"5":{"start":{"line":56,"column":8},"end":{"line":56,"column":79}},"6":{"start":{"line":58,"column":8},"end":{"line":66,"column":9}},"7":{"start":{"line":59,"column":12},"end":{"line":61,"column":13}},"8":{"start":{"line":60,"column":16},"end":{"line":60,"column":60}},"9":{"start":{"line":63,"column":12},"end":{"line":65,"column":13}},"10":{"start":{"line":64,"column":16},"end":{"line":64,"column":54}},"11":{"start":{"line":83,"column":8},"end":{"line":83,"column":28}},"12":{"start":{"line":108,"column":8},"end":{"line":110,"column":9}},"13":{"start":{"line":109,"column":12},"end":{"line":109,"column":24}},"14":{"start":{"line":112,"column":8},"end":{"line":112,"column":34}},"15":{"start":{"line":114,"column":8},"end":{"line":114,"column":23}},"16":{"start":{"line":116,"column":8},"end":{"line":120,"column":9}},"17":{"start":{"line":117,"column":12},"end":{"line":117,"column":70}},"18":{"start":{"line":119,"column":12},"end":{"line":119,"column":68}},"19":{"start":{"line":122,"column":8},"end":{"line":122,"column":20}},"20":{"start":{"line":124,"column":8},"end":{"line":130,"column":9}},"21":{"start":{"line":125,"column":12},"end":{"line":125,"column":61}},"22":{"start":{"line":126,"column":15},"end":{"line":130,"column":9}},"23":{"start":{"line":127,"column":12},"end":{"line":127,"column":39}},"24":{"start":{"line":129,"column":12},"end":{"line":129,"column":39}},"25":{"start":{"line":132,"column":8},"end":{"line":132,"column":75}},"26":{"start":{"line":134,"column":8},"end":{"line":140,"column":9}},"27":{"start":{"line":135,"column":12},"end":{"line":139,"column":15}},"28":{"start":{"line":142,"column":8},"end":{"line":142,"column":20}},"29":{"start":{"line":160,"column":8},"end":{"line":160,"column":44}},"30":{"start":{"line":177,"column":8},"end":{"line":177,"column":44}},"31":{"start":{"line":195,"column":8},"end":{"line":199,"column":89}},"32":{"start":{"line":201,"column":8},"end":{"line":203,"column":9}},"33":{"start":{"line":202,"column":12},"end":{"line":202,"column":23}},"34":{"start":{"line":210,"column":8},"end":{"line":212,"column":9}},"35":{"start":{"line":211,"column":12},"end":{"line":211,"column":37}},"36":{"start":{"line":214,"column":8},"end":{"line":215,"column":39}},"37":{"start":{"line":219,"column":8},"end":{"line":219,"column":19}},"38":{"start":{"line":221,"column":8},"end":{"line":229,"column":9}},"39":{"start":{"line":222,"column":12},"end":{"line":222,"column":38}},"40":{"start":{"line":224,"column":12},"end":{"line":228,"column":13}},"41":{"start":{"line":225,"column":16},"end":{"line":225,"column":33}},"42":{"start":{"line":227,"column":16},"end":{"line":227,"column":29}},"43":{"start":{"line":231,"column":8},"end":{"line":231,"column":19}},"44":{"start":{"line":247,"column":8},"end":{"line":248,"column":42}},"45":{"start":{"line":252,"column":0},"end":{"line":252,"column":27}},"46":{"start":{"line":267,"column":0},"end":{"line":267,"column":26}},"47":{"start":{"line":269,"column":0},"end":{"line":293,"column":2}},"48":{"start":{"line":290,"column":8},"end":{"line":290,"column":42}},"49":{"start":{"line":291,"column":8},"end":{"line":291,"column":20}},"50":{"start":{"line":295,"column":0},"end":{"line":295,"column":36}}},"branchMap":{"1":{"line":58,"type":"if","locations":[{"start":{"line":58,"column":8},"end":{"line":58,"column":8}},{"start":{"line":58,"column":8},"end":{"line":58,"column":8}}]},"2":{"line":59,"type":"if","locations":[{"start":{"line":59,"column":12},"end":{"line":59,"column":12}},{"start":{"line":59,"column":12},"end":{"line":59,"column":12}}]},"3":{"line":63,"type":"if","locations":[{"start":{"line":63,"column":12},"end":{"line":63,"column":12}},{"start":{"line":63,"column":12},"end":{"line":63,"column":12}}]},"4":{"line":108,"type":"if","locations":[{"start":{"line":108,"column":8},"end":{"line":108,"column":8}},{"start":{"line":108,"column":8},"end":{"line":108,"column":8}}]},"5":{"line":112,"type":"binary-expr","locations":[{"start":{"line":112,"column":8},"end":{"line":112,"column":15}},{"start":{"line":112,"column":20},"end":{"line":112,"column":32}}]},"6":{"line":116,"type":"if","locations":[{"start":{"line":116,"column":8},"end":{"line":116,"column":8}},{"start":{"line":116,"column":8},"end":{"line":116,"column":8}}]},"7":{"line":119,"type":"binary-expr","locations":[{"start":{"line":119,"column":25},"end":{"line":119,"column":44}},{"start":{"line":119,"column":48},"end":{"line":119,"column":67}}]},"8":{"line":124,"type":"if","locations":[{"start":{"line":124,"column":8},"end":{"line":124,"column":8}},{"start":{"line":124,"column":8},"end":{"line":124,"column":8}}]},"9":{"line":126,"type":"if","locations":[{"start":{"line":126,"column":15},"end":{"line":126,"column":15}},{"start":{"line":126,"column":15},"end":{"line":126,"column":15}}]},"10":{"line":134,"type":"if","locations":[{"start":{"line":134,"column":8},"end":{"line":134,"column":8}},{"start":{"line":134,"column":8},"end":{"line":134,"column":8}}]},"11":{"line":160,"type":"cond-expr","locations":[{"start":{"line":160,"column":23},"end":{"line":160,"column":25}},{"start":{"line":160,"column":29},"end":{"line":160,"column":42}}]},"12":{"line":160,"type":"cond-expr","locations":[{"start":{"line":160,"column":37},"end":{"line":160,"column":38}},{"start":{"line":160,"column":41},"end":{"line":160,"column":42}}]},"13":{"line":177,"type":"cond-expr","locations":[{"start":{"line":177,"column":23},"end":{"line":177,"column":25}},{"start":{"line":177,"column":29},"end":{"line":177,"column":42}}]},"14":{"line":177,"type":"cond-expr","locations":[{"start":{"line":177,"column":37},"end":{"line":177,"column":38}},{"start":{"line":177,"column":41},"end":{"line":177,"column":42}}]},"15":{"line":196,"type":"binary-expr","locations":[{"start":{"line":196,"column":25},"end":{"line":196,"column":46}},{"start":{"line":196,"column":50},"end":{"line":196,"column":69}}]},"16":{"line":199,"type":"cond-expr","locations":[{"start":{"line":199,"column":51},"end":{"line":199,"column":69}},{"start":{"line":199,"column":72},"end":{"line":199,"column":88}}]},"17":{"line":201,"type":"if","locations":[{"start":{"line":201,"column":8},"end":{"line":201,"column":8}},{"start":{"line":201,"column":8},"end":{"line":201,"column":8}}]},"18":{"line":210,"type":"if","locations":[{"start":{"line":210,"column":8},"end":{"line":210,"column":8}},{"start":{"line":210,"column":8},"end":{"line":210,"column":8}}]},"19":{"line":211,"type":"cond-expr","locations":[{"start":{"line":211,"column":29},"end":{"line":211,"column":30}},{"start":{"line":211,"column":33},"end":{"line":211,"column":36}}]},"20":{"line":214,"type":"cond-expr","locations":[{"start":{"line":214,"column":32},"end":{"line":214,"column":52}},{"start":{"line":214,"column":55},"end":{"line":214,"column":68}}]},"21":{"line":224,"type":"if","locations":[{"start":{"line":224,"column":12},"end":{"line":224,"column":12}},{"start":{"line":224,"column":12},"end":{"line":224,"column":12}}]},"22":{"line":247,"type":"cond-expr","locations":[{"start":{"line":247,"column":30},"end":{"line":247,"column":47}},{"start":{"line":247,"column":50},"end":{"line":247,"column":60}}]}},"code":["(function () { YUI.add('tree-sortable', function (Y, NAME) {","","/*jshint expr:true, onevar:false */","","/**","Extension for `Tree` that makes nodes sortable.","","@module tree","@submodule tree-sortable","@main tree-sortable","**/","","/**","Extension for `Tree` that makes nodes sortable.","","@class Tree.Sortable","@constructor","@param {Object} [config] Configuration options.","@param {Function} [config.sortComparator] Default comparator function to use","    when sorting a node's children if the node itself doesn't have a custom","    comparator function. If not specified, insertion order will be used by","    default.","@param {Boolean} [config.sortReverse=false] If `true`, node children will be","    sorted in reverse (descending) order by default. Otherwise they'll be sorted","    in ascending order.","@extensionfor Tree","**/","","/**","Fired after a node's children are re-sorted.","","@event sort","@param {Tree.Node} node Node whose children were sorted.","@param {Boolean} reverse `true` if the children were sorted in reverse","    (descending) order, `false` otherwise.","@param {String} src Source of the event.","**/","var EVT_SORT = 'sort';","","function Sortable() {}","","Sortable.prototype = {","    // -- Public Properties ----------------------------------------------------","","    /**","    If `true`, node children will be sorted in reverse (descending) order by","    default. Otherwise they'll be sorted in ascending order.","","    @property {Boolean} sortReverse","    @default false","    **/","    sortReverse: false,","","    // -- Lifecycle ------------------------------------------------------------","    initializer: function (config) {","        this.nodeExtensions = this.nodeExtensions.concat(Y.Tree.Node.Sortable);","","        if (config) {","            if (config.sortComparator) {","                this.sortComparator = config.sortComparator;","            }","","            if ('sortReverse' in config) {","                this.sortReverse = config.sortReverse;","            }","        }","    },","","    // -- Public Methods -------------------------------------------------------","","    /**","    Default comparator function to use when sorting a node's children if the","    node itself doesn't have a custom comparator function.","","    If not specified, insertion order will be used by default.","","    @method sortComparator","    @param {Tree.Node} node Node being sorted.","    @return {Number|String} Value by which the node should be sorted relative to","        its siblings.","    **/","    sortComparator: function (node) {","        return node.index();","    },","","    /**","    Sorts the children of the specified node.","","    @method sortNode","    @param {Tree.Node} node Node whose children should be sorted.","    @param {Object} [options] Options.","        @param {Boolean} [options.silent] If `true`, no `sort` event will be","            fired.","        @param {Function} [options.sortComparator] Custom comparator function to","            use. If specified, this will become the node's new comparator","            function, overwriting any previous comparator function that was set","            for the node.","        @param {Boolean} [options.sortReverse] If `true`, children will be","            sorted in reverse (descending) order. Otherwise they'll be sorted in","            ascending order. This will become the node's new sort order,","            overwriting any previous sort order that was set for the node.","        @param {String} [options.src] Source of the sort operation. Will be","            passed along to the `sort` event facade.","    @chainable","    **/","    sortNode: function (node, options) {","        // Nothing to do if the node has no children.","        if (!node.children.length) {","            return this;","        }","","        options || (options = {});","","        var comparator;","","        if (options.sortComparator) {","            comparator = node.sortComparator = options.sortComparator;","        } else {","            comparator = node.sortComparator || this.sortComparator;","        }","","        var reverse;","","        if ('sortReverse' in options) {","            reverse = node.sortReverse = options.sortReverse;","        } else if ('sortReverse' in node) {","            reverse = node.sortReverse;","        } else {","            reverse = this.sortReverse;","        }","","        node.children.sort(Y.rbind(this._sort, this, comparator, reverse));","","        if (!options.silent) {","            this.fire(EVT_SORT, {","                node   : node,","                reverse: !!reverse,","                src    : options.src","            });","        }","","        return this;","    },","","    // -- Protected Methods ----------------------------------------------------","","    /**","    Compares value _a_ to value _b_ for sorting purposes.","","    Values are assumed to be the result of calling a sortComparator function.","","    @method _compare","    @param {Mixed} a First value to compare.","    @param {Mixed} b Second value to compare.","    @return {Number} `-1` if _a_ should come before _b_, `0` if they're","        equivalent, `1` if _a_ should come after _b_.","    @protected","    **/","    _compare: function (a, b) {","        return a < b ? -1 : (a > b ? 1 : 0);","    },","","    /**","    Compares value _a_ to value _b_ for sorting purposes, but sorts them in","    reverse (descending) order.","","    Values are assumed to be the result of calling a sortComparator function.","","    @method _compareReverse","    @param {Mixed} a First value to compare.","    @param {Mixed} b Second value to compare.","    @return {Number} `-1` if _a_ should come before _b_, `0` if they're","        equivalent, `1` if _a_ should come after _b_.","    @protected","    **/","    _compareReverse: function (a, b) {","        return b < a ? -1 : (b > a ? 1 : 0);","    },","","    /**","    Overrides `Tree#_getDefaultNodeIndex()` to provide insertion-time sorting","    for nodes inserted without an explicit index.","","    @method _getDefaultNodeIndex","    @param {Tree.Node} parent Parent node.","    @param {Tree.Node} node Node being inserted.","    @param {Object} [options] Options passed to `insertNode()`.","    @return {Number} Index at which _node_ should be inserted into _parent_'s","        `children` array.","    @protected","    **/","    _getDefaultNodeIndex: function (parent, node) {","        /*jshint bitwise:false */","","        var children   = parent.children,","            comparator = parent.sortComparator || this.sortComparator,","            max        = children.length,","            min        = 0,","            reverse    = 'sortReverse' in parent ? parent.sortReverse : this.sortReverse;","","        if (!max) {","            return max;","        }","","        // Special case: if the sortComparator is the default sortComparator,","        // cheat and just return the first or last index of the children array.","        //","        // This is necessary because the default sortComparator relies on","        // the node's index, which is always -1 for uninserted nodes.","        if (comparator === Sortable.prototype.sortComparator) {","            return reverse ? 0 : max;","        }","","        var compare = reverse ? this._compareReverse : this._compare,","            needle  = comparator(node);","","        // Perform an iterative binary search to determine the correct position","        // for the node based on the return value of the comparator function.","        var middle;","","        while (min < max) {","            middle = (min + max) >> 1; // Divide by two and discard remainder.","","            if (compare(comparator(children[middle]), needle) < 0) {","                min = middle + 1;","            } else {","                max = middle;","            }","        }","","        return min;","    },","","    /**","    Array sort function used by `sortNode()` to re-sort a node's children.","","    @method _sort","    @param {Tree.Node} a First node to compare.","    @param {Tree.Node} b Second node to compare.","    @param {Function} comparator Comparator function.","    @param {Boolean} [reverse=false] If `true`, this will be a reverse","        (descending) comparison.","    @return {Number} `-1` if _a_ is less than _b_, `0` if equal, `1` if greater.","    @protected","    **/","    _sort: function (a, b, comparator, reverse) {","        return this[reverse ? '_compareReverse' : '_compare'](","            comparator(a), comparator(b));","    }","};","","Y.Tree.Sortable = Sortable;","/**","@module tree","@submodule tree-sortable","**/","","/**","`Tree.Node` extension that adds methods useful for nodes in trees that use the","`Tree.Sortable` extension.","","@class Tree.Node.Sortable","@constructor","@extensionfor Tree.Node","**/","","function NodeSortable() {}","","NodeSortable.prototype = {","    /**","    Sorts this node's children.","","    @method sort","    @param {Object} [options] Options.","        @param {Boolean} [options.silent] If `true`, no `sort` event will be","            fired.","        @param {Function} [options.sortComparator] Custom comparator function to","            use. If specified, this will become the node's new comparator","            function, overwriting any previous comparator function that was set","            for the node.","        @param {Boolean} [options.sortReverse] If `true`, children will be","            sorted in reverse (descending) order. Otherwise they'll be sorted in","            ascending order. This will become the node's new sort order,","            overwriting any previous sort order that was set for the node.","        @param {String} [options.src] Source of the sort operation. Will be","            passed along to the `sort` event facade.","    @chainable","    **/","    sort: function (options) {","        this.tree.sortNode(this, options);","        return this;","    }","};","","Y.Tree.Node.Sortable = NodeSortable;","","","}, '3.10.3', {\"requires\": [\"tree\"]});","","}());"]};
}
var __cov_fY8F3aSOoRZD9yhOq4F7Fw = __coverage__['build/tree-sortable/tree-sortable.js'];
__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['1']++;YUI.add('tree-sortable',function(Y,NAME){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['1']++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['2']++;var EVT_SORT='sort';__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['3']++;function Sortable(){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['2']++;}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['4']++;Sortable.prototype={sortReverse:false,initializer:function(config){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['3']++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['5']++;this.nodeExtensions=this.nodeExtensions.concat(Y.Tree.Node.Sortable);__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['6']++;if(config){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['1'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['7']++;if(config.sortComparator){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['2'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['8']++;this.sortComparator=config.sortComparator;}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['2'][1]++;}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['9']++;if('sortReverse'in config){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['3'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['10']++;this.sortReverse=config.sortReverse;}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['3'][1]++;}}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['1'][1]++;}},sortComparator:function(node){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['4']++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['11']++;return node.index();},sortNode:function(node,options){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['5']++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['12']++;if(!node.children.length){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['4'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['13']++;return this;}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['4'][1]++;}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['14']++;(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['5'][0]++,options)||(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['5'][1]++,options={});__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['15']++;var comparator;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['16']++;if(options.sortComparator){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['6'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['17']++;comparator=node.sortComparator=options.sortComparator;}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['6'][1]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['18']++;comparator=(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['7'][0]++,node.sortComparator)||(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['7'][1]++,this.sortComparator);}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['19']++;var reverse;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['20']++;if('sortReverse'in options){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['8'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['21']++;reverse=node.sortReverse=options.sortReverse;}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['8'][1]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['22']++;if('sortReverse'in node){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['9'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['23']++;reverse=node.sortReverse;}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['9'][1]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['24']++;reverse=this.sortReverse;}}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['25']++;node.children.sort(Y.rbind(this._sort,this,comparator,reverse));__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['26']++;if(!options.silent){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['10'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['27']++;this.fire(EVT_SORT,{node:node,reverse:!!reverse,src:options.src});}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['10'][1]++;}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['28']++;return this;},_compare:function(a,b){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['6']++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['29']++;return a<b?(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['11'][0]++,-1):(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['11'][1]++,a>b?(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['12'][0]++,1):(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['12'][1]++,0));},_compareReverse:function(a,b){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['7']++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['30']++;return b<a?(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['13'][0]++,-1):(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['13'][1]++,b>a?(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['14'][0]++,1):(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['14'][1]++,0));},_getDefaultNodeIndex:function(parent,node){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['8']++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['31']++;var children=parent.children,comparator=(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['15'][0]++,parent.sortComparator)||(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['15'][1]++,this.sortComparator),max=children.length,min=0,reverse='sortReverse'in parent?(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['16'][0]++,parent.sortReverse):(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['16'][1]++,this.sortReverse);__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['32']++;if(!max){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['17'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['33']++;return max;}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['17'][1]++;}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['34']++;if(comparator===Sortable.prototype.sortComparator){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['18'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['35']++;return reverse?(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['19'][0]++,0):(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['19'][1]++,max);}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['18'][1]++;}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['36']++;var compare=reverse?(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['20'][0]++,this._compareReverse):(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['20'][1]++,this._compare),needle=comparator(node);__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['37']++;var middle;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['38']++;while(min<max){__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['39']++;middle=min+max>>1;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['40']++;if(compare(comparator(children[middle]),needle)<0){__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['21'][0]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['41']++;min=middle+1;}else{__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['21'][1]++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['42']++;max=middle;}}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['43']++;return min;},_sort:function(a,b,comparator,reverse){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['9']++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['44']++;return this[reverse?(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['22'][0]++,'_compareReverse'):(__cov_fY8F3aSOoRZD9yhOq4F7Fw.b['22'][1]++,'_compare')](comparator(a),comparator(b));}};__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['45']++;Y.Tree.Sortable=Sortable;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['46']++;function NodeSortable(){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['10']++;}__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['47']++;NodeSortable.prototype={sort:function(options){__cov_fY8F3aSOoRZD9yhOq4F7Fw.f['11']++;__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['48']++;this.tree.sortNode(this,options);__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['49']++;return this;}};__cov_fY8F3aSOoRZD9yhOq4F7Fw.s['50']++;Y.Tree.Node.Sortable=NodeSortable;},'3.10.3',{'requires':['tree']});
