/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/axis-category/axis-category.js']) {
   __coverage__['build/axis-category/axis-category.js'] = {"path":"build/axis-category/axis-category.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":25},"end":{"line":1,"column":44}}},"2":{"name":"(anonymous_2)","line":27,"loc":{"start":{"line":27,"column":21},"end":{"line":28,"column":4}}},"3":{"name":"(anonymous_3)","line":41,"loc":{"start":{"line":41,"column":21},"end":{"line":42,"column":4}}},"4":{"name":"(anonymous_4)","line":58,"loc":{"start":{"line":58,"column":22},"end":{"line":59,"column":4}}},"5":{"name":"(anonymous_5)","line":81,"loc":{"start":{"line":81,"column":29},"end":{"line":82,"column":4}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":130,"column":59}},"2":{"start":{"line":19,"column":0},"end":{"line":126,"column":3}},"3":{"start":{"line":29,"column":8},"end":{"line":30,"column":28}},"4":{"start":{"line":31,"column":8},"end":{"line":31,"column":21}},"5":{"start":{"line":43,"column":8},"end":{"line":45,"column":30}},"6":{"start":{"line":46,"column":8},"end":{"line":46,"column":21}},"7":{"start":{"line":60,"column":8},"end":{"line":61,"column":36}},"8":{"start":{"line":62,"column":8},"end":{"line":62,"column":24}},"9":{"start":{"line":63,"column":8},"end":{"line":63,"column":21}},"10":{"start":{"line":83,"column":8},"end":{"line":95,"column":19}},"11":{"start":{"line":96,"column":8},"end":{"line":105,"column":9}},"12":{"start":{"line":98,"column":12},"end":{"line":98,"column":30}},"13":{"start":{"line":99,"column":12},"end":{"line":99,"column":31}},"14":{"start":{"line":103,"column":12},"end":{"line":103,"column":30}},"15":{"start":{"line":104,"column":12},"end":{"line":104,"column":31}},"16":{"start":{"line":106,"column":8},"end":{"line":106,"column":46}},"17":{"start":{"line":107,"column":8},"end":{"line":120,"column":9}},"18":{"start":{"line":109,"column":12},"end":{"line":109,"column":40}},"19":{"start":{"line":110,"column":12},"end":{"line":110,"column":59}},"20":{"start":{"line":111,"column":12},"end":{"line":119,"column":13}},"21":{"start":{"line":113,"column":16},"end":{"line":113,"column":68}},"22":{"start":{"line":114,"column":16},"end":{"line":114,"column":30}},"23":{"start":{"line":115,"column":16},"end":{"line":115,"column":52}},"24":{"start":{"line":116,"column":16},"end":{"line":116,"column":61}},"25":{"start":{"line":117,"column":16},"end":{"line":117,"column":38}},"26":{"start":{"line":118,"column":16},"end":{"line":118,"column":40}},"27":{"start":{"line":121,"column":8},"end":{"line":124,"column":10}}},"branchMap":{"1":{"line":96,"type":"if","locations":[{"start":{"line":96,"column":8},"end":{"line":96,"column":8}},{"start":{"line":96,"column":8},"end":{"line":96,"column":8}}]},"2":{"line":111,"type":"if","locations":[{"start":{"line":111,"column":12},"end":{"line":111,"column":12}},{"start":{"line":111,"column":12},"end":{"line":111,"column":12}}]},"3":{"line":111,"type":"binary-expr","locations":[{"start":{"line":111,"column":15},"end":{"line":111,"column":42}},{"start":{"line":111,"column":46},"end":{"line":111,"column":61}}]},"4":{"line":113,"type":"cond-expr","locations":[{"start":{"line":113,"column":39},"end":{"line":113,"column":62}},{"start":{"line":113,"column":66},"end":{"line":113,"column":67}}]}},"code":["(function () { YUI.add('axis-category', function (Y, NAME) {","","/**"," * Provides functionality for drawing a category axis for use with a chart."," *"," * @module charts"," * @submodule axis-category"," */","/**"," * CategoryAxis draws a category axis for a chart."," *"," * @class CategoryAxis"," * @constructor"," * @extends Axis"," * @uses CategoryImpl"," * @param {Object} config (optional) Configuration parameters."," * @submodule axis-category"," */","Y.CategoryAxis = Y.Base.create(\"categoryAxis\", Y.Axis, [Y.CategoryImpl], {","    /**","     * Returns a string corresponding to the first label on an","     * axis.","     *","     * @method getMinimumValue","     * @return String","     */","    getMinimumValue: function()","    {","        var data = this.get(\"data\"),","            label = data[0];","        return label;","    },","","    /**","     * Returns a string corresponding to the last label on an","     * axis.","     *","     * @method getMaximumValue","     * @return String","     */","    getMaximumValue: function()","    {","        var data = this.get(\"data\"),","            len = data.length - 1,","            label = data[len];","        return label;","    },","","    /**","     * Calculates and returns a value based on the number of labels and the index of","     * the current label.","     *","     * @method _getLabelByIndex","     * @param {Number} i Index of the label.","     * @return String","     * @private","     */","    _getLabelByIndex: function(i)","    {","        var label,","            data = this.get(\"data\");","        label = data[i];","        return label;","    },","","    /**","     * Calculates the position of ticks and labels based on an array of specified label values. Returns","     * an object containing an array of values to be used for labels and an array of objects containing","     * x and y coordinates for each label.","     *","     * @method _getDataFromLabelValues","     * @param {Object} startPoint An object containing the x and y coordinates for the start of the axis.","     * @param {Array} labelValues An array containing values to be used for determining the number and","     * position of labels and ticks on the axis.","     * @param {Number} edgeOffset The distance, in pixels, on either edge of the axis.","     * @param {Number} layoutLength The length, in pixels, of the axis. If the axis is vertical, the length","     * is equal to the height. If the axis is horizontal, the length is equal to the width.","     * @return Object","     * @private","     */","    _getDataFromLabelValues: function(startPoint, labelValues, edgeOffset, layoutLength, direction)","    {","        var points = [],","            values = [],","            labelValue,","            multiplier = (layoutLength - (edgeOffset * 2))/(this.getTotalMajorUnits() - 1),","            data = this.get(\"data\"),","            labelIndex,","            i,","            len = labelValues.length,","            staticCoord,","            dynamicCoord,","            constantVal,","            newPoint,","            rawVal;","        if(direction === \"vertical\")","        {","            staticCoord = \"x\";","            dynamicCoord = \"y\";","        }","        else","        {","            staticCoord = \"y\";","            dynamicCoord = \"x\";","        }","        constantVal = startPoint[staticCoord];","        for(i = 0; i < len; i = i + 1)","        {","            labelValue = labelValues[i];","            labelIndex = Y.Array.indexOf(data, labelValue);","            if(Y.Lang.isNumber(labelIndex) && labelIndex > -1)","            {","                rawVal = labelIndex ? (labelIndex * multiplier) : 0;","                newPoint = {};","                newPoint[staticCoord] = constantVal;","                newPoint[dynamicCoord] = rawVal + edgeOffset;","                points.push(newPoint);","                values.push(labelValue);","            }","        }","        return {","            points: points,","            values: values","        };","    }","});","","","","}, '3.10.3', {\"requires\": [\"axis\", \"axis-category-base\"]});","","}());"]};
}
var __cov_5I7GX8nuMNZAAeOsedEb6g = __coverage__['build/axis-category/axis-category.js'];
__cov_5I7GX8nuMNZAAeOsedEb6g.s['1']++;YUI.add('axis-category',function(Y,NAME){__cov_5I7GX8nuMNZAAeOsedEb6g.f['1']++;__cov_5I7GX8nuMNZAAeOsedEb6g.s['2']++;Y.CategoryAxis=Y.Base.create('categoryAxis',Y.Axis,[Y.CategoryImpl],{getMinimumValue:function(){__cov_5I7GX8nuMNZAAeOsedEb6g.f['2']++;__cov_5I7GX8nuMNZAAeOsedEb6g.s['3']++;var data=this.get('data'),label=data[0];__cov_5I7GX8nuMNZAAeOsedEb6g.s['4']++;return label;},getMaximumValue:function(){__cov_5I7GX8nuMNZAAeOsedEb6g.f['3']++;__cov_5I7GX8nuMNZAAeOsedEb6g.s['5']++;var data=this.get('data'),len=data.length-1,label=data[len];__cov_5I7GX8nuMNZAAeOsedEb6g.s['6']++;return label;},_getLabelByIndex:function(i){__cov_5I7GX8nuMNZAAeOsedEb6g.f['4']++;__cov_5I7GX8nuMNZAAeOsedEb6g.s['7']++;var label,data=this.get('data');__cov_5I7GX8nuMNZAAeOsedEb6g.s['8']++;label=data[i];__cov_5I7GX8nuMNZAAeOsedEb6g.s['9']++;return label;},_getDataFromLabelValues:function(startPoint,labelValues,edgeOffset,layoutLength,direction){__cov_5I7GX8nuMNZAAeOsedEb6g.f['5']++;__cov_5I7GX8nuMNZAAeOsedEb6g.s['10']++;var points=[],values=[],labelValue,multiplier=(layoutLength-edgeOffset*2)/(this.getTotalMajorUnits()-1),data=this.get('data'),labelIndex,i,len=labelValues.length,staticCoord,dynamicCoord,constantVal,newPoint,rawVal;__cov_5I7GX8nuMNZAAeOsedEb6g.s['11']++;if(direction==='vertical'){__cov_5I7GX8nuMNZAAeOsedEb6g.b['1'][0]++;__cov_5I7GX8nuMNZAAeOsedEb6g.s['12']++;staticCoord='x';__cov_5I7GX8nuMNZAAeOsedEb6g.s['13']++;dynamicCoord='y';}else{__cov_5I7GX8nuMNZAAeOsedEb6g.b['1'][1]++;__cov_5I7GX8nuMNZAAeOsedEb6g.s['14']++;staticCoord='y';__cov_5I7GX8nuMNZAAeOsedEb6g.s['15']++;dynamicCoord='x';}__cov_5I7GX8nuMNZAAeOsedEb6g.s['16']++;constantVal=startPoint[staticCoord];__cov_5I7GX8nuMNZAAeOsedEb6g.s['17']++;for(i=0;i<len;i=i+1){__cov_5I7GX8nuMNZAAeOsedEb6g.s['18']++;labelValue=labelValues[i];__cov_5I7GX8nuMNZAAeOsedEb6g.s['19']++;labelIndex=Y.Array.indexOf(data,labelValue);__cov_5I7GX8nuMNZAAeOsedEb6g.s['20']++;if((__cov_5I7GX8nuMNZAAeOsedEb6g.b['3'][0]++,Y.Lang.isNumber(labelIndex))&&(__cov_5I7GX8nuMNZAAeOsedEb6g.b['3'][1]++,labelIndex>-1)){__cov_5I7GX8nuMNZAAeOsedEb6g.b['2'][0]++;__cov_5I7GX8nuMNZAAeOsedEb6g.s['21']++;rawVal=labelIndex?(__cov_5I7GX8nuMNZAAeOsedEb6g.b['4'][0]++,labelIndex*multiplier):(__cov_5I7GX8nuMNZAAeOsedEb6g.b['4'][1]++,0);__cov_5I7GX8nuMNZAAeOsedEb6g.s['22']++;newPoint={};__cov_5I7GX8nuMNZAAeOsedEb6g.s['23']++;newPoint[staticCoord]=constantVal;__cov_5I7GX8nuMNZAAeOsedEb6g.s['24']++;newPoint[dynamicCoord]=rawVal+edgeOffset;__cov_5I7GX8nuMNZAAeOsedEb6g.s['25']++;points.push(newPoint);__cov_5I7GX8nuMNZAAeOsedEb6g.s['26']++;values.push(labelValue);}else{__cov_5I7GX8nuMNZAAeOsedEb6g.b['2'][1]++;}}__cov_5I7GX8nuMNZAAeOsedEb6g.s['27']++;return{points:points,values:values};}});},'3.10.3',{'requires':['axis','axis-category-base']});
