/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/attribute-extras/attribute-extras.js']) {
   __coverage__['build/attribute-extras/attribute-extras.js'] = {"path":"build/attribute-extras/attribute-extras.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":28},"end":{"line":1,"column":47}}},"2":{"name":"AttributeExtras","line":38,"loc":{"start":{"line":38,"column":4},"end":{"line":38,"column":31}}},"3":{"name":"(anonymous_3)","line":54,"loc":{"start":{"line":54,"column":20},"end":{"line":54,"column":43}}},"4":{"name":"(anonymous_4)","line":86,"loc":{"start":{"line":86,"column":20},"end":{"line":86,"column":35}}},"5":{"name":"(anonymous_5)","line":99,"loc":{"start":{"line":99,"column":16},"end":{"line":99,"column":31}}},"6":{"name":"(anonymous_6)","line":108,"loc":{"start":{"line":108,"column":41},"end":{"line":108,"column":56}}},"7":{"name":"(anonymous_7)","line":125,"loc":{"start":{"line":125,"column":22},"end":{"line":125,"column":37}}},"8":{"name":"(anonymous_8)","line":133,"loc":{"start":{"line":133,"column":35},"end":{"line":133,"column":50}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":145,"column":36}},"2":{"start":{"line":20,"column":4},"end":{"line":29,"column":10}},"3":{"start":{"line":38,"column":4},"end":{"line":38,"column":33}},"4":{"start":{"line":40,"column":4},"end":{"line":140,"column":6}},"5":{"start":{"line":55,"column":12},"end":{"line":56,"column":28}},"6":{"start":{"line":58,"column":12},"end":{"line":75,"column":13}},"7":{"start":{"line":60,"column":16},"end":{"line":62,"column":17}},"8":{"start":{"line":61,"column":20},"end":{"line":61,"column":44}},"9":{"start":{"line":64,"column":16},"end":{"line":64,"column":36}},"10":{"start":{"line":65,"column":16},"end":{"line":74,"column":17}},"11":{"start":{"line":66,"column":20},"end":{"line":73,"column":21}},"12":{"start":{"line":67,"column":24},"end":{"line":67,"column":60}},"13":{"start":{"line":70,"column":24},"end":{"line":72,"column":25}},"14":{"start":{"line":71,"column":28},"end":{"line":71,"column":58}},"15":{"start":{"line":87,"column":12},"end":{"line":87,"column":40}},"16":{"start":{"line":100,"column":12},"end":{"line":100,"column":28}},"17":{"start":{"line":102,"column":12},"end":{"line":111,"column":13}},"18":{"start":{"line":103,"column":16},"end":{"line":105,"column":17}},"19":{"start":{"line":104,"column":20},"end":{"line":104,"column":44}},"20":{"start":{"line":106,"column":16},"end":{"line":106,"column":66}},"21":{"start":{"line":108,"column":16},"end":{"line":110,"column":19}},"22":{"start":{"line":109,"column":20},"end":{"line":109,"column":34}},"23":{"start":{"line":112,"column":12},"end":{"line":112,"column":24}},"24":{"start":{"line":126,"column":12},"end":{"line":127,"column":36}},"25":{"start":{"line":129,"column":12},"end":{"line":136,"column":13}},"26":{"start":{"line":130,"column":16},"end":{"line":130,"column":45}},"27":{"start":{"line":132,"column":16},"end":{"line":132,"column":23}},"28":{"start":{"line":133,"column":16},"end":{"line":135,"column":19}},"29":{"start":{"line":134,"column":20},"end":{"line":134,"column":43}},"30":{"start":{"line":138,"column":12},"end":{"line":138,"column":21}},"31":{"start":{"line":142,"column":4},"end":{"line":142,"column":40}}},"branchMap":{"1":{"line":58,"type":"if","locations":[{"start":{"line":58,"column":12},"end":{"line":58,"column":12}},{"start":{"line":58,"column":12},"end":{"line":58,"column":12}}]},"2":{"line":60,"type":"if","locations":[{"start":{"line":60,"column":16},"end":{"line":60,"column":16}},{"start":{"line":60,"column":16},"end":{"line":60,"column":16}}]},"3":{"line":66,"type":"if","locations":[{"start":{"line":66,"column":20},"end":{"line":66,"column":20}},{"start":{"line":66,"column":20},"end":{"line":66,"column":20}}]},"4":{"line":66,"type":"binary-expr","locations":[{"start":{"line":66,"column":24},"end":{"line":66,"column":40}},{"start":{"line":66,"column":44},"end":{"line":66,"column":71}}]},"5":{"line":70,"type":"if","locations":[{"start":{"line":70,"column":24},"end":{"line":70,"column":24}},{"start":{"line":70,"column":24},"end":{"line":70,"column":24}}]},"6":{"line":102,"type":"if","locations":[{"start":{"line":102,"column":12},"end":{"line":102,"column":12}},{"start":{"line":102,"column":12},"end":{"line":102,"column":12}}]},"7":{"line":103,"type":"if","locations":[{"start":{"line":103,"column":16},"end":{"line":103,"column":16}},{"start":{"line":103,"column":16},"end":{"line":103,"column":16}}]},"8":{"line":129,"type":"if","locations":[{"start":{"line":129,"column":12},"end":{"line":129,"column":12}},{"start":{"line":129,"column":12},"end":{"line":129,"column":12}}]},"9":{"line":130,"type":"binary-expr","locations":[{"start":{"line":130,"column":20},"end":{"line":130,"column":38}},{"start":{"line":130,"column":42},"end":{"line":130,"column":44}}]}},"code":["(function () { YUI.add('attribute-extras', function (Y, NAME) {","","    /**","     * The attribute module provides an augmentable Attribute implementation, which","     * adds configurable attributes and attribute change events to the class being","     * augmented. It also provides a State class, which is used internally by Attribute,","     * but can also be used independently to provide a name/property/value data structure to","     * store state.","     *","     * @module attribute","     */","","    /**","     * The attribute-extras submodule provides less commonly used attribute methods, and can","     * be augmented/mixed into an implemention which used attribute-core.","     *","     * @module attribute","     * @submodule attribute-extras","     */","    var BROADCAST = \"broadcast\",","        PUBLISHED = \"published\",","        INIT_VALUE = \"initValue\",","","        MODIFIABLE = {","            readOnly:1,","            writeOnce:1,","            getter:1,","            broadcast:1","        };","","    /**","     * A augmentable implementation for AttributeCore, providing less frequently used","     * methods for Attribute management such as modifyAttrs(), removeAttr and reset()","     *","     * @class AttributeExtras","     * @extensionfor AttributeCore","     */","    function AttributeExtras() {}","","    AttributeExtras.prototype = {","","        /**","         * Updates the configuration of an attribute which has already been added.","         * <p>","         * The properties which can be modified through this interface are limited","         * to the following subset of attributes, which can be safely modified","         * after a value has already been set on the attribute: readOnly, writeOnce,","         * broadcast and getter.","         * </p>","         * @method modifyAttr","         * @param {String} name The name of the attribute whose configuration is to be updated.","         * @param {Object} config An object with configuration property/value pairs, specifying the configuration properties to modify.","         */","        modifyAttr: function(name, config) {","            var host = this, // help compression","                prop, state;","","            if (host.attrAdded(name)) {","","                if (host._isLazyAttr(name)) {","                    host._addLazyAttr(name);","                }","","                state = host._state;","                for (prop in config) {","                    if (MODIFIABLE[prop] && config.hasOwnProperty(prop)) {","                        state.add(name, prop, config[prop]);","","                        // If we reconfigured broadcast, need to republish","                        if (prop === BROADCAST) {","                            state.remove(name, PUBLISHED);","                        }","                    }","                }","            }","            /*jshint maxlen:200*/","            /*jshint maxlen:150 */","        },","","        /**","         * Removes an attribute from the host object","         *","         * @method removeAttr","         * @param {String} name The name of the attribute to be removed.","         */","        removeAttr: function(name) {","            this._state.removeAll(name);","        },","","        /**","         * Resets the attribute (or all attributes) to its initial value, as long as","         * the attribute is not readOnly, or writeOnce.","         *","         * @method reset","         * @param {String} name Optional. The name of the attribute to reset.  If omitted, all attributes are reset.","         * @return {Object} A reference to the host object.","         * @chainable","         */","        reset : function(name) {","            var host = this;  // help compression","","            if (name) {","                if (host._isLazyAttr(name)) {","                    host._addLazyAttr(name);","                }","                host.set(name, host._state.get(name, INIT_VALUE));","            } else {","                Y.each(host._state.data, function(v, n) {","                    host.reset(n);","                });","            }","            return host;","        },","","        /**","         * Returns an object with the configuration properties (and value)","         * for the given attribute. If attrName is not provided, returns the","         * configuration properties for all attributes.","         *","         * @method _getAttrCfg","         * @protected","         * @param {String} name Optional. The attribute name. If not provided, the method will return the configuration for all attributes.","         * @return {Object} The configuration properties for the given attribute, or all attributes.","         */","        _getAttrCfg : function(name) {","            var o,","                state = this._state;","","            if (name) {","                o = state.getAll(name) || {};","            } else {","                o = {};","                Y.each(state.data, function(v, n) {","                    o[n] = state.getAll(n);","                });","            }","","            return o;","        }","    };","","    Y.AttributeExtras = AttributeExtras;","","","}, '3.10.3', {\"requires\": [\"oop\"]});","","}());"]};
}
var __cov_cQW7zljOhw00PGaOS2Wxww = __coverage__['build/attribute-extras/attribute-extras.js'];
__cov_cQW7zljOhw00PGaOS2Wxww.s['1']++;YUI.add('attribute-extras',function(Y,NAME){__cov_cQW7zljOhw00PGaOS2Wxww.f['1']++;__cov_cQW7zljOhw00PGaOS2Wxww.s['2']++;var BROADCAST='broadcast',PUBLISHED='published',INIT_VALUE='initValue',MODIFIABLE={readOnly:1,writeOnce:1,getter:1,broadcast:1};__cov_cQW7zljOhw00PGaOS2Wxww.s['3']++;function AttributeExtras(){__cov_cQW7zljOhw00PGaOS2Wxww.f['2']++;}__cov_cQW7zljOhw00PGaOS2Wxww.s['4']++;AttributeExtras.prototype={modifyAttr:function(name,config){__cov_cQW7zljOhw00PGaOS2Wxww.f['3']++;__cov_cQW7zljOhw00PGaOS2Wxww.s['5']++;var host=this,prop,state;__cov_cQW7zljOhw00PGaOS2Wxww.s['6']++;if(host.attrAdded(name)){__cov_cQW7zljOhw00PGaOS2Wxww.b['1'][0]++;__cov_cQW7zljOhw00PGaOS2Wxww.s['7']++;if(host._isLazyAttr(name)){__cov_cQW7zljOhw00PGaOS2Wxww.b['2'][0]++;__cov_cQW7zljOhw00PGaOS2Wxww.s['8']++;host._addLazyAttr(name);}else{__cov_cQW7zljOhw00PGaOS2Wxww.b['2'][1]++;}__cov_cQW7zljOhw00PGaOS2Wxww.s['9']++;state=host._state;__cov_cQW7zljOhw00PGaOS2Wxww.s['10']++;for(prop in config){__cov_cQW7zljOhw00PGaOS2Wxww.s['11']++;if((__cov_cQW7zljOhw00PGaOS2Wxww.b['4'][0]++,MODIFIABLE[prop])&&(__cov_cQW7zljOhw00PGaOS2Wxww.b['4'][1]++,config.hasOwnProperty(prop))){__cov_cQW7zljOhw00PGaOS2Wxww.b['3'][0]++;__cov_cQW7zljOhw00PGaOS2Wxww.s['12']++;state.add(name,prop,config[prop]);__cov_cQW7zljOhw00PGaOS2Wxww.s['13']++;if(prop===BROADCAST){__cov_cQW7zljOhw00PGaOS2Wxww.b['5'][0]++;__cov_cQW7zljOhw00PGaOS2Wxww.s['14']++;state.remove(name,PUBLISHED);}else{__cov_cQW7zljOhw00PGaOS2Wxww.b['5'][1]++;}}else{__cov_cQW7zljOhw00PGaOS2Wxww.b['3'][1]++;}}}else{__cov_cQW7zljOhw00PGaOS2Wxww.b['1'][1]++;}},removeAttr:function(name){__cov_cQW7zljOhw00PGaOS2Wxww.f['4']++;__cov_cQW7zljOhw00PGaOS2Wxww.s['15']++;this._state.removeAll(name);},reset:function(name){__cov_cQW7zljOhw00PGaOS2Wxww.f['5']++;__cov_cQW7zljOhw00PGaOS2Wxww.s['16']++;var host=this;__cov_cQW7zljOhw00PGaOS2Wxww.s['17']++;if(name){__cov_cQW7zljOhw00PGaOS2Wxww.b['6'][0]++;__cov_cQW7zljOhw00PGaOS2Wxww.s['18']++;if(host._isLazyAttr(name)){__cov_cQW7zljOhw00PGaOS2Wxww.b['7'][0]++;__cov_cQW7zljOhw00PGaOS2Wxww.s['19']++;host._addLazyAttr(name);}else{__cov_cQW7zljOhw00PGaOS2Wxww.b['7'][1]++;}__cov_cQW7zljOhw00PGaOS2Wxww.s['20']++;host.set(name,host._state.get(name,INIT_VALUE));}else{__cov_cQW7zljOhw00PGaOS2Wxww.b['6'][1]++;__cov_cQW7zljOhw00PGaOS2Wxww.s['21']++;Y.each(host._state.data,function(v,n){__cov_cQW7zljOhw00PGaOS2Wxww.f['6']++;__cov_cQW7zljOhw00PGaOS2Wxww.s['22']++;host.reset(n);});}__cov_cQW7zljOhw00PGaOS2Wxww.s['23']++;return host;},_getAttrCfg:function(name){__cov_cQW7zljOhw00PGaOS2Wxww.f['7']++;__cov_cQW7zljOhw00PGaOS2Wxww.s['24']++;var o,state=this._state;__cov_cQW7zljOhw00PGaOS2Wxww.s['25']++;if(name){__cov_cQW7zljOhw00PGaOS2Wxww.b['8'][0]++;__cov_cQW7zljOhw00PGaOS2Wxww.s['26']++;o=(__cov_cQW7zljOhw00PGaOS2Wxww.b['9'][0]++,state.getAll(name))||(__cov_cQW7zljOhw00PGaOS2Wxww.b['9'][1]++,{});}else{__cov_cQW7zljOhw00PGaOS2Wxww.b['8'][1]++;__cov_cQW7zljOhw00PGaOS2Wxww.s['27']++;o={};__cov_cQW7zljOhw00PGaOS2Wxww.s['28']++;Y.each(state.data,function(v,n){__cov_cQW7zljOhw00PGaOS2Wxww.f['8']++;__cov_cQW7zljOhw00PGaOS2Wxww.s['29']++;o[n]=state.getAll(n);});}__cov_cQW7zljOhw00PGaOS2Wxww.s['30']++;return o;}};__cov_cQW7zljOhw00PGaOS2Wxww.s['31']++;Y.AttributeExtras=AttributeExtras;},'3.10.3',{'requires':['oop']});
