/*
YUI 3.10.3 (build 2fb5187)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/button-core/button-core.js']) {
   __coverage__['build/button-core/button-core.js'] = {"path":"build/button-core/button-core.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0]},"f":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":23},"end":{"line":1,"column":42}}},"2":{"name":"ButtonCore","line":19,"loc":{"start":{"line":19,"column":0},"end":{"line":19,"column":28}}},"3":{"name":"(anonymous_3)","line":48,"loc":{"start":{"line":48,"column":17},"end":{"line":48,"column":34}}},"4":{"name":"(anonymous_4)","line":60,"loc":{"start":{"line":60,"column":15},"end":{"line":60,"column":32}}},"5":{"name":"(anonymous_5)","line":74,"loc":{"start":{"line":74,"column":21},"end":{"line":74,"column":38}}},"6":{"name":"(anonymous_6)","line":88,"loc":{"start":{"line":88,"column":15},"end":{"line":88,"column":26}}},"7":{"name":"(anonymous_7)","line":105,"loc":{"start":{"line":105,"column":12},"end":{"line":105,"column":23}}},"8":{"name":"(anonymous_8)","line":114,"loc":{"start":{"line":114,"column":13},"end":{"line":114,"column":24}}},"9":{"name":"(anonymous_9)","line":123,"loc":{"start":{"line":123,"column":13},"end":{"line":123,"column":24}}},"10":{"name":"(anonymous_10)","line":132,"loc":{"start":{"line":132,"column":15},"end":{"line":132,"column":27}}},"11":{"name":"(anonymous_11)","line":153,"loc":{"start":{"line":153,"column":17},"end":{"line":153,"column":34}}},"12":{"name":"(anonymous_12)","line":172,"loc":{"start":{"line":172,"column":20},"end":{"line":172,"column":36}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":274,"column":80}},"2":{"start":{"line":9,"column":0},"end":{"line":9,"column":51}},"3":{"start":{"line":19,"column":0},"end":{"line":21,"column":1}},"4":{"start":{"line":20,"column":4},"end":{"line":20,"column":29}},"5":{"start":{"line":23,"column":0},"end":{"line":180,"column":2}},"6":{"start":{"line":49,"column":8},"end":{"line":49,"column":31}},"7":{"start":{"line":50,"column":8},"end":{"line":50,"column":37}},"8":{"start":{"line":51,"column":8},"end":{"line":51,"column":31}},"9":{"start":{"line":61,"column":8},"end":{"line":65,"column":9}},"10":{"start":{"line":62,"column":12},"end":{"line":62,"column":44}},"11":{"start":{"line":64,"column":12},"end":{"line":64,"column":54}},"12":{"start":{"line":75,"column":8},"end":{"line":76,"column":72}},"13":{"start":{"line":78,"column":8},"end":{"line":78,"column":60}},"14":{"start":{"line":79,"column":8},"end":{"line":79,"column":61}},"15":{"start":{"line":89,"column":8},"end":{"line":90,"column":56}},"16":{"start":{"line":93,"column":8},"end":{"line":93,"column":53}},"17":{"start":{"line":95,"column":8},"end":{"line":97,"column":9}},"18":{"start":{"line":96,"column":12},"end":{"line":96,"column":39}},"19":{"start":{"line":106,"column":8},"end":{"line":106,"column":36}},"20":{"start":{"line":115,"column":8},"end":{"line":115,"column":35}},"21":{"start":{"line":124,"column":8},"end":{"line":124,"column":26}},"22":{"start":{"line":133,"column":8},"end":{"line":135,"column":18}},"23":{"start":{"line":137,"column":8},"end":{"line":142,"column":9}},"24":{"start":{"line":138,"column":12},"end":{"line":138,"column":38}},"25":{"start":{"line":141,"column":12},"end":{"line":141,"column":87}},"26":{"start":{"line":144,"column":8},"end":{"line":144,"column":21}},"27":{"start":{"line":154,"column":8},"end":{"line":155,"column":56}},"28":{"start":{"line":157,"column":8},"end":{"line":161,"column":9}},"29":{"start":{"line":158,"column":12},"end":{"line":158,"column":37}},"30":{"start":{"line":160,"column":12},"end":{"line":160,"column":86}},"31":{"start":{"line":163,"column":8},"end":{"line":163,"column":21}},"32":{"start":{"line":173,"column":8},"end":{"line":173,"column":34}},"33":{"start":{"line":175,"column":8},"end":{"line":175,"column":43}},"34":{"start":{"line":176,"column":8},"end":{"line":176,"column":65}},"35":{"start":{"line":178,"column":8},"end":{"line":178,"column":21}},"36":{"start":{"line":183,"column":0},"end":{"line":183,"column":55}},"37":{"start":{"line":193,"column":0},"end":{"line":218,"column":2}},"38":{"start":{"line":227,"column":0},"end":{"line":227,"column":27}},"39":{"start":{"line":237,"column":0},"end":{"line":242,"column":2}},"40":{"start":{"line":252,"column":0},"end":{"line":255,"column":2}},"41":{"start":{"line":265,"column":0},"end":{"line":269,"column":2}},"42":{"start":{"line":272,"column":0},"end":{"line":272,"column":26}}},"branchMap":{"1":{"line":61,"type":"if","locations":[{"start":{"line":61,"column":8},"end":{"line":61,"column":8}},{"start":{"line":61,"column":8},"end":{"line":61,"column":8}}]},"2":{"line":76,"type":"binary-expr","locations":[{"start":{"line":76,"column":19},"end":{"line":76,"column":63}},{"start":{"line":76,"column":67},"end":{"line":76,"column":71}}]},"3":{"line":78,"type":"binary-expr","locations":[{"start":{"line":78,"column":23},"end":{"line":78,"column":35}},{"start":{"line":78,"column":39},"end":{"line":78,"column":59}}]},"4":{"line":95,"type":"if","locations":[{"start":{"line":95,"column":8},"end":{"line":95,"column":8}},{"start":{"line":95,"column":8},"end":{"line":95,"column":8}}]},"5":{"line":95,"type":"binary-expr","locations":[{"start":{"line":95,"column":12},"end":{"line":95,"column":32}},{"start":{"line":95,"column":36},"end":{"line":95,"column":55}}]},"6":{"line":137,"type":"if","locations":[{"start":{"line":137,"column":8},"end":{"line":137,"column":8}},{"start":{"line":137,"column":8},"end":{"line":137,"column":8}}]},"7":{"line":141,"type":"binary-expr","locations":[{"start":{"line":141,"column":21},"end":{"line":141,"column":65}},{"start":{"line":141,"column":69},"end":{"line":141,"column":73}}]},"8":{"line":157,"type":"if","locations":[{"start":{"line":157,"column":8},"end":{"line":157,"column":8}},{"start":{"line":157,"column":8},"end":{"line":157,"column":8}}]},"9":{"line":160,"type":"binary-expr","locations":[{"start":{"line":160,"column":13},"end":{"line":160,"column":57}},{"start":{"line":160,"column":61},"end":{"line":160,"column":65}}]}},"code":["(function () { YUI.add('button-core', function (Y, NAME) {","","/**"," * Provides an interface for working with button-like DOM nodes"," *"," * @module button-core"," * @since 3.5.0"," */","var getClassName = Y.ClassNameManager.getClassName;","","/**"," * Creates a button"," *"," * @class ButtonCore"," * @uses AttributeCore"," * @param config {Object} Configuration object"," * @constructor"," */","function ButtonCore(config) {","    this.initializer(config);","}","","ButtonCore.prototype = {","","    /**","     *","     * @property TEMPLATE","     * @type {String}","     * @default <button/>","     */","    TEMPLATE: '<button/>',","","    /**","     *","     * @property constructor","     * @type {Object}","     * @default ButtonCore","     * @private","     */","    constructor: ButtonCore,","","    /**","     * @method initializer","     * @description Internal init() handler.","     * @param config {Object} Config object.","     * @private","     */","    initializer: function(config) {","        this._initNode(config);","        this._initAttributes(config);","        this._renderUI(config);","    },","","    /**","     * @method _initNode","     * @description Node initializer","     * @param config {Object} Config object.","     * @private","     */","    _initNode: function(config) {","        if (config.host) {","            this._host = Y.one(config.host);","        } else {","            this._host = Y.Node.create(this.TEMPLATE);","        }","    },","","    /**","     * @method _initAttributes","     * @description  Attribute initializer","     * @param config {Object} Config object.","     * @private","     */","    _initAttributes: function(config) {","        var host = this._host,","            node = host.one('.' + ButtonCore.CLASS_NAMES.LABEL) || host;","            ","        config.label = config.label || this._getLabel(node);","        Y.AttributeCore.call(this, ButtonCore.ATTRS, config);","    },","","    /**","     * @method renderUI","     * @description Renders any UI/DOM elements for Button instances","     * @param config {Object} Config object.","     * @private","     */","    _renderUI: function() {","        var node = this.getNode(),","            tagName = node.get('tagName').toLowerCase();","","        // Set some default node attributes","        node.addClass(ButtonCore.CLASS_NAMES.BUTTON);","        ","        if (tagName !== 'button' && tagName !== 'input') {","            node.set('role', 'button');","        }","    },","","    /**","     * @method enable","     * @description Sets the button's `disabled` DOM attribute to false","     * @public","     */","    enable: function() {","        this.set('disabled', false);","    },","","    /**","     * @method disable","     * @description Sets the button's `disabled` DOM attribute to true","     * @public","     */","    disable: function() {","        this.set('disabled', true);","    },","","    /**","     * @method getNode","     * @description Gets the host DOM node for this button instance","     * @public","     */","    getNode: function() {","        return this._host;","    },","    ","    /**","     * @method _getLabel","     * @description Getter for a button's 'label' ATTR","     * @private","     */","    _getLabel: function () {","        var node    = this.getNode(),","            tagName = node.get('tagName').toLowerCase(),","            label;","","        if (tagName === 'input') {","            label = node.get('value');","        }","        else {","            label = (node.one('.' + ButtonCore.CLASS_NAMES.LABEL) || node).get('text');","        }","        ","        return label;","    },","    ","    /**","     * @method _uiSetLabel","     * @description Setter for a button's 'label' ATTR","     * @param label {string}","     * @private","     */","    _uiSetLabel: function (label) {","        var node    = this.getNode(),","            tagName = node.get('tagName').toLowerCase();","","        if (tagName === 'input') {","            node.set('value', label);","        } else {","            (node.one('.' + ButtonCore.CLASS_NAMES.LABEL) || node).set('text', label);","        }","","        return label;","    },","","    /**","     * @method _uiSetDisabled","     * @description Setter for the 'disabled' ATTR","     * @param value {boolean}","     * @private","     */","    _uiSetDisabled: function(value) {","        var node = this.getNode();","        ","        node.getDOMNode().disabled = value; // avoid rerunning setter when this === node","        node.toggleClass(ButtonCore.CLASS_NAMES.DISABLED, value);","        ","        return value;","    }","};","","","Y.mix(ButtonCore.prototype, Y.AttributeCore.prototype);","","/**"," * Attribute configuration."," *"," * @property ATTRS"," * @type {Object}"," * @protected"," * @static"," */","ButtonCore.ATTRS = {","","    /**","     * The text of the button (the `value` or `text` property)","     *","     * @attribute label","     * @type String","     */","    label: {","        setter: '_uiSetLabel',","        getter: '_getLabel',","        lazyAdd: false","    },","","    /**","     * The button's enabled/disabled state","     *","     * @attribute disabled","     * @type Boolean","     */","    disabled: {","        value: false,","        setter: '_uiSetDisabled',","        lazyAdd: false","    }","};","","/**"," * Name of this component."," *"," * @property NAME"," * @type String"," * @static"," */","ButtonCore.NAME = \"button\";","","/**"," * Array of static constants used to identify the classnames applied to DOM nodes"," *"," * @property CLASS_NAMES"," * @type {Object}"," * @public"," * @static"," */","ButtonCore.CLASS_NAMES = {","    BUTTON  : getClassName('button'),","    DISABLED: getClassName('button', 'disabled'),","    SELECTED: getClassName('button', 'selected'),","    LABEL   : getClassName('button', 'label')","};","","/**"," * Array of static constants used to for applying ARIA states"," *"," * @property CLASS_NAMES"," * @type {Object}"," * @private"," * @static"," */","ButtonCore.ARIA_STATES = {","    PRESSED : 'aria-pressed',","    CHECKED : 'aria-checked'","};","","/**"," * Array of static constants used to for applying ARIA roles"," *"," * @property CLASS_NAMES"," * @type {Object}"," * @private"," * @static"," */","ButtonCore.ARIA_ROLES = {","    BUTTON  : 'button',","    CHECKBOX: 'checkbox',","    TOGGLE  : 'toggle'","};","","// Export Button","Y.ButtonCore = ButtonCore;","","}, '3.10.3', {\"requires\": [\"attribute-core\", \"classnamemanager\", \"node-base\"]});","","}());"]};
}
var __cov_oaiXFrFXvCNKuifOTFqz5A = __coverage__['build/button-core/button-core.js'];
__cov_oaiXFrFXvCNKuifOTFqz5A.s['1']++;YUI.add('button-core',function(Y,NAME){__cov_oaiXFrFXvCNKuifOTFqz5A.f['1']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['2']++;var getClassName=Y.ClassNameManager.getClassName;__cov_oaiXFrFXvCNKuifOTFqz5A.s['3']++;function ButtonCore(config){__cov_oaiXFrFXvCNKuifOTFqz5A.f['2']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['4']++;this.initializer(config);}__cov_oaiXFrFXvCNKuifOTFqz5A.s['5']++;ButtonCore.prototype={TEMPLATE:'<button/>',constructor:ButtonCore,initializer:function(config){__cov_oaiXFrFXvCNKuifOTFqz5A.f['3']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['6']++;this._initNode(config);__cov_oaiXFrFXvCNKuifOTFqz5A.s['7']++;this._initAttributes(config);__cov_oaiXFrFXvCNKuifOTFqz5A.s['8']++;this._renderUI(config);},_initNode:function(config){__cov_oaiXFrFXvCNKuifOTFqz5A.f['4']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['9']++;if(config.host){__cov_oaiXFrFXvCNKuifOTFqz5A.b['1'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['10']++;this._host=Y.one(config.host);}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['1'][1]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['11']++;this._host=Y.Node.create(this.TEMPLATE);}},_initAttributes:function(config){__cov_oaiXFrFXvCNKuifOTFqz5A.f['5']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['12']++;var host=this._host,node=(__cov_oaiXFrFXvCNKuifOTFqz5A.b['2'][0]++,host.one('.'+ButtonCore.CLASS_NAMES.LABEL))||(__cov_oaiXFrFXvCNKuifOTFqz5A.b['2'][1]++,host);__cov_oaiXFrFXvCNKuifOTFqz5A.s['13']++;config.label=(__cov_oaiXFrFXvCNKuifOTFqz5A.b['3'][0]++,config.label)||(__cov_oaiXFrFXvCNKuifOTFqz5A.b['3'][1]++,this._getLabel(node));__cov_oaiXFrFXvCNKuifOTFqz5A.s['14']++;Y.AttributeCore.call(this,ButtonCore.ATTRS,config);},_renderUI:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['6']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['15']++;var node=this.getNode(),tagName=node.get('tagName').toLowerCase();__cov_oaiXFrFXvCNKuifOTFqz5A.s['16']++;node.addClass(ButtonCore.CLASS_NAMES.BUTTON);__cov_oaiXFrFXvCNKuifOTFqz5A.s['17']++;if((__cov_oaiXFrFXvCNKuifOTFqz5A.b['5'][0]++,tagName!=='button')&&(__cov_oaiXFrFXvCNKuifOTFqz5A.b['5'][1]++,tagName!=='input')){__cov_oaiXFrFXvCNKuifOTFqz5A.b['4'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['18']++;node.set('role','button');}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['4'][1]++;}},enable:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['7']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['19']++;this.set('disabled',false);},disable:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['8']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['20']++;this.set('disabled',true);},getNode:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['9']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['21']++;return this._host;},_getLabel:function(){__cov_oaiXFrFXvCNKuifOTFqz5A.f['10']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['22']++;var node=this.getNode(),tagName=node.get('tagName').toLowerCase(),label;__cov_oaiXFrFXvCNKuifOTFqz5A.s['23']++;if(tagName==='input'){__cov_oaiXFrFXvCNKuifOTFqz5A.b['6'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['24']++;label=node.get('value');}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['6'][1]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['25']++;label=((__cov_oaiXFrFXvCNKuifOTFqz5A.b['7'][0]++,node.one('.'+ButtonCore.CLASS_NAMES.LABEL))||(__cov_oaiXFrFXvCNKuifOTFqz5A.b['7'][1]++,node)).get('text');}__cov_oaiXFrFXvCNKuifOTFqz5A.s['26']++;return label;},_uiSetLabel:function(label){__cov_oaiXFrFXvCNKuifOTFqz5A.f['11']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['27']++;var node=this.getNode(),tagName=node.get('tagName').toLowerCase();__cov_oaiXFrFXvCNKuifOTFqz5A.s['28']++;if(tagName==='input'){__cov_oaiXFrFXvCNKuifOTFqz5A.b['8'][0]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['29']++;node.set('value',label);}else{__cov_oaiXFrFXvCNKuifOTFqz5A.b['8'][1]++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['30']++;((__cov_oaiXFrFXvCNKuifOTFqz5A.b['9'][0]++,node.one('.'+ButtonCore.CLASS_NAMES.LABEL))||(__cov_oaiXFrFXvCNKuifOTFqz5A.b['9'][1]++,node)).set('text',label);}__cov_oaiXFrFXvCNKuifOTFqz5A.s['31']++;return label;},_uiSetDisabled:function(value){__cov_oaiXFrFXvCNKuifOTFqz5A.f['12']++;__cov_oaiXFrFXvCNKuifOTFqz5A.s['32']++;var node=this.getNode();__cov_oaiXFrFXvCNKuifOTFqz5A.s['33']++;node.getDOMNode().disabled=value;__cov_oaiXFrFXvCNKuifOTFqz5A.s['34']++;node.toggleClass(ButtonCore.CLASS_NAMES.DISABLED,value);__cov_oaiXFrFXvCNKuifOTFqz5A.s['35']++;return value;}};__cov_oaiXFrFXvCNKuifOTFqz5A.s['36']++;Y.mix(ButtonCore.prototype,Y.AttributeCore.prototype);__cov_oaiXFrFXvCNKuifOTFqz5A.s['37']++;ButtonCore.ATTRS={label:{setter:'_uiSetLabel',getter:'_getLabel',lazyAdd:false},disabled:{value:false,setter:'_uiSetDisabled',lazyAdd:false}};__cov_oaiXFrFXvCNKuifOTFqz5A.s['38']++;ButtonCore.NAME='button';__cov_oaiXFrFXvCNKuifOTFqz5A.s['39']++;ButtonCore.CLASS_NAMES={BUTTON:getClassName('button'),DISABLED:getClassName('button','disabled'),SELECTED:getClassName('button','selected'),LABEL:getClassName('button','label')};__cov_oaiXFrFXvCNKuifOTFqz5A.s['40']++;ButtonCore.ARIA_STATES={PRESSED:'aria-pressed',CHECKED:'aria-checked'};__cov_oaiXFrFXvCNKuifOTFqz5A.s['41']++;ButtonCore.ARIA_ROLES={BUTTON:'button',CHECKBOX:'checkbox',TOGGLE:'toggle'};__cov_oaiXFrFXvCNKuifOTFqz5A.s['42']++;Y.ButtonCore=ButtonCore;},'3.10.3',{'requires':['attribute-core','classnamemanager','node-base']});
