class sysconfig::django_init (
    $superuser_name   = hiera('sysconfig::params::superuser_name'   ,$sysconfig::params::superuser_name   ),
    $superuser_pw     = hiera('sysconfig::params::superuser_pw'     ,$sysconfig::params::superuser_pw     ),
    $user_edit_name   = hiera('sysconfig::params::user_edit_name'   ,$sysconfig::params::user_edit_name   ),
    $user_edit_pw     = hiera('sysconfig::params::user_edit_pw'     ,$sysconfig::params::user_edit_pw     ),
    $user_com_name    = hiera('sysconfig::params::user_com_name'    ,$sysconfig::params::user_com_name    ),
    $user_com_pw      = hiera('sysconfig::params::user_com_pw'      ,$sysconfig::params::user_com_pw      ),
    $user_observ_name = hiera('sysconfig::params::user_observ_name' ,$sysconfig::params::user_observ_name ),
    $user_observ_pw   = hiera('sysconfig::params::user_observ_pw'   ,$sysconfig::params::user_observ_pw   ),
    $testserver_port  = hiera('sysconfig::params::testserver_port'  ,$sysconfig::params::testserver_port  )

) inherits sysconfig::params {
    
    notify {'django_init': name => "\$superuser_name : ${superuser_name}, \$superuser_pw : ${superuser_pw}", withpath => true }->

    exec { 'syncdb':
        command => '/srv/comt/bin/django syncdb --noinput --migrate',
        user    => 'vagrant' 
    }

    exec { 'loaddata':
        command => '/srv/comt/bin/django loaddata roles_generic',
        user    => 'vagrant',
        require => Exec['syncdb']
    }

    exec { 'createsuperuser':
        command => "/bin/echo \"from django.contrib.auth.models import User; User.objects.create_superuser('${superuser_name}', 'admin@example.com', '${superuser_pw}')\" | /srv/comt/bin/django shell",
        cwd     => '/srv/comt',
        user    => 'vagrant',
        onlyif  => "/bin/echo \"from django.contrib.auth.models import User; exit(User.objects.filter(username='${superuser_name}').count())\" | /srv/comt/bin/django shell",
       require => Exec['syncdb']
    }

    file { 'karma_workspace_info':
        ensure  => 'present',
        path    => "/srv/comt/src/cm/scripts/test-suite/workspace.info.js",
        replace => 'no',
        owner   => 'vagrant',
        group   => 'vagrant',
        mode    => 644,
        content => template('sysconfig/workspace.info.js.erb','sysconfig/url.workspace.info.js.erb'),
    }

    file { 'karma_workspace_info_full':
        ensure  => 'present',
        path    => "/srv/comt/src/cm/scripts/test-suite/workspace.info.full.js",
        replace => 'no',
        owner   => 'vagrant',
        group   => 'vagrant',
        mode    => 644,
        content => template('sysconfig/workspace.info.js.erb','sysconfig/url.test.workspace.info.js.erb'),
    }

}