$(function(){

$(window).bind('resize', function(){
	setSidebarContentHeight();
});
setSidebarContentHeight();
function setSidebarContentHeight(){
	var newHeight = $(window).height() - $('header').height() - $('footer').height();
	$(".sidebar .content").css('height', newHeight);
}

$(".sidebar .content").mCustomScrollbar({
	advanced:{
	    updateOnContentResize: true
	}
});

$('a.more').bind('click', function(e){
	e.preventDefault();
	var target = $(this).attr('href');
	if($(target).hasClass('less')){
		$(target).removeClass('less');
		$(this).addClass('less');
	}else{
		$(target).addClass('less');
		$(this).removeClass('less');
	}	
});// a.more

$('.stickers a').bind('click', function(e){
	e.preventDefault();
});

//-- API allocine

//-- movie
var urlMovie = 'http://api.allocine.fr/rest/v3/movie?partner='+partnerCode+'&code='+ idMovie;
$.getJSON(urlMovie, function(data) {
	var movie = data.movie;

	//-- title
	var titleMovie = movie.title;
	$('.renkan .wrap-top h2').text(titleMovie);

	//-- stars
	var castMember = movie.castMember;

	$.each(castMember, function(k, v){
		var name =	v.person.name;
		var codeActor = v.person.code;
		var urlPicture;
		if(v.picture !== undefined) {
			urlPicture = v.picture.href;
		}else{
			urlPicture = 'http://fr.web.img3.acsta.net/c_160_213/b_1_d6d6d6/commons/emptymedia/empty_star.jpg';
		}	
		var urlFichePersonne = 'http://www.allocine.fr/personne/fichepersonne_gen_cpersonne='+codeActor+'.html';
		var itemStar = 
			'<li>'+

				'<a class="tool-info" target="_blank" href="'+ urlFichePersonne +'" title="'+ name +'">'+
					'<img src="'+ urlPicture +'" alt="'+ name +'" />'+
				'</a>'+
			'</li>';
		$('#stars-more').append(itemStar);
	});	

	/* Initializing Renkan */
	
	setRenkanPoster({
		title: movie.title,
		image: movie.poster.href,
		uri: _(movie.link).find(function(l) { return l.rel === "aco:web" }).href
	});


});

//-- picture
var urlPicture = 'http://api.allocine.fr/rest/v3/picturelist?partner='+partnerCode+'&subject=movie:'+ idMovie;
$.getJSON(urlPicture, function(data) {
	var media = data.feed.media;
	$.each(media, function(k, v){
		var urlThumb = v.thumbnail.href;
		var rcode = v.rcode;
		var title = v.title;
		var urlAllocine = 'http://www.allocine.fr/film/fichefilm-'+ idMovie +'/photos/detail/?cmediafile='+ rcode;
		var itemImagess = 
			'<li>'+
				'<a target="_blank" href="'+ urlAllocine +'">'+
					'<img src="'+ urlThumb +'" alt="'+title+'" />'+
				'</a>'+
			'</li>';
		$('#images-more').append(itemImagess);
	});
	//redimensionnement images
	$("#images-more img").each(function() {
	    var img = $(this),
	        div = $(this).parent();
	    img.load(function() {
	        var iw = img.width(),
	            ih = img.height(),
	            dw = div.width(),
	            dh = div.height(),
	            scale = Math.max(dw/iw, dh/ih),
	            niw = iw * scale,
	            nih = ih * scale;
	        img.css({
	            width: niw,
	            height: nih,
	            "margin-left": (dw - niw) / 2,
	            "margin-top": (dh - nih) / 3
	        });
	    });
	});
});//get

//-- trailer
var urlTrailers = 'http://api.allocine.fr/rest/v3/videolist?partner='+partnerCode+'&mediafmt=flv&subject=movie:'+ idMovie;
$.getJSON(urlTrailers, function(data) {
	var media = data.feed.media;
	$.each(media, function(k, v){
		console.log(v)
		var urlThumbnail = v.thumbnail.href;
		var title = v.title;
		var code = v.code;
		var url = 'http://www.allocine.fr/video/player_gen_cmedia='+code+'&cfilm='+idMovie+'.html';
		var itemVideo = 
			'<li>'+
				'<a target="_blank" href="'+ url +'">'+
					'<img src="'+ urlThumbnail +'" alt="'+title+'" />'+
				'</a>'+
			'</li>';
		$('#videos-more').append(itemVideo);
	});
});

//TOOLTIP
var show_tooltip_info_iri = function(elem){
	var tooltip = $('.tooltip-iri'),
		name = elem.attr('title'),
		arrow = tooltip.find('.arrow_tooltip'),
		top = elem.offset().top,
		right = elem.offset().left + elem.width() + arrow.width();
	tooltip.find('p').text(name)
	tooltip.show();
	tooltip.css({
		top : top,
		left : right
	});
}
var hide_tooltip_info_iri = function(elem){
	var tooltip = $('.tooltip-iri');
	tooltip.hide();
}
$(document).on({
    mouseenter: function() {
    	show_tooltip_info_iri($(this));
	},
    mouseleave: function() {
    	hide_tooltip_info_iri($(this));
    }
}, 'a.tool-info');



});