Rkns.Renderer = {
    _MINIMAP_MARGIN: 20,
    _MIN_DRAG_DISTANCE: 2,
    _NODE_BUTTON_WIDTH: 40,
    _EDGE_BUTTON_INNER: 2,
    _EDGE_BUTTON_OUTER: 40,
    _CLICKMODE_ADDNODE : 1,
    _CLICKMODE_STARTEDGE : 2,
    _CLICKMODE_ENDEDGE : 3,
    _IMAGE_MAX_KB : 500,
    _NODE_SIZE_STEP: Math.LN2/4,
    _MIN_SCALE: 1/20,
    _MAX_SCALE: 20,
    _AUTOSCALE_MARGIN: 50,
    _USER_PLACEHOLDER : function(_renkan) {
    	return {
    		color: _renkan.options.default_user_color,
	        title: _renkan.translate("(unknown user)"),
	        get: function(attr) {
	            return this[attr] || false;
	        }
    	}
    },
    _BOOKMARKLET_CODE: function(_renkan) {
    	return "(function(a,b,c,d,e,f,h,i,j,k,l,m,n,o,p,q,r){a=document;b=a.body;c=a.location.href;j='draggable';m='text/x-iri-';d=a.createElement('div');d.innerHTML='<p_style=\"position:fixed;top:0;right:0;font:bold_18px_sans-serif;color:#fff;background:#909;padding:10px;z-index:100000;\">"
	    + _renkan.translate("Drag items from this website, drop them in Renkan").replace(/ /g,"_")
	    + "</p>'.replace(/_/g,String.fromCharCode(32));b.appendChild(d);e=[{r:/https?:\\/\\/[^\\/]*twitter\\.com\\//,s:'.tweet',n:'twitter'},{r:/https?:\\/\\/[^\\/]*google\\.[^\\/]+\\//,s:'.g',n:'google'},{r:/https?:\\/\\/[^\\/]*lemonde\\.fr\\//,s:'[data-vr-contentbox]',n:'lemonde'}];f=false;e.forEach(function(g){if(g.r.test(c)){f=g;}});if(f){h=function(){Array.prototype.forEach.call(a.querySelectorAll(f.s),function(i){i[j]=true;k=i.style;k.borderWidth='2px';k.borderColor='#909';k.borderStyle='solid';k.backgroundColor='rgba(200,0,180,.1)';})};window.setInterval(h,500);h();};a.addEventListener('dragstart',function(k){l=k.dataTransfer;l.setData(m+'source-uri',c);l.setData(m+'source-title',a.title);n=k.target;if(f){o=n;while(!o.attributes[j]){o=o.parentNode;if(o==b){break;}}}if(f&&o.attributes[j]){p=o.cloneNode(true);l.setData(m+'specific-site',f.n)}else{q=a.getSelection();if(q.type==='Range'||!q.type){p=q.getRangeAt(0).cloneContents();}else{p=n.cloneNode();}}r=a.createElement('div');r.appendChild(p);l.setData('text/x-iri-selected-text',r.textContent.trim());l.setData('text/x-iri-selected-html',r.innerHTML);},false);})();"
    }
}

Rkns.Renderer.Utils = {
	shortenText : function(_text, _maxlength) {
		return (_text.length > _maxlength ? (_text.substr(0,_maxlength) + '…') : _text);
	},
    drawEditBox : function(_options, _coords, _path, _xmargin, _selector) {
    	_selector.css({
            width: ( _options.tooltip_width - 2* _options.tooltip_padding ),
        })
        var _height = _selector.outerHeight() + 2* _options.tooltip_padding,
            _isLeft = (_coords.x < paper.view.center.x ? 1 : -1),
            _left = _coords.x + _isLeft * ( _xmargin + _options.tooltip_arrow_length ),
            _right = _coords.x + _isLeft * ( _xmargin + _options.tooltip_arrow_length + _options.tooltip_width ),
            _top = _coords.y - _height / 2;
        if (_top < _options.tooltip_margin) {
            _top = Math.min( _options.tooltip_margin, _coords.y - _options.tooltip_arrow_width / 2 );
        }
        var _bottom = _top + _height;
        if (_bottom > (paper.view.size.height - _options.tooltip_margin)) {
            _bottom = Math.max( paper.view.size.height - _options.tooltip_margin, _coords.y + _options.tooltip_arrow_width / 2 );
            _top = _bottom - _height;
        }
        _path.segments[0].point
            = _path.segments[7].point
            = _coords.add([_isLeft * _xmargin, 0]);
        _path.segments[1].point.x
            = _path.segments[2].point.x
            = _path.segments[5].point.x
            = _path.segments[6].point.x
            = _left;
        _path.segments[3].point.x
            = _path.segments[4].point.x
            = _right;
        _path.segments[2].point.y
            = _path.segments[3].point.y
            = _top;
        _path.segments[4].point.y
            = _path.segments[5].point.y
            = _bottom;
        _path.segments[1].point.y = _coords.y - _options.tooltip_arrow_width / 2;
        _path.segments[6].point.y = _coords.y + _options.tooltip_arrow_width / 2;
        _path.closed = true;
        _path.fillColor = new paper.GradientColor(new paper.Gradient([_options.tooltip_top_color, _options.tooltip_bottom_color]), [0,_top], [0, _bottom]);
        _selector.css({
            left: (_options.tooltip_padding + Math.min(_left, _right)),
            top: (_options.tooltip_padding + _top)
        });
        return _path;
    },
    sector : function(_repr, _inR, _outR, _startAngle, _endAngle, _padding, _imgsrc, _caption) {
        var _options = _repr.renderer.renkan.options,
        	_startRads = _startAngle * Math.PI / 180,
            _endRads = _endAngle * Math.PI / 180,
            _img = new Image(),
            _span = _endRads - _startRads,
            _startdx = - Math.sin(_startRads),
            _startdy = Math.cos(_startRads),
            _startXIn = Math.cos(_startRads) * _inR + _padding * _startdx,
            _startYIn = Math.sin(_startRads) * _inR + _padding * _startdy,
            _startXOut = Math.cos(_startRads) * _outR + _padding * _startdx,
            _startYOut = Math.sin(_startRads) * _outR + _padding * _startdy,
            _enddx = - Math.sin(_endRads),
            _enddy = Math.cos(_endRads),
            _endXIn = Math.cos(_endRads) * _inR - _padding * _enddx,
            _endYIn = Math.sin(_endRads) * _inR - _padding * _enddy,
            _endXOut = Math.cos(_endRads) * _outR - _padding * _enddx,
            _endYOut = Math.sin(_endRads) * _outR - _padding * _enddy,
            _centerR = (_inR + _outR)/2,
            _centerRads = (_startRads + _endRads) / 2,
            _centerX = Math.cos(_centerRads) * _centerR,
            _centerY = Math.sin(_centerRads) * _centerR,
            _centerXIn = Math.cos(_centerRads) * _inR,
            _centerXOut = Math.cos(_centerRads) * _outR,
            _centerYIn = Math.sin(_centerRads) * _inR,
            _centerYOut = Math.sin(_centerRads) * _outR,
            _textX = Math.cos(_centerRads) * (_outR + 3),
            _textY = Math.sin(_centerRads) * (_outR + _options.buttons_label_font_size) + _options.buttons_label_font_size / 2,
            _segments = [];
    	_repr.renderer.buttons_layer.activate();
        var _path = new paper.Path();
        _path.add([_startXIn, _startYIn]);
        _path.arcTo([_centerXIn, _centerYIn], [_endXIn, _endYIn]);
        _path.lineTo([_endXOut,  _endYOut]);
        _path.arcTo([_centerXOut, _centerYOut], [_startXOut, _startYOut]);
        _path.fillColor = _options.buttons_background;
        _path.opacity = .5;
        _path.closed = true;
        _path.__representation = _repr;
        var _text = new paper.PointText(_textX,_textY);
        _text.characterStyle = {
            fontSize: _options.buttons_label_font_size,
            fillColor: _options.buttons_label_color
        };
        if (_textX > 2) {
            _text.paragraphStyle.justification = 'left';
        } else if (_textX < -2) {
            _text.paragraphStyle.justification = 'right';
        } else {
            _text.paragraphStyle.justification = 'center';
        }
        _text.visible = false;
        var _visible = false,
            _restPos = new paper.Point(-200, -200),
            _grp = new paper.Group([_path, _text]),
            _delta = _grp.position,
            _imgdelta = new paper.Point([_centerX, _centerY]),
            _currentPos = new paper.Point(0,0);
        _text.content = _caption;
        _grp.visible = false;
        _grp.position = _restPos;
        var _res = {
            show: function() {
                _visible = true;
                _grp.position = _currentPos.add(_delta);
                _grp.visible = true;
            },
            moveTo: function(_point) {
                _currentPos = _point;
                if (_visible) {
                    _grp.position = _point.add(_delta);
                }
            },
            hide: function() {
                _visible = false;
                _grp.visible = false;
                _grp.position = _restPos;
            },
            select: function() {
                _path.opacity = .8;
                _text.visible = true;
            },
            unselect: function() {
                _path.opacity = .5;
                _text.visible = false;
            },
            destroy: function() {
                _grp.remove();
            }
        }
        _img.onload = function() {
            var _h = _img.height;
            var _raster = new paper.Raster(_img);
            _raster.position = _imgdelta.add(_grp.position).subtract(_delta);
            _grp.addChild(_raster);
            _repr.renderer.throttledPaperDraw();
        }
        _img.src = _imgsrc;
        return _res
    }
}

Rkns.Renderer._BaseRepresentation = function(_renderer, _model) {
    if (typeof _renderer !== "undefined") {
        this.renderer = _renderer;
        this.renkan = _renderer.renkan;
        this.project = _renderer.renkan.project;
        this.options = _renderer.renkan.options;
        this.model = _model;
        if (this.model) {
            var _this = this;
            this._changeBinding = function() {
                _this.redraw();
            }
            this._removeBinding = function() {
                _renderer.removeRepresentation(_this);
                _(function() {
                	_renderer.redraw()
            	}).defer();
            }
            this.model.on("change", this._changeBinding );
            this.model.on("remove", this._removeBinding );
        }
    }
}

Rkns.Renderer._BaseRepresentation.prototype.super = function(_func) {
    Rkns.Renderer._BaseRepresentation.prototype[_func].apply(this, Array.prototype.slice.call(arguments, 1));
}

Rkns.Renderer._BaseRepresentation.prototype.redraw = function() {}

Rkns.Renderer._BaseRepresentation.prototype.moveTo = function() {}

Rkns.Renderer._BaseRepresentation.prototype.show = function() {}

Rkns.Renderer._BaseRepresentation.prototype.hide = function() {}

Rkns.Renderer._BaseRepresentation.prototype.select = function() {}

Rkns.Renderer._BaseRepresentation.prototype.unselect = function() {}

Rkns.Renderer._BaseRepresentation.prototype.highlight = function() {}

Rkns.Renderer._BaseRepresentation.prototype.unhighlight = function() {}

Rkns.Renderer._BaseRepresentation.prototype.mouseup = function() {}

Rkns.Renderer._BaseRepresentation.prototype.destroy = function() {
    if (this.model) {
        this.model.off("change", this._changeBinding );
        this.model.off("remove", this._removeBinding );
    }
}

/* */

Rkns.Renderer._BaseButton = Rkns.Utils.inherit(Rkns.Renderer._BaseRepresentation);

Rkns.Renderer._BaseButton.prototype.moveTo = function(_pos) {
    this.sector.moveTo(_pos);
}

Rkns.Renderer._BaseButton.prototype.show = function() {
    this.sector.show();
}

Rkns.Renderer._BaseButton.prototype.hide = function() {
    this.sector.hide();
}

Rkns.Renderer._BaseButton.prototype.select = function() {
    this.sector.select();
}

Rkns.Renderer._BaseButton.prototype.unselect = function(_newTarget) {
    this.sector.unselect();
    if (!_newTarget || (_newTarget !== this.source_representation && _newTarget.source_representation !== this.source_representation)) {
        this.source_representation.unselect();
    }
}

Rkns.Renderer._BaseButton.prototype.destroy = function() {
    this.sector.destroy();
}

/* */

Rkns.Renderer.Node = Rkns.Utils.inherit(Rkns.Renderer._BaseRepresentation);

Rkns.Renderer.Node.prototype._init = function() {
    this.renderer.node_layer.activate();
    this.type = "Node";
    this.circle = new paper.Path.Circle([0, 0], 1);
    this.circle.__representation = this;
    this.circle.fillColor = this.options.node_fill_color;
    if (this.options.show_node_circles) {
	    this.circle.strokeWidth = this.options.node_stroke_width;
	    this.h_ratio = 1;
    } else {
    	this.circle.opacity = .01;
    	this.h_ratio = 0;
    }
    this.title = new paper.PointText([0,0]);
    this.title.characterStyle = {
        font: this.options.node_label_font,
        fontSize: this.options.node_label_font_size,
        fillColor: this.options.node_label_color
    };
    if (this.options.editor_mode) {
    	this.buttons = [
    		new Rkns.Renderer.NodeEditButton(this.renderer, null),
    		new Rkns.Renderer.NodeRemoveButton(this.renderer, null),
    		new Rkns.Renderer.NodeLinkButton(this.renderer, null),
    		new Rkns.Renderer.NodeEnlargeButton(this.renderer, null),
    		new Rkns.Renderer.NodeShrinkButton(this.renderer, null)
    	];
    	for (var i = 0; i < this.buttons.length; i++) {
    		this.buttons[i].source_representation = this;
    	}
    } else {
    	this.buttons = [];
    }
    this.last_circle_radius = 1;
    this.title.paragraphStyle.justification = 'center';
    
    if (this.renderer.minimap) {
	    this.renderer.minimap.node_layer.activate();
	    this.minimap_circle = new paper.Path.Circle([0, 0], 1);
	    this.minimap_circle.__representation = this.renderer.minimap.miniframe.__representation;
	    this.renderer.minimap.node_group.addChild(this.minimap_circle);
    }
}

Rkns.Renderer.Node.prototype.redraw = function(_dontRedrawEdges) {
    var _model_coords = new paper.Point(this.model.get("position")),
    	_baseRadius = this.options.node_size_base * Math.exp((this.model.get("size") || 0) * Rkns.Renderer._NODE_SIZE_STEP);
    if (!this.is_dragging || !this.paper_coords) {
        this.paper_coords = this.renderer.toPaperCoords(_model_coords);
    }
    this.circle_radius = _baseRadius * this.renderer.scale;
    if (this.last_circle_radius !== this.circle_radius) {
    	this.buttons.forEach(function(b) {
    		b.setSectorSize();
    	});
	    var square = new paper.Size(this.circle_radius, this.circle_radius),
	    	topleft = this.paper_coords.subtract(square),
	    	bounds = new paper.Rectangle(topleft, square.multiply(2));
    	this.circle.fitBounds(bounds);
	    if (this.node_image) {
	    	this.node_image.fitBounds(bounds);
	    }
    } else {
    	this.circle.position = this.paper_coords;
    	if (this.node_image) {
            this.node_image.position = this.paper_coords;
        }
    }
    this.last_circle_radius = this.circle_radius;
    
    var _text = this.model.get("title") || this.renkan.translate("(untitled)");
    this.title.content = Rkns.Renderer.Utils.shortenText(_text, this.options.node_label_max_length);

    this.title.position = this.paper_coords.add([
    	0,
    	this.circle_radius * this.h_ratio + this.options.node_label_font_size + this.options.node_label_distance
	]);
    var _color = this.model.get("color") || (this.model.get("created_by") || Rkns.Renderer._USER_PLACEHOLDER(this.renkan)).get("color");
    this.circle.strokeColor = _color;
    var _pc = this.paper_coords;
	this.buttons.forEach(function(b) {
		b.moveTo(_pc);
	});
    var _img = this.model.get("image");
    if (_img && _img !== this.img) {
        var _image = new Image(),
            _this = this;
        _image.onload = function() {
            if (_this.node_image) {
                _this.node_image.remove();
            }
            _this.renderer.node_layer.activate();
            var _ratio = Math.min(2 / _image.width, 2 / _image.height );
            if (!_this.options.show_node_circles) {
            	_this.h_ratio = Math.min(1, _image.height / _image.width);
            }
            var _raster = new paper.Raster(_image);
            if (_this.options.clip_node_images) {
	            var _clip = new paper.Path.Circle([0, 0], 1);
	            _raster.scale(_ratio);
	            _this.node_image = new paper.Group(_clip, _raster);
	            _this.node_image.opacity = .99;
	            /* This is a workaround to allow clipping at group level
	             * If opacity was set to 1, paper.js would merge all clipping groups in one (known bug).
	            */
	            _this.node_image.clipped = true;
            	_clip.__representation = _this;
            } else {
            	_this.node_image = _raster;
            }
            _this.node_image.__representation = _this;
		    var square = new paper.Size(_this.circle_radius, _this.circle_radius),
		    	topleft = _this.paper_coords.subtract(square),
		    	bounds = new paper.Rectangle(topleft, square.multiply(2));
		    _this.node_image.fitBounds(bounds);
            _this.redraw();
    		paper.view.draw();
        }
        _image.src = _img;
    }
    this.img = _img;
    if (this.node_image && !this.img) {
        this.node_image.remove();
        delete this.node_image;
    }
    
    if (this.renderer.minimap) {
	    this.minimap_circle.fillColor = _color;
	    var minipos = this.renderer.toMinimapCoords(_model_coords),
	    	miniradius = this.renderer.minimap.scale * _baseRadius,
	    	minisize = new paper.Size([miniradius, miniradius]);
	    this.minimap_circle.fitBounds(minipos.subtract(minisize), minisize.multiply(2));
    }
    
    if (!_dontRedrawEdges) {
    	Rkns._.each(this.project.get("edges").filter(function (ed) { return ((ed.to === this.model) || (ed.from === this.model));}), function(edge, index, list){
	        var repr = this.renderer.getRepresentationByModel(edge);
	    	if(repr != null && typeof repr.from_representation.paper_coords !== "undefined" && typeof repr.to_representation.paper_coords !== "undefined") {
	    		repr.redraw();
	    	}
	    }, this);
    }

}

Rkns.Renderer.Node.prototype.paperShift = function(_delta) {
	if (this.options.editor_mode) {
		if (!this.renkan.read_only) {
			this.is_dragging = true;
			this.paper_coords = this.paper_coords.add(_delta);
	    	this.redraw();
    	}
	} else {
		this.renderer.paperShift(_delta);
	}
}

Rkns.Renderer.Node.prototype.openEditor = function() {
    this.renderer.removeRepresentationsOfType("editor");
    var _editor = this.renderer.addRepresentation("NodeEditor",null);
    _editor.source_representation = this;
    _editor.draw();
}

Rkns.Renderer.Node.prototype.select = function() {
    this.circle.strokeWidth = this.options.selected_node_stroke_width;
    if (this.renderer.isEditable()) {
    	this.buttons.forEach(function(b) {
    		b.show();
    	});
    }
    var _uri = this.model.get("uri");
    if (_uri) {
    	Rkns.$('.Rk-Bin-Item').each(function() {
	        var _el = Rkns.$(this);
	        if (_el.attr("data-uri") == _uri) {
	            _el.addClass("selected");
	        }
	    });
    }
    if (!this.options.editor_mode) {
        this.openEditor();
    }
    
    if (this.renderer.minimap) {
		this.minimap_circle.strokeWidth = this.options.minimap_highlight_weight;
    	this.minimap_circle.strokeColor = this.options.minimap_highlight_color;
    }
}

Rkns.Renderer.Node.prototype.unselect = function(_newTarget) {
    if (!_newTarget || _newTarget.source_representation !== this) {
    	this.buttons.forEach(function(b) {
    		b.hide();
    	});
    	this.circle.strokeWidth = this.options.node_stroke_width;
        Rkns.$('.Rk-Bin-Item').removeClass("selected");
    	if (this.renderer.minimap) {
    		this.minimap_circle.strokeColor = undefined;
    	}
    }
}

Rkns.Renderer.Node.prototype.highlight = function() {
    this.circle.fillColor = this.options.highlighted_node_fill_color;
    if (this.node_image) {
        this.node_image.opacity = .5;
    }
}

Rkns.Renderer.Node.prototype.unhighlight = function(_newTarget) {
    this.circle.fillColor = this.options.node_fill_color;
    if (this.node_image) {
        this.node_image.opacity = .99;
    }
}

Rkns.Renderer.Node.prototype.saveCoords = function() {
    var _coords = this.renderer.toModelCoords(this.paper_coords),
        _data = {
            position: {
                x: _coords.x,
                y: _coords.y
            }
        };
    if (this.renderer.isEditable()) {
    	this.model.set(_data);
    }
}

Rkns.Renderer.Node.prototype.mouseup = function(_event) {
    if (this.renderer.isEditable() && this.renderer.is_dragging) {
        this.saveCoords();
    }
    else {
        this.openEditor();
    }
    this.renderer.click_target = null;
    this.renderer.is_dragging = false;
    this.is_dragging = false;
}

Rkns.Renderer.Node.prototype.destroy = function(_event) {
    this.super("destroy");
	this.buttons.forEach(function(b) {
		b.destroy();
	});
    this.circle.remove();
    this.title.remove();
    if (this.renderer.minimap) {
    	this.minimap_circle.remove();
    }
    if (this.node_image) {
        this.node_image.remove();
    }
}

/* */

Rkns.Renderer.Edge = Rkns.Utils.inherit(Rkns.Renderer._BaseRepresentation);

Rkns.Renderer.Edge.prototype._init = function() {
    this.renderer.edge_layer.activate();
    this.type = "Edge";
    this.from_representation = this.renderer.getRepresentationByModel(this.model.get("from"));
    this.to_representation = this.renderer.getRepresentationByModel(this.model.get("to"));
    this.bundle = this.renderer.addToBundles(this);
    this.line = new paper.Path();
    this.line.add([0,0],[0,0],[0,0]);
    this.line.__representation = this;
    this.line.strokeWidth = this.options.edge_stroke_width;
    this.arrow = new paper.Path();
    this.arrow.add(
    	[ 0, 0 ],
    	[ this.options.edge_arrow_length, this.options.edge_arrow_width / 2 ],
    	[ 0, this.options.edge_arrow_width ]
	);
    this.arrow.__representation = this;
    this.text = new paper.PointText();
    this.text.characterStyle = {
        font: this.options.edge_label_font,
        fontSize: this.options.edge_label_font_size,
        fillColor: this.options.edge_label_color
    };
    this.text.paragraphStyle.justification = 'center';
    this.text_angle = 0;
    this.arrow_angle = 0;
    if (this.options.editor_mode) {
        this.edit_button = new Rkns.Renderer.EdgeEditButton(this.renderer, null);
        this.edit_button.source_representation = this;
        this.remove_button = new Rkns.Renderer.EdgeRemoveButton(this.renderer, null);
        this.remove_button.source_representation = this;
    }
    
    if (this.renderer.minimap) {
    	this.renderer.minimap.edge_layer.activate();
	    this.minimap_line = new paper.Path();
	    this.minimap_line.add([0,0],[0,0]);
	    this.minimap_line.__representation = this.renderer.minimap.miniframe.__representation;
	    this.minimap_line.strokeWidth = 1;
    }
}

Rkns.Renderer.Edge.prototype.redraw = function() {
    this.from_representation = this.renderer.getRepresentationByModel(this.model.get("from"));
    this.to_representation = this.renderer.getRepresentationByModel(this.model.get("to"));
    if (!this.from_representation || !this.to_representation) {
    	return;
    }
    var _p0a = this.from_representation.paper_coords,
        _p1a = this.to_representation.paper_coords,
        _v = _p1a.subtract(_p0a),
        _r = _v.length,
        _u = _v.divide(_r),
        _ortho = new paper.Point([- _u.y, _u.x]),
        _group_pos = this.bundle.getPosition(this),
        _delta = _ortho.multiply( this.options.edge_gap_in_bundles * _group_pos ),
        _p0b = _p0a.add(_delta), /* Adding a 4 px difference */
        _p1b = _p1a.add(_delta), /* to differentiate bundled links */
        _a = _v.angle,
        _textdelta = _ortho.multiply(this.options.edge_label_distance),
        _handle = _v.divide(3),
        _color = this.model.get("color") || this.model.get("color") || (this.model.get("created_by") || Rkns.Renderer._USER_PLACEHOLDER(this.renkan)).get("color");
    this.paper_coords = _p0b.add(_p1b).divide(2);
    this.line.strokeColor = _color;
    this.line.segments[0].point = _p0a;
    this.line.segments[1].point = this.paper_coords;
    this.line.segments[1].handleIn = _handle.multiply(-1);
    this.line.segments[1].handleOut = _handle;
    this.line.segments[2].point = _p1a;
    this.arrow.rotate(_a - this.arrow_angle);
    this.arrow.fillColor = _color;
    this.arrow.position = this.paper_coords;
    this.arrow_angle = _a;
    if (_a > 90) {
        _a -= 180;
        _textdelta = _textdelta.multiply(-1);
    }
    if (_a < -90) {
        _a += 180;
        _textdelta = _textdelta.multiply(-1);
    }
    this.text.rotate(_a - this.text_angle);
    var _text = this.model.get("title");
    this.text.content = Rkns.Renderer.Utils.shortenText(_text, this.options.edge_label_max_length);
    this.text.position = this.paper_coords.add(_textdelta);
    this.text_angle = _a;
    if (this.options.editor_mode) {
	    this.edit_button.moveTo(this.paper_coords);
	    this.remove_button.moveTo(this.paper_coords);
    }
    
    if (this.renderer.minimap) {
	    this.minimap_line.strokeColor = _color;
	    this.minimap_line.segments[0].point = this.renderer.toMinimapCoords(new paper.Point(this.from_representation.model.get("position")));
 	    this.minimap_line.segments[1].point = this.renderer.toMinimapCoords(new paper.Point(this.to_representation.model.get("position")));
    }
}

Rkns.Renderer.Edge.prototype.openEditor = function() {
    this.renderer.removeRepresentationsOfType("editor");
    var _editor = this.renderer.addRepresentation("EdgeEditor",null);
    _editor.source_representation = this;
    _editor.draw();
}

Rkns.Renderer.Edge.prototype.select = function() {
    this.line.strokeWidth = this.options.selected_edge_stroke_width;
    if (this.renderer.isEditable()) {
	    this.edit_button.show();
	    this.remove_button.show();
   	}
    if (!this.options.editor_mode) {
        this.openEditor();
    }
}

Rkns.Renderer.Edge.prototype.unselect = function(_newTarget) {
    if (!_newTarget || _newTarget.source_representation !== this) {
    	if (this.options.editor_mode) {
	        this.edit_button.hide();
	        this.remove_button.hide();
        }
        this.line.strokeWidth = this.options.edge_stroke_width;
    }
}

Rkns.Renderer.Edge.prototype.mouseup = function(_event) {
    if (!this.renkan.read_only) {
        if (this.renderer.is_dragging) {
            this.from_representation.saveCoords();
            this.to_representation.saveCoords();
            this.from_representation.is_dragging = false;
            this.to_representation.is_dragging = false;
        } else {
            this.openEditor();
        }
    }
    this.renderer.click_target = null;
    this.renderer.is_dragging = false;
}

Rkns.Renderer.Edge.prototype.paperShift = function(_delta) {
	if (this.options.editor_mode) {
		if (!this.options.read_only) {
		    this.from_representation.paperShift(_delta);
		    this.to_representation.paperShift(_delta);
	    }
	} else {
		this.renderer.paperShift(_delta);
	}
}

Rkns.Renderer.Edge.prototype.destroy = function() {
    this.super("destroy");
    this.line.remove();
    this.arrow.remove();
    this.text.remove();
    if (this.renderer.minimap) {
   	    this.minimap_line.remove();
    }
    if (this.options.editor_mode) {
	    this.edit_button.destroy();
	    this.remove_button.destroy();
   	}
    var _this = this;
    this.bundle.edges = Rkns._(this.bundle.edges).reject(function(_edge) {
        return _edge === _this;
    });
}

/* */

Rkns.Renderer.TempEdge = Rkns.Utils.inherit(Rkns.Renderer._BaseRepresentation);

Rkns.Renderer.TempEdge.prototype._init = function() {
    this.renderer.edge_layer.activate();
    this.type = "Temp-edge";
    
    var _color = (this.project.get("users").get(this.renkan.current_user) || Rkns.Renderer._USER_PLACEHOLDER(this.renkan)).get("color");
    this.line = new paper.Path();
    this.line.strokeColor = _color;
    this.line.dashArray = [4, 2];
    this.line.strokeWidth = this.options.selected_edge_stroke_width;
    this.line.add([0,0],[0,0]);
    this.line.__representation = this;
    this.arrow = new paper.Path();
    this.arrow.fillColor = _color;
    this.arrow.add(
    	[ 0, 0 ],
    	[ this.options.edge_arrow_length, this.options.edge_arrow_width / 2 ],
    	[ 0, this.options.edge_arrow_width ]
	);
    this.arrow.__representation = this;
    this.arrow_angle = 0;
}

Rkns.Renderer.TempEdge.prototype.redraw = function() {
    var _p0 = this.from_representation.paper_coords,
        _p1 = this.end_pos,
        _a = _p1.subtract(_p0).angle,
        _c = _p0.add(_p1).divide(2);
    this.line.segments[0].point = _p0;
    this.line.segments[1].point = _p1;
    this.arrow.rotate(_a - this.arrow_angle);
    this.arrow.position = _c;
    this.arrow_angle = _a;
}

Rkns.Renderer.TempEdge.prototype.paperShift = function(_delta) {
	if (!this.renderer.isEditable()) {
		this.renderer.removeRepresentation(_this);
    	paper.view.draw();
    	return;
	}
    this.end_pos = this.end_pos.add(_delta);
    var _hitResult = paper.project.hitTest(this.end_pos);
    this.renderer.findTarget(_hitResult);
    this.redraw();
}

Rkns.Renderer.TempEdge.prototype.mouseup = function(_event) {
    var _hitResult = paper.project.hitTest(_event.point),
        _model = this.from_representation.model,
        _endDrag = true;
    if (_hitResult && typeof _hitResult.item.__representation !== "undefined") {
        var _target = _hitResult.item.__representation;
        if (_target.type.substr(0,4) === "Node") {
        	var _destmodel = _target.model || _target.source_representation.model;
        	if (_model !== _destmodel) {
	            var _data = {
	                id: Rkns.Utils.getUID('edge'),
	                created_by: this.renkan.current_user,
	                from: _model,
	                to: _destmodel
	            };
	            if (this.renderer.isEditable()) {
	            	this.project.addEdge(_data);
	            }
	        }
        }
        
        if (_model === _target.model || (_target.source_representation && _target.source_representation.model === _model)) {
            _endDrag = false;
            this.renderer.is_dragging = true;
        }
    }
    if (_endDrag) {
        this.renderer.click_target = null;
        this.renderer.is_dragging = false;
        this.renderer.removeRepresentation(this);
        paper.view.draw();
    }
}

Rkns.Renderer.TempEdge.prototype.destroy = function() {
    this.arrow.remove();
    this.line.remove();
}

/* */

Rkns.Renderer.NodeEditor = Rkns.Utils.inherit(Rkns.Renderer._BaseRepresentation);

Rkns.Renderer.NodeEditor.prototype._init = function() {
    this.renderer.buttons_layer.activate();
    this.type = "editor";
    this.editor_block = new paper.Path();
    var _pts = Rkns._(Rkns._.range(8)).map(function() {return [0,0]});
    this.editor_block.add.apply(this.editor_block, _pts);
    this.editor_block.strokeWidth = this.options.tooltip_border_width;
    this.editor_block.strokeColor = this.options.tooltip_border_color;
    this.editor_block.opacity = .8;
    this.editor_$ = Rkns.$('<div>')
        .appendTo(this.renderer.editor_$)
        .css({
            position: "absolute",
            opacity: .8
        })
        .hide();
}

Rkns.Renderer.NodeEditor.prototype.template = Rkns._.template(
    '<h2><span class="Rk-CloseX">&times;</span><%-translate("Edit Node")%></span></h2>'
    + '<p><label><%-translate("Title:")%></label><input class="Rk-Edit-Title" type="text" value="<%-node.title%>"/></p>'
    + '<p><label><%-translate("URI:")%></label><input class="Rk-Edit-URI" type="text" value="<%-node.uri%>"/><a class="Rk-Edit-Goto" href="<%-node.uri%>" target="_blank"></a></p>'
    + '<p><label><%-translate("Description:")%></label><textarea class="Rk-Edit-Description"><%-node.description%></textarea></p>'
    + '<p><span class="Rk-Editor-Label"><%-translate("Size:")%></span><a href="#" class="Rk-Edit-Size-Down">-</a><span class="Rk-Edit-Size-Value"><%-node.size%></span><a href="#" class="Rk-Edit-Size-Up">+</a></p>'
    + '<div class="Rk-Editor-p"><span class="Rk-Editor-Label"><%-translate("Node color:")%></span><div class="Rk-Edit-ColorPicker-Wrapper"><span class="Rk-Edit-Color" style="background:<%-node.color%>;"><span class="Rk-Edit-ColorTip"></span></span><ul class="Rk-Edit-ColorPicker">'
    + '<% _(Rkns.pickerColors).each(function(c) { %><li data-color="<%=c%>" style="background: <%=c%>"></li><% }); %></ul><span class="Rk-Edit-ColorPicker-Text"><%- translate("Choose color") %></span></div></div>'
    + '<img class="Rk-Edit-ImgPreview" src="<%-node.image || node.image_placeholder%>" />'
    + '<p><label><%-translate("Image URL:")%></label><input class="Rk-Edit-Image" type="text" value="<%-node.image%>"/></p>'
    + '<p><label><%-translate("Choose Image File:")%></label><input class="Rk-Edit-Image-File" type="file" accept="image/*"/></p>'    
    + '<% if (node.has_creator) { %><p><span class="Rk-Editor-Label"><%-translate("Created by:")%></span> <span class="Rk-UserColor" style="background:<%-node.created_by_color%>;"></span><%- Rkns.Renderer.Utils.shortenText(node.created_by_title, 25) %></p><% } %>'
);

Rkns.Renderer.NodeEditor.prototype.readOnlyTemplate = Rkns._.template(
    '<h2><span class="Rk-CloseX">&times;</span><span class="Rk-UserColor" style="background:<%-node.color%>;"></span>'
    + '<span class="Rk-Display-Title"><% if (node.uri) { %><a href="<%-node.uri%>" target="_blank"><% } %><%-node.title%><% if (node.uri) { %></a><% } %></span></h2>'
    + '<% if (node.uri) { %><p class="Rk-Display-URI"><a href="<%-node.uri%>" target="_blank"><%-node.short_uri%></a></p><% } %>'
    + '<p><%-node.description%></p>'
    + '<% if (node.image) { %><img class="Rk-Display-ImgPreview" src="<%-node.image%>" /><% } %>'
    + '<% if (node.has_creator) { %><p><span class="Rk-Editor-Label"><%-translate("Created by:")%></span><span class="Rk-UserColor" style="background:<%-node.created_by_color%>;"></span><%- Rkns.Renderer.Utils.shortenText(node.created_by_title, 25) %></p><% } %>'
);

Rkns.Renderer.NodeEditor.prototype.draw = function() {
    var _model = this.source_representation.model,
        _created_by = _model.get("created_by") || Rkns.Renderer._USER_PLACEHOLDER(this.renkan),
        _template = (this.renderer.isEditable() ? this.template : this.readOnlyTemplate ),
        _image_placeholder = this.options.static_url + "img/image-placeholder.png",
        _size = (_model.get("size") || 0);
    this.editor_$
        .html(_template({
            node: {
            	has_creator: !!_model.get("created_by"),
                title: _model.get("title"),
                uri: _model.get("uri"),
                short_uri:  Rkns.Renderer.Utils.shortenText((_model.get("uri") || "").replace(/^(https?:\/\/)?(www\.)?/,'').replace(/\/$/,''),40),
                description: _model.get("description"),
                image: _model.get("image") || "",
                image_placeholder: _image_placeholder,
                color: _model.get("color") || _created_by.get("color"),
                created_by_color: _created_by.get("color"),
                created_by_title: _created_by.get("title"),
                size: (_size > 0 ? "+" : "") + _size
            },
            translate: this.renkan.translate
        }));
    this.redraw();
    var _this = this,
    	closeEditor = function() {
    		_this.renderer.removeRepresentation(_this);
        	paper.view.draw();
    	}
    	
    this.editor_$.find(".Rk-CloseX").click(closeEditor);
    
    if (this.renderer.isEditable()) {
    	
    	var onFieldChange = Rkns._(function() {
    		Rkns._(function() {
	            if (_this.renderer.isEditable()) {
		            var _uri = _this.editor_$.find(".Rk-Edit-URI").val(),
		                _image = _this.editor_$.find(".Rk-Edit-Image").val();
		            _this.editor_$.find(".Rk-Edit-ImgPreview").attr("src", _image || _image_placeholder);
		            _this.editor_$.find(".Rk-Edit-Goto").attr("href",_uri);
		            var _data = {
		                title: _this.editor_$.find(".Rk-Edit-Title").val(),
		                description: _this.editor_$.find(".Rk-Edit-Description").val(),
		                uri: _uri,
		                image: _image
		            }
	            	_model.set(_data);
	            	_this.redraw();
	            } else {
	            	closeEditor();
	            }
	            
    		}).defer();
    	}).throttle(500);
    	
    	this.editor_$.on("keyup", function(_e) {
    		if (_e.keyCode === 27) {
    			closeEditor();
    		}
    	});
    	
    	this.editor_$.find("input, textarea").on("change keyup paste", onFieldChange);
    	
        this.editor_$.find(".Rk-Edit-Image-File").change(function() {
        	if (this.files.length) {
        		var f = this.files[0],
        			fr = new FileReader();
    			if (f.type.substr(0,5) !== "image") {
    				alert(_this.renkan.translate("This file is not an image"));
    				return;
    			}
    			if (f.size > (Rkns.Renderer._IMAGE_MAX_KB * 1024)) {
    				alert(_this.renkan.translate("Image size must be under ")+Rkns.Renderer._IMAGE_MAX_KB+_this.renkan.translate("KB"));
    				return;
    			}
        		fr.onload = function(e) {
        			_this.editor_$.find(".Rk-Edit-Image").val(e.target.result);
        			onFieldChange();
        		}
        		fr.readAsDataURL(f);
        	}
        });
        this.editor_$.find(".Rk-Edit-Title")[0].focus();
        this.editor_$.find(".Rk-Edit-ColorPicker-Wrapper").hover(
            function() { _this.editor_$.find(".Rk-Edit-ColorPicker").show(); },
            function() { _this.editor_$.find(".Rk-Edit-ColorPicker").hide(); }
        );
        this.editor_$.find(".Rk-Edit-ColorPicker li").hover(
            function() { _this.editor_$.find(".Rk-Edit-Color").css("background", $(this).attr("data-color")); },
            function() { _this.editor_$.find(".Rk-Edit-Color").css("background", _model.get("color") || (_model.get("created_by") || Rkns.Renderer._USER_PLACEHOLDER(_this.renkan)).get("color")) }
        ).click(function() {
            if (_this.renderer.isEditable()) {
	            _model.set("color", $(this).attr("data-color"));
				paper.view.draw();
            } else {
            	closeEditor();
            }
        });
        
        function shiftSize(n) {
        	if (_this.renderer.isEditable()) {
	        	var _newsize = n+(_model.get("size") || 0);
	        	_this.editor_$.find(".Rk-Edit-Size-Value").text((_newsize > 0 ? "+" : "") + _newsize);
	        	_model.set("size", _newsize);
				paper.view.draw();
			} else {
				closeEditor();
			}
        }
        
        this.editor_$.find(".Rk-Edit-Size-Down").click(function() {
        	shiftSize(-1);
        	return false;
        });
        this.editor_$.find(".Rk-Edit-Size-Up").click(function() {
        	shiftSize(1);
        	return false;
        });
    }
    this.editor_$.find("img").load(function() {
        _this.redraw();
    });
}

Rkns.Renderer.NodeEditor.prototype.redraw = function() {
    var _coords = this.source_representation.paper_coords;
    Rkns.Renderer.Utils.drawEditBox(this.options, _coords, this.editor_block, this.source_representation.circle_radius * .75, this.editor_$);
    this.editor_$.show();
    paper.view.draw();
}

Rkns.Renderer.NodeEditor.prototype.destroy = function() {
    this.editor_block.remove();
    this.editor_$.detach();
}

/* */

Rkns.Renderer.EdgeEditor = Rkns.Utils.inherit(Rkns.Renderer._BaseRepresentation);

Rkns.Renderer.EdgeEditor.prototype._init = function() {
    this.renderer.buttons_layer.activate();
    this.type = "editor";
    this.editor_block = new paper.Path();
    var _pts = Rkns._(Rkns._.range(8)).map(function() {return [0,0]});
    this.editor_block.add.apply(this.editor_block, _pts);
    this.editor_block.strokeWidth = this.options.tooltip_border_width;
    this.editor_block.strokeColor = this.options.tooltip_border_color;
    this.editor_block.opacity = .8;
    this.editor_$ = Rkns.$('<div>')
        .appendTo(this.renderer.editor_$)
        .css({
            position: "absolute",
            opacity: .8
        })
        .hide();
}

Rkns.Renderer.EdgeEditor.prototype.template = Rkns._.template(
    '<h2><span class="Rk-CloseX">&times;</span><%-translate("Edit Edge")%></span></h2>'
    + '<p><label><%-translate("Title:")%></label><input class="Rk-Edit-Title" type="text" value="<%-edge.title%>"/></p>'
    + '<p><label><%-translate("URI:")%></label><input class="Rk-Edit-URI" type="text" value="<%-edge.uri%>"/><a class="Rk-Edit-Goto" href="<%-edge.uri%>" target="_blank"></a></p>'
    + '<% if (properties.length) { %><p><label><%-translate("Choose from vocabulary:")%></label><select class="Rk-Edit-Vocabulary">'
    + '<% _(properties).each(function(ontology) { %><option class="Rk-Edit-Vocabulary-Class" value=""><%- translate(ontology.label) %></option>'
    + '<% _(ontology.properties).each(function(property) { var uri = ontology["base-uri"] + property.uri; %><option class="Rk-Edit-Vocabulary-Property" value="<%- uri %>'
    + '"<% if (uri === edge.uri) { %> selected<% } %>><%- translate(property.label) %></option>'
    + '<% }) %><% }) %></select></p><% } %>'
    + '<div class="Rk-Editor-p"><span class="Rk-Editor-Label"><%-translate("Edge color:")%></span><div class="Rk-Edit-ColorPicker-Wrapper"><span class="Rk-Edit-Color" style="background:<%-edge.color%>;"><span class="Rk-Edit-ColorTip"></span></span><ul class="Rk-Edit-ColorPicker">'
    + '<% _(Rkns.pickerColors).each(function(c) { %><li data-color="<%=c%>" style="background: <%=c%>"></li><% }); %></ul><span class="Rk-Edit-ColorPicker-Text"><%- translate("Choose color") %></span></div></div>'
    + '<p><span class="Rk-Edit-Direction"><%- translate("Change edge direction") %></span></p>'
    + '<p><span class="Rk-Editor-Label"><%-translate("From:")%></span><span class="Rk-UserColor" style="background:<%-edge.from_color%>;"></span><%- Rkns.Renderer.Utils.shortenText(edge.from_title, 25) %></p>'
    + '<p><span class="Rk-Editor-Label"><%-translate("To:")%></span><span class="Rk-UserColor" style="background:<%-edge.to_color%>;"></span><%- Rkns.Renderer.Utils.shortenText(edge.to_title, 25) %></p>'
    + '<% if (edge.has_creator) { %><p><span class="Rk-Editor-Label"><%-translate("Created by:")%></span><span class="Rk-UserColor" style="background:<%-edge.created_by_color%>;"></span><%- Rkns.Renderer.Utils.shortenText(edge.created_by_title, 25) %></p><% } %>'
);

Rkns.Renderer.EdgeEditor.prototype.readOnlyTemplate = Rkns._.template(
    '<h2><span class="Rk-CloseX">&times;</span><span class="Rk-UserColor" style="background:<%-edge.color%>;"></span>'
    + '<span class="Rk-Display-Title"><% if (edge.uri) { %><a href="<%-edge.uri%>" target="_blank"><% } %><%-edge.title%><% if (edge.uri) { %></a><% } %></span></h2>'
    + '<% if (edge.uri) { %><p class="Rk-Display-URI"><a href="<%-edge.uri%>" target="_blank"><%-edge.short_uri%></a></p><% } %>'
    + '<p><%-edge.description%></p>'
    + '<p><span class="Rk-Editor-Label"><%-translate("From:")%></span><span class="Rk-UserColor" style="background:<%-edge.from_color%>;"></span><%- Rkns.Renderer.Utils.shortenText(edge.from_title, 25) %></p>'
    + '<p><span class="Rk-Editor-Label"><%-translate("To:")%></span><span class="Rk-UserColor" style="background:<%-edge.to_color%>;"></span><%- Rkns.Renderer.Utils.shortenText(edge.to_title, 25) %></p>'
    + '<% if (edge.has_creator) { %><p><span class="Rk-Editor-Label"><%-translate("Created by:")%></span><span class="Rk-UserColor" style="background:<%-edge.created_by_color%>;"></span><%- Rkns.Renderer.Utils.shortenText(edge.created_by_title, 25) %></p><% } %>'
);

Rkns.Renderer.EdgeEditor.prototype.draw = function() {
    var _model = this.source_representation.model,
        _from_model = _model.get("from"),
        _to_model = _model.get("to"),
        _created_by = _model.get("created_by") || Rkns.Renderer._USER_PLACEHOLDER(this.renkan),
        _template = (this.renderer.isEditable() ? this.template : this.readOnlyTemplate);
    this.editor_$
        .html(_template({
            edge: {
            	has_creator: !!_model.get("created_by"),
                title: _model.get("title"),
                uri: _model.get("uri"),
                short_uri:  Rkns.Renderer.Utils.shortenText((_model.get("uri") || "").replace(/^(https?:\/\/)?(www\.)?/,'').replace(/\/$/,''),40),
                description: _model.get("description"),
                color: _model.get("color") || _created_by.get("color"),
                from_title: _from_model.get("title"),
                to_title: _to_model.get("title"),
                from_color: _from_model.get("color") || (_from_model.get("created_by") || Rkns.Renderer._USER_PLACEHOLDER(this.renkan)).get("color"),
                to_color: _to_model.get("color") || (_to_model.get("created_by") || Rkns.Renderer._USER_PLACEHOLDER(this.renkan)).get("color"),
                created_by_color: _created_by.get("color"),
                created_by_title: _created_by.get("title")
            },
            translate: this.renkan.translate,
            properties: this.options.properties
        }));
    this.redraw();
    var _this = this,
    	closeEditor = function() {
	        _this.renderer.removeRepresentation(_this);
	        paper.view.draw();
    	}
    this.editor_$.find(".Rk-CloseX").click(closeEditor);
    
    if (this.renderer.isEditable()) {
    	
    	var onFieldChange = Rkns._(function() {
    		Rkns._(function() {
    			if (_this.renderer.isEditable()) {
	    			_this.editor_$.find(".Rk-Edit-Goto").attr("href",_this.editor_$.find(".Rk-Edit-URI").val());
		            var _data = {
		                title: _this.editor_$.find(".Rk-Edit-Title").val(),
		                uri: _this.editor_$.find(".Rk-Edit-URI").val()
		            }
		            _model.set(_data);
		            paper.view.draw();
	           	} else {
	           		closeEditor();
	           	}
    		}).defer();
    	}).throttle(500);
    	
    	this.editor_$.on("keyup", function(_e) {
    		if (_e.keyCode === 27) {
    			closeEditor();
    		}
    	});
    	
        this.editor_$.find("input").on("keyup change paste", onFieldChange);
        
        this.editor_$.find(".Rk-Edit-Vocabulary").change(function() {
        	var e = $(this),
        		v = e.val();
        	if (v) {
        		_this.editor_$.find(".Rk-Edit-Title").val(e.find(":selected").text());
        		_this.editor_$.find(".Rk-Edit-URI").val(v);
        		onFieldChange();
        	}
        });
        this.editor_$.find(".Rk-Edit-Direction").click(function() {
			if (_this.renderer.isEditable()) {
	        	_model.set({
	        		from: _model.get("to"),
	        		to: _model.get("from")
	        	});
	        	_this.draw();
	       	} else {
	       		closeEditor();
	       	}
        });
        this.editor_$.find(".Rk-Edit-ColorPicker-Wrapper").hover(
            function() { _this.editor_$.find(".Rk-Edit-ColorPicker").show(); },
            function() { _this.editor_$.find(".Rk-Edit-ColorPicker").hide(); }
        );
        this.editor_$.find(".Rk-Edit-ColorPicker li").hover(
            function() { _this.editor_$.find(".Rk-Edit-Color").css("background", $(this).attr("data-color")); },
            function() { _this.editor_$.find(".Rk-Edit-Color").css("background", _model.get("color") || (_model.get("created_by") || Rkns.Renderer._USER_PLACEHOLDER(this.renkan)).get("color")); }
        ).click(function() {
			if (_this.renderer.isEditable()) {
            	_model.set("color", $(this).attr("data-color"));
            	paper.view.draw();
            } else {
	       		closeEditor();
	       	}
        });
    }
}

Rkns.Renderer.EdgeEditor.prototype.redraw = function() {
    var _coords = this.source_representation.paper_coords;
    Rkns.Renderer.Utils.drawEditBox(this.options, _coords, this.editor_block, 5, this.editor_$);
    this.editor_$.show();
    paper.view.draw();
}

Rkns.Renderer.EdgeEditor.prototype.destroy = function() {
    this.editor_block.remove();
    this.editor_$.detach();
}

/* */

Rkns.Renderer._NodeButton = Rkns.Utils.inherit(Rkns.Renderer._BaseButton);

Rkns.Renderer._NodeButton.prototype.setSectorSize = function() {
	var sectorInner = this.source_representation.circle_radius;
	if (sectorInner !== this.lastSectorInner) {
		if (this.sector) {
			this.sector.destroy();
		}
		this.sector = Rkns.Renderer.Utils.sector(
			this, 1 + sectorInner,
			Rkns.Renderer._NODE_BUTTON_WIDTH + sectorInner,
			this.startAngle,
			this.endAngle,
			1,
			this.options.static_url + this.imageFile,
			this.renkan.translate(this.text)
		);
		this.lastSectorInner = sectorInner;
	}
}

/* */

Rkns.Renderer.NodeEditButton = Rkns.Utils.inherit(Rkns.Renderer._NodeButton);

Rkns.Renderer.NodeEditButton.prototype._init = function() {
    this.type = "Node-edit-button";
    this.lastSectorInner = 0;
    this.startAngle = -135;
    this.endAngle = -45;
    this.imageFile = 'img/edit.png';
    this.text = "Edit";
}

Rkns.Renderer.NodeEditButton.prototype.mouseup = function() {
    if (!this.renderer.is_dragging) {
        this.source_representation.openEditor();
    }
}

/* */

Rkns.Renderer.NodeRemoveButton = Rkns.Utils.inherit(Rkns.Renderer._NodeButton);

Rkns.Renderer.NodeRemoveButton.prototype._init = function() {
    this.type = "Node-remove-button";
    this.lastSectorInner = 0;
    this.startAngle = 90;
    this.endAngle = 180;
    this.imageFile = 'img/remove.png';
    this.text = "Remove";
}

Rkns.Renderer.NodeRemoveButton.prototype.mouseup = function() {
    this.renderer.click_target = null;
    this.renderer.is_dragging = false;
    this.renderer.removeRepresentationsOfType("editor");
    if (this.renderer.isEditable() && confirm(this.renkan.translate('Do you really wish to remove node ') + '"' + this.source_representation.model.get("title") + '"?')) {
        this.project.removeNode(this.source_representation.model);
    }
}

/* */

Rkns.Renderer.NodeLinkButton = Rkns.Utils.inherit(Rkns.Renderer._NodeButton);

Rkns.Renderer.NodeLinkButton.prototype._init = function() {
    this.type = "Node-link-button";
    this.lastSectorInner = 0;
    this.startAngle = 0;
    this.endAngle = 90;
    this.imageFile = 'img/link.png';
    this.text = "Link to another node";
}

/* */

Rkns.Renderer.NodeEnlargeButton = Rkns.Utils.inherit(Rkns.Renderer._NodeButton);

Rkns.Renderer.NodeEnlargeButton.prototype._init = function() {
    this.type = "Node-enlarge-button";
    this.lastSectorInner = 0;
    this.startAngle = -45;
    this.endAngle = 0;
    this.imageFile = 'img/enlarge.png';
    this.text = "Enlarge";
}

Rkns.Renderer.NodeEnlargeButton.prototype.mouseup = function() {
	var _newsize = 1 + (this.source_representation.model.get("size") || 0);
	this.source_representation.model.set("size", _newsize);
	this.source_representation.select();
	this.select();
	paper.view.draw();
}

/* */

Rkns.Renderer.NodeShrinkButton = Rkns.Utils.inherit(Rkns.Renderer._NodeButton);

Rkns.Renderer.NodeShrinkButton.prototype._init = function() {
    this.type = "Node-shrink-button";
    this.lastSectorInner = 0;
    this.startAngle = -180;
    this.endAngle = -135;
    this.imageFile = 'img/shrink.png';
    this.text = "Shrink";
}

Rkns.Renderer.NodeShrinkButton.prototype.mouseup = function() {
	var _newsize = -1 + (this.source_representation.model.get("size") || 0);
	this.source_representation.model.set("size", _newsize);
	this.source_representation.select();
	this.select();
	paper.view.draw();
}

/* */

Rkns.Renderer.EdgeEditButton = Rkns.Utils.inherit(Rkns.Renderer._BaseButton);

Rkns.Renderer.EdgeEditButton.prototype._init = function() {
    this.type = "Edge-edit-button";
    this.sector = Rkns.Renderer.Utils.sector(this, Rkns.Renderer._EDGE_BUTTON_INNER, Rkns.Renderer._EDGE_BUTTON_OUTER, - 90, 90, 1, this.options.static_url+'img/edit.png', this.renkan.translate("Edit"));
}

Rkns.Renderer.EdgeEditButton.prototype.mouseup = function() {
    if (!this.renderer.is_dragging) {
        this.source_representation.openEditor();
    }
}

/* */

Rkns.Renderer.EdgeRemoveButton = Rkns.Utils.inherit(Rkns.Renderer._BaseButton);

Rkns.Renderer.EdgeRemoveButton.prototype._init = function() {
    this.type = "Edge-remove-button";
    this.sector = Rkns.Renderer.Utils.sector(this, Rkns.Renderer._EDGE_BUTTON_INNER, Rkns.Renderer._EDGE_BUTTON_OUTER, - 270, -90, 1, this.options.static_url+'img/remove.png', this.renkan.translate("Remove"));
}

Rkns.Renderer.EdgeRemoveButton.prototype.mouseup = function() {
    this.renderer.removeRepresentationsOfType("editor");
    if (this.renderer.isEditable() && confirm(this.renkan.translate('Do you really wish to remove edge ') + '"' + this.source_representation.model.get("title") + '"?')) {
        this.project.removeEdge(this.source_representation.model);
    }
}

/* */

Rkns.Renderer.MiniFrame = Rkns.Utils.inherit(Rkns.Renderer._BaseRepresentation);

Rkns.Renderer.MiniFrame.prototype.paperShift = function(_delta) {
	this.renderer.offset = this.renderer.offset.subtract(_delta.divide(this.renderer.minimap.scale).multiply(this.renderer.scale));
    this.renderer.redraw();
}

Rkns.Renderer.MiniFrame.prototype.mouseup = function(_delta) {
	this.renderer.click_target = null;
    this.renderer.is_dragging = false;
}

/* */

Rkns.Renderer.Scene = function(_renkan) {
    this.renkan = _renkan;
    this.$ = Rkns.$(".Rk-Render");
    this.representations = [];
    this.$.html(this.template(_renkan));
    this.onStatusChange();
    this.canvas_$ = this.$.find(".Rk-Canvas");
    this.editor_$ = this.$.find(".Rk-Editor");
    this.notif_$ = this.$.find(".Rk-Notifications");
    paper.setup(this.canvas_$[0]);
    this.scale = 1;
    this.offset = paper.view.center;
    this.totalScroll = 0;
    this.mouse_down = false;
    this.click_target = null;
    this.selected_target = null;
    this.edge_layer = new paper.Layer();
    this.node_layer = new paper.Layer();
    this.buttons_layer = new paper.Layer();
    
    if (_renkan.options.show_minimap) {
	    this.minimap = {
	    	background_layer: new paper.Layer(),
	    	edge_layer: new paper.Layer(),
	    	node_layer: new paper.Layer(),
	    	node_group: new paper.Group(),
	    	size: new paper.Size( _renkan.options.minimap_width, _renkan.options.minimap_height )
	    }
	    
	    this.minimap.background_layer.activate();
	    this.minimap.topleft = paper.view.bounds.bottomRight.subtract(this.minimap.size);
	    this.minimap.rectangle = new paper.Path.Rectangle(this.minimap.topleft.subtract([2,2]), this.minimap.size.add([4,4]));
	    this.minimap.rectangle.fillColor = _renkan.options.minimap_background_color;
	    this.minimap.rectangle.strokeColor = _renkan.options.minimap_border_color;
	    this.minimap.rectangle.strokeWidth = 4;
	    this.minimap.offset = new paper.Point(this.minimap.size.divide(2));
	    this.minimap.scale = .1;
	    
	    this.minimap.node_layer.activate();
	    this.minimap.cliprectangle = new paper.Path.Rectangle(this.minimap.topleft, this.minimap.size);
	    this.minimap.node_group.addChild(this.minimap.cliprectangle);
	    this.minimap.node_group.clipped = true;
	    this.minimap.miniframe = new paper.Path.Rectangle(this.minimap.topleft, this.minimap.size);
	    this.minimap.node_group.addChild(this.minimap.miniframe);
	    this.minimap.miniframe.fillColor = '#c0c0ff';
	    this.minimap.miniframe.opacity = .3;
	    this.minimap.miniframe.strokeColor = '#000080';
	    this.minimap.miniframe.strokeWidth = 3;
	    this.minimap.miniframe.__representation = new Rkns.Renderer.MiniFrame(this, null);
    }
    
    this.throttledPaperDraw = Rkns._(function() {
    	paper.view.draw();
    }).throttle(100);
    
    this.bundles = [];
    this.click_mode = false;
    
    var _this = this,
        _allowScroll = true;
    
    this.canvas_$.on({
    	mousedown: function(_event) {
    		_this.onMouseDown(_event);
    	},
    	mousemove: function(_event) {
        _this.onMouseMove(_event);
	    },
	    mouseup: function(_event) {
	        _this.onMouseUp(_event);
	    },
	    mousewheel: function(_event, _delta) {
	        if (_allowScroll) {
	        	_this.onScroll(_event, _delta);
	        }
	    },
	    dblclick: function(_event) {
	        _this.onDoubleClick(_event);
	    },
	    mouseleave: function(_event) {
	        _this.onMouseUp(_event);
	        _this.click_target = null;
	        _this.is_dragging = false;
	    },
	    dragover: function(_event) {
	    	_event.preventDefault();
	    },
	    dragenter: function(_event) {
	    	_allowScroll = false;
	    	_event.preventDefault();
	    },
	    dragleave: function(_event) {
	    	_allowScroll = true;
	    	_event.preventDefault();
	    },
    drop: function(_event) {
    	_event.preventDefault();
    	_allowScroll = true;
    	if (!_this.isEditable()) {
    		return;
    	}
    	var res = {};
    	Rkns._(_event.originalEvent.dataTransfer.types).each(function(t) {
    		try {
    			res[t] = _event.originalEvent.dataTransfer.getData(t);
    		} catch(e) {}
    	});
		var text = _event.originalEvent.dataTransfer.getData("Text");
		if (typeof text === "string") {
			switch(text[0]) {
    			case "{":
    			case "[":
    				try {
    					var data = JSON.parse(text);
    					_(res).extend(data);
    				}
    				catch(e) {
    					if (!res["text/plain"]) {
    						res["text/plain"] = text;
    					}
    				}
				break;
				case "<":
					if (!res["text/html"]) {
						res["text/html"] = text;
					}
				break;
				default:
					if (!res["text/plain"]) {
						res["text/plain"] = text;
					}
    		}
		}
		var url = _event.originalEvent.dataTransfer.getData("URL");
		if (url && !res["text/uri-list"]) {
			res["text/uri-list"] = url;
		}
		if (res["text/json"] || res["application/json"]) {
			try {
				var data = JSON.parse(res["text/json"] || res["application/json"]);
				_(res).extend(data);
			}
			catch(e) {}
		}
    	var newNode = {};
    	switch(res["text/x-iri-specific-site"]) {
    		case "twitter":
    			var snippet = Rkns.$('<div>').html(res["text/x-iri-selected-html"]),
    				tweetdiv = snippet.find(".tweet")
    			newNode.title = _renkan.translate("Tweet by ") + tweetdiv.attr("data-name");
    			newNode.uri = "http://twitter.com/" + tweetdiv.attr("data-screen-name") + "/status/" + tweetdiv.attr("data-tweet-id");
    			newNode.image = tweetdiv.find(".avatar").attr("src");
    			newNode.description = tweetdiv.find(".js-tweet-text:first").text();
    		break;
    		case "google":
    			var snippet = Rkns.$('<div>').html(res["text/x-iri-selected-html"]);
    			newNode.title = snippet.find("h3:first").text().trim();
    			newNode.uri = snippet.find("h3 a").attr("href");
    			newNode.description = snippet.find(".st:first").text().trim();
    		break;
    		case undefined:
	    	default:
		    	if (res["text/x-iri-source-uri"]) {
		    		newNode.uri = res["text/x-iri-source-uri"];
		    	}
		    	if (res["text/plain"] || res["text/x-iri-selected-text"]) {
		    		newNode.description = (res["text/plain"] || res["text/x-iri-selected-text"]).replace(/[\s\n]+/gm,' ').trim();
		    	}
		    	if (res["text/html"] || res["text/x-iri-selected-html"]) {
		    		var snippet = Rkns.$('<div>').html(res["text/html"] || res["text/x-iri-selected-html"]);
		    		var _imgs = snippet.find("img");
		    		if (_imgs.length) {
		    			newNode.image = _imgs[0].src;
		    		}
		    		var _as = snippet.find("a");
		    		if (_as.length) {
		    			newNode.uri = _as[0].href;
		    		}
		    		newNode.title = snippet.find("[title]").attr("title") || newNode.title;
		    		newNode.description = snippet.text().replace(/[\s\n]+/gm,' ').trim();
		    	}
		    	if (res["text/uri-list"]) {
		    		newNode.uri = res["text/uri-list"];
		    	}
		    	if (res["text/x-moz-url"] && !newNode.title) {
		    		newNode.title = (res["text/x-moz-url"].split("\n")[1] || "").trim();
		    		if (newNode.title === newNode.uri) {
		    			newNode.title = false;
		    		}
		    	}
		    	if (res["text/x-iri-source-title"] && !newNode.title) {
		    		newNode.title = res["text/x-iri-source-title"];
		    	}
		    	if (res["text/html"] || res["text/x-iri-selected-html"]) {
		    		newNode.image = snippet.find("[data-image]").attr("data-image") || newNode.image;
		    		newNode.uri = snippet.find("[data-uri]").attr("data-uri") || newNode.uri;
		    		newNode.title = snippet.find("[data-title]").attr("data-title") || newNode.title;
		    		newNode.description = snippet.find("[data-description]").attr("data-description") || newNode.description;
		    	}
    	}
    	var fields = ["title", "description", "uri", "image"];
    	for (var i = 0; i < fields.length; i++) {
    		var f = fields[i];
    		if (res["text/x-iri-" + f] || res[f]) {
    			newNode[f] = res["text/x-iri-" + f] || res[f];
    		}
    		if (newNode[f] === "none" || newNode[f] === "null") {
    			newNode[f] = undefined;
    		}
    	}
    	if (newNode.title || newNode.description || newNode.uri) {
    		var _off = _this.canvas_$.offset(),
            _point = new paper.Point([
                _event.originalEvent.pageX - _off.left,
                _event.originalEvent.pageY - _off.top
            ]),
            _coords = _this.toModelCoords(_point),
            _data = {
                id: Rkns.Utils.getUID('node'),
                created_by: _this.renkan.current_user,
                uri: newNode.uri || "",
                title: newNode.title || _this.renkan.translate("Dragged resource"),
                description: newNode.description || "",
                image: newNode.image || "",
                color: newNode.color || undefined,
                position: {
                    x: _coords.x,
                    y: _coords.y
                }
            };
        	var _node = _this.renkan.project.addNode(_data);
            _this.getRepresentationByModel(_node).openEditor();
    	}
    }
    });
    this.editor_$.find(".Rk-ZoomOut").click(function() {
    	var _newScale = _this.scale * Math.SQRT1_2,
    		_offset = new paper.Point([
	            _this.canvas_$.width(),
	            _this.canvas_$.height()
	        ]).multiply( .5 * ( 1 - Math.SQRT1_2 ) ).add(_this.offset.multiply( Math.SQRT1_2 ));
        _this.setScale( _newScale, _offset );
    });
    this.editor_$.find(".Rk-ZoomIn").click(function() {
    	var _newScale = _this.scale * Math.SQRT2,
    		_offset = new paper.Point([
	            _this.canvas_$.width(),
	            _this.canvas_$.height()
	        ]).multiply( .5 * ( 1 - Math.SQRT2 ) ).add(_this.offset.multiply( Math.SQRT2 ));
        _this.setScale( _newScale, _offset );
    });
    this.$.find(".Rk-CurrentUser").mouseenter(
        function() { _this.$.find(".Rk-UserList").slideDown() }
    );
    this.$.find(".Rk-Users").mouseleave(
        function() { _this.$.find(".Rk-UserList").slideUp(); }
    );
    this.$.find(".Rk-FullScreen-Button").click(function() {
        var _isFull = document.fullScreen || document.mozFullScreen || document.webkitIsFullScreen,
            _el = _this.renkan.$[0],
            _requestMethods = ["requestFullScreen","mozRequestFullScreen","webkitRequestFullScreen"],
            _cancelMethods = ["cancelFullScreen","mozCancelFullScreen","webkitCancelFullScreen"];
        if (_isFull) {
            for (var i = 0; i < _cancelMethods.length; i++) {
                if (typeof document[_cancelMethods[i]] === "function") {
                    document[_cancelMethods[i]]();
                    break;
                }
            }
        } else {
            for (var i = 0; i < _requestMethods.length; i++) {
                if (typeof _el[_requestMethods[i]] === "function") {
                    _el[_requestMethods[i]]();
                    break;
                }
            }
        }
    });
    this.$.find(".Rk-AddNode-Button").click(function() {
        if (_this.click_mode === Rkns.Renderer._CLICKMODE_ADDNODE) {
            _this.click_mode = false;
            _this.notif_$.hide();
        } else {
            _this.click_mode = Rkns.Renderer._CLICKMODE_ADDNODE;
            _this.notif_$.text(_renkan.translate("Click on the background canvas to add a node")).fadeIn();
        }
    });
    this.$.find(".Rk-AddEdge-Button").click(function() {
        if (_this.click_mode === Rkns.Renderer._CLICKMODE_STARTEDGE || _this.click_mode === Rkns.Renderer._CLICKMODE_ENDEDGE) {
            _this.click_mode = false;
            _this.notif_$.hide();
        } else {
            _this.click_mode = Rkns.Renderer._CLICKMODE_STARTEDGE;
            _this.notif_$.text(_renkan.translate("Click on a first node to start the edge")).fadeIn();
        }
    });
    this.$.find(".Rk-Bookmarklet-Button")
	    .attr("href","javascript:" + Rkns.Renderer._BOOKMARKLET_CODE(_renkan))
		.click(function(){
	    	_this.notif_$
	    		.text(_renkan.translate("Drag this button to your bookmark bar. When on a third-party website, click it to enable drag-and-drop from the website to Renkan."))
	    		.fadeIn()
	    		.delay(5000)
	    		.fadeOut();
			return false;
	    });
    this.$.find(".Rk-TopBar-Button").mouseover(function() {
        Rkns.$(this).find(".Rk-TopBar-Tooltip").show();
    }).mouseout(function() {
        Rkns.$(this).find(".Rk-TopBar-Tooltip").hide();
    });
    this.$.find(".Rk-Fold-Bins").click(function() {
    	var bins = _renkan.$.find(".Rk-Bins");
    	if (bins.offset().left < 0) {
    		bins.animate({left: 0},250);
    		_this.$.animate({left: 300},250,function() {
    			var w = _this.$.width();
    			paper.view.viewSize = new paper.Size([w, _this.canvas_$.height()]);
    		});
    		$(this).html("&laquo;");
    	} else {
    		bins.animate({left: -300},250);
    		_this.$.animate({left: 0},250,function() {
    			var w = _this.$.width();
    			paper.view.viewSize = new paper.Size([w, _this.canvas_$.height()]);
    		});
    		$(this).html("&raquo;");
    	}
    });
    
    paper.view.onResize = function(_event) {
    	_this.offset = _this.offset.add(_event.delta.divide(2));
    	if (_this.minimap) {
	        _this.minimap.topleft = paper.view.bounds.bottomRight.subtract(_this.minimap.size)
	        _this.minimap.rectangle.fitBounds(_this.minimap.topleft.subtract([2,2]), _this.minimap.size.add([4,4]));
	        _this.minimap.cliprectangle.fitBounds(_this.minimap.topleft, _this.minimap.size);
        }
        _this.redraw();
    }
    
    var _thRedraw = Rkns._.throttle(function() {
        _this.redraw();
    },50);
    
    this.addRepresentations("Node", this.renkan.project.get("nodes"));
    this.addRepresentations("Edge", this.renkan.project.get("edges"));
    this.renkan.project.on("change:title", function() {
        _this.$.find(".Rk-PadTitle").val(_renkan.project.get("title"));
    });
    
    this.$.find(".Rk-PadTitle").on("keyup input paste", function() {
        _renkan.project.set({"title": $(this).val()});
    })
    
    this.renkan.project.get("users").each(function(_user) {
        _this.addUser(_user);
    });
    
    this.renkan.project.on("add:users", function(_user) {
        _this.addUser(_user);
    });
    this.renkan.project.on("add:nodes", function(_node) {
        _this.addRepresentation("Node", _node);
        _thRedraw();
    });
    this.renkan.project.on("add:edges", function(_edge) {
        _this.addRepresentation("Edge", _edge);
        _thRedraw();
    });
    this.renkan.project.on("change:title", function(_model, _title) {
        var el = $(".Rk-PadTitle");
        if (el.is("input")) {
            if (el.val() !== _title) {
                el.val(_title);
            }
        } else {
            el.text(_title);
        }
    });
    
    this.redraw();
    
    if (this.minimap) {
	    window.setInterval(function() {
	    	_this.rescaleMinimap()
	    }, 2000);
    }
}

Rkns.Renderer.Scene.prototype.template = Rkns._.template(
    '<% if (options.show_top_bar) { %><div class="Rk-TopBar"><% if (!options.editor_mode) { %><h2 class="Rk-PadTitle"><%- project.get("title") || translate("Untitled project")%></h2>'
    + '<% } else { %><input type="text" class="Rk-PadTitle" value="<%- project.get("title") || "" %>" placeholder="<%-translate("Untitled project")%>" /><% } %>'
    + '<div class="Rk-Users"><div class="Rk-CurrentUser"><span class="Rk-CurrentUser-Color"></span><span class="Rk-CurrentUser-Name">&lt;unknown user&gt;</span></div><ul class="Rk-UserList"></ul></div>'
    + '<div class="Rk-TopBar-Separator"></div><div class="Rk-TopBar-Button Rk-FullScreen-Button"><div class="Rk-TopBar-Tooltip"><div class="Rk-TopBar-Tooltip-Tip"></div><div class="Rk-TopBar-Tooltip-Contents"><%-translate("Full Screen")%></div></div></div>'
    + '<% if (options.editor_mode) { %>'
    + '<div class="Rk-TopBar-Separator"></div><div class="Rk-TopBar-Button Rk-AddNode-Button"><div class="Rk-TopBar-Tooltip"><div class="Rk-TopBar-Tooltip-Tip"></div><div class="Rk-TopBar-Tooltip-Contents"><%-translate("Add Node")%></div></div></div>'
    + '<div class="Rk-TopBar-Separator"></div><div class="Rk-TopBar-Button Rk-AddEdge-Button"><div class="Rk-TopBar-Tooltip"><div class="Rk-TopBar-Tooltip-Tip"></div><div class="Rk-TopBar-Tooltip-Contents"><%-translate("Add Edge")%></div></div></div>'
    + '<div class="Rk-TopBar-Separator"></div><div class="Rk-TopBar-Button Rk-Save-Button"><div class="Rk-TopBar-Tooltip"><div class="Rk-TopBar-Tooltip-Tip"></div><div class="Rk-TopBar-Tooltip-Contents"> </div></div></div>'
    + '<div class="Rk-TopBar-Separator"></div><a class="Rk-TopBar-Button Rk-Bookmarklet-Button" href="#"><div class="Rk-TopBar-Tooltip"><div class="Rk-TopBar-Tooltip-Tip"></div><div class="Rk-TopBar-Tooltip-Contents">'
    + '<%-translate("Renkan \'Drag-to-Add\' bookmarklet")%></div></div></a>'
    + '<div class="Rk-TopBar-Separator"></div></div>'
    + '<% } } %>'
    + '<div class="Rk-Editing-Space<% if (!options.show_top_bar) { %> Rk-Editing-Space-Full<% } %>"><canvas class="Rk-Canvas" resize></canvas><div class="Rk-Editor"><div class="Rk-Notifications"></div>'
    + '<% if (options.show_bins) { %><div class="Rk-Fold-Bins">&laquo;</div><% } %>'
    + '<div class="Rk-ZoomButtons"><div class="Rk-ZoomIn" title="<%-translate("Zoom In")%>"></div><div class="Rk-ZoomOut" title="<%-translate("Zoom Out")%>"></div></div>'
    + '</div></div>'
);

Rkns.Renderer.Scene.prototype.addToBundles = function(_edgeRepr) {
    var _bundle = Rkns._(this.bundles).find(function(_bundle) {
        return ( 
            ( _bundle.from === _edgeRepr.from_representation && _bundle.to === _edgeRepr.to_representation )
            || ( _bundle.from === _edgeRepr.to_representation && _bundle.to === _edgeRepr.from_representation )
        );
    });
    if (typeof _bundle !== "undefined") {
        _bundle.edges.push(_edgeRepr)
    } else {
        _bundle = {
            from: _edgeRepr.from_representation,
            to: _edgeRepr.to_representation,
            edges: [ _edgeRepr ],
            getPosition: function(_er) {
                var _dir = (_er.from_representation === this.from) ? 1 : -1;
                return _dir * ( Rkns._(this.edges).indexOf(_er) - (this.edges.length - 1) / 2 );
            }
        }
        this.bundles.push(_bundle);
    }
    return _bundle;
}

Rkns.Renderer.Scene.prototype.isEditable = function() {
	return (this.renkan.options.editor_mode && !this.renkan.read_only)
}

Rkns.Renderer.Scene.prototype.onStatusChange = function() {
	var savebtn = this.$.find(".Rk-Save-Button"),
		tip = savebtn.find(".Rk-TopBar-Tooltip-Contents");
	if (this.renkan.read_only) {
		savebtn.removeClass("disabled Rk-Save-Online").addClass("Rk-Save-ReadOnly");
		tip.text(this.renkan.translate("Connection lost"));
	} else {
		if (this.renkan.options.snapshot_mode) {
			savebtn.removeClass("Rk-Save-ReadOnly Rk-Save-Online");
			tip.text(this.renkan.translate("Archive Project"));
		} else {
			savebtn.removeClass("disabled Rk-Save-ReadOnly").addClass("Rk-Save-Online");
			tip.text(this.renkan.translate("Auto-save enabled"));
		}
	}
}

Rkns.Renderer.Scene.prototype.setScale = function(_newScale, _offset) {
	if (_newScale > Rkns.Renderer._MIN_SCALE && _newScale < Rkns.Renderer._MAX_SCALE) {
	    this.scale = _newScale;
	    if (_offset) {
	    	this.offset = _offset
	    }
	    this.redraw();
    }
}

Rkns.Renderer.Scene.prototype.autoScale = function() {
    var nodes = this.renkan.project.get("nodes")
    if (nodes.length > 1) {
        var _xx = nodes.map(function(_node) { return _node.get("position").x }),
            _yy = nodes.map(function(_node) { return _node.get("position").y }),
            _minx = Math.min.apply(Math, _xx),
            _miny = Math.min.apply(Math, _yy),
            _maxx = Math.max.apply(Math, _xx),
            _maxy = Math.max.apply(Math, _yy);
        var _scale = Math.max(Rkns.Renderer._MIN_SCALE, Math.min(Rkns.Renderer._MAX_SCALE, (paper.view.size.width - 2 * Rkns.Renderer._AUTOSCALE_MARGIN) / (_maxx - _minx), (paper.view.size.height - 2 * Rkns.Renderer._AUTOSCALE_MARGIN) / (_maxy - _miny)));
		this.setScale(_scale, paper.view.center.subtract(new paper.Point([(_maxx + _minx) / 2, (_maxy + _miny) / 2]).multiply(_scale)));
    }
    if (nodes.length === 1) {
        this.setScale(1, paper.view.center.subtract(new paper.Point([nodes.at(0).get("position").x, nodes.at(0).get("position").y])));
    }
}

Rkns.Renderer.Scene.prototype.redrawMiniframe = function() {
	var topleft = this.toMinimapCoords(this.toModelCoords(new paper.Point([0,0]))),
		bottomright = this.toMinimapCoords(this.toModelCoords(paper.view.bounds.bottomRight));
	this.minimap.miniframe.fitBounds(topleft, bottomright);
}

Rkns.Renderer.Scene.prototype.rescaleMinimap = function() {
    var nodes = this.renkan.project.get("nodes")
    if (nodes.length > 1) {
        var _xx = nodes.map(function(_node) { return _node.get("position").x }),
            _yy = nodes.map(function(_node) { return _node.get("position").y }),
            _minx = Math.min.apply(Math, _xx),
            _miny = Math.min.apply(Math, _yy),
            _maxx = Math.max.apply(Math, _xx),
            _maxy = Math.max.apply(Math, _yy);
        var _scale = Math.min(
        	this.scale * .8 * this.renkan.options.minimap_width / paper.view.bounds.width,
        	this.scale * .8 * this.renkan.options.minimap_height / paper.view.bounds.height,
        	( this.renkan.options.minimap_width - 2 * Rkns.Renderer._MINIMAP_MARGIN ) / (_maxx - _minx),
        	( this.renkan.options.minimap_height - 2 * Rkns.Renderer._MINIMAP_MARGIN ) / (_maxy - _miny)
    	);
        this.minimap.offset = this.minimap.size.divide(2).subtract(new paper.Point([(_maxx + _minx) / 2, (_maxy + _miny) / 2]).multiply(_scale));
        this.minimap.scale = _scale;
    }
    if (nodes.length === 1) {
    	this.minimap.scale = .1;
        this.minimap.offset = this.minimap.size.divide(2).subtract(new paper.Point([nodes.at(0).get("position").x, nodes.at(0).get("position").y]).multiply(this.minimap.scale));
    }
    this.redraw();
}

Rkns.Renderer.Scene.prototype.toPaperCoords = function(_point) {
    return _point.multiply(this.scale).add(this.offset);
}

Rkns.Renderer.Scene.prototype.toMinimapCoords = function(_point) {
    return _point.multiply(this.minimap.scale).add(this.minimap.offset).add(this.minimap.topleft);
}

Rkns.Renderer.Scene.prototype.toModelCoords = function(_point) {
    return _point.subtract(this.offset).divide(this.scale);
}

Rkns.Renderer.Scene.prototype.addRepresentation = function(_type, _model) {
    var _repr = new Rkns.Renderer[_type](this, _model);
    this.representations.push(_repr);
    return _repr;
}

Rkns.Renderer.Scene.prototype.addRepresentations = function(_type, _collection) {
    var _this = this;
    _collection.forEach(function(_model) {
        _this.addRepresentation(_type, _model);
    });
}

Rkns.Renderer.Scene.prototype.userTemplate = Rkns._.template(
    '<li class="Rk-User"><span class="Rk-UserColor" style="background:<%=background%>;"></span><%=name%></li>'
);

Rkns.Renderer.Scene.prototype.addUser = function(_user) {
    if (_user.get("_id") === this.renkan.current_user) {
        this.$.find(".Rk-CurrentUser-Name").text(_user.get("title"));
        this.$.find(".Rk-CurrentUser-Color").css("background", _user.get("color"));
    } else {
        this.$.find(".Rk-UserList").append(
            Rkns.$(
                this.userTemplate({
                    name: _user.get("title"),
                    background: _user.get("color")
                })
            )
        );
    }
}

Rkns.Renderer.Scene.prototype.removeRepresentation = function(_representation) {
    _representation.destroy();
    this.representations = Rkns._(this.representations).reject(
        function(_repr) {
            return _repr == _representation
        }
    );
}

Rkns.Renderer.Scene.prototype.getRepresentationByModel = function(_model) {
    return Rkns._(this.representations).find(function(_repr) {
        return _repr.model === _model;
    });
}

Rkns.Renderer.Scene.prototype.removeRepresentationsOfType = function(_type) {
    var _representations = Rkns._(this.representations).filter(function(_repr) {
            return _repr.type == _type;
        }),
        _this = this;
    Rkns._(_representations).each(function(_repr) {
        _this.removeRepresentation(_repr);
    });
}

Rkns.Renderer.Scene.prototype.highlightModel = function(_model) {
    var _repr = this.getRepresentationByModel(_model);
    if (_repr) {
        _repr.highlight();
    }
}

Rkns.Renderer.Scene.prototype.unhighlightAll = function(_model) {
    Rkns._(this.representations).each(function(_repr) {
        _repr.unhighlight();
    });
}

Rkns.Renderer.Scene.prototype.redraw = function() {
    Rkns._(this.representations).each(function(_representation) {
    	_representation.redraw(true);
    });
    if (this.minimap) {
    	this.redrawMiniframe();
    }
    paper.view.draw();
}

Rkns.Renderer.Scene.prototype.addTempEdge = function(_from, _point) {
    var _tmpEdge = this.addRepresentation("TempEdge",null);
    _tmpEdge.end_pos = _point;
    _tmpEdge.from_representation = _from;
    _tmpEdge.redraw();
    this.click_target = _tmpEdge;
}

Rkns.Renderer.Scene.prototype.findTarget = function(_hitResult) {
    if (_hitResult && typeof _hitResult.item.__representation !== "undefined") {
        var _newTarget = _hitResult.item.__representation;
        if (this.selected_target !== _hitResult.item.__representation) {
            if (this.selected_target) {
                this.selected_target.unselect(_newTarget);
            }
            _newTarget.select(this.selected_target);
            this.selected_target = _newTarget;
        }
    } else {
        if (this.selected_target) {
            this.selected_target.unselect(null);
        }
        this.selected_target = null;
    }
}

Rkns.Renderer.Scene.prototype.paperShift = function(_delta) {
	this.offset = this.offset.add(_delta);
    this.redraw();
}

Rkns.Renderer.Scene.prototype.onMouseMove = function(_event) {
    var _off = this.canvas_$.offset(),
    	_point = new paper.Point([
            _event.pageX - _off.left,
            _event.pageY - _off.top
        ]);
	var _delta = _point.subtract(this.last_point);
	this.last_point = _point;
    if (!this.is_dragging && this.mouse_down && _delta.length > Rkns.Renderer._MIN_DRAG_DISTANCE) {
    	this.is_dragging = true;
    }
    var _hitResult = paper.project.hitTest(_point);
    if (this.is_dragging) {
        if (this.click_target && typeof this.click_target.paperShift === "function") {
            this.click_target.paperShift(_delta);
        } else {
            this.paperShift(_delta);
        }
    } else {
        this.findTarget(_hitResult);
    }
    paper.view.draw();
}

Rkns.Renderer.Scene.prototype.onMouseDown = function(_event) {
    var _off = this.canvas_$.offset(),
    	_point = new paper.Point([
            _event.pageX - _off.left,
            _event.pageY - _off.top
        ]);
    this.last_point = _point;
    this.mouse_down = true;
    if (!this.click_target || this.click_target.type !== "Temp-edge") {
        this.removeRepresentationsOfType("editor");
        this.is_dragging = false;
        var _hitResult = paper.project.hitTest(_point);
        if (this.isEditable() && _hitResult && typeof _hitResult.item.__representation !== "undefined") {
            this.click_target = _hitResult.item.__representation;
            if (this.click_target.type === "Node-link-button") {
                this.removeRepresentationsOfType("editor");
                this.addTempEdge(this.click_target.source_representation, _point);
            }
        } else {
            this.click_target = null;
            if (this.isEditable() && this.click_mode === Rkns.Renderer._CLICKMODE_ADDNODE) {
                var _coords = this.toModelCoords(_point),
                    _data = {
                        id: Rkns.Utils.getUID('node'),
                        created_by: this.renkan.current_user,
                        position: {
                            x: _coords.x,
                            y: _coords.y
                        }
                    };
                    _node = this.renkan.project.addNode(_data);
                this.getRepresentationByModel(_node).openEditor();
            }
        }
    }
    if (this.click_mode) {
        if (this.isEditable() && this.click_mode === Rkns.Renderer._CLICKMODE_STARTEDGE && this.click_target && this.click_target.type === "Node") {
            this.removeRepresentationsOfType("editor");
            this.addTempEdge(this.click_target, _point);
            this.click_mode = Rkns.Renderer._CLICKMODE_ENDEDGE;
            this.notif_$.fadeOut(function() {
                Rkns.$(this).html(_renkan.translate("Click on a second node to complete the edge")).fadeIn();
            });
        } else {
            this.notif_$.hide();
            this.click_mode = false;
        }
    }
}

Rkns.Renderer.Scene.prototype.onMouseUp = function(_event) {
	this.mouse_down = false;
    if (this.click_target) {
        var _off = this.canvas_$.offset();
        this.click_target.mouseup(
            {
                point: new paper.Point([
                    _event.pageX - _off.left,
                    _event.pageY - _off.top
                ])
            }
        );
    } else {
        this.click_target = null;
        this.is_dragging = false;
    }
}

Rkns.Renderer.Scene.prototype.onScroll = function(_event, _scrolldelta) {
    this.totalScroll += _scrolldelta;
    if (Math.abs(this.totalScroll) >= 1) {
        var _off = this.canvas_$.offset(),
            _delta = new paper.Point([
                _event.pageX - _off.left,
                _event.pageY - _off.top
            ]).subtract(this.offset).multiply( Math.SQRT2 - 1 );
        if (this.totalScroll > 0) {
        	this.setScale( this.scale * Math.SQRT2, this.offset.subtract(_delta) );
        } else {
        	this.setScale( this.scale * Math.SQRT1_2, this.offset.add(_delta.divide(Math.SQRT2)));
        }
        this.totalScroll = 0;
    }
}

Rkns.Renderer.Scene.prototype.onDoubleClick = function(_event) {
    if (!this.isEditable()) {
        return;
    }
    var _off = this.canvas_$.offset(),
        _point = new paper.Point([
            _event.pageX - _off.left,
            _event.pageY - _off.top
        ]);
    var _hitResult = paper.project.hitTest(_point);
    if (this.isEditable() && (!_hitResult || typeof _hitResult.item.__representation === "undefined")) {
        var _coords = this.toModelCoords(_point),
            _data = {
                id: Rkns.Utils.getUID('node'),
                created_by: this.renkan.current_user,
                position: {
                    x: _coords.x,
                    y: _coords.y
                }
            };
            _node = this.renkan.project.addNode(_data);
            this.getRepresentationByModel(_node).openEditor();
    }
    paper.view.draw();
}
