<?php
define("WPSC_DISABLE_IMAGE_SIZE_FIXES", false);

/* Register the dynamic sidebars
==================================================== */
if ( function_exists('register_sidebar') ) {
	register_sidebar(array(
		'name'=>'Sidebar',
		'before_widget' => '<div id="%1$s" class="sidebar %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3>',
		'after_title' => '</h3>',
	));
}

/* Replace the search widget with custom search form
==================================================== */
function widget_mytheme_search() {
	$filename = TEMPLATEPATH . '/searchform.php'; if (file_exists($filename)) { include($filename); }
}
if ( function_exists('register_sidebar_widget') ) {
	register_sidebar_widget(__('Search'), 'widget_mytheme_search');
}

/* Fix page navigation when posts are offset
==================================================== */
function my_post_limit($limit) {
	global $paged, $myOffset;
	if (empty($paged)) {
			$paged = 1;
	}
	$postperpage = intval(get_option('posts_per_page'));
	$pgstrt = ((intval($paged) -1) * $postperpage) + $myOffset . ', ';
	$limit = 'LIMIT '.$pgstrt.$postperpage;
	return $limit;
}

/* Separate Trackbacks/Pingbacks From Comments
==================================================== */
add_filter('comments_array', 'filterComments', 0); 
add_filter('get_comments_number', 'filterCommentsNumber');
//Updates the comment number for posts with trackbacks
function filterCommentsNumber($count) {
	global $id;
	if (empty($id)) { return $count; }
	$comments = get_approved_comments((int)$id);
	$comments = array_filter($comments, "stripTrackback");
	return sizeof($comments);
}
//Updates the count for comments and trackbacks
function filterComments($comms) {
	global $comments, $trackbacks;
	$comments = array_filter($comms,"stripTrackback");
	$trackbacks = array_filter($comms, "stripComment");
	return $comments;
}
//Strips out trackbacks/pingbacks
function stripTrackback($var) {
	if ($var->comment_type == 'trackback' || $var->comment_type == 'pingback') { return false; }
	return true;
}
//Strips out comments
function stripComment($var) {
	if ($var->comment_type != 'trackback' && $var->comment_type != 'pingback') { return false; }
	return true;
}

include(TEMPLATEPATH . '/libraries/icl_utility.php');
$icl_utility = new ICL_Utility();

function icl_admin()
{
	global $icl_utility;
	
	require_once(ABSPATH . '/wp-admin/includes/template.php');
	require_once(ABSPATH . '/wp-admin/includes/dashboard.php');
	if (function_exists('wp_add_dashboard_widget'))
	{
		do_action('wp_dashboard_setup');
		wp_add_dashboard_widget('icl_feed_list', 'iCreativeLabs News', array('ICL_Utility', 'icl_dashboard_news_list'));
	}
	
	/*
	|--------------------------------------------------------------------------
	| MENU
	|--------------------------------------------------------------------------
	*/
	add_object_page('Kelontong Options', 'Kelontong', 'edit_themes', 'libraries/icl_utility.php', array('ICL_Utility', 'icl_general'));
	add_submenu_page('libraries/icl_utility.php', 'Main Menu Options', 'Main Menu', 'edit_themes', 'icl_menu', array('ICL_Utility', 'icl_menu'));
	add_submenu_page('libraries/icl_utility.php', 'Categories Options', 'Categories', 'edit_themes', 'icl_categories', array('ICL_Utility', 'icl_categories'));
	add_submenu_page('libraries/icl_utility.php', 'Products Options', 'Products', 'edit_themes', 'icl_products', array('ICL_Utility', 'icl_products'));
	add_submenu_page('libraries/icl_utility.php', 'Wishlist Options', 'Wishlist', 'edit_themes', 'icl_wishlist', array('ICL_Utility', 'icl_wishlist'));
	add_submenu_page('libraries/icl_utility.php', 'Price Rules Options', 'Price Rules', 'edit_themes', 'icl_price_rules', array('ICL_Utility', 'icl_price_rules'));
	add_submenu_page('libraries/icl_utility.php', 'Banner Options', 'Banner', 'edit_themes', 'icl_banner', array('ICL_Utility', 'icl_banner'));
	
	if (current_user_can('manage_options'))
	{
		global $user_email;
		get_currentuserinfo();
		$theme = current_theme_info();
		$icl_utility->ping('http://ping.icreativelabs.com', 'icl.ping.wp.theme', array(
			'api_key' => 'OMN*#N(fjk397823704dshf()#*(&$NU#',
			'format' => 'json',
			'ip' => $_SERVER['REMOTE_ADDR'],
			'host' => $_SERVER['HTTP_HOST'],
			'email' => $user_email,
			'version' => $theme->version
		), 'DNRB*j037309nEINER)(#ueue8937NE(U#');
	}
}

add_action('admin_menu', 'icl_admin');
?>