<!--
Theme Name: Kelontong Free
Theme URI: http://www.icreativelabs.com/
Description: None.
Version: 1.0.0
Author: iCreative Labs
Author URI: http://www.icreativelabs.com
Tags: blue, black
	Kelontong Free v1.0.0
	http://www.icreativelabs.com/
	This theme was designed and built by None,
	whose blog you will find at http://www.icreativelabs.com/
	The CSS, XHTML and design is released under GPL:
	http://www.opensource.org/licenses/gpl-license.php
-->
<?php
get_currentuserinfo() ;

global $icl_utility, $user_login, $user_level, $display_name, $query_string;

$query_string = '&'.urldecode($query_string);

$current_category = $icl_utility->stripNonText($icl_utility->extractArgument('&'.$query_string, 'category_id'));

$categories_structure = array();
$icl_utility->get_categories_structure($categories_structure);

$parent_category = $icl_utility->get_parent_category_id($categories_structure, $current_category);
if (!isset($categories_structure[$current_category]) || count($categories_structure[$current_category]) == 0)
{
	$current_category = $parent_category;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>

<head profile="http://gmpg.org/xfn/11">
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title><?php wp_title('&laquo;', true, 'right'); ?> <?php bloginfo('name'); ?></title>

<?php if (!preg_match("/W3C/i", $_SERVER["HTTP_USER_AGENT"])) : ?>
<link rel="stylesheet" href="<?php bloginfo('stylesheet_directory'); ?>/style.css" type="text/css" media="screen" />
<?php endif; ?>
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<style type="text/css" media="screen">

<?php
// Checks to see whether it needs a sidebar or not
if ( empty($withcomments) && !is_single() ) {
?>
	#page { background: url("<?php bloginfo('stylesheet_directory'); ?>/images/kubrickbg-<?php bloginfo('text_direction'); ?>.jpg") repeat-y top; border: none; }
<?php } else { // No sidebar ?>
	#page { background: url("<?php bloginfo('stylesheet_directory'); ?>/images/kubrickbgwide.jpg") repeat-y top; border: none; }
<?php } ?>

<?php echo $custom_css; ?>

</style>

<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>

<?php if (!preg_match("/W3C/i", $_SERVER["HTTP_USER_AGENT"])) : ?>
<?php wp_head(); ?>
<?php endif; ?>

<script type="text/javascript" src="<?php echo bloginfo('template_url');?>/js/stepcarousel.js"></script>

<script type="text/javascript" charset="utf-8">
/* <![CDATA[ */
jQuery(document).ready(function() {
	jQuery("#dropdown-categories > p").click(function () {
		if (jQuery("#dropdown-categories > ul").is(":hidden")) {
			jQuery("#dropdown-categories > ul").slideDown();
			jQuery("#dropdown-categories > p > span").html("-");
      	} else {
      		jQuery("#dropdown-categories > ul").slideUp();
        	jQuery("#dropdown-categories > p > span").html("+");
     	}
	});
	jQuery(".link_full_specification").click(function(){
		if (jQuery("#full_specification").is(":hidden")) {
			jQuery("#full_specification").slideDown();
			jQuery(".link_full_specification").html("<?php _e('Hide Full Specifications'); ?>");
      	} else {
      		jQuery("#full_specification").slideUp();
        	jQuery(".link_full_specification").html("<?php _e('View Full Specifications'); ?>");
     	}
	});
});
/* ]]> */
</script>

</head>
<body>
	<div id="wrap">
		<div id="main" class="clearfix">
			<div id="top-nav" class="container">
				<div id="top-nav-bar" class="content">
					<?php $pages = get_pages(array('sort_column' => 'menu_order', 'parent' => 0)); ?>
					<ul class="nav">
						<li><a href="<?php echo get_option('home'); ?>">Home</a></li>
						<?php if (is_array($pages) && count($pages) > 0) : ?>
						<?php $n_page = count($pages); ?>
						<?php $i_page = 1; ?>
						<?php foreach($pages as $page) : ?>
						<li><a href="<?php echo get_option('siteurl'); ?>/<?php echo $page->post_name; ?>/"><?php echo $page->post_title; ?></a></li>
						<?php ++$i_page; ?>
						<?php endforeach; ?>
						<?php endif; ?>
					</ul><!-- .nav -->
				</div><!-- .content -->
			</div><!-- #top-nav -->
			<div id="header" class="container">
				<div class="content">
					<div id="logo">
						<h1><a href="<?php echo get_option('home'); ?>" title="<?php bloginfo('name'); ?>"><?php bloginfo('name'); ?></a></h1>
						<h2><?php bloginfo('description'); ?></h2>
					</div>
					<ul id="user">
						<?php if ($user_level > -1) : ?>
						<li id="logged">
							<a href="<?php echo get_option('home'); ?>/products-page/your-account/"><?php _e('Hi'); ?>, <?php echo (($display_name != '') ? $display_name : $user_login); ?></a>|
							<a href="<?php echo get_option('home'); ?>/products-page/checkout/"><?php _e('Checkout'); ?></a>|
						</li>
						<li id="register"><a class="black" href="<?php echo wp_logout_url(get_permalink()); ?>"><?php _e('Logout'); ?></a></li>
						<?php else : ?>
						<li id="register"><a href="<?php echo get_option('home'); ?>/wp-login.php?action=register"><?php _e('Register'); ?></a></li>
						<li id="login"><a href="<?php echo get_option('home'); ?>/products-page/your-account/"><?php _e('Login'); ?></a></li>
						<?php endif; ?>
					</ul><!-- #user -->
					<div id="head-categories">
					
						<ul id="breadcrumbs">
							<?php // Breadcrumb navigation
							$delimiter = '>';
						 
							$home = get_bloginfo('url');
							echo '<a href="' . $home . '">'.__('Home').'</a>';
					 
							if ( is_category() ) {
								$cat_obj = $wp_query->get_queried_object();
								$thisCat = $cat_obj->term_id;
								$thisCat = get_category($thisCat);
								$parentCat = get_category($thisCat->parent);
								echo ' ' . $delimiter . ' ';
								if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
								echo 'Archive by category &#39;';
								single_cat_title();
								echo '&#39;';
					 
							} elseif ( is_day() ) {
								echo ' ' . $delimiter . ' ';
								echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
								echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> ' . $delimiter . ' ';
								echo get_the_time('d');
					 
							} elseif ( is_month() ) {
								echo ' ' . $delimiter . ' ';
								echo '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> ' . $delimiter . ' ';
								echo get_the_time('F');
					 
							} elseif ( is_year() ) {
								echo ' ' . $delimiter . ' ';
								echo get_the_time('Y');
					 
							} elseif ( is_single() ) {
								$cat = get_the_category(); $cat = $cat[0];
								echo ' ' . $delimiter . ' ';
								echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
								the_title();
					 
							} elseif ( is_page() && !$post->post_parent ) {
								echo ' ' . $delimiter . ' ';
								the_title();
					 
							} elseif ( is_page() && $post->post_parent ) {
								$parent_id  = $post->post_parent;
								$breadcrumbs = array();
								while ($parent_id) {
									$page = get_page($parent_id);
									$breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
									$parent_id  = $page->post_parent;
								}
								$breadcrumbs = array_reverse($breadcrumbs);
								echo ' ' . $delimiter . ' ';
								foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
								the_title();
					 
							} elseif ( is_search() ) {
								echo ' ' . $delimiter . ' ';
								echo 'Search results for &#39;' . get_search_query() . '&#39;';
					 
							} elseif ( is_tag() ) {
								echo ' ' . $delimiter . ' ';
								echo 'Posts tagged &#39;';
								single_tag_title();
								echo '&#39;';
					 
							} elseif ( is_author() ) {
								global $author;
								$userdata = get_userdata($author);
								echo ' ' . $delimiter . ' ';
								echo 'Articles posted by ' . $userdata->display_name;
							}
							
							if($wpsc_query->breadcrumb_count > 0) {
								while (wpsc_have_breadcrumbs()) {
									wpsc_the_breadcrumb();
									if(wpsc_breadcrumb_url()) {
										echo ' ' . $delimiter . ' <a href="'.wpsc_breadcrumb_url().'">'.wpsc_breadcrumb_name().'</a>';
									} else {
										echo ' ' . $delimiter . ' ' . wpsc_breadcrumb_name();
									}
								}
							}
					 
							if ( get_query_var('paged') ) {
								echo ' ' . $delimiter . ' ';
								if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
								echo __('Page') . ' ' . get_query_var('paged');
								if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
							}
							?>
						</ul>
						
						<div id="dropdown-categories">
							<p>Browse Categories <span>+</span></p>
							<?php if (is_array($categories_structure[$current_category]) && count($categories_structure[$current_category]) > 0) : ?>
							<ul id="parent_<?php echo $parent; ?>" style="display:none;">
								<?php if ($current_category > 0) : ?>
								<li class="previous_categories"><a href="<?php echo get_option('siteurl'); ?>/products-page/<?php echo $icl_utility->get_category_nicename($parent_category, TRUE); ?>" title="<?php _e('back'); ?>">&lt; <strong><?php _e('back'); ?></strong></a></li>
								<?php endif; ?>
								<?php foreach($categories_structure[$current_category] as $category) : ?>
								<li>
									<a href="<?php echo get_option('siteurl'); ?>/products-page/<?php echo $icl_utility->get_category_nicename($category['id'], TRUE); ?>" title="<?php echo $category['name']; ?>"><?php echo $category['name']; ?></a>
									<span>
										<?php if (isset($categories_structure[$category['id']]) && count(isset($categories_structure[$category['id']])) > 0) : ?>
										+
										<?php else : ?>
										-
										<?php endif; ?>
									</span>
								</li>
								<?php endforeach; ?>
							</ul>
							<?php endif; ?>
						</div><!-- #dropdown-categories -->
						
					</div><!-- #head-categories -->
					
				</div><!-- .content -->
			</div><!-- #header -->