<?php get_header(); ?>
<script type="text/javascript" charset="utf-8">
/* <![CDATA[ */
function setEqualHeight(columns) {
	var tallestcolumn = 0;
	columns.each(
		function() {
			currentHeight = jQuery(this).height();
			if(currentHeight > tallestcolumn) {
				tallestcolumn  = currentHeight;
			}
		}
	);
	columns.css('min-height', tallestcolumn);
	delete tallestcolumn;
}

jQuery(document).ready(function() {
	setEqualHeight(jQuery(".wrapin  > div"));
});
/* ]]> */
</script>
	<div id="two-columns" class="container">
		<div class="content">
			<div id="right-column">
			<?php if (have_posts()) : ?>
				<?php while (have_posts()) : the_post(); ?>
				<div class="post" id="post-<?php the_ID(); ?>">
					<h3 class="post-title">
						<a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent link to <?php the_title(); ?>">
						<?php the_title(); ?>
						</a>
					</h3><!-- .post-title -->
					<div class="post-detail">
						<?php the_time('F jS, Y'); ?>
						<?php the_category(' &middot; '); ?>
					</div><!-- .post-detail -->
					<div class="post-detail">
						<?php the_tags('<span class="post-tags">Tags: ', ', ', '</span>'); ?>
					</div><!-- .post-detail -->
					<div class="commentcount">
						<a href="#respond"><?php comments_number('0','1','%'); ?></a>
					</div><!-- .commentcount -->
					<div class="post-content">
					<?php the_content("Continue reading&hellip;"); ?>
					<?php link_pages('<p class="pagenav">Page: ', '</p>'); ?>
					</div>
				</div>

				<?php comments_template(); ?>
				
				<?php endwhile; ?>
			<?php else : ?>
			<?php /* Error 404 */ ?>	
			<?php $filename = TEMPLATEPATH . '/404.php'; if (file_exists($filename)) { include($filename); } ?>
			<?php endif; ?>
			</div>
			<?php get_sidebar(); ?>
			<div class="clear"></div>
		</div>
	</div>

<?php get_footer(); ?>